/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.plugins.quality.FindBugsReports;
import org.gradle.api.plugins.quality.internal.FindBugsReportsImpl;
import org.gradle.api.plugins.quality.internal.FindBugsReportsInternal;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsClasspathValidator;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsResult;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsSpec;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsSpecBuilder;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsWorkerManager;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OrderSensitive;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class FindBugs
extends SourceTask
implements VerificationTask,
Reporting<FindBugsReports> {
    private FileCollection classes;
    private FileCollection classpath;
    private FileCollection findbugsClasspath;
    private FileCollection pluginClasspath;
    private boolean ignoreFailures;
    private String effort;
    private String reportLevel;
    private String maxHeapSize;
    private Collection<String> visitors = new ArrayList<String>();
    private Collection<String> omitVisitors = new ArrayList<String>();
    private TextResource includeFilterConfig;
    private TextResource excludeFilterConfig;
    private TextResource excludeBugsFilterConfig;
    private Collection<String> extraArgs = new ArrayList<String>();
    @Nested
    private final FindBugsReportsInternal reports = (FindBugsReportsInternal)this.getInstantiator().newInstance(FindBugsReportsImpl.class, new Object[]{this});

    @Inject
    public Instantiator getInstantiator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public WorkerProcessFactory getWorkerProcessBuilderFactory() {
        throw new UnsupportedOperationException();
    }

    public FindBugsReports getReports() {
        return this.reports;
    }

    public FindBugsReports reports(Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    public FindBugsReports reports(Action<? super FindBugsReports> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    @Internal
    public File getIncludeFilter() {
        TextResource config = this.getIncludeFilterConfig();
        return config == null ? null : config.asFile();
    }

    public void setIncludeFilter(File filter) {
        this.setIncludeFilterConfig(this.getProject().getResources().getText().fromFile((Object)filter));
    }

    @Internal
    public File getExcludeFilter() {
        TextResource config = this.getExcludeFilterConfig();
        return config == null ? null : config.asFile();
    }

    public void setExcludeFilter(File filter) {
        this.setExcludeFilterConfig(this.getProject().getResources().getText().fromFile((Object)filter));
    }

    @Internal
    public File getExcludeBugsFilter() {
        TextResource config = this.getExcludeBugsFilterConfig();
        return config == null ? null : config.asFile();
    }

    public void setExcludeBugsFilter(File filter) {
        this.setExcludeBugsFilterConfig(this.getProject().getResources().getText().fromFile((Object)filter));
    }

    @TaskAction
    public void run() throws IOException, InterruptedException {
        new FindBugsClasspathValidator(JavaVersion.current()).validateClasspath(Iterables.transform((Iterable)this.getFindbugsClasspath().getFiles(), (Function)new Function<File, String>(){

            public String apply(File input) {
                return input.getName();
            }
        }));
        FindBugsSpec spec = this.generateSpec();
        FindBugsWorkerManager manager = new FindBugsWorkerManager();
        this.getLogging().captureStandardOutput(LogLevel.DEBUG);
        this.getLogging().captureStandardError(LogLevel.DEBUG);
        FindBugsResult result = manager.runWorker(this.getProject().getProjectDir(), this.getWorkerProcessBuilderFactory(), this.getFindbugsClasspath(), spec);
        this.evaluateResult(result);
    }

    @VisibleForTesting
    FindBugsSpec generateSpec() {
        FindBugsSpecBuilder specBuilder = new FindBugsSpecBuilder(this.getClasses()).withPluginsList(this.getPluginClasspath()).withSources((FileCollection)this.getSource()).withClasspath(this.getClasspath()).withDebugging(this.getLogger().isDebugEnabled()).withEffort(this.getEffort()).withReportLevel(this.getReportLevel()).withMaxHeapSize(this.getMaxHeapSize()).withVisitors(this.getVisitors()).withOmitVisitors(this.getOmitVisitors()).withExcludeFilter(this.getExcludeFilter()).withIncludeFilter(this.getIncludeFilter()).withExcludeBugsFilter(this.getExcludeBugsFilter()).withExtraArgs(this.getExtraArgs()).configureReports(this.getReports());
        return specBuilder.build();
    }

    @VisibleForTesting
    void evaluateResult(FindBugsResult result) {
        if (result.getException() != null) {
            throw new GradleException("FindBugs encountered an error. Run with --debug to get more information.", result.getException());
        }
        if (result.getErrorCount() > 0) {
            throw new GradleException("FindBugs encountered an error. Run with --debug to get more information.");
        }
        if (result.getBugCount() > 0) {
            String message = "FindBugs rule violations were found.";
            SingleFileReport report = this.reports.getFirstEnabled();
            if (report != null) {
                String reportUrl = new ConsoleRenderer().asClickableFileUrl(report.getDestination());
                message = message + " See the report at: " + reportUrl;
            }
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message);
            } else {
                throw new GradleException(message);
            }
        }
    }

    public FindBugs extraArgs(Iterable<String> arguments) {
        for (String argument : arguments) {
            this.extraArgs.add(argument);
        }
        return this;
    }

    public FindBugs extraArgs(String ... arguments) {
        this.extraArgs.addAll(Arrays.asList(arguments));
        return this;
    }

    @SkipWhenEmpty
    @InputFiles
    public FileCollection getClasses() {
        return this.classes;
    }

    public void setClasses(FileCollection classes) {
        this.classes = classes;
    }

    @OrderSensitive
    @InputFiles
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @OrderSensitive
    @InputFiles
    public FileCollection getFindbugsClasspath() {
        return this.findbugsClasspath;
    }

    public void setFindbugsClasspath(FileCollection findbugsClasspath) {
        this.findbugsClasspath = findbugsClasspath;
    }

    @OrderSensitive
    @InputFiles
    public FileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    public void setPluginClasspath(FileCollection pluginClasspath) {
        this.pluginClasspath = pluginClasspath;
    }

    @Input
    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Input
    @Optional
    public String getEffort() {
        return this.effort;
    }

    public void setEffort(String effort) {
        this.effort = effort;
    }

    @Input
    @Optional
    public String getReportLevel() {
        return this.reportLevel;
    }

    public void setReportLevel(String reportLevel) {
        this.reportLevel = reportLevel;
    }

    @Input
    @Optional
    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(String maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    @Input
    @Optional
    public Collection<String> getVisitors() {
        return this.visitors;
    }

    public void setVisitors(Collection<String> visitors) {
        this.visitors = visitors;
    }

    @Input
    @Optional
    public Collection<String> getOmitVisitors() {
        return this.omitVisitors;
    }

    public void setOmitVisitors(Collection<String> omitVisitors) {
        this.omitVisitors = omitVisitors;
    }

    @Incubating
    @Nested
    @Optional
    public TextResource getIncludeFilterConfig() {
        return this.includeFilterConfig;
    }

    public void setIncludeFilterConfig(TextResource includeFilterConfig) {
        this.includeFilterConfig = includeFilterConfig;
    }

    @Incubating
    @Nested
    @Optional
    public TextResource getExcludeFilterConfig() {
        return this.excludeFilterConfig;
    }

    public void setExcludeFilterConfig(TextResource excludeFilterConfig) {
        this.excludeFilterConfig = excludeFilterConfig;
    }

    @Incubating
    @Nested
    @Optional
    public TextResource getExcludeBugsFilterConfig() {
        return this.excludeBugsFilterConfig;
    }

    public void setExcludeBugsFilterConfig(TextResource excludeBugsFilterConfig) {
        this.excludeBugsFilterConfig = excludeBugsFilterConfig;
    }

    @Input
    @Optional
    public Collection<String> getExtraArgs() {
        return this.extraArgs;
    }

    public void setExtraArgs(Collection<String> extraArgs) {
        this.extraArgs = extraArgs;
    }
}

