/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyYielder;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyGenerator
extends RubyObject {
    private IRubyObject proc;

    public static void createGeneratorClass(Ruby runtime) {
        RubyClass genc = runtime.defineClassUnder("Generator", runtime.getObject(), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                return new RubyGenerator(runtime, klazz);
            }
        }, runtime.getEnumerator());
        genc.includeModule(runtime.getEnumerable());
        genc.defineAnnotatedMethods(RubyGenerator.class);
        runtime.setGenerator(genc);
    }

    public RubyGenerator(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, optional=1)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject proc2;
        Ruby runtime = context.runtime;
        if (args2.length == 0) {
            proc2 = RubyProc.newProc(runtime, block, Block.Type.PROC);
        } else {
            if (!(args2[0] instanceof RubyProc)) {
                throw runtime.newTypeError(args2[0], runtime.getProc());
            }
            proc2 = args2[0];
            if (block.isGiven()) {
                runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
            }
        }
        return this.init(runtime, proc2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyGenerator)) {
            throw context.runtime.newTypeError(other, context.runtime.getGenerator());
        }
        this.checkFrozen();
        this.proc = ((RubyGenerator)other).proc;
        return this;
    }

    @JRubyMethod(rest=true)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        newArgs[0] = RubyYielder.newYielder(context, block);
        if (args2.length > 0) {
            System.arraycopy(args2, 0, newArgs, 1, args2.length);
        }
        return ((RubyProc)this.proc).call19(context, newArgs, Block.NULL_BLOCK);
    }

    private IRubyObject init(Ruby runtime, IRubyObject proc2) {
        this.proc = proc2;
        return this;
    }
}

