/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.vm.PolyglotEngine;

public final class ExecutionEvent {
    private Object[] debugger;
    private final PolyglotEngine engine;
    private final int currentDepth;
    private final Source source;

    ExecutionEvent(PolyglotEngine engine, int currentDepth, Object[] debugger, Source source) {
        this.debugger = debugger;
        this.engine = engine;
        this.currentDepth = currentDepth;
        this.source = source;
    }

    public synchronized Debugger getDebugger() {
        if (this.debugger == null) {
            throw new IllegalStateException("Event was disposed.");
        }
        if (this.debugger[0] instanceof Debugger) {
            return (Debugger)this.debugger[0];
        }
        Debugger dbg = Debugger.find(this.engine, true);
        dbg.executionStarted(this.currentDepth, this.source);
        this.debugger[0] = dbg;
        return dbg;
    }

    public void prepareContinue() {
        this.getDebugger().prepareContinue(-1);
    }

    public void prepareStepInto() {
        this.getDebugger().prepareStepInto(1);
    }

    synchronized void dispose() {
        this.debugger = null;
    }
}

