/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.StandardScriptDefinition;

public class KotlinScriptDefinitionProvider {
    private final List<KotlinScriptDefinition> definitions = new ArrayList<KotlinScriptDefinition>();

    public static KotlinScriptDefinitionProvider getInstance(Project project) {
        return ServiceManager.getService(project, KotlinScriptDefinitionProvider.class);
    }

    public KotlinScriptDefinitionProvider() {
        this.definitions.add(StandardScriptDefinition.INSTANCE);
    }

    public KotlinScriptDefinition findScriptDefinition(PsiFile psiFile) {
        for (KotlinScriptDefinition definition : this.definitions) {
            if (!definition.isScript(psiFile)) continue;
            return definition;
        }
        return null;
    }

    public boolean isScript(PsiFile psiFile) {
        return this.findScriptDefinition(psiFile) != null;
    }

    public void addScriptDefinition(@NotNull KotlinScriptDefinition scriptDefinition) {
        if (scriptDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDefinition", "org/jetbrains/kotlin/script/KotlinScriptDefinitionProvider", "addScriptDefinition"));
        }
        this.definitions.add(0, scriptDefinition);
    }

    public void removeScriptDefinition(@NotNull KotlinScriptDefinition scriptDefinition) {
        if (scriptDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDefinition", "org/jetbrains/kotlin/script/KotlinScriptDefinitionProvider", "removeScriptDefinition"));
        }
        this.definitions.remove(scriptDefinition);
    }

    public void setScriptDefinitions(@NotNull List<KotlinScriptDefinition> definitions) {
        if (definitions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitions", "org/jetbrains/kotlin/script/KotlinScriptDefinitionProvider", "setScriptDefinitions"));
        }
        this.definitions.clear();
        this.definitions.addAll(definitions);
    }
}

