/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicStreams;
import org.elasticsearch.search.internal.SearchContext;

public class JLHScore
extends SignificanceHeuristic {
    public static final JLHScore INSTANCE = new JLHScore();
    protected static final String[] NAMES = new String[]{"jlh"};
    public static final SignificanceHeuristicStreams.Stream STREAM = new SignificanceHeuristicStreams.Stream(){

        @Override
        public SignificanceHeuristic readResult(StreamInput in) throws IOException {
            return JLHScore.readFrom(in);
        }

        @Override
        public String getName() {
            return NAMES[0];
        }
    };

    private JLHScore() {
    }

    public static SignificanceHeuristic readFrom(StreamInput in) throws IOException {
        return INSTANCE;
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        double supersetProbability;
        double subsetProbability;
        double absoluteProbabilityChange;
        this.checkFrequencyValidity(subsetFreq, subsetSize, supersetFreq, supersetSize, "JLHScore");
        if (subsetSize == 0L || supersetSize == 0L) {
            return 0.0;
        }
        if (supersetFreq == 0L) {
            supersetFreq = 1L;
        }
        if ((absoluteProbabilityChange = (subsetProbability = (double)subsetFreq / (double)subsetSize) - (supersetProbability = (double)supersetFreq / (double)supersetSize)) <= 0.0) {
            return 0.0;
        }
        double relativeProbabilityChange = subsetProbability / supersetProbability;
        return absoluteProbabilityChange * relativeProbabilityChange;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(STREAM.getName());
    }

    public static class JLHScoreBuilder
    implements SignificanceHeuristicBuilder {
        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(STREAM.getName()).endObject();
            return builder;
        }
    }

    public static class JLHScoreParser
    implements SignificanceHeuristicParser {
        @Override
        public SignificanceHeuristic parse(XContentParser parser, ParseFieldMatcher parseFieldMatcher, SearchContext context) throws IOException, QueryParsingException {
            if (!parser.nextToken().equals((Object)XContentParser.Token.END_OBJECT)) {
                throw new ElasticsearchParseException("failed to parse [jhl] significance heuristic. expected an empty object, but found [{}] instead", new Object[]{parser.currentToken()});
            }
            return new JLHScore();
        }

        @Override
        public String[] getNames() {
            return NAMES;
        }
    }
}

