/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.bidi;

import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.bidi.BidiResolver;
import org.apache.fop.complexscripts.bidi.TextInterval;
import org.apache.fop.complexscripts.bidi.UnicodeBidiAlgorithm;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.WritingModeTraits;
import org.apache.fop.traits.WritingModeTraitsGetter;
import org.apache.fop.util.CharUtilities;

public class DelimitedTextRange {
    private FONode fn;
    private StringBuffer buffer;
    private List intervals;
    private static final Log log = LogFactory.getLog(BidiResolver.class);

    public DelimitedTextRange(FONode fn) {
        this.fn = fn;
        this.buffer = new StringBuffer();
        this.intervals = new Vector();
    }

    public FONode getNode() {
        return this.fn;
    }

    public void append(CharIterator it, FONode fn) {
        if (it != null) {
            int s;
            int e = s = this.buffer.length();
            while (it.hasNext()) {
                char c = it.nextChar();
                this.buffer.append(c);
                ++e;
            }
            this.intervals.add(new TextInterval(fn, s, e));
        }
    }

    public void append(char c, FONode fn) {
        if (c != '\u0000') {
            int s = this.buffer.length();
            int e = s + 1;
            this.buffer.append(c);
            this.intervals.add(new TextInterval(fn, s, e));
        }
    }

    public boolean isEmpty() {
        return this.buffer.length() == 0;
    }

    public void resolve() {
        WritingModeTraitsGetter tg = WritingModeTraits.getWritingModeTraitsGetter(this.getNode());
        if (tg != null) {
            this.resolve(tg.getInlineProgressionDirection());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DR: " + this.fn.getLocalName() + " { <" + CharUtilities.toNCRefs(this.buffer.toString()) + ">");
        sb.append(", intervals <");
        boolean first = true;
        for (TextInterval ti : this.intervals) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(ti.toString());
        }
        sb.append("> }");
        return sb.toString();
    }

    private void resolve(Direction paragraphEmbeddingLevel) {
        int[] levels = UnicodeBidiAlgorithm.resolveLevels(this.buffer, paragraphEmbeddingLevel);
        if (levels != null) {
            this.assignLevels(levels);
            this.assignBlockLevel(paragraphEmbeddingLevel);
            this.assignTextLevels();
        }
    }

    private void assignLevels(int[] levels) {
        Vector intervalsNew = new Vector(this.intervals.size());
        for (TextInterval ti : this.intervals) {
            intervalsNew.addAll(this.assignLevels(ti, levels));
        }
        if (!intervalsNew.equals(this.intervals)) {
            this.intervals = intervalsNew;
        }
    }

    private List assignLevels(TextInterval ti, int[] levels) {
        int fnStart;
        Vector<TextInterval> tiv = new Vector<TextInterval>();
        FONode fn = ti.getNode();
        int i = fnStart = ti.getStart();
        int n = ti.getEnd();
        while (i < n) {
            int e;
            int s;
            int l = levels[s];
            for (e = s = i; e < n && levels[e] == l; ++e) {
            }
            if (ti.getStart() == s && ti.getEnd() == e) {
                ti.setLevel(l);
            } else {
                ti = new TextInterval(fn, fnStart, s, e, l);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("AL(" + l + "): " + ti));
            }
            tiv.add(ti);
            i = e;
        }
        return tiv;
    }

    private void assignTextLevels() {
        for (TextInterval ti : this.intervals) {
            ti.assignTextLevels();
        }
    }

    private void assignBlockLevel(Direction paragraphEmbeddingLevel) {
        int defaultLevel = paragraphEmbeddingLevel == Direction.RL ? 1 : 0;
        for (TextInterval ti : this.intervals) {
            this.assignBlockLevel(ti.getNode(), defaultLevel);
        }
    }

    private void assignBlockLevel(FONode node, int defaultLevel) {
        for (FONode fn = node; fn != null; fn = fn.getParent()) {
            FObj fo;
            if (!(fn instanceof FObj) || !(fo = (FObj)fn).isBidiRangeBlockItem()) continue;
            if (fo.getBidiLevel() >= 0) break;
            fo.setBidiLevel(defaultLevel);
            break;
        }
    }
}

