/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;

public class VersionParser
implements Transformer<Version, String> {
    public Version transform(String original) {
        int pos;
        ArrayList<String> parts = new ArrayList<String>();
        boolean digit = false;
        int startPart = 0;
        int endBase = 0;
        int endBaseStr = 0;
        for (pos = 0; pos < original.length(); ++pos) {
            char ch = original.charAt(pos);
            if (ch == '.' || ch == '_' || ch == '-' || ch == '+') {
                parts.add(original.substring(startPart, pos));
                startPart = pos + 1;
                digit = false;
                if (ch == '.' || endBaseStr != 0) continue;
                endBase = parts.size();
                endBaseStr = pos;
                continue;
            }
            if (ch >= '0' && ch <= '9') {
                if (!digit && pos > startPart) {
                    if (endBaseStr == 0) {
                        endBase = parts.size() + 1;
                        endBaseStr = pos;
                    }
                    parts.add(original.substring(startPart, pos));
                    startPart = pos;
                }
                digit = true;
                continue;
            }
            if (digit) {
                if (endBaseStr == 0) {
                    endBase = parts.size() + 1;
                    endBaseStr = pos;
                }
                parts.add(original.substring(startPart, pos));
                startPart = pos;
            }
            digit = false;
        }
        if (pos > startPart) {
            parts.add(original.substring(startPart, pos));
        }
        DefaultVersion base = null;
        if (endBaseStr > 0) {
            base = new DefaultVersion(original.substring(0, endBaseStr), parts.subList(0, endBase), null);
        }
        return new DefaultVersion(original, parts, base);
    }

    private static class DefaultVersion
    implements Version {
        private final String source;
        private final String[] parts;
        private final DefaultVersion baseVersion;

        public DefaultVersion(String source, List<String> parts, DefaultVersion baseVersion) {
            this.source = source;
            this.parts = parts.toArray(new String[0]);
            this.baseVersion = baseVersion == null ? this : baseVersion;
        }

        public String toString() {
            return this.source;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            DefaultVersion other = (DefaultVersion)obj;
            return this.source.equals(other.source);
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        @Override
        public boolean isQualified() {
            return this.baseVersion != this;
        }

        @Override
        public Version getBaseVersion() {
            return this.baseVersion;
        }

        @Override
        public String[] getParts() {
            return this.parts;
        }
    }
}

