/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.coffeescript.compile.internal.rhino;

import java.io.File;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.WorkResult;
import org.gradle.plugins.javascript.coffeescript.CoffeeScriptCompileSpec;
import org.gradle.plugins.javascript.coffeescript.CoffeeScriptCompiler;
import org.gradle.plugins.javascript.coffeescript.compile.internal.SerializableCoffeeScriptCompileSpec;
import org.gradle.plugins.javascript.coffeescript.compile.internal.rhino.CoffeeScriptCompilerProtocol;
import org.gradle.plugins.javascript.coffeescript.compile.internal.rhino.CoffeeScriptCompilerWorker;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerHandleFactory;

public class RhinoCoffeeScriptCompiler
implements CoffeeScriptCompiler {
    private final RhinoWorkerHandleFactory rhinoWorkerHandleFactory;
    private final Iterable<File> rhinoClasspath;
    private final LogLevel logLevel;
    private final File workingDir;

    public RhinoCoffeeScriptCompiler(RhinoWorkerHandleFactory rhinoWorkerHandleFactory, Iterable<File> rhinoClasspath, LogLevel logLevel, File workingDir) {
        this.rhinoWorkerHandleFactory = rhinoWorkerHandleFactory;
        this.rhinoClasspath = rhinoClasspath;
        this.logLevel = logLevel;
        this.workingDir = workingDir;
    }

    @Override
    public WorkResult compile(CoffeeScriptCompileSpec spec) {
        CoffeeScriptCompilerProtocol compiler = this.rhinoWorkerHandleFactory.create(this.rhinoClasspath, CoffeeScriptCompilerProtocol.class, CoffeeScriptCompilerWorker.class, this.logLevel, this.workingDir);
        compiler.process(new SerializableCoffeeScriptCompileSpec(spec));
        return new WorkResult(){

            public boolean getDidWork() {
                return true;
            }
        };
    }
}

