/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ValueParameterDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmPackagePartSource;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValueParameterDescriptor> copyValueParameters(@NotNull Collection<? extends KotlinType> newValueParametersTypes, @NotNull Collection<? extends ValueParameterDescriptor> oldValueParameters, @NotNull CallableDescriptor newOwner) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(newValueParametersTypes, "newValueParametersTypes");
        Intrinsics.checkParameterIsNotNull(oldValueParameters, "oldValueParameters");
        Intrinsics.checkParameterIsNotNull(newOwner, "newOwner");
        boolean bl = newValueParametersTypes.size() == oldValueParameters.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Different value parameters sizes: Enhanced = " + newValueParametersTypes.size() + ", Old = " + oldValueParameters.size();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Iterable $receiver$iv = CollectionsKt.zip((Iterable)newValueParametersTypes, (Iterable)oldValueParameters);
        Iterable $i$a$1$assert = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void newType;
            void oldParameter;
            void pair;
            Pair pair2 = (Pair)item$iv$iv;
            void var9_11 = destination$iv$iv;
            Object var10_12 = pair;
            KotlinType kotlinType = (KotlinType)var10_12.component1();
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)var10_12.component2();
            var10_12 = null;
            int n = oldParameter.getIndex();
            Annotations annotations2 = oldParameter.getAnnotations();
            Name name = oldParameter.getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "oldParameter.name");
            boolean bl2 = oldParameter.declaresDefaultValue();
            boolean bl3 = oldParameter.isCrossinline();
            boolean bl4 = oldParameter.isNoinline();
            boolean bl5 = oldParameter.isCoroutine();
            KotlinType kotlinType2 = oldParameter.getVarargElementType() != null ? DescriptorUtilsKt.getModule(newOwner).getBuiltIns().getArrayElementType((KotlinType)newType) : (KotlinType)null;
            SourceElement sourceElement = oldParameter.getSource();
            Intrinsics.checkExpressionValueIsNotNull(sourceElement, "oldParameter.source");
            ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(newOwner, (ValueParameterDescriptor)oldParameter, n, annotations2, name, (KotlinType)newType, bl2, bl3, bl4, bl5, kotlinType2, sourceElement);
            var9_11.add(valueParameterDescriptorImpl);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final LazyJavaStaticClassScope getParentJavaStaticClassScope(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny($receiver);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor superClassDescriptor = classDescriptor;
        MemberScope staticScope = superClassDescriptor.getStaticScope();
        if (!(staticScope instanceof LazyJavaStaticClassScope)) {
            return UtilKt.getParentJavaStaticClassScope(superClassDescriptor);
        }
        return (LazyJavaStaticClassScope)staticScope;
    }

    @Nullable
    public static final Name getImplClassNameForDeserialized(@NotNull DeserializedCallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        SourceElement sourceElement = $receiver.getContainerSource();
        if (!(sourceElement instanceof JvmPackagePartSource)) {
            sourceElement = null;
        }
        JvmPackagePartSource jvmPackagePartSource = (JvmPackagePartSource)sourceElement;
        return jvmPackagePartSource != null ? jvmPackagePartSource.getSimpleName() : null;
    }
}

