/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.AbstractModifierChecks;
import kotlin.reflect.jvm.internal.impl.util.Check;
import kotlin.reflect.jvm.internal.impl.util.Checks;
import kotlin.reflect.jvm.internal.impl.util.IsKPropertyCheck;
import kotlin.reflect.jvm.internal.impl.util.MemberKindCheck;
import kotlin.reflect.jvm.internal.impl.util.NoDefaultAndVarargsCheck;
import kotlin.reflect.jvm.internal.impl.util.NoTypeParametersCheck;
import kotlin.reflect.jvm.internal.impl.util.OperatorChecks;
import kotlin.reflect.jvm.internal.impl.util.OperatorNameConventions;
import kotlin.reflect.jvm.internal.impl.util.ReturnsCheck;
import kotlin.reflect.jvm.internal.impl.util.ValueParameterCountCheck;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OperatorChecks
extends AbstractModifierChecks {
    @NotNull
    private static final List<Checks> checks;
    public static final OperatorChecks INSTANCE;

    @Override
    @NotNull
    public List<Checks> getChecks$kotlin_core() {
        return checks;
    }

    /*
     * WARNING - void declaration
     */
    private final String checkHandleSecondParameter(@NotNull FunctionDescriptor $receiver) {
        void cond$iv;
        ValueParameterDescriptor secondParameter = $receiver.getValueParameters().get(1);
        OperatorChecks operatorChecks = this;
        KotlinType kotlinType = secondParameter.getType();
        FqName fqName2 = DescriptorUtils.CONTINUATION_INTERFACE_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "DescriptorUtils.CONTINUATION_INTERFACE_FQ_NAME");
        boolean bl = TypeUtilsKt.isConstructedFromClassWithGivenFqName(kotlinType, fqName2) && TypeUtilsKt.isNothing(secondParameter.getType().getArguments().get(0).getType());
        return cond$iv == false ? "Second parameter should be Continuation<Nothing>" : (String)null;
    }

    private OperatorChecks() {
        INSTANCE = this;
        Checks[] checksArray = new Checks[19];
        Name name = OperatorNameConventions.GET;
        Intrinsics.checkExpressionValueIsNotNull(name, "GET");
        checksArray[0] = new Checks(name, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, new ValueParameterCountCheck.AtLeast(1)}, null, 4, null);
        Name name2 = OperatorNameConventions.SET;
        Intrinsics.checkExpressionValueIsNotNull(name2, "SET");
        checksArray[1] = new Checks(name2, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, new ValueParameterCountCheck.AtLeast(2)}, (Function1<? super FunctionDescriptor, String>)checks.1.INSTANCE);
        Name name3 = OperatorNameConventions.GET_VALUE;
        Intrinsics.checkExpressionValueIsNotNull(name3, "GET_VALUE");
        checksArray[2] = new Checks(name3, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.AtLeast(2), IsKPropertyCheck.INSTANCE}, null, 4, null);
        Name name4 = OperatorNameConventions.SET_VALUE;
        Intrinsics.checkExpressionValueIsNotNull(name4, "SET_VALUE");
        checksArray[3] = new Checks(name4, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.AtLeast(3), IsKPropertyCheck.INSTANCE}, null, 4, null);
        Name name5 = OperatorNameConventions.INVOKE;
        Intrinsics.checkExpressionValueIsNotNull(name5, "INVOKE");
        checksArray[4] = new Checks(name5, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE}, null, 4, null);
        Name name6 = OperatorNameConventions.CONTAINS;
        Intrinsics.checkExpressionValueIsNotNull(name6, "CONTAINS");
        checksArray[5] = new Checks(name6, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, ReturnsCheck.ReturnsBoolean.INSTANCE}, null, 4, null);
        Name name7 = OperatorNameConventions.ITERATOR;
        Intrinsics.checkExpressionValueIsNotNull(name7, "ITERATOR");
        checksArray[6] = new Checks(name7, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE}, null, 4, null);
        Name name8 = OperatorNameConventions.NEXT;
        Intrinsics.checkExpressionValueIsNotNull(name8, "NEXT");
        checksArray[7] = new Checks(name8, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE}, null, 4, null);
        Name name9 = OperatorNameConventions.HAS_NEXT;
        Intrinsics.checkExpressionValueIsNotNull(name9, "HAS_NEXT");
        checksArray[8] = new Checks(name9, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE, ReturnsCheck.ReturnsBoolean.INSTANCE}, null, 4, null);
        Name name10 = OperatorNameConventions.RANGE_TO;
        Intrinsics.checkExpressionValueIsNotNull(name10, "RANGE_TO");
        checksArray[9] = new Checks(name10, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE}, null, 4, null);
        Name name11 = OperatorNameConventions.EQUALS;
        Intrinsics.checkExpressionValueIsNotNull(name11, "EQUALS");
        checksArray[10] = new Checks(name11, new Check[]{MemberKindCheck.Member.INSTANCE}, (Function1<? super FunctionDescriptor, String>)checks.2.INSTANCE);
        Name name12 = OperatorNameConventions.COMPARE_TO;
        Intrinsics.checkExpressionValueIsNotNull(name12, "COMPARE_TO");
        checksArray[11] = new Checks(name12, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ReturnsCheck.ReturnsInt.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE}, null, 4, null);
        checksArray[12] = new Checks(OperatorNameConventions.BINARY_OPERATION_NAMES, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE}, null, 4, null);
        checksArray[13] = new Checks(OperatorNameConventions.SIMPLE_UNARY_OPERATION_NAMES, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE}, null, 4, null);
        checksArray[14] = new Checks((Collection<Name>)CollectionsKt.listOf(new Name[]{OperatorNameConventions.INC, OperatorNameConventions.DEC}), new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE}, (Function1<? super FunctionDescriptor, String>)checks.3.INSTANCE);
        checksArray[15] = new Checks(OperatorNameConventions.ASSIGNMENT_OPERATIONS, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ReturnsCheck.ReturnsUnit.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE}, null, 4, null);
        checksArray[16] = new Checks(OperatorNameConventions.COMPONENT_REGEX, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE}, null, 4, null);
        Name name13 = OperatorNameConventions.COROUTINE_HANDLE_RESULT;
        Intrinsics.checkExpressionValueIsNotNull(name13, "COROUTINE_HANDLE_RESULT");
        checksArray[17] = new Checks(name13, new Check[]{MemberKindCheck.Member.INSTANCE, new ValueParameterCountCheck.Equals(2), ReturnsCheck.ReturnsUnit.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, NoTypeParametersCheck.INSTANCE}, (Function1<? super FunctionDescriptor, String>)checks.4.INSTANCE);
        Name name14 = OperatorNameConventions.COROUTINE_HANDLE_EXCEPTION;
        Intrinsics.checkExpressionValueIsNotNull(name14, "COROUTINE_HANDLE_EXCEPTION");
        checksArray[18] = new Checks(name14, new Check[]{MemberKindCheck.Member.INSTANCE, new ValueParameterCountCheck.Equals(2), ReturnsCheck.ReturnsUnit.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, NoTypeParametersCheck.INSTANCE}, (Function1<? super FunctionDescriptor, String>)checks.5.INSTANCE);
        checks = CollectionsKt.listOf(checksArray);
    }

    static {
        new OperatorChecks();
    }

    @Nullable
    public static final /* synthetic */ String access$checkHandleSecondParameter(OperatorChecks $this, @NotNull FunctionDescriptor $receiver) {
        return $this.checkHandleSecondParameter($receiver);
    }
}

