/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.coroutines;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.coroutines.UninitializedNewValue;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/codegen/coroutines/UninitializedNewValueMarkerInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter;", "()V", "uninitializedValuesToCopyUsages", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "", "getUninitializedValuesToCopyUsages", "()Ljava/util/HashMap;", "copyOperation", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "value", "merge", "v", "w", "newOperation", "kotlin-compiler"})
final class UninitializedNewValueMarkerInterpreter
extends OptimizationBasicInterpreter {
    @NotNull
    private final HashMap<AbstractInsnNode, Set<AbstractInsnNode>> uninitializedValuesToCopyUsages = MapsKt.hashMapOf(new Pair[0]);

    @NotNull
    public final HashMap<AbstractInsnNode, Set<AbstractInsnNode>> getUninitializedValuesToCopyUsages() {
        return this.uninitializedValuesToCopyUsages;
    }

    @Override
    @Nullable
    public BasicValue newOperation(@NotNull AbstractInsnNode insn) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        if (insn.getOpcode() == 187) {
            Map map2 = this.uninitializedValuesToCopyUsages;
            Set<AbstractInsnNode> set = SetsKt.mutableSetOf(new AbstractInsnNode[0]);
            map2.put(insn, set);
            AbstractInsnNode abstractInsnNode = insn;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TypeInsnNode");
            }
            TypeInsnNode typeInsnNode = (TypeInsnNode)abstractInsnNode;
            String string = ((TypeInsnNode)insn).desc;
            Intrinsics.checkExpressionValueIsNotNull(string, "insn.desc");
            return new UninitializedNewValue(typeInsnNode, string);
        }
        return super.newOperation(insn);
    }

    @Override
    @Nullable
    public BasicValue copyOperation(@NotNull AbstractInsnNode insn, @Nullable BasicValue value) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        if (value instanceof UninitializedNewValue) {
            Set<AbstractInsnNode> set = this.uninitializedValuesToCopyUsages.get(((UninitializedNewValue)value).getNewInsn());
            if (set == null) {
                Intrinsics.throwNpe();
            }
            set.add(insn);
            return value;
        }
        return super.copyOperation(insn, value);
    }

    @Override
    @NotNull
    public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        Intrinsics.checkParameterIsNotNull(w, "w");
        if (v == w) {
            return v;
        }
        if (v == BasicValue.UNINITIALIZED_VALUE || w == BasicValue.UNINITIALIZED_VALUE) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        if (v instanceof UninitializedNewValue || w instanceof UninitializedNewValue) {
            BasicValue basicValue = v;
            if (!(basicValue instanceof UninitializedNewValue)) {
                basicValue = null;
            }
            UninitializedNewValue uninitializedNewValue = (UninitializedNewValue)basicValue;
            TypeInsnNode typeInsnNode = uninitializedNewValue != null ? uninitializedNewValue.getNewInsn() : null;
            BasicValue basicValue2 = w;
            if (!(basicValue2 instanceof UninitializedNewValue)) {
                basicValue2 = null;
            }
            UninitializedNewValue uninitializedNewValue2 = (UninitializedNewValue)basicValue2;
            if (typeInsnNode != (uninitializedNewValue2 != null ? uninitializedNewValue2.getNewInsn() : null)) {
                BasicValue basicValue3 = BasicValue.UNINITIALIZED_VALUE;
                Intrinsics.checkExpressionValueIsNotNull(basicValue3, "BasicValue.UNINITIALIZED_VALUE");
                return basicValue3;
            }
            return v;
        }
        BasicValue basicValue = super.merge(v, w);
        Intrinsics.checkExpressionValueIsNotNull(basicValue, "super.merge(v, w)");
        return basicValue;
    }
}

