/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultFileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.DirSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyPathSensitivity;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.cache.CacheAccess;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractFileCollectionSnapshotter
implements FileCollectionSnapshotter {
    protected final FileSnapshotter snapshotter;
    protected final StringInterner stringInterner;
    protected final FileResolver fileResolver;
    protected CacheAccess cacheAccess;

    public AbstractFileCollectionSnapshotter(FileSnapshotter snapshotter, CacheAccess cacheAccess, StringInterner stringInterner, FileResolver fileResolver) {
        this.snapshotter = snapshotter;
        this.cacheAccess = cacheAccess;
        this.stringInterner = stringInterner;
        this.fileResolver = fileResolver;
    }

    @Override
    public FileCollectionSnapshot emptySnapshot() {
        return new DefaultFileCollectionSnapshot(Collections.<String, NormalizedFileSnapshot>emptyMap(), TaskFilePropertyCompareStrategy.UNORDERED);
    }

    @Override
    public void registerSerializers(SerializerRegistry registry) {
        registry.register(DefaultFileCollectionSnapshot.class, (Serializer)new DefaultFileCollectionSnapshot.SerializerImpl(this.stringInterner));
    }

    @Override
    public FileCollectionSnapshot snapshot(FileCollection input, TaskFilePropertyCompareStrategy compareStrategy, final TaskFilePropertyPathSensitivity pathSensitivity) {
        final LinkedList fileTreeElements = Lists.newLinkedList();
        final ArrayList missingFiles = Lists.newArrayList();
        this.visitFiles(input, fileTreeElements, missingFiles);
        if (fileTreeElements.isEmpty() && missingFiles.isEmpty()) {
            return this.emptySnapshot();
        }
        final LinkedHashMap snapshots = Maps.newLinkedHashMap();
        this.cacheAccess.useCache("Create file snapshot", new Runnable(){

            public void run() {
                String absolutePath;
                for (FileTreeElement fileDetails : fileTreeElements) {
                    IncrementalFileSnapshot snapshot;
                    NormalizedFileSnapshot normalizedSnapshot;
                    absolutePath = AbstractFileCollectionSnapshotter.this.getInternedAbsolutePath(fileDetails.getFile());
                    if (snapshots.containsKey(absolutePath) || (normalizedSnapshot = pathSensitivity.getNormalizedSnapshot(fileDetails, snapshot = fileDetails.isDirectory() ? DirSnapshot.getInstance() : new FileHashSnapshot(AbstractFileCollectionSnapshotter.this.snapshotter.snapshot(fileDetails).getHash(), fileDetails.getLastModified()), AbstractFileCollectionSnapshotter.this.stringInterner)) == null) continue;
                    snapshots.put(absolutePath, normalizedSnapshot);
                }
                for (FileTreeElement missingFileDetails : missingFiles) {
                    absolutePath = AbstractFileCollectionSnapshotter.this.getInternedAbsolutePath(missingFileDetails.getFile());
                    if (snapshots.containsKey(absolutePath)) continue;
                    snapshots.put(absolutePath, pathSensitivity.getNormalizedSnapshot(missingFileDetails, MissingFileSnapshot.getInstance(), AbstractFileCollectionSnapshotter.this.stringInterner));
                }
            }
        });
        return new DefaultFileCollectionSnapshot(snapshots, compareStrategy);
    }

    @Override
    public FileCollectionSnapshot snapshot(TaskFilePropertySpec propertySpec) {
        return this.snapshot(propertySpec.getPropertyFiles(), propertySpec.getCompareStrategy(), propertySpec.getPathSensitivity());
    }

    private String getInternedAbsolutePath(File file) {
        return this.stringInterner.intern(file.getAbsolutePath());
    }

    protected abstract void visitFiles(FileCollection var1, List<FileTreeElement> var2, List<FileTreeElement> var3);
}

