/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class ReactorCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    @Override
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation(classNode, "EnableReactor") || AstUtils.hasAtLeastOneFieldOrMethod(classNode, "EventBus");
    }

    @Override
    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses("reactor.bus.EventBus").add("reactor-spring-context", false).add("reactor-spring-core", false).add("reactor-bus").add("reactor-stream");
    }

    @Override
    public void applyImports(ImportCustomizer imports) {
        imports.addImports(new String[]{"reactor.bus.Bus", "reactor.bus.Event", "reactor.bus.EventBus", "reactor.fn.Function", "reactor.fn.Functions", "reactor.fn.Predicate", "reactor.fn.Predicates", "reactor.fn.Supplier", "reactor.fn.Suppliers", "reactor.spring.context.annotation.Consumer", "reactor.spring.context.annotation.ReplyTo", "reactor.spring.context.annotation.Selector", "reactor.spring.context.annotation.SelectorType", "reactor.spring.context.config.EnableReactor"}).addStarImports(new String[]{"reactor.bus.selector.Selectors"}).addImport("ReactorEnvironment", "reactor.Environment");
    }
}

