/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.jmol.console.GenericConsole;
import org.jmol.console.JmolButton;
import org.jmol.console.KeyJCheckBox;
import org.jmol.console.KeyJCheckBoxMenuItem;
import org.jmol.console.KeyJMenu;
import org.jmol.console.KeyJMenuItem;
import org.jmol.console.KeyJRadioButtonMenuItem;
import org.jmol.i18n.GT;
import org.jmol.viewer.JC;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;

public class GuiMap {
    private static Object language;
    Map<String, Object> map = new Hashtable<String, Object>();
    Map<String, String> labels;
    private static String[] translations;

    private void setupLabels() {
        this.labels = new Hashtable<String, String>();
        this.labels.put("macros", GT._("&Macros"));
        this.labels.put("idfileMenu", GT._("&File"));
        this.labels.put("file", GT._("&File"));
        this.labels.put("newwin", GT._("&New"));
        this.labels.put("open", GT._("&Open"));
        this.labels.put("openTip", GT._("Open a file."));
        this.labels.put("openurl", GT._("Open &URL"));
        this.labels.put("openpdb", GT._("&Get PDB"));
        this.labels.put("openmol", GT._("Get &MOL"));
        this.labels.put("reloadScript", GT._("&Reload"));
        this.labels.put("spectrumMenu", "&Spectra");
        this.labels.put("openJSpecViewScript", "JSpecView");
        this.labels.put("simulate1HSpectrumScript", "Simulated 1H Spectrum");
        this.labels.put("simulate13CSpectrumScript", "Simulated 13C Spectrum");
        this.labels.put("editor", GT._("Scrip&t Editor..."));
        this.labels.put("console", GT._("Conso&le..."));
        this.labels.put("jconsole", GT._("Jmol Java &Console"));
        this.labels.put("atomsetchooser", GT._("AtomSet&Chooser..."));
        this.labels.put("saveas", GT._("&Save As..."));
        this.labels.put("exportMenu", GT._("&Export"));
        this.labels.put("export", GT._("Export &Image..."));
        this.labels.put("exportTip", GT._("Save current view as an image."));
        this.labels.put("toweb", GT._("Export to &Web Page..."));
        this.labels.put("towebTip", GT._("Export one or more views to a web page."));
        this.labels.put("povray", GT._("Render in POV-&Ray..."));
        this.labels.put("povrayTip", GT._("Render in POV-Ray"));
        this.labels.put("write", GT._("Write &State..."));
        this.labels.put("writeTip", GT._("Save current view as a Jmol state script."));
        this.labels.put("print", GT._("&Print..."));
        this.labels.put("printTip", GT._("Print view."));
        this.labels.put("close", GT._("&Close"));
        this.labels.put("exit", GT._("E&xit"));
        this.labels.put("recentFiles", GT._("Recent &Files..."));
        this.labels.put("edit", GT._("&Edit"));
        this.labels.put("selectall", GT._("Select &All"));
        this.labels.put("deselectall", GT._("Deselect All"));
        this.labels.put("copyImage", GT._("Copy &Image"));
        this.labels.put("copyScript", GT._("Copy Script"));
        this.labels.put("prefs", GT._("Pr&eferences..."));
        this.labels.put("pasteClipboard", GT._("&Paste"));
        this.labels.put("editSelectAllScript", GT._("Select &All"));
        this.labels.put("selectMenu", GT._("&Select"));
        this.labels.put("selectMenuText", GT._("&Select"));
        this.labels.put("selectAllScript", GT._("&All"));
        this.labels.put("selectNoneScript", GT._("&None"));
        this.labels.put("selectHydrogenScript", GT._("Hydrogen"));
        this.labels.put("selectCarbonScript", GT._("Carbon"));
        this.labels.put("selectNitrogenScript", GT._("Nitrogen"));
        this.labels.put("selectOxygenScript", GT._("Oxygen"));
        this.labels.put("selectPhosphorusScript", GT._("Phosphorus"));
        this.labels.put("selectSulfurScript", GT._("Sulfur"));
        this.labels.put("selectAminoScript", GT._("Amino"));
        this.labels.put("selectNucleicScript", GT._("Nucleic"));
        this.labels.put("selectWaterScript", GT._("Water"));
        this.labels.put("selectHeteroScript", GT._("Hetero"));
        this.labels.put("display", GT._("&Display"));
        this.labels.put("atomMenu", GT._("&Atom"));
        this.labels.put("atomNoneScript", GT._("&None"));
        this.labels.put("atom15Script", GT.o(GT._("{0}% van der Waals"), "15"));
        this.labels.put("atom20Script", GT.o(GT._("{0}% van der Waals"), "20"));
        this.labels.put("atom25Script", GT.o(GT._("{0}% van der Waals"), "25"));
        this.labels.put("atom100Script", GT.o(GT._("{0}% van der Waals"), "100"));
        this.labels.put("bondMenu", GT._("&Bond"));
        this.labels.put("bondNoneScript", GT._("&None"));
        this.labels.put("bondWireframeScript", GT._("&Wireframe"));
        this.labels.put("bond100Script", GT.o(GT._("{0} \u00c5"), "0.10"));
        this.labels.put("bond150Script", GT.o(GT._("{0} \u00c5"), "0.15"));
        this.labels.put("bond200Script", GT.o(GT._("{0} \u00c5"), "0.20"));
        this.labels.put("labelMenu", GT._("&Label"));
        this.labels.put("labelNoneScript", GT._("&None"));
        this.labels.put("labelSymbolScript", GT._("&Symbol"));
        this.labels.put("labelNameScript", GT._("&Name"));
        this.labels.put("labelNumberScript", GT._("&Number"));
        this.labels.put("labelCenteredScript", GT._("&Centered"));
        this.labels.put("labelUpperRightScript", GT._("&Upper right"));
        this.labels.put("vectorMenu", GT._("&Vector"));
        this.labels.put("vectorOffScript", GT._("&None"));
        this.labels.put("vectorOnScript", GT._("&On"));
        this.labels.put("vector3Script", GT.o(GT._("{0} pixels"), "3"));
        this.labels.put("vector005Script", GT.o(GT._("{0} \u00c5"), "0.05"));
        this.labels.put("vector01Script", GT.o(GT._("{0} \u00c5"), "0.1"));
        this.labels.put("vectorScale02Script", GT.o(GT._("Scale {0}"), "0.2"));
        this.labels.put("vectorScale05Script", GT.o(GT._("Scale {0}"), "0.5"));
        this.labels.put("vectorScale1Script", GT.o(GT._("Scale {0}"), "1"));
        this.labels.put("vectorScale2Script", GT.o(GT._("Scale {0}"), "2"));
        this.labels.put("vectorScale5Script", GT.o(GT._("Scale {0}"), "5"));
        this.labels.put("zoomMenu", GT._("&Zoom"));
        this.labels.put("zoom100Script", GT.o(GT._("{0}%"), "100"));
        this.labels.put("zoom150Script", GT.o(GT._("{0}%"), "150"));
        this.labels.put("zoom200Script", GT.o(GT._("{0}%"), "200"));
        this.labels.put("zoom400Script", GT.o(GT._("{0}%"), "400"));
        this.labels.put("zoom800Script", GT.o(GT._("{0}%"), "800"));
        this.labels.put("perspectiveCheck", GT._("&Perspective Depth"));
        this.labels.put("axesCheck", GT._("A&xes"));
        this.labels.put("boundboxCheck", GT._("B&ounding Box"));
        this.labels.put("hydrogensCheck", GT._("&Hydrogens"));
        this.labels.put("vectorsCheck", GT._("V&ectors"));
        this.labels.put("measurementsCheck", GT._("&Measurements"));
        this.labels.put("resize", GT._("Resi&ze"));
        this.labels.put("view", GT._("&View"));
        this.labels.put("front", GT._("&Front"));
        this.labels.put("top", GT._("&Top"));
        this.labels.put("bottom", GT._("&Bottom"));
        this.labels.put("right", GT._("&Right"));
        this.labels.put("left", GT._("&Left"));
        this.labels.put("axisaScript", GT._("Axis a"));
        this.labels.put("axisbScript", GT._("Axis b"));
        this.labels.put("axiscScript", GT._("Axis c"));
        this.labels.put("axisxScript", GT._("Axis x"));
        this.labels.put("axisyScript", GT._("Axis y"));
        this.labels.put("axiszScript", GT._("Axis z"));
        this.labels.put("transform", GT._("Tr&ansform..."));
        this.labels.put("definecenter", GT._("Define &Center"));
        this.labels.put("tools", GT._("&Tools"));
        this.labels.put("gauss", GT._("&Gaussian..."));
        this.labels.put("nboMenu", "&NBO...");
        this.labels.put("nboConfigScript", GT._("&Config"));
        this.labels.put("nboModelScript", GT._("&Model"));
        this.labels.put("nboRunScript", GT._("&Run"));
        this.labels.put("nboViewScript", GT._("&View"));
        this.labels.put("nboSearchScript", GT._("&Search"));
        this.labels.put("viewMeasurementTable", GT._("&Measurements") + "...");
        this.labels.put("distanceUnitsMenu", GT._("Distance &Units"));
        this.labels.put("distanceNanometersScript", GT._("&Nanometers 1E-9"));
        this.labels.put("distanceAngstromsScript", GT._("&Angstroms 1E-10"));
        this.labels.put("distancePicometersScript", GT._("&Picometers 1E-12"));
        this.labels.put("animateMenu", GT._("&Animate..."));
        this.labels.put("vibrateMenu", GT._("&Vibrate..."));
        this.labels.put("graph", GT._("&Graph..."));
        this.labels.put("chemicalShifts", GT._("Calculate chemical &shifts..."));
        this.labels.put("crystprop", GT._("&Crystal Properties"));
        this.labels.put("animateOnceScript", GT._("&Once"));
        this.labels.put("animateLoopScript", GT._("&Loop"));
        this.labels.put("animatePalindromeScript", GT._("P&alindrome"));
        this.labels.put("animateStopScript", GT._("&Stop animation"));
        this.labels.put("animateRewindScript", GT._("&Rewind to first frame"));
        this.labels.put("animateRewindScriptTip", GT._("Rewind to first frame"));
        this.labels.put("animateNextScript", GT._("Go to &next frame"));
        this.labels.put("animateNextScriptTip", GT._("Go to next frame"));
        this.labels.put("animatePrevScript", GT._("Go to &previous frame"));
        this.labels.put("animatePrevScriptTip", GT._("Go to previous frame"));
        this.labels.put("animateAllScript", GT._("All &frames"));
        this.labels.put("animateAllScriptTip", GT._("All frames"));
        this.labels.put("animateLastScript", GT._("Go to &last frame"));
        this.labels.put("animateLastScriptTip", GT._("Go to last frame"));
        this.labels.put("vibrateStartScript", GT._("Start &vibration"));
        this.labels.put("vibrateStopScript", GT._("&Stop vibration"));
        this.labels.put("vibrateRewindScript", GT._("&First frequency"));
        this.labels.put("vibrateNextScript", GT._("&Next frequency"));
        this.labels.put("vibratePrevScript", GT._("&Previous frequency"));
        this.labels.put("surfaceTool", GT._("SurfaceTool..."));
        this.labels.put("surfaceToolTip", GT._("Control Display of Surfaces"));
        this.labels.put("help", GT._("&Help"));
        this.labels.put("about", GT._("About Jmol"));
        this.labels.put("uguide", GT._("Jmol Wiki"));
        this.labels.put("whatsnew", GT._("What's New"));
        this.labels.put("credits", GT._("Credits"));
        this.labels.put("Prefs.showHydrogens", GT._("Hydrogens"));
        this.labels.put("Prefs.showMeasurements", GT._("Measurements"));
        this.labels.put("Prefs.perspectiveDepth", GT._("Perspective Depth"));
        this.labels.put("Prefs.showAxes", GT._("Axes"));
        this.labels.put("Prefs.showBoundingBox", GT._("Bounding Box"));
        this.labels.put("Prefs.axesOrientationRasmol", GT._("RasMol/Chime compatible axes orientation/rotations"));
        this.labels.put("Prefs.openFilePreview", GT._("File Preview (requires restarting Jmol)"));
        this.labels.put("Prefs.clearHistory", GT._("Clear history (requires restarting Jmol)"));
        this.labels.put("Prefs.largeFont", GT._("Large Console Font"));
        this.labels.put("Prefs.isLabelAtomColor", GT._("Use Atom Color"));
        this.labels.put("Prefs.isBondAtomColor", GT._("Use Atom Color"));
        this.labels.put("rotateScriptTip", GT._("Rotate molecule."));
        this.labels.put("pickScriptTip", GT._("Select a set of atoms using SHIFT-LEFT-DRAG."));
        this.labels.put("pickMeasureScriptTip", GT._("Click atoms to measure distances"));
        this.labels.put("pickCenterScriptTip", GT._("Click an atom to center on it"));
        this.labels.put("homeTip", GT._("Return molecule to home position."));
        this.labels.put("modelkitScriptTip", GT._("Open the model kit."));
        this.labels.put("JavaConsole.clear", GT._("Clear"));
    }

    String getLabel(String key) {
        if (this.labels == null) {
            this.setupLabels();
        }
        String label = this.labels.get(key);
        return label;
    }

    JMenu newJMenu(String key) {
        return new KeyJMenu(key, this.getLabel(key), this.map);
    }

    JMenuItem newJMenuItem(String key) {
        return new KeyJMenuItem(key, this.getLabel(key), this.map);
    }

    JCheckBoxMenuItem newJCheckBoxMenuItem(String key, boolean isChecked) {
        return new KeyJCheckBoxMenuItem(key, this.getLabel(key), this.map, isChecked);
    }

    JRadioButtonMenuItem newJRadioButtonMenuItem(String key) {
        return new KeyJRadioButtonMenuItem(key, this.getLabel(key), this.map);
    }

    JCheckBox newJCheckBox(String key, boolean isChecked) {
        return new KeyJCheckBox(key, this.getLabel(key), this.map, isChecked);
    }

    JButton newJButton(String key) {
        JmolButton jb = new JmolButton(this.getLabel(key));
        this.map.put(key, jb);
        return jb;
    }

    Object get(String key) {
        return this.map.get(key);
    }

    void setSelected(String key, boolean b) {
        ((AbstractButton)this.get(key)).setSelected(b);
    }

    void setEnabled(String key, boolean b) {
        ((AbstractButton)this.get(key)).setEnabled(b);
    }

    public void updateLabels() {
        boolean doTranslate = GT.setDoTranslate(true);
        this.setupLabels();
        GenericConsole.setAbstractButtonLabels(this.map, this.labels);
        GT.setDoTranslate(doTranslate);
    }

    public static String translate(String str) {
        if (translations == null || !GT.getLanguage().equals(language)) {
            GuiMap.setTranslations();
        }
        language = GT.getLanguage();
        for (int i = 0; i < translations.length; i += 2) {
            String t = translations[i];
            if (str.indexOf(t) < 0) continue;
            String s = translations[i + 1];
            if (s.equals("see Jmol-resources.properties")) {
                s = JmolResourceHandler.getStringX(t);
            }
            str = PT.rep(str, t, s);
        }
        return str;
    }

    public static URL getResource(Object object, String fileName) {
        return GuiMap.getResource(object, fileName, true);
    }

    public static URL getHtmlResource(Object object, String root) {
        String lang = GT.getLanguage();
        String fileName = root + "_" + lang + ".html";
        URL url = GuiMap.getResource(object, fileName, false);
        if (url == null && lang.length() == 5) {
            fileName = root + "_" + lang.substring(0, 2) + ".html";
            url = GuiMap.getResource(object, fileName, false);
        }
        if (url == null) {
            fileName = root + ".html";
            url = GuiMap.getResource(object, fileName, true);
        }
        return url;
    }

    public static URL getResource(Object object, String fileName, boolean flagError) {
        URL url = null;
        if (fileName.indexOf("/org/") > 0) {
            fileName = fileName.substring(fileName.indexOf("/org/") + 1);
        }
        if (!fileName.contains("/")) {
            fileName = "org/openscience/jmol/app/webexport/html/" + fileName;
        }
        try {
            url = ClassLoader.getSystemResource(fileName);
            if (url == null && flagError) {
                System.err.println("Couldn't find file: " + fileName);
            }
        }
        catch (Exception e) {
            System.err.println("Exception " + e.getMessage() + " in getResource " + fileName);
        }
        return url;
    }

    public static String getResourceString(Object object, String name) throws IOException {
        URL url;
        URL uRL = url = name.indexOf(".") >= 0 ? GuiMap.getResource(object, name) : GuiMap.getHtmlResource(object, name);
        if (url == null) {
            throw new FileNotFoundException("Error loading resource " + name);
        }
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)url.getContent()));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return GuiMap.translate(sb.toString());
    }

    private static void setTranslations() {
        translations = new String[]{"GT_JmolPopIn.js_TOGETA3DMODEL", GT.escapeHTML(GT.o(GT._("To get a 3-D model you can manipulate, click {0}here{1}. Download time may be significant the first time the applet is loaded."), new String[]{"<a href=\"HREF\">", "</a>"})), "GT_pop_in_template.html_INSERTTITLE", GT.escapeHTML(GT._("Insert the page TITLE here.")), "GT_pop_in_template.html_INSERTINTRO", GT.escapeHTML(GT._("Insert the page INTRODUCTION here.")), "GT_pop_in_template2.html_INSERTCAPTION", GT.escapeHTML(GT.o(GT._("CLICK IMAGE TO ACTIVATE 3D <br/> Insert a caption for {0} here."), "@NAME@")), "GT_pop_in_template2.html_INSERTADDITIONAL", GT.escapeHTML(GT.o(GT._("Insert additional explanatory text here. Long text will wrap around Jmol model {0}."), "@NAME@")), "GT_script_btn_template.html_INSERT", GT.escapeHTML(GT._("Insert your TITLE and INTRODUCTION here.")), "GT_script_btn_template.html_LOADING", GT.escapeHTML(GT.o(GT._("Once the molecule file is fully loaded, the image at right will become live.  At that time the \"activate 3-D\" icon {0} will disappear."), new String[]{"<img id=\"make_live_icon\" src=\"\" height=\"15px\" />"})), "GT_script_btn_template.html_VIEWAGAIN", GT.escapeHTML(GT._("You may look at any of these intermediate views again by clicking on the appropriate button.")), "GT_script_btn_template.html_JAVACAPABLE", GT.escapeHTML(GT._("If your browser/OS combination is Java capable, you will get snappier performance if you <a href=\"?use=JAVA\">use Java</a>")), "GT_script_btn_template2.html_BUTTONINFO", GT.escapeHTML(GT.o(GT._("The button {0} will appear below.  Insert information for {0} here and below."), "@NAME@")), "GT_script_btn_template2.html_MORE", GT.escapeHTML(GT.o(GT._("Insert more information for {0} here."), "@NAME@")), "About.html#version", "<p><b>Jmol " + JC.version + " (" + JC.date + ")</b></p>", "About.html#splash", "see Jmol-resources.properties", "About.html#weblinks", "see Jmol-resources.properties", "About.html#libraries", "see Jmol-resources.properties"};
    }
}

