/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.gui.GettingStarted;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.util.GuiHelper;

public class MainPanel
extends JPanel {
    private MapFrame map;
    private GettingStarted gettingStarted;
    private final CopyOnWriteArrayList<MapFrameListener> mapFrameListeners = new CopyOnWriteArrayList();
    private final transient MainLayerManager layerManager;

    public MainPanel(MainLayerManager mainLayerManager) {
        super(new BorderLayout());
        this.layerManager = mainLayerManager;
    }

    protected void updateContent(boolean bl) {
        GuiHelper.assertCallFromEdt();
        MapFrame mapFrame = this.map;
        if (mapFrame != null && bl) {
            return;
        }
        this.setVisible(false);
        this.removeAll();
        if (mapFrame != null) {
            mapFrame.destroy();
        }
        if (bl) {
            this.map = this.createNewMapFrame();
        } else {
            Main.map = this.map = null;
            this.add((Component)this.getGettingStarted(), "Center");
        }
        this.setVisible(true);
        if (mapFrame == null && !bl) {
            return;
        }
        for (MapFrameListener mapFrameListener : this.mapFrameListeners) {
            MapView.fireDeprecatedListenerOnAdd = true;
            mapFrameListener.mapFrameInitialized(mapFrame, this.map);
            MapView.fireDeprecatedListenerOnAdd = false;
        }
        if (this.map == null && Main.currentProgressMonitor != null) {
            Main.currentProgressMonitor.showForegroundDialog();
        }
    }

    private MapFrame createNewMapFrame() {
        MapFrame mapFrame;
        Main.map = mapFrame = new MapFrame(null, null);
        mapFrame.fillPanel(this);
        List<Layer> list = Main.getLayerManager().getLayers();
        if (!list.isEmpty()) {
            mapFrame.selectMapMode((MapMode)mapFrame.getDefaultButtonAction(), list.get(0));
        }
        mapFrame.initializeDialogsPane();
        mapFrame.setVisible(true);
        return mapFrame;
    }

    public boolean addAndFireMapFrameListener(MapFrameListener mapFrameListener) {
        boolean bl = this.addMapFrameListener(mapFrameListener);
        if (bl && this.map != null) {
            mapFrameListener.mapFrameInitialized(null, this.map);
        }
        return bl;
    }

    public boolean addMapFrameListener(MapFrameListener mapFrameListener) {
        return mapFrameListener != null && this.mapFrameListeners.add(mapFrameListener);
    }

    public boolean removeMapFrameListener(MapFrameListener mapFrameListener) {
        return mapFrameListener != null && this.mapFrameListeners.remove(mapFrameListener);
    }

    public GettingStarted getGettingStarted() {
        if (this.gettingStarted == null) {
            this.gettingStarted = new GettingStarted();
        }
        return this.gettingStarted;
    }

    public void reAddListeners() {
        this.layerManager.addLayerAvailabilityListener(new MainLayerManager.LayerAvailabilityListener(){

            @Override
            public void beforeFirstLayerAdded(MainLayerManager.LayerAvailabilityEvent layerAvailabilityEvent) {
                MainPanel.this.updateContent(true);
            }

            @Override
            public void afterLastLayerRemoved(MainLayerManager.LayerAvailabilityEvent layerAvailabilityEvent) {
                MainPanel.this.updateContent(false);
            }
        });
        GuiHelper.runInEDTAndWait(() -> this.updateContent(!this.layerManager.getLayers().isEmpty()));
    }
}

