/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.IConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.MergedTableCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.tags.MineTableCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.tags.TheirTableCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagTableColumnModelBuilder;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TagMerger
extends JPanel
implements IConflictResolver {
    private JTable mineTable;
    private JTable mergedTable;
    private JTable theirTable;
    private final TagMergeModel model = new TagMergeModel();
    private final String[] keyvalue = new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])};
    private transient AdjustmentSynchronizer adjustmentSynchronizer;

    public TagMerger() {
        this.build();
    }

    protected JScrollPane embeddInScrollPane(JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.adjustmentSynchronizer.synchronizeAdjustment(jScrollPane.getVerticalScrollBar());
        return jScrollPane;
    }

    protected JScrollPane buildMineTagTable() {
        this.mineTable = new JTable(this.model, new TagTableColumnModelBuilder(new MineTableCellRenderer(), this.keyvalue).build());
        this.mineTable.setName("table.my");
        return this.embeddInScrollPane(this.mineTable);
    }

    protected JScrollPane buildTheirTable() {
        this.theirTable = new JTable(this.model, new TagTableColumnModelBuilder(new TheirTableCellRenderer(), this.keyvalue).build());
        this.theirTable.setName("table.their");
        return this.embeddInScrollPane(this.theirTable);
    }

    protected JScrollPane buildMergedTable() {
        this.mergedTable = new JTable(this.model, new TagTableColumnModelBuilder(new MergedTableCellRenderer(), this.keyvalue).build());
        this.mergedTable.setName("table.merged");
        return this.embeddInScrollPane(this.mergedTable);
    }

    protected final void build() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        JLabel jLabel = new JLabel(I18n.tr("My version (local dataset)", new Object[0]));
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel2 = new JLabel(I18n.tr("Merged version", new Object[0]));
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel3 = new JLabel(I18n.tr("Their version (server dataset)", new Object[0]));
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = this.buildMineTagTable();
        jLabel.setLabelFor(jScrollPane);
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        KeepMineAction keepMineAction = new KeepMineAction();
        this.mineTable.getSelectionModel().addListSelectionListener(keepMineAction);
        JButton jButton = new JButton(keepMineAction);
        jButton.setName("button.keepmine");
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane2 = this.buildMergedTable();
        jLabel2.setLabelFor(jScrollPane2);
        this.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        KeepTheirAction keepTheirAction = new KeepTheirAction();
        JButton jButton2 = new JButton(keepTheirAction);
        jButton2.setName("button.keeptheir");
        this.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane3 = this.buildTheirTable();
        jLabel3.setLabelFor(jScrollPane3);
        this.add((Component)jScrollPane3, gridBagConstraints);
        this.theirTable.getSelectionModel().addListSelectionListener(keepTheirAction);
        DoubleClickAdapter doubleClickAdapter = new DoubleClickAdapter();
        this.mineTable.addMouseListener(doubleClickAdapter);
        this.theirTable.addMouseListener(doubleClickAdapter);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        UndecideAction undecideAction = new UndecideAction();
        this.mergedTable.getSelectionModel().addListSelectionListener(undecideAction);
        JButton jButton3 = new JButton(undecideAction);
        jButton3.setName("button.undecide");
        this.add((Component)jButton3, gridBagConstraints);
    }

    public TagMergeModel getModel() {
        return this.model;
    }

    private void selectNextConflict(int ... nArray) {
        int n = nArray[0];
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        int n3 = this.model.getFirstUndecided(n + 1);
        if (n3 == -1) {
            n3 = this.model.getFirstUndecided(0);
        }
        this.mineTable.getSelectionModel().setSelectionInterval(n3, n3);
        this.theirTable.getSelectionModel().setSelectionInterval(n3, n3);
    }

    @Override
    public void deletePrimitive(boolean bl) {
        MergeDecisionType mergeDecisionType = bl ? MergeDecisionType.KEEP_MINE : MergeDecisionType.UNDECIDED;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            this.model.decide(i, mergeDecisionType);
        }
    }

    @Override
    public void populate(Conflict<? extends OsmPrimitive> conflict) {
        this.model.populate(conflict.getMy(), conflict.getTheir());
        for (JTable jTable : new JTable[]{this.mineTable, this.theirTable}) {
            int n = jTable.getRowCount() > 0 ? 0 : -1;
            jTable.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    @Override
    public void decideRemaining(MergeDecisionType mergeDecisionType) {
        this.model.decideRemaining(mergeDecisionType);
    }

    class UndecideAction
    extends AbstractAction
    implements ListSelectionListener {
        UndecideAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "tagundecide");
            if (imageIcon != null) {
                this.putValue("SmallIcon", imageIcon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", I18n.tr("Undecide", new Object[0]));
            }
            this.putValue("ShortDescription", I18n.tr("Mark the selected tags as undecided", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TagMerger.this.mergedTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            TagMerger.this.model.decide(nArray, MergeDecisionType.UNDECIDED);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(TagMerger.this.mergedTable.getSelectedRowCount() > 0);
        }
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            MergeDecisionType mergeDecisionType;
            JTable jTable;
            if (mouseEvent.getClickCount() != 2) {
                return;
            }
            if (mouseEvent.getSource() == TagMerger.this.mineTable) {
                jTable = TagMerger.this.mineTable;
                mergeDecisionType = MergeDecisionType.KEEP_MINE;
            } else if (mouseEvent.getSource() == TagMerger.this.theirTable) {
                jTable = TagMerger.this.theirTable;
                mergeDecisionType = MergeDecisionType.KEEP_THEIR;
            } else if (mouseEvent.getSource() == TagMerger.this.mergedTable) {
                jTable = TagMerger.this.mergedTable;
                mergeDecisionType = MergeDecisionType.UNDECIDED;
            } else {
                return;
            }
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            TagMerger.this.model.decide(n, mergeDecisionType);
        }
    }

    static class AdjustmentSynchronizer
    implements AdjustmentListener {
        private final Set<Adjustable> synchronizedAdjustables = new HashSet<Adjustable>();

        AdjustmentSynchronizer() {
        }

        public void synchronizeAdjustment(Adjustable adjustable) {
            if (adjustable == null) {
                return;
            }
            if (this.synchronizedAdjustables.contains(adjustable)) {
                return;
            }
            this.synchronizedAdjustables.add(adjustable);
            adjustable.addAdjustmentListener(this);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            for (Adjustable adjustable : this.synchronizedAdjustables) {
                if (adjustable == adjustmentEvent.getAdjustable()) continue;
                adjustable.setValue(adjustmentEvent.getValue());
            }
        }
    }

    class KeepTheirAction
    extends AbstractAction
    implements ListSelectionListener {
        KeepTheirAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "tagkeeptheir");
            if (imageIcon != null) {
                this.putValue("SmallIcon", imageIcon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", ">");
            }
            this.putValue("ShortDescription", I18n.tr("Keep the selected key/value pairs from the server dataset", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TagMerger.this.theirTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            TagMerger.this.model.decide(nArray, MergeDecisionType.KEEP_THEIR);
            TagMerger.this.selectNextConflict(nArray);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(TagMerger.this.theirTable.getSelectedRowCount() > 0);
        }
    }

    class KeepMineAction
    extends AbstractAction
    implements ListSelectionListener {
        KeepMineAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "tagkeepmine");
            if (imageIcon != null) {
                this.putValue("SmallIcon", imageIcon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", ">");
            }
            this.putValue("ShortDescription", I18n.tr("Keep the selected key/value pairs from the local dataset", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TagMerger.this.mineTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            TagMerger.this.model.decide(nArray, MergeDecisionType.KEEP_MINE);
            TagMerger.this.selectNextConflict(nArray);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(TagMerger.this.mineTable.getSelectedRowCount() > 0);
        }
    }
}

