/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openstreetmap.josm.gui.util.GuiSizesHelper;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageResource {
    private final Map<Dimension, Image> imgCache = new HashMap<Dimension, Image>();
    private SVGDiagram svg;
    public static final Dimension DEFAULT_DIMENSION = new Dimension(-1, -1);
    protected List<ImageOverlay> overlayInfo;
    protected boolean isDisabled;
    private Image baseImage;

    public ImageResource(Image image) {
        CheckParameterUtil.ensureParameterNotNull(image);
        this.baseImage = ImageResource.scaleBaseImageIfNeeded(image);
    }

    private static Image scaleBaseImageIfNeeded(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int n3 = GuiSizesHelper.getSizeDpiAdjusted(n);
        int n4 = GuiSizesHelper.getSizeDpiAdjusted(n2);
        if (n3 != -1 && n4 != -1 && n != n3 && n2 != n4) {
            Image image2 = image.getScaledInstance(n3, n4, 4);
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
            bufferedImage.getGraphics().drawImage(image2, 0, 0, null);
            return bufferedImage;
        }
        return image;
    }

    public ImageResource(SVGDiagram sVGDiagram) {
        CheckParameterUtil.ensureParameterNotNull(sVGDiagram);
        this.svg = sVGDiagram;
    }

    public ImageResource(ImageResource imageResource, List<ImageOverlay> list) {
        this.svg = imageResource.svg;
        this.baseImage = imageResource.baseImage;
        this.overlayInfo = list;
    }

    public ImageResource setDisabled(boolean bl) {
        this.isDisabled = bl;
        return this;
    }

    public void attachImageIcon(AbstractAction abstractAction) {
        Dimension dimension = ImageProvider.ImageSizes.SMALLICON.getImageDimension();
        ImageIcon imageIcon = this.getImageIconBounded(dimension);
        abstractAction.putValue("SmallIcon", imageIcon);
        dimension = ImageProvider.ImageSizes.LARGEICON.getImageDimension();
        imageIcon = this.getImageIconBounded(dimension);
        abstractAction.putValue("SwingLargeIconKey", imageIcon);
    }

    public void attachImageIcon(AbstractAction abstractAction, boolean bl) {
        this.attachImageIcon(abstractAction);
        if (bl) {
            abstractAction.putValue("ImageResource", this);
        }
    }

    public ImageIcon getImageIcon() {
        return this.getImageIcon(DEFAULT_DIMENSION);
    }

    public ImageIcon getImageIcon(Dimension dimension) {
        BufferedImage bufferedImage;
        Object object;
        if (dimension.width < -1 || dimension.width == 0 || dimension.height < -1 || dimension.height == 0) {
            throw new IllegalArgumentException(dimension + " is invalid");
        }
        Image image = this.imgCache.get(dimension);
        if (image != null) {
            return new ImageIcon(image);
        }
        if (this.svg != null) {
            object = GuiSizesHelper.getDimensionDpiAdjusted(dimension);
            bufferedImage = ImageProvider.createImageFromSvg(this.svg, (Dimension)object);
            if (bufferedImage == null) {
                return null;
            }
        } else {
            if (this.baseImage == null) {
                throw new AssertionError();
            }
            int n = GuiSizesHelper.getSizeDpiAdjusted(dimension.width);
            int n2 = GuiSizesHelper.getSizeDpiAdjusted(dimension.height);
            ImageIcon imageIcon = new ImageIcon(this.baseImage);
            if (n == -1 && n2 == -1) {
                n = GuiSizesHelper.getSizeDpiAdjusted(imageIcon.getIconWidth());
                n2 = GuiSizesHelper.getSizeDpiAdjusted(imageIcon.getIconHeight());
            } else if (n == -1) {
                n = Math.max(1, imageIcon.getIconWidth() * n2 / imageIcon.getIconHeight());
            } else if (n2 == -1) {
                n2 = Math.max(1, imageIcon.getIconHeight() * n / imageIcon.getIconWidth());
            }
            Image image2 = imageIcon.getImage().getScaledInstance(n, n2, 4);
            bufferedImage = new BufferedImage(n, n2, 2);
            bufferedImage.getGraphics().drawImage(image2, 0, 0, null);
        }
        if (this.overlayInfo != null) {
            for (ImageOverlay imageOverlay : this.overlayInfo) {
                imageOverlay.process(bufferedImage);
            }
        }
        if (this.isDisabled) {
            object = UIManager.getLookAndFeel().getDisabledIcon(null, new ImageIcon(bufferedImage));
            if (object == null) {
                return null;
            }
            bufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 6);
            object.paintIcon(new JPanel(), bufferedImage.getGraphics(), 0, 0);
        }
        this.imgCache.put(dimension, bufferedImage);
        return new ImageIcon(bufferedImage);
    }

    public ImageIcon getImageIconBounded(Dimension dimension) {
        float f;
        float f2;
        if (dimension.width < -1 || dimension.width == 0 || dimension.height < -1 || dimension.height == 0) {
            throw new IllegalArgumentException(dimension + " is invalid");
        }
        int n = dimension.width;
        int n2 = dimension.height;
        if (this.svg != null) {
            f2 = this.svg.getWidth();
            f = this.svg.getHeight();
        } else {
            if (this.baseImage == null) {
                throw new AssertionError();
            }
            ImageIcon imageIcon = new ImageIcon(this.baseImage);
            f2 = imageIcon.getIconWidth();
            f = imageIcon.getIconHeight();
            if (f2 <= (float)n) {
                n = -1;
            }
            if (f <= (float)n2) {
                n2 = -1;
            }
        }
        if (n == -1 && n2 == -1) {
            return this.getImageIcon(DEFAULT_DIMENSION);
        }
        if (n == -1) {
            return this.getImageIcon(new Dimension(-1, n2));
        }
        if (n2 == -1) {
            return this.getImageIcon(new Dimension(n, -1));
        }
        if (f2 / (float)n > f / (float)n2) {
            return this.getImageIcon(new Dimension(n, -1));
        }
        return this.getImageIcon(new Dimension(-1, n2));
    }
}

