/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.BreakpointFactory;
import com.oracle.truffle.api.debug.ExecutionEvent;
import com.oracle.truffle.api.debug.KillException;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.debug.impl.DebuggerInstrument;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.vm.PolyglotEngine;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;

public final class Debugger {
    @Deprecated
    public static final String HALT_TAG = "debug-HALT";
    @Deprecated
    public static final String CALL_TAG = "debug-CALL";
    private static final boolean TRACE = Boolean.getBoolean("truffle.debug.trace");
    private static final String TRACE_PREFIX = "Debug";
    private static final PrintStream OUT = System.out;
    private static final SourceSectionFilter CALL_FILTER = SourceSectionFilter.newBuilder().tagIs(StandardTags.CallTag.class).build();
    private static final SourceSectionFilter HALT_FILTER = SourceSectionFilter.newBuilder().tagIs(StandardTags.StatementTag.class).build();
    private static final Assumption NO_DEBUGGER = Truffle.getRuntime().createAssumption("No debugger assumption");
    private static final Set<Debugger> EXISTING_DEBUGGERS = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private static int nextActionID = 0;
    private static final DebuggerInstrument.Factory FACTORY = new DebuggerInstrument.Factory(){

        @Override
        public Debugger create(PolyglotEngine engine, Instrumenter instrumenter) {
            Debugger newDebugger = new Debugger(engine, instrumenter);
            AccessorDebug.engineAccess().registerDebugger(engine, newDebugger);
            return newDebugger;
        }
    };
    private final PolyglotEngine engine;
    private final Instrumenter instrumenter;
    private final BreakpointFactory breakpoints;
    private Source lastSource;
    private final BreakpointCallback breakpointCallback = new BreakpointCallback(){

        @Override
        @CompilerDirectives.TruffleBoundary
        public void haltedAt(EventContext eventContext, MaterializedFrame mFrame, Breakpoint breakpoint) {
            StepStrategy strategy;
            if (Debugger.this.currentDebugContext == null) {
                SourceSection sourceSection = eventContext.getInstrumentedNode().getSourceSection();
                assert (sourceSection != null);
                Debugger.this.currentDebugContext = new DebugExecutionContext(sourceSection.getSource(), null, 0);
            }
            if ((strategy = Debugger.this.currentDebugContext.strategy) != null && strategy.wouldHaltAt(eventContext)) {
                Debugger.this.currentDebugContext.trace("REDUNDANT HALT, breakpoint@" + breakpoint.getLocationDescription(), new Object[0]);
            } else {
                Debugger.this.currentDebugContext.halt(eventContext, mFrame, HaltPosition.BEFORE, breakpoint);
            }
        }
    };
    private WarningLog warningLog = new WarningLog(){

        @Override
        public void addWarning(String warning) {
            assert (Debugger.this.currentDebugContext != null);
            Debugger.this.currentDebugContext.logWarning(warning);
        }
    };
    private DebugExecutionContext currentDebugContext;
    static final AccessorDebug ACCESSOR = new AccessorDebug();

    private static boolean matchesHaltFilter(EventContext eventContext) {
        return AccessorDebug.nodesAccess().isTaggedWith(eventContext.getInstrumentedNode(), StandardTags.StatementTag.class);
    }

    public static Debugger find(PolyglotEngine engine) {
        return Debugger.find(engine, true);
    }

    static Debugger find(PolyglotEngine engine, boolean create) {
        DebuggerInstrument debugInstrument;
        PolyglotEngine.Instrument instrument = engine.getInstruments().get("debugger");
        if (instrument == null) {
            throw new IllegalStateException();
        }
        if (create) {
            instrument.setEnabled(true);
        }
        if ((debugInstrument = instrument.lookup(DebuggerInstrument.class)) == null) {
            return null;
        }
        return debugInstrument.getDebugger(engine, create ? FACTORY : null);
    }

    Debugger(PolyglotEngine engine, Instrumenter instrumenter) {
        this.engine = engine;
        this.instrumenter = instrumenter;
        this.breakpoints = new BreakpointFactory(instrumenter, this.breakpointCallback, this.warningLog);
        NO_DEBUGGER.invalidate();
        EXISTING_DEBUGGERS.add(this);
    }

    @CompilerDirectives.TruffleBoundary
    public Breakpoint setLineBreakpoint(int ignoreCount, LineLocation lineLocation, boolean oneShot) throws IOException {
        return this.breakpoints.create(ignoreCount, lineLocation, oneShot);
    }

    @CompilerDirectives.TruffleBoundary
    public Breakpoint setLineBreakpoint(int ignoreCount, URI sourceUri, int line, boolean oneShot) throws IOException {
        return this.breakpoints.create(ignoreCount, sourceUri, line, -1, oneShot);
    }

    @Deprecated
    @CompilerDirectives.TruffleBoundary
    public Breakpoint setTagBreakpoint(int ignoreCount, SyntaxTag tag, boolean oneShot) throws IOException {
        throw new UnsupportedOperationException();
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<Breakpoint> getBreakpoints() {
        return this.breakpoints.getAll();
    }

    public boolean pause() {
        DebugExecutionContext dc = this.currentDebugContext;
        if (dc != null) {
            dc.doPause();
            return true;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    void prepareContinue(int depth) {
        this.currentDebugContext.setAction(depth, new Continue());
    }

    @CompilerDirectives.TruffleBoundary
    void prepareStepInto(int stepCount) {
        if (stepCount <= 0) {
            throw new IllegalArgumentException();
        }
        this.currentDebugContext.setAction(new StepInto(stepCount));
    }

    @CompilerDirectives.TruffleBoundary
    void prepareStepOut() {
        this.currentDebugContext.setAction(new StepOut());
    }

    @CompilerDirectives.TruffleBoundary
    void prepareStepOver(int stepCount) {
        if (stepCount <= 0) {
            throw new IllegalArgumentException();
        }
        this.currentDebugContext.setAction(new StepOver(stepCount));
    }

    Instrumenter getInstrumenter() {
        return this.instrumenter;
    }

    @CompilerDirectives.TruffleBoundary
    private static int computeStackDepth() {
        final int[] count = new int[]{0};
        Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<Void>(){

            @Override
            public Void visitFrame(FrameInstance frameInstance) {
                count[0] = count[0] + 1;
                return null;
            }
        });
        return count[0] == 0 ? 0 : count[0] + 1;
    }

    void executionStarted(int depth, Source source) {
        Source execSource = source;
        if (execSource == null) {
            execSource = this.lastSource;
        } else {
            this.lastSource = execSource;
        }
        this.currentDebugContext = new DebugExecutionContext(execSource, this.currentDebugContext, depth);
        this.breakpoints.notifySourceLoaded(source);
        this.prepareContinue(depth);
        this.currentDebugContext.trace("BEGIN EXECUTION", new Object[0]);
    }

    private void executionEnded() {
        this.currentDebugContext.trace("END EXECUTION", new Object[0]);
        this.currentDebugContext.dispose();
        this.currentDebugContext = this.currentDebugContext.predecessor;
    }

    Object evalInContext(SuspendedEvent ev, String code, FrameInstance frameInstance) throws IOException {
        try {
            if (frameInstance == null) {
                return AccessorDebug.langs().evalInContext(this.engine, ev, code, this.currentDebugContext.haltedEventContext.getInstrumentedNode(), this.currentDebugContext.haltedFrame);
            }
            return AccessorDebug.langs().evalInContext(this.engine, ev, code, frameInstance.getCallNode(), frameInstance.getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize());
        }
        catch (KillException kex) {
            throw new IOException("Evaluation was killed.", kex);
        }
    }

    static /* synthetic */ int access$908() {
        return nextActionID++;
    }

    static final class AccessorDebug
    extends Accessor {
        AccessorDebug() {
        }

        static Accessor.Nodes nodesAccess() {
            return ACCESSOR.nodes();
        }

        static Accessor.LanguageSupport langs() {
            return ACCESSOR.languageSupport();
        }

        static Accessor.EngineSupport engineAccess() {
            return ACCESSOR.engineSupport();
        }

        @Override
        protected Accessor.DebugSupport debugSupport() {
            return new DebugImpl();
        }

        protected CallTarget parse(Class<? extends TruffleLanguage> languageClass, Source code, Node context, String ... argumentNames) throws IOException {
            TruffleLanguage<?> truffleLanguage = this.engineSupport().findLanguageImpl(null, languageClass, code.getMimeType());
            return this.languageSupport().parse(truffleLanguage, code, context, argumentNames);
        }

        String toStringInContext(RootNode rootNode, Object value) {
            Class<? extends TruffleLanguage> languageClass = AccessorDebug.nodesAccess().findLanguage(rootNode);
            TruffleLanguage.Env env = AccessorDebug.engineAccess().findEnv(languageClass);
            TruffleLanguage<?> language = AccessorDebug.langs().findLanguage(env);
            return AccessorDebug.langs().toString(language, env, value);
        }

        private static final class DebugImpl
        extends Accessor.DebugSupport {
            private DebugImpl() {
            }

            @Override
            public void executionStarted(Object vm, int currentDepth, Object[] debugger, Source s) {
                PolyglotEngine engine = (PolyglotEngine)vm;
                if (debugger[0] != null) {
                    Debugger dbg = (Debugger)debugger[0];
                    dbg.executionStarted(currentDepth, s);
                }
                ExecutionEvent event = new ExecutionEvent(engine, currentDepth, debugger, s);
                AccessorDebug.engineAccess().dispatchEvent(engine, event, 1);
                event.dispose();
            }

            @Override
            public void executionEnded(Object vm, Object[] debugger) {
                if (debugger[0] != null) {
                    ((Debugger)debugger[0]).executionEnded();
                }
            }

            @Override
            public void executionSourceSection(SourceSection ss) {
                Source source = ss.getSource();
                for (Debugger debugger : EXISTING_DEBUGGERS) {
                    debugger.breakpoints.notifySourceLoaded(source);
                }
            }

            @Override
            public Assumption assumeNoDebugger() {
                return NO_DEBUGGER;
            }
        }
    }

    private final class DebugExecutionContext {
        private final DebugExecutionContext predecessor;
        private final int level;
        private final Source source;
        private final int contextStackBase;
        private final List<String> warnings = new ArrayList<String>();
        private boolean disposed;
        private boolean running;
        private StepStrategy strategy;
        private EventContext haltedEventContext;
        private MaterializedFrame haltedFrame;
        private HaltPosition haltedPosition;
        private final Object pauseHandlerLock = new Object();
        private PauseHandler pauseHandler;
        private List<FrameInstance> contextStack;

        private DebugExecutionContext(Source executionSource, DebugExecutionContext previousContext) {
            this(executionSource, previousContext, -1);
        }

        private DebugExecutionContext(Source executionSource, DebugExecutionContext previousContext, int depth) {
            this.source = executionSource;
            this.predecessor = previousContext;
            this.level = previousContext == null ? 0 : previousContext.level + 1;
            this.contextStackBase = depth == -1 ? Debugger.computeStackDepth() : depth;
            this.running = true;
            if (TRACE) {
                this.trace("NEW DEBUG CONTEXT level=" + this.level, new Object[0]);
            }
        }

        private void setAction(StepStrategy stepStrategy) {
            this.setAction(Debugger.computeStackDepth(), stepStrategy);
        }

        private void setAction(int depth, StepStrategy newStrategy) {
            if (this.disposed) {
                throw new IllegalStateException("DebugExecutionContexts are single-use.");
            }
            assert (newStrategy != null);
            if (this.strategy == null) {
                this.strategy = newStrategy;
                this.strategy.enable(this, depth);
            } else {
                this.strategy.disable();
                this.strategy = newStrategy;
                this.strategy.enable(this, Debugger.computeStackDepth());
            }
        }

        private void clearAction() {
            if (this.strategy != null) {
                this.strategy.disable();
                this.strategy = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doPause() {
            Object object = this.pauseHandlerLock;
            synchronized (object) {
                if (this.pauseHandler != null) {
                    return;
                }
                this.pauseHandler = new PauseHandler(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearPause() {
            boolean cleared = false;
            Object object = this.pauseHandlerLock;
            synchronized (object) {
                if (this.pauseHandler != null) {
                    this.pauseHandler.disable();
                    this.pauseHandler = null;
                    cleared = true;
                }
            }
            if (TRACE && cleared) {
                this.trace("CLEAR PAUSE", new Object[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void halt(EventContext eventContext, MaterializedFrame mFrame, HaltPosition position, Object cause) {
            if (this.disposed) {
                throw new IllegalStateException("DebugExecutionContexts are single-use.");
            }
            assert (this.running);
            assert (this.haltedEventContext == null);
            assert (this.haltedFrame == null);
            this.haltedEventContext = eventContext;
            this.haltedFrame = mFrame;
            this.haltedPosition = position;
            this.running = false;
            if (cause instanceof StepStrategy) {
                this.clearAction();
            }
            this.clearPause();
            Debugger.this.breakpoints.disposeOneShots();
            ArrayList<String> recentWarnings = new ArrayList<String>(this.warnings);
            this.warnings.clear();
            final int contextStackDepth = Debugger.computeStackDepth() - this.contextStackBase + 1;
            final ArrayList frames = new ArrayList();
            Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<FrameInstance>(){
                int stackIndex = 1;

                @Override
                public FrameInstance visitFrame(FrameInstance frameInstance) {
                    if (this.stackIndex < contextStackDepth) {
                        if (TRACE && frameInstance.getCallNode() == null) {
                            DebugExecutionContext.this.trace("frame %d null callNode: %s", new Object[]{this.stackIndex, frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY, true)});
                        }
                        frames.add(frameInstance);
                        ++this.stackIndex;
                        return null;
                    }
                    return frameInstance;
                }
            });
            this.contextStack = Collections.unmodifiableList(frames);
            String haltReason = null;
            if (TRACE) {
                haltReason = cause instanceof StepStrategy ? ((StepStrategy)cause).description() : (cause instanceof Breakpoint ? "breakpoint@" + ((Breakpoint)cause).getLocationDescription() : cause.toString());
                this.trace("HALT %s: (%s) stack base=%d", this.haltedPosition.toString(), haltReason, this.contextStackBase);
            }
            try {
                SuspendedEvent event = new SuspendedEvent(Debugger.this, this.haltedEventContext.getInstrumentedNode(), this.haltedPosition, this.haltedFrame, this.contextStack, recentWarnings);
                AccessorDebug.engineAccess().dispatchEvent(Debugger.this.engine, event, 2);
                if (event.isKillPrepared()) {
                    this.trace("KILL", new Object[0]);
                    throw new KillException();
                }
                this.running = true;
                if (TRACE) {
                    this.trace("RESUME %s : (%s) stack base=%d", this.haltedPosition.toString(), haltReason, this.contextStackBase);
                }
            }
            finally {
                this.haltedEventContext = null;
                this.haltedFrame = null;
                this.haltedPosition = null;
            }
        }

        private void dispose() {
            Debugger.this.breakpoints.disposeOneShots();
            this.clearAction();
            this.disposed = true;
            if (TRACE) {
                this.trace("DISPOSE DEBUG CONTEXT level=" + this.level, new Object[0]);
            }
        }

        private void logWarning(String warning) {
            this.warnings.add(warning);
        }

        private void trace(String format, Object ... args) {
            if (TRACE) {
                String location = "";
                location = this.haltedEventContext != null && this.haltedEventContext.getInstrumentedNode().getSourceSection() != null ? this.haltedEventContext.getInstrumentedNode().getSourceSection().getShortDescription() : (this.source != null ? this.source.getName() : "no source");
                String message = String.format(format, args);
                OUT.println(String.format("%s<%d>: %s [%s]", Debugger.TRACE_PREFIX, this.level, message, location));
            }
        }
    }

    private final class PauseHandler {
        private EventBinding<?>[] bindings;

        @CompilerDirectives.TruffleBoundary
        PauseHandler(final DebugExecutionContext debugContext) {
            if (TRACE) {
                debugContext.trace("PAUSE requested.", new Object[0]);
            }
            ExecutionEventListener execListener = new ExecutionEventListener(){

                @Override
                public void onEnter(EventContext context, VirtualFrame frame) {
                    debugContext.halt(context, frame.materialize(), HaltPosition.BEFORE, "Paused");
                }

                @Override
                public void onReturnValue(EventContext context, VirtualFrame frame, Object result) {
                    debugContext.halt(context, frame.materialize(), HaltPosition.AFTER, "Paused");
                }

                @Override
                public void onReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
                    debugContext.halt(context, frame.materialize(), HaltPosition.AFTER, "Paused");
                }
            };
            this.bindings = new EventBinding[]{Debugger.this.instrumenter.attachListener(HALT_FILTER, execListener), Debugger.this.instrumenter.attachListener(CALL_FILTER, execListener)};
        }

        private void disable() {
            for (EventBinding<?> eb : this.bindings) {
                eb.dispose();
            }
            this.bindings = null;
        }
    }

    private final class StepOverNested
    extends StepStrategy {
        private final int startStackDepth;
        private int unfinishedStepCount;
        private EventBinding<?> beforeHaltBinding;

        StepOverNested(int stepCount, int startStackDepth) {
            this.startStackDepth = startStackDepth;
            this.unfinishedStepCount = stepCount;
        }

        @Override
        protected void setStrategy(int stackDepth) {
            this.traceAction("SET STRATEGY", this.startStackDepth, this.unfinishedStepCount);
            this.beforeHaltBinding = Debugger.this.instrumenter.attachListener(HALT_FILTER, new ExecutionEventListener(){

                @Override
                public void onEnter(EventContext eventContext, VirtualFrame frame) {
                    StepOverNested.this.traceAction("BEGIN onEnter()", StepOverNested.this.startStackDepth, StepOverNested.this.unfinishedStepCount);
                    if (Debugger.computeStackDepth() <= StepOverNested.this.startStackDepth && --StepOverNested.this.unfinishedStepCount <= 0) {
                        StepOverNested.this.halt(eventContext, frame.materialize(), HaltPosition.BEFORE);
                    }
                    StepOverNested.this.traceAction("END onEnter()", StepOverNested.this.startStackDepth, StepOverNested.this.unfinishedStepCount);
                }

                @Override
                public void onReturnValue(EventContext eventContext, VirtualFrame frame, Object result) {
                }

                @Override
                public void onReturnExceptional(EventContext eventContext, VirtualFrame frame, Throwable exception) {
                }
            });
        }

        @Override
        protected void unsetStrategy() {
            if (this.beforeHaltBinding == null) {
                return;
            }
            this.beforeHaltBinding.dispose();
        }

        @Override
        boolean wouldHaltAt(EventContext eventContext) {
            return AccessorDebug.nodesAccess().isTaggedWith(eventContext.getInstrumentedNode(), StandardTags.StatementTag.class);
        }
    }

    private final class StepOver
    extends StepStrategy {
        private int unfinishedStepCount;
        private EventBinding<?> beforeHaltBinding;
        private EventBinding<?> afterCallBinding;

        StepOver(int stepCount) {
            this.unfinishedStepCount = stepCount;
        }

        @Override
        protected void setStrategy(final int startStackDepth) {
            this.traceAction("SET STRATEGY", startStackDepth, this.unfinishedStepCount);
            this.beforeHaltBinding = Debugger.this.instrumenter.attachListener(HALT_FILTER, new ExecutionEventListener(){

                @Override
                public void onEnter(EventContext eventContext, VirtualFrame frame) {
                    if (Debugger.computeStackDepth() <= startStackDepth) {
                        StepOver.this.traceAction("BEGIN onEnter()", startStackDepth, StepOver.this.unfinishedStepCount);
                        if (--StepOver.this.unfinishedStepCount <= 0) {
                            StepOver.this.halt(eventContext, frame.materialize(), HaltPosition.BEFORE);
                        }
                        StepOver.this.traceAction("END onEnter()", startStackDepth, StepOver.this.unfinishedStepCount);
                    } else {
                        StepOver.this.traceAction("BEGIN onEnter() STEPPPED INTO CALL", startStackDepth, StepOver.this.unfinishedStepCount);
                        StepOver.this.replaceStrategy(new StepOverNested(StepOver.this.unfinishedStepCount, startStackDepth));
                        StepOver.this.traceAction("END onEnter() STEPPPED INTO CALL", startStackDepth, StepOver.this.unfinishedStepCount);
                    }
                }

                @Override
                public void onReturnValue(EventContext eventContext, VirtualFrame frame, Object result) {
                }

                @Override
                public void onReturnExceptional(EventContext eventContext, VirtualFrame frame, Throwable exception) {
                }
            });
            this.afterCallBinding = Debugger.this.instrumenter.attachListener(CALL_FILTER, new ExecutionEventListener(){

                @Override
                public void onEnter(EventContext eventContext, VirtualFrame frame) {
                }

                @Override
                public void onReturnValue(EventContext eventContext, VirtualFrame frame, Object result) {
                    StepOver.this.traceAction("BEGIN onReturnValue()", startStackDepth, StepOver.this.unfinishedStepCount);
                    if (Debugger.computeStackDepth() < startStackDepth) {
                        --StepOver.this.unfinishedStepCount;
                    }
                    if (StepOver.this.unfinishedStepCount <= 0) {
                        StepOver.this.halt(eventContext, frame.materialize(), HaltPosition.AFTER);
                    }
                    StepOver.this.traceAction("END onReturnValue()", startStackDepth, StepOver.this.unfinishedStepCount);
                }

                @Override
                public void onReturnExceptional(EventContext eventContext, VirtualFrame frame, Throwable exception) {
                }
            });
        }

        @Override
        protected void unsetStrategy() {
            if (this.beforeHaltBinding == null || this.afterCallBinding == null) {
                return;
            }
            this.beforeHaltBinding.dispose();
            this.afterCallBinding.dispose();
        }

        @Override
        boolean wouldHaltAt(EventContext eventContext) {
            return Debugger.matchesHaltFilter(eventContext) && this.unfinishedStepCount <= 1;
        }
    }

    private final class StepOut
    extends StepStrategy {
        private int unfinishedStepCount;
        private EventBinding<?> afterCallBinding;

        StepOut() {
            this.unfinishedStepCount = 1;
        }

        StepOut(int stepCount) {
            this.unfinishedStepCount = stepCount;
        }

        @Override
        protected void setStrategy(final int startStackDepth) {
            this.traceAction("SET STRATEGY", startStackDepth, this.unfinishedStepCount);
            this.afterCallBinding = Debugger.this.instrumenter.attachListener(CALL_FILTER, new ExecutionEventListener(){

                @Override
                public void onEnter(EventContext eventContext, VirtualFrame frame) {
                }

                @Override
                public void onReturnValue(EventContext eventContext, VirtualFrame frame, Object result) {
                    StepOut.this.traceAction("BEGIN onReturnValue()", startStackDepth, StepOut.this.unfinishedStepCount);
                    if (Debugger.computeStackDepth() < startStackDepth && --StepOut.this.unfinishedStepCount <= 0) {
                        StepOut.this.halt(eventContext, frame.materialize(), HaltPosition.AFTER);
                    }
                    StepOut.this.traceAction("END onReturnValue()", startStackDepth, StepOut.this.unfinishedStepCount);
                }

                @Override
                public void onReturnExceptional(EventContext eventContext, VirtualFrame frame, Throwable exception) {
                    StepOut.this.traceAction("BEGIN onReturnExceptional()", startStackDepth, StepOut.this.unfinishedStepCount);
                    if (Debugger.computeStackDepth() < startStackDepth && --StepOut.this.unfinishedStepCount <= 0) {
                        StepOut.this.halt(eventContext, frame.materialize(), HaltPosition.AFTER);
                    }
                    StepOut.this.traceAction("END onReturnExceptional()", startStackDepth, StepOut.this.unfinishedStepCount);
                }
            });
        }

        @Override
        protected void unsetStrategy() {
            if (this.afterCallBinding == null) {
                return;
            }
            this.afterCallBinding.dispose();
        }

        @Override
        boolean wouldHaltAt(EventContext eventContext) {
            return AccessorDebug.nodesAccess().isTaggedWith(eventContext.getInstrumentedNode(), StandardTags.StatementTag.class);
        }
    }

    private final class StepInto
    extends StepStrategy {
        private int startStackDepth;
        private int unfinishedStepCount;
        private EventBinding<?> beforeHaltBinding;
        private EventBinding<?> afterCallBinding;

        StepInto(int stepCount) {
            this.unfinishedStepCount = stepCount;
        }

        @Override
        protected void setStrategy(final int startStackDepth) {
            this.startStackDepth = startStackDepth;
            this.traceAction("SET ACTION", startStackDepth, this.unfinishedStepCount);
            this.beforeHaltBinding = Debugger.this.instrumenter.attachListener(HALT_FILTER, new ExecutionEventListener(){

                @Override
                public void onEnter(EventContext eventContext, VirtualFrame frame) {
                    StepInto.this.traceAction("BEGIN onEnter()", startStackDepth, StepInto.this.unfinishedStepCount);
                    if (--StepInto.this.unfinishedStepCount <= 0) {
                        StepInto.this.halt(eventContext, frame.materialize(), HaltPosition.BEFORE);
                    }
                    StepInto.this.traceAction("END onEnter()", startStackDepth, StepInto.this.unfinishedStepCount);
                }

                @Override
                public void onReturnValue(EventContext eventContext, VirtualFrame frame, Object result) {
                }

                @Override
                public void onReturnExceptional(EventContext eventContext, VirtualFrame frame, Throwable exception) {
                }
            });
            this.afterCallBinding = Debugger.this.instrumenter.attachListener(CALL_FILTER, new ExecutionEventListener(){

                @Override
                public void onEnter(EventContext eventContext, VirtualFrame frame) {
                }

                @Override
                public void onReturnValue(EventContext eventContext, VirtualFrame frame, Object result) {
                    StepInto.this.traceAction("BEGIN onReturnValue()", startStackDepth, StepInto.this.unfinishedStepCount);
                    if (Debugger.computeStackDepth() < startStackDepth && --StepInto.this.unfinishedStepCount <= 0) {
                        StepInto.this.halt(eventContext, frame.materialize(), HaltPosition.AFTER);
                    }
                    StepInto.this.traceAction("END onReturnValue()", startStackDepth, StepInto.this.unfinishedStepCount);
                }

                @Override
                public void onReturnExceptional(EventContext eventContext, VirtualFrame frame, Throwable exception) {
                    StepInto.this.traceAction("BEGIN onReturnExceptional()", startStackDepth, StepInto.this.unfinishedStepCount);
                    if (Debugger.computeStackDepth() < startStackDepth && --StepInto.this.unfinishedStepCount <= 0) {
                        StepInto.this.halt(eventContext, frame.materialize(), HaltPosition.AFTER);
                    }
                    StepInto.this.traceAction("END onReturnExceptional()", startStackDepth, StepInto.this.unfinishedStepCount);
                }
            });
        }

        @Override
        protected void unsetStrategy() {
            if (this.beforeHaltBinding == null || this.afterCallBinding == null) {
                return;
            }
            this.traceAction("CLEAR ACTION", this.startStackDepth, this.unfinishedStepCount);
            this.beforeHaltBinding.dispose();
            this.afterCallBinding.dispose();
        }

        @Override
        boolean wouldHaltAt(EventContext eventContext) {
            return Debugger.matchesHaltFilter(eventContext) && this.unfinishedStepCount <= 1;
        }
    }

    private final class Continue
    extends StepStrategy {
        private Continue() {
        }

        @Override
        protected void setStrategy(int stackDepth) {
        }

        @Override
        protected void unsetStrategy() {
        }

        @Override
        boolean wouldHaltAt(EventContext eventContext) {
            return false;
        }
    }

    private abstract class StepStrategy {
        private final String name = this.getClass().getSimpleName();
        private final int actionID = Debugger.access$908();
        private DebugExecutionContext debugContext;
        private boolean disposed;

        protected StepStrategy() {
        }

        final void enable(DebugExecutionContext c, int stackDepth) {
            if (this.disposed) {
                throw new IllegalStateException("Debugger strategies are single-use");
            }
            this.debugContext = c;
            this.setStrategy(stackDepth);
        }

        final void disable() {
            this.unsetStrategy();
            this.disposed = true;
        }

        abstract boolean wouldHaltAt(EventContext var1);

        @CompilerDirectives.TruffleBoundary
        protected final void halt(EventContext eventContext, MaterializedFrame mFrame, HaltPosition haltPosition) {
            this.debugContext.halt(eventContext, mFrame, haltPosition, this);
        }

        @CompilerDirectives.TruffleBoundary
        protected final void replaceStrategy(StepStrategy newStrategy) {
            this.debugContext.setAction(newStrategy);
        }

        @CompilerDirectives.TruffleBoundary
        protected final void traceAction(String action, int startStackDepth, int unfinishedStepCount) {
            if (TRACE) {
                this.debugContext.trace("%s (%s) stack=%d,%d unfinished=%d", new Object[]{action, this.description(), startStackDepth, Debugger.computeStackDepth(), unfinishedStepCount});
            }
        }

        protected abstract void setStrategy(int var1);

        protected abstract void unsetStrategy();

        String description() {
            return this.name + "<" + this.actionID + ">";
        }
    }

    static interface WarningLog {
        public void addWarning(String var1);
    }

    static interface BreakpointCallback {
        public void haltedAt(EventContext var1, MaterializedFrame var2, Breakpoint var3);
    }

    static enum HaltPosition {
        BEFORE,
        AFTER;

    }
}

