/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.basic;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.LayoutStrategy;
import com.oracle.truffle.object.LocationImpl;
import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.basic.BasicAllocator;
import com.oracle.truffle.object.basic.BasicLayout;
import java.util.Objects;

class DefaultStrategy
extends LayoutStrategy {
    DefaultStrategy() {
    }

    @Override
    public boolean updateShape(DynamicObject object) {
        assert (object.getShape().isValid());
        return false;
    }

    @Override
    public ShapeImpl ensureValid(ShapeImpl newShape) {
        assert (newShape.isValid());
        return newShape;
    }

    private static boolean assertLocationInRange(ShapeImpl shape, Location location) {
        BasicLayout layout = (BasicLayout)shape.getLayout();
        assert (shape.getPrimitiveFieldSize() + ((LocationImpl)location).primitiveFieldCount() <= layout.getPrimitiveFieldCount());
        assert (shape.getObjectFieldSize() + ((LocationImpl)location).objectFieldCount() <= layout.getObjectFieldCount());
        return true;
    }

    @Override
    public ShapeImpl ensureSpace(ShapeImpl shape, Location location) {
        Objects.requireNonNull(location);
        assert (DefaultStrategy.assertLocationInRange(shape, location));
        return shape;
    }

    @Override
    public ShapeImpl.BaseAllocator createAllocator(ShapeImpl shape) {
        return new DefaultAllocatorImpl(shape);
    }

    @Override
    public ShapeImpl.BaseAllocator createAllocator(LayoutImpl layout) {
        return new DefaultAllocatorImpl(layout);
    }

    static class DefaultAllocatorImpl
    extends BasicAllocator {
        protected DefaultAllocatorImpl(LayoutImpl layout) {
            super(layout);
        }

        protected DefaultAllocatorImpl(ShapeImpl shape) {
            super(shape);
        }

        @Override
        public Location locationForValue(Object value, boolean useFinal, boolean nonNull) {
            if (value instanceof Integer || value instanceof Double || value instanceof Long || value instanceof Boolean) {
                return super.newDualLocationForValue(value);
            }
            return this.newObjectLocation(useFinal, nonNull);
        }

        @Override
        public Location declaredLocation(Object value) {
            return super.newDeclaredDualLocation(value);
        }
    }
}

