/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.x500.X500Name;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.X509Attribute;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.impl.PKCS10Request;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class X509Request
extends RubyObject {
    private static final long serialVersionUID = -2886532636278901502L;
    private static ObjectAllocator REQUEST_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509Request(runtime, klass);
        }
    };
    private IRubyObject subject;
    private PKey public_key;
    private IRubyObject version;
    private final List<X509Attribute> attributes = new ArrayList<X509Attribute>();
    private transient PKCS10Request request;

    public static void createRequest(Ruby runtime, RubyModule _X509) {
        RubyClass _Request = _X509.defineClassUnder("Request", runtime.getObject(), REQUEST_ALLOCATOR);
        RubyClass _OpenSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        _X509.defineClassUnder("RequestError", _OpenSSLError, _OpenSSLError.getAllocator());
        _Request.defineAnnotatedMethods(X509Request.class);
    }

    public X509Request(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
        byte[] encoded;
        String algorithm;
        Ruby runtime = context2.runtime;
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)1) == 0) {
            return this;
        }
        try {
            this.request = new PKCS10Request(StringHelper.readX509PEM(context2, args[0]));
        }
        catch (RuntimeException e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw X509Request.newRequestError(runtime, "invalid certificate request data", e);
        }
        try {
            PublicKey pkey = this.request.generatePublicKey();
            algorithm = pkey.getAlgorithm();
            encoded = pkey.getEncoded();
        }
        catch (IOException e) {
            throw X509Request.newRequestError(runtime, e);
        }
        catch (GeneralSecurityException e) {
            throw X509Request.newRequestError(runtime, e);
        }
        RubyString enc = RubyString.newString((Ruby)runtime, (byte[])encoded);
        if ("RSA".equalsIgnoreCase(algorithm)) {
            this.public_key = X509Request.newPKeyImplInstance(context2, "RSA", enc);
        } else if ("DSA".equalsIgnoreCase(algorithm)) {
            this.public_key = X509Request.newPKeyImplInstance(context2, "DSA", enc);
        } else {
            throw runtime.newLoadError("not implemented algo for public key: " + algorithm);
        }
        this.subject = X509Request.newName(context2, this.request.getSubject());
        Attribute[] attrs = this.request.getAttributes();
        try {
            if (attrs != null) {
                for (Attribute attr : attrs) {
                    ASN1ObjectIdentifier type = attr.getAttrType();
                    ASN1Set values = attr.getAttrValues();
                    this.attributes.add(X509Request.newAttribute(context2, type, values));
                }
            }
        }
        catch (IOException e) {
            throw X509Request.newRequestError(runtime, e);
        }
        return this;
    }

    private static PKey newPKeyImplInstance(ThreadContext context2, String className, RubyString encoded) {
        return (PKey)PKey._PKey(context2.runtime).getClass(className).callMethod(context2, "new", (IRubyObject)encoded);
    }

    private static X509Attribute newAttribute(ThreadContext context2, ASN1ObjectIdentifier type, ASN1Set values) throws IOException {
        return X509Attribute.newAttribute(context2.runtime, type, values);
    }

    private static IRubyObject newName(ThreadContext context2, X500Name name2) {
        if (name2 == null) {
            return context2.nil;
        }
        return X509Name.newName(context2.runtime, name2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        Ruby runtime = this.getRuntime();
        OpenSSL.warn(runtime.getCurrentContext(), "WARNING: unimplemented method called: request#initialize_copy");
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        return this;
    }

    private PKCS10Request getRequest() {
        if (this.request != null) {
            return this.request;
        }
        PublicKey publicKey = null;
        if (this.public_key != null && !this.public_key.isNil()) {
            publicKey = this.public_key.getPublicKey();
        }
        X500Name subjectName = this.subject != null ? X509Request.getX500Name(this.subject) : null;
        ThreadContext context2 = this.getRuntime().getCurrentContext();
        this.request = new PKCS10Request(subjectName, publicKey, this.newAttributesImpl(context2));
        return this.request;
    }

    private static X500Name getX500Name(IRubyObject name2) {
        if (name2.isNil()) {
            return null;
        }
        return ((X509Name)name2).getX500Name();
    }

    @JRubyMethod(name={"to_pem", "to_s"})
    public RubyString to_pem() {
        StringWriter writer = new StringWriter();
        try {
            PEMInputOutput.writeX509Request(writer, this.getRequest());
            return this.getRuntime().newString(writer.toString());
        }
        catch (IOException e) {
            throw Utils.newIOError(this.getRuntime(), e);
        }
    }

    @JRubyMethod
    public RubyString to_der() {
        ASN1Sequence seq = this.getRequest().toASN1Structure();
        try {
            return StringHelper.newString(this.getRuntime(), seq.getEncoded("DER"));
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
    }

    @JRubyMethod
    public IRubyObject to_text(ThreadContext context2) {
        OpenSSL.warn(context2, "WARNING: unimplemented method called: X509::Request#to_text");
        return context2.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject version() {
        BigInteger certVersion;
        PKCS10Request request = this.getRequest();
        if (request != null && (certVersion = request.getVersion()) != null) {
            return this.getRuntime().newFixnum(certVersion.intValue());
        }
        return this.version == null ? this.getRuntime().newFixnum(0) : this.version;
    }

    @JRubyMethod(name={"version="})
    public IRubyObject set_version(ThreadContext context2, IRubyObject version2) {
        OpenSSL.warn(context2, "X509::Request#version= has no effect on certification request");
        this.version = version2;
        return this.version;
    }

    @JRubyMethod
    public IRubyObject subject() {
        return this.subject == null ? (this.subject = this.getRuntime().getNil()) : this.subject;
    }

    @JRubyMethod(name={"subject="})
    public IRubyObject set_subject(IRubyObject val) {
        if (val != this.subject) {
            if (this.request != null) {
                this.request.setSubject(X509Request.getX500Name(val));
            }
            this.subject = val;
        }
        return val;
    }

    @JRubyMethod
    public IRubyObject signature_algorithm(ThreadContext context2) {
        OpenSSL.warn(context2, "WARNING: unimplemented method called: request#signature_algorithm");
        return context2.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject public_key() {
        return this.public_key == null ? this.getRuntime().getNil() : this.public_key;
    }

    @JRubyMethod(name={"public_key="})
    public IRubyObject set_public_key(IRubyObject pkey) {
        if (pkey != this.public_key) {
            if (this.request != null) {
                this.request.setPublicKey(((PKey)pkey).getPublicKey());
            }
            this.public_key = (PKey)pkey;
        }
        return pkey;
    }

    @JRubyMethod
    public IRubyObject sign(ThreadContext context2, IRubyObject key, IRubyObject digest2) {
        PrivateKey privateKey = ((PKey)key).getPrivateKey();
        Ruby runtime = context2.runtime;
        PKey.supportedSignatureAlgorithm(runtime, this.public_key, (Digest)digest2);
        String digAlg = ((Digest)digest2).getShortAlgorithm();
        try {
            this.request = null;
            this.getRequest().sign(privateKey, digAlg);
        }
        catch (GeneralSecurityException e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw X509Request.newRequestError(runtime, e);
        }
        return this;
    }

    private List<Attribute> newAttributesImpl(ThreadContext context2) {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(this.attributes.size());
        for (X509Attribute attribute : this.attributes) {
            attrs.add(this.newAttributeImpl(context2, attribute));
        }
        return attrs;
    }

    private Attribute newAttributeImpl(ThreadContext context2, X509Attribute attribute) {
        return Attribute.getInstance((Object)attribute.toASN1(context2));
    }

    @JRubyMethod
    public IRubyObject verify(ThreadContext context2, IRubyObject key) {
        Ruby runtime = context2.runtime;
        try {
            PublicKey publicKey = ((PKey)key.callMethod(context2, "public_key")).getPublicKey();
            return runtime.newBoolean(this.getRequest().verify(publicKey));
        }
        catch (InvalidKeyException e) {
            OpenSSL.debug(runtime, "X509::Request.verify invalid key", e);
            throw X509Request.newRequestError(runtime, "invalid key supplied", e);
        }
    }

    @JRubyMethod
    public IRubyObject attributes() {
        List<X509Attribute> attributes2 = this.attributes;
        return this.getRuntime().newArray(attributes2);
    }

    @JRubyMethod(name={"attributes="})
    public IRubyObject set_attributes(ThreadContext context2, IRubyObject attributes2) {
        this.attributes.clear();
        RubyArray attrs = (RubyArray)attributes2;
        for (int i2 = 0; i2 < attrs.size(); ++i2) {
            this.attributes.add((X509Attribute)attrs.entry(i2));
        }
        if (this.request != null) {
            this.request.setAttributes(this.newAttributesImpl(context2));
        }
        return attributes2;
    }

    @JRubyMethod
    public IRubyObject add_attribute(ThreadContext context2, IRubyObject attribute) {
        this.attributes.add((X509Attribute)attribute);
        if (this.request != null) {
            this.request.addAttribute(this.newAttributeImpl(context2, (X509Attribute)attribute));
        }
        return attribute;
    }

    private static RaiseException newRequestError(Ruby runtime, Exception e) {
        return Utils.newError(runtime, X509._X509(runtime).getClass("RequestError"), e);
    }

    private static RaiseException newRequestError(Ruby runtime, String message) {
        return Utils.newError(runtime, X509._X509(runtime).getClass("RequestError"), message);
    }

    private static RaiseException newRequestError(Ruby runtime, String message, Exception cause) {
        return Utils.newError(runtime, X509._X509(runtime).getClass("RequestError"), message, cause);
    }
}

