/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::StructByReference"}, parent="Object")
public final class StructByReference
extends RubyObject {
    private StructLayout structLayout;
    private final RubyClass structClass;

    public static RubyClass createStructByReferenceClass(Ruby runtime, RubyModule ffiModule) {
        RubyClass sbrClass = ffiModule.defineClassUnder("StructByReference", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        sbrClass.defineAnnotatedMethods(StructByReference.class);
        sbrClass.defineAnnotatedConstants(StructByReference.class);
        sbrClass.includeModule(ffiModule.getConstant("DataConverter"));
        return sbrClass;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static final IRubyObject newStructByReference(ThreadContext context, IRubyObject klass, IRubyObject structClass) {
        if (!(structClass instanceof RubyClass)) {
            throw context.runtime.newTypeError("wrong argument type " + structClass.getMetaClass().getName() + " (expected Class)");
        }
        if (!((RubyClass)structClass).isKindOfModule(context.runtime.getFFI().structClass)) {
            throw context.runtime.newTypeError("wrong argument type " + structClass.getMetaClass().getName() + " (expected subclass of FFI::Struct)");
        }
        return new StructByReference(context.runtime, (RubyClass)klass, (RubyClass)structClass, null);
    }

    private StructByReference(Ruby runtime, RubyClass klass, RubyClass structClass, StructLayout layout2) {
        super(runtime, klass);
        this.structClass = structClass;
        this.structLayout = layout2;
    }

    @JRubyMethod(name={"to_s"})
    public final IRubyObject to_s(ThreadContext context) {
        return RubyString.newString(context.runtime, String.format("#<FFI::StructByReference:%s>", this.structClass.getName()));
    }

    @JRubyMethod(name={"layout"})
    public final IRubyObject layout(ThreadContext context) {
        if (this.structLayout == null) {
            this.structLayout = Struct.getStructLayout(context.runtime, this.structClass);
        }
        return this.structLayout;
    }

    @JRubyMethod(name={"struct_class"})
    public final IRubyObject struct_class(ThreadContext context) {
        return this.structClass;
    }

    @JRubyMethod(name={"native_type"})
    public IRubyObject native_type(ThreadContext context) {
        return context.runtime.getFFI().typeClass.getConstant("POINTER");
    }

    @JRubyMethod(name={"to_native"})
    public IRubyObject to_native(ThreadContext context, IRubyObject value2, IRubyObject ctx) {
        if (value2 instanceof Struct && this.structClass.isInstance(value2)) {
            return ((Struct)value2).getMemory();
        }
        if (value2.isNil()) {
            return Pointer.getNull(context.runtime);
        }
        throw context.runtime.newTypeError(value2, this.structClass);
    }

    @JRubyMethod(name={"from_native"})
    public IRubyObject from_native(ThreadContext context, IRubyObject value2, IRubyObject ctx) {
        if (value2 instanceof AbstractMemory) {
            return this.getStructClass().newInstance(context, value2, Block.NULL_BLOCK);
        }
        if (value2.isNil()) {
            return this.getStructClass().newInstance(context, Pointer.getNull(context.runtime), Block.NULL_BLOCK);
        }
        throw context.runtime.newTypeError(value2, context.runtime.getFFI().pointerClass);
    }

    @JRubyMethod(name={"reference_required?"})
    public IRubyObject reference_required_p(ThreadContext context) {
        return context.runtime.getFalse();
    }

    public final StructLayout getStructLayout() {
        return this.structLayout;
    }

    public final RubyClass getStructClass() {
        return this.structClass;
    }
}

