/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoResultCallInstr;
import org.jruby.ir.instructions.specialized.OneArgOperandAttrAssignInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AttrAssignInstr
extends NoResultCallInstr {
    public static AttrAssignInstr create(Operand obj, String attr2, Operand[] args2, boolean isPotentiallyRefined) {
        if (!AttrAssignInstr.containsArgSplat(args2) && args2.length == 1) {
            return new OneArgOperandAttrAssignInstr(obj, attr2, args2, isPotentiallyRefined);
        }
        return new AttrAssignInstr(obj, attr2, args2, isPotentiallyRefined);
    }

    public AttrAssignInstr(Operand obj, String attr2, Operand[] args2, boolean isPotentiallyRefined) {
        super(Operation.ATTR_ASSIGN, CallType.UNKNOWN, attr2, obj, args2, null, isPotentiallyRefined);
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        super.computeScopeFlags(scope);
        if (this.targetRequiresCallersFrame()) {
            scope.getFlags().add(IRFlags.REQUIRES_FRAME);
        }
        return true;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new AttrAssignInstr(this.getReceiver().cloneForInlining(ii), this.getName(), this.cloneCallArgs(ii), this.isPotentiallyRefined());
    }

    @Override
    public void encode(IRWriterEncoder e) {
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("Instr(" + (Object)((Object)this.getOperation()) + "): " + this);
        }
        e.encode(this.getOperation());
        e.encode(this.getReceiver());
        e.encode(this.getName());
        e.encode(this.getCallArgs());
    }

    public static AttrAssignInstr decode(IRReaderDecoder d) {
        return AttrAssignInstr.create(d.decodeOperand(), d.decodeString(), d.decodeOperandArray(), d.getCurrentScope().maybeUsingRefinements());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope dynamicScope, IRubyObject self2, Object[] temp) {
        IRubyObject object = (IRubyObject)this.getReceiver().retrieve(context, self2, currScope, dynamicScope, temp);
        IRubyObject[] values2 = this.prepareArguments(context, self2, currScope, dynamicScope, temp);
        CallType callType = self2 == object ? CallType.FUNCTIONAL : CallType.NORMAL;
        Helpers.invoke(context, object, this.getName(), values2, callType, Block.NULL_BLOCK);
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.AttrAssignInstr(this);
    }
}

