/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import jnr.constants.platform.AddressFamily;
import jnr.unixsocket.UnixSocketAddress;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Sockaddr {
    public static InetAddress addressFromString(Ruby runtime, String s2) {
        try {
            byte[] bs = ByteList.plain(s2);
            return InetAddress.getByAddress(bs);
        }
        catch (Exception e) {
            throw Sockaddr.sockerr(runtime, "strtoaddr: " + e.toString());
        }
    }

    public static String stringFromAddress(Ruby runtime, InetAddress as) {
        try {
            return new String(ByteList.plain(as.getAddress()));
        }
        catch (Exception e) {
            throw Sockaddr.sockerr(runtime, "addrtostr: " + e.toString());
        }
    }

    public static InetSocketAddress addressFromSockaddr_in(ThreadContext context, IRubyObject arg2) {
        RubyArray sockaddr = Sockaddr.unpack_sockaddr_in(context, arg2);
        IRubyObject addr2 = sockaddr.pop(context);
        IRubyObject _port = sockaddr.pop(context);
        int port = SocketUtils.portToInt(_port);
        return new InetSocketAddress(addr2.convertToString().toString(), port);
    }

    public static InetSocketAddress addressFromArg(ThreadContext context, IRubyObject arg2) {
        InetSocketAddress iaddr;
        if (arg2 instanceof Addrinfo) {
            Addrinfo addrinfo = (Addrinfo)arg2;
            iaddr = new InetSocketAddress(addrinfo.getInetAddress(), addrinfo.getPort());
        } else {
            iaddr = Sockaddr.addressFromSockaddr_in(context, arg2);
        }
        return iaddr;
    }

    public static UnixSocketAddress addressFromSockaddr_un(ThreadContext context, IRubyObject arg2) {
        int end2;
        ByteList bl = arg2.convertToString().getByteList();
        byte[] raw = bl.bytes();
        for (end2 = 2; end2 < raw.length && raw[end2] != 0; ++end2) {
        }
        ByteList path2 = new ByteList(raw, 2, end2, false);
        String pathStr = Helpers.decodeByteList(context.runtime, path2);
        return new UnixSocketAddress(new File(pathStr));
    }

    public static RubyArray unpack_sockaddr_in(ThreadContext context, IRubyObject addr2) {
        Ruby runtime = context.runtime;
        ByteList val = addr2.convertToString().getByteList();
        Sockaddr.validateSockaddr(runtime, val);
        int port = ((val.get(2) & 0xFF) << 8) + (val.get(3) & 0xFF);
        AddressFamily af = Sockaddr.getAddressFamilyFromSockaddr(runtime, val);
        StringBuilder formatAddr = new StringBuilder();
        if (af == AddressFamily.AF_INET) {
            formatAddr.append(val.get(4) & 0xFF).append('.').append(val.get(5) & 0xFF).append('.').append(val.get(6) & 0xFF).append('.').append(val.get(7) & 0xFF);
        } else {
            for (int i2 = 4; i2 <= 19; ++i2) {
                if (i2 != 4 && i2 % 2 == 0) {
                    formatAddr.append(':');
                }
                formatAddr.append(Integer.toHexString(val.get(i2) & 0xFF | 0x100).substring(1));
            }
        }
        return RubyArray.newArray(runtime, runtime.newFixnum(port), RubyString.newString(runtime, formatAddr));
    }

    public static IRubyObject packSockaddrFromAddress(ThreadContext context, InetSocketAddress sock) {
        if (sock == null) {
            return Sockaddr.pack_sockaddr_in(context, 0, "");
        }
        return Sockaddr.pack_sockaddr_in(context, sock);
    }

    public static IRubyObject pack_sockaddr_in(ThreadContext context, int port, String host) {
        ByteArrayOutputStream bufS = new ByteArrayOutputStream();
        try {
            DataOutputStream ds = new DataOutputStream(bufS);
            try {
                if (host != null && host.length() == 0) {
                    Sockaddr.writeSockaddrHeader(AddressFamily.AF_INET, ds);
                    Sockaddr.writeSockaddrPort(ds, port);
                    ds.writeInt(0);
                } else {
                    InetAddress[] addrs = InetAddress.getAllByName(host);
                    byte[] addr2 = addrs[0].getAddress();
                    if (addr2.length == 4) {
                        Sockaddr.writeSockaddrHeader(AddressFamily.AF_INET, ds);
                    } else {
                        Sockaddr.writeSockaddrHeader(AddressFamily.AF_INET6, ds);
                    }
                    Sockaddr.writeSockaddrPort(ds, port);
                    ds.write(addr2, 0, addr2.length);
                }
            }
            catch (UnknownHostException e) {
                throw Sockaddr.sockerr(context.runtime, "getaddrinfo: No address associated with nodename");
            }
            Sockaddr.writeSockaddrFooter(ds);
        }
        catch (IOException e) {
            throw Sockaddr.sockerr(context.runtime, "pack_sockaddr_in: internal error");
        }
        return context.runtime.newString(new ByteList(bufS.toByteArray(), false));
    }

    public static IRubyObject pack_sockaddr_in(ThreadContext context, InetSocketAddress sock) {
        ByteArrayOutputStream bufS = new ByteArrayOutputStream();
        try {
            DataOutputStream ds = new DataOutputStream(bufS);
            Sockaddr.writeSockaddrHeader(AddressFamily.AF_INET, ds);
            Sockaddr.writeSockaddrPort(ds, sock);
            String host = sock.getAddress().getHostAddress();
            if (host != null && "".equals(host)) {
                ds.writeInt(0);
            } else {
                byte[] addr2 = sock.getAddress().getAddress();
                ds.write(addr2, 0, addr2.length);
            }
            Sockaddr.writeSockaddrFooter(ds);
        }
        catch (IOException e) {
            throw Sockaddr.sockerr(context.runtime, "pack_sockaddr_in: internal error");
        }
        return context.runtime.newString(new ByteList(bufS.toByteArray(), false));
    }

    public static void writeSockaddrHeader(AddressFamily family2, DataOutputStream ds) throws IOException {
        int value2 = family2.intValue();
        int high = (value2 & 0xFF00) >> 8;
        int low = value2 & 0xFF;
        ds.write((byte)high);
        ds.write((byte)low);
    }

    public static void writeSockaddrFooter(DataOutputStream ds) throws IOException {
        ds.writeInt(0);
        ds.writeInt(0);
    }

    public static void writeSockaddrPort(DataOutputStream ds, InetSocketAddress sockaddr) throws IOException {
        Sockaddr.writeSockaddrPort(ds, sockaddr.getPort());
    }

    public static void writeSockaddrPort(DataOutputStream ds, int port) throws IOException {
        ds.write(port >> 8);
        ds.write(port);
    }

    public static void validateSockaddr(Ruby runtime, ByteList val) {
        int low;
        int high = val.get(0) & 0xFF;
        AddressFamily af = AddressFamily.valueOf((high << 8) + (low = val.get(1) & 0xFF));
        if (af != AddressFamily.AF_INET && af != AddressFamily.AF_INET6) {
            throw runtime.newArgumentError("can't resolve socket address of wrong type");
        }
    }

    public static AddressFamily getAddressFamilyFromSockaddr(Ruby runtime, ByteList val) {
        int high = val.get(0) & 0xFF;
        int low = val.get(1) & 0xFF;
        return AddressFamily.valueOf((high << 8) + low);
    }

    private static RuntimeException sockerr(Ruby runtime, String msg) {
        return new RaiseException(runtime, runtime.getClass("SocketError"), msg, true);
    }
}

