/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeployResult;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.internal.impl.ArtifactRequestBuilder;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class DefaultRepositorySystem
implements RepositorySystem,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private VersionResolver versionResolver;
    private VersionRangeResolver versionRangeResolver;
    private ArtifactResolver artifactResolver;
    private MetadataResolver metadataResolver;
    private ArtifactDescriptorReader artifactDescriptorReader;
    private DependencyCollector dependencyCollector;
    private Installer installer;
    private Deployer deployer;
    private LocalRepositoryProvider localRepositoryProvider;
    private SyncContextFactory syncContextFactory;
    private RemoteRepositoryManager remoteRepositoryManager;

    public DefaultRepositorySystem() {
    }

    @Inject
    DefaultRepositorySystem(VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, MetadataResolver metadataResolver, ArtifactDescriptorReader artifactDescriptorReader, DependencyCollector dependencyCollector, Installer installer, Deployer deployer, LocalRepositoryProvider localRepositoryProvider, SyncContextFactory syncContextFactory, RemoteRepositoryManager remoteRepositoryManager, LoggerFactory loggerFactory) {
        this.setVersionResolver(versionResolver);
        this.setVersionRangeResolver(versionRangeResolver);
        this.setArtifactResolver(artifactResolver);
        this.setMetadataResolver(metadataResolver);
        this.setArtifactDescriptorReader(artifactDescriptorReader);
        this.setDependencyCollector(dependencyCollector);
        this.setInstaller(installer);
        this.setDeployer(deployer);
        this.setLocalRepositoryProvider(localRepositoryProvider);
        this.setSyncContextFactory(syncContextFactory);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setLoggerFactory(loggerFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory((LoggerFactory)locator.getService(LoggerFactory.class));
        this.setVersionResolver((VersionResolver)locator.getService(VersionResolver.class));
        this.setVersionRangeResolver((VersionRangeResolver)locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver((ArtifactResolver)locator.getService(ArtifactResolver.class));
        this.setMetadataResolver((MetadataResolver)locator.getService(MetadataResolver.class));
        this.setArtifactDescriptorReader((ArtifactDescriptorReader)locator.getService(ArtifactDescriptorReader.class));
        this.setDependencyCollector((DependencyCollector)locator.getService(DependencyCollector.class));
        this.setInstaller((Installer)locator.getService(Installer.class));
        this.setDeployer((Deployer)locator.getService(Deployer.class));
        this.setLocalRepositoryProvider((LocalRepositoryProvider)locator.getService(LocalRepositoryProvider.class));
        this.setRemoteRepositoryManager((RemoteRepositoryManager)locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory((SyncContextFactory)locator.getService(SyncContextFactory.class));
    }

    public DefaultRepositorySystem setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger((LoggerFactory)loggerFactory, this.getClass());
        return this;
    }

    public DefaultRepositorySystem setVersionResolver(VersionResolver versionResolver) {
        if (versionResolver == null) {
            throw new IllegalArgumentException("version resolver has not been specified");
        }
        this.versionResolver = versionResolver;
        return this;
    }

    public DefaultRepositorySystem setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        if (versionRangeResolver == null) {
            throw new IllegalArgumentException("version range resolver has not been specified");
        }
        this.versionRangeResolver = versionRangeResolver;
        return this;
    }

    public DefaultRepositorySystem setArtifactResolver(ArtifactResolver artifactResolver) {
        if (artifactResolver == null) {
            throw new IllegalArgumentException("artifact resolver has not been specified");
        }
        this.artifactResolver = artifactResolver;
        return this;
    }

    public DefaultRepositorySystem setMetadataResolver(MetadataResolver metadataResolver) {
        if (metadataResolver == null) {
            throw new IllegalArgumentException("metadata resolver has not been specified");
        }
        this.metadataResolver = metadataResolver;
        return this;
    }

    public DefaultRepositorySystem setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        if (artifactDescriptorReader == null) {
            throw new IllegalArgumentException("artifact descriptor reader has not been specified");
        }
        this.artifactDescriptorReader = artifactDescriptorReader;
        return this;
    }

    public DefaultRepositorySystem setDependencyCollector(DependencyCollector dependencyCollector) {
        if (dependencyCollector == null) {
            throw new IllegalArgumentException("dependency collector has not been specified");
        }
        this.dependencyCollector = dependencyCollector;
        return this;
    }

    public DefaultRepositorySystem setInstaller(Installer installer) {
        if (installer == null) {
            throw new IllegalArgumentException("installer has not been specified");
        }
        this.installer = installer;
        return this;
    }

    public DefaultRepositorySystem setDeployer(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("deployer has not been specified");
        }
        this.deployer = deployer;
        return this;
    }

    public DefaultRepositorySystem setLocalRepositoryProvider(LocalRepositoryProvider localRepositoryProvider) {
        if (localRepositoryProvider == null) {
            throw new IllegalArgumentException("local repository provider has not been specified");
        }
        this.localRepositoryProvider = localRepositoryProvider;
        return this;
    }

    public DefaultRepositorySystem setSyncContextFactory(SyncContextFactory syncContextFactory) {
        if (syncContextFactory == null) {
            throw new IllegalArgumentException("sync context factory has not been specified");
        }
        this.syncContextFactory = syncContextFactory;
        return this;
    }

    public DefaultRepositorySystem setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException("remote repository manager has not been specified");
        }
        this.remoteRepositoryManager = remoteRepositoryManager;
        return this;
    }

    public VersionResult resolveVersion(RepositorySystemSession session, VersionRequest request) throws VersionResolutionException {
        this.validateSession(session);
        return this.versionResolver.resolveVersion(session, request);
    }

    public VersionRangeResult resolveVersionRange(RepositorySystemSession session, VersionRangeRequest request) throws VersionRangeResolutionException {
        this.validateSession(session);
        return this.versionRangeResolver.resolveVersionRange(session, request);
    }

    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        this.validateSession(session);
        return this.artifactDescriptorReader.readArtifactDescriptor(session, request);
    }

    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        this.validateSession(session);
        return this.artifactResolver.resolveArtifact(session, request);
    }

    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        this.validateSession(session);
        return this.artifactResolver.resolveArtifacts(session, requests);
    }

    public List<MetadataResult> resolveMetadata(RepositorySystemSession session, Collection<? extends MetadataRequest> requests) {
        this.validateSession(session);
        return this.metadataResolver.resolveMetadata(session, requests);
    }

    public CollectResult collectDependencies(RepositorySystemSession session, CollectRequest request) throws DependencyCollectionException {
        this.validateSession(session);
        return this.dependencyCollector.collectDependencies(session, request);
    }

    public DependencyResult resolveDependencies(RepositorySystemSession session, DependencyRequest request) throws DependencyResolutionException {
        List results;
        this.validateSession(session);
        RequestTrace trace = RequestTrace.newChild((RequestTrace)request.getTrace(), (Object)request);
        DependencyResult result = new DependencyResult(request);
        DependencyCollectionException dce = null;
        ArtifactResolutionException are = null;
        if (request.getRoot() != null) {
            result.setRoot(request.getRoot());
        } else if (request.getCollectRequest() != null) {
            CollectResult collectResult;
            try {
                request.getCollectRequest().setTrace(trace);
                collectResult = this.dependencyCollector.collectDependencies(session, request.getCollectRequest());
            }
            catch (DependencyCollectionException e) {
                dce = e;
                collectResult = e.getResult();
            }
            result.setRoot(collectResult.getRoot());
            result.setCycles(collectResult.getCycles());
            result.setCollectExceptions(collectResult.getExceptions());
        } else {
            throw new IllegalArgumentException("dependency node or collect request missing");
        }
        ArtifactRequestBuilder builder = new ArtifactRequestBuilder(trace);
        DependencyFilter filter = request.getFilter();
        ArtifactRequestBuilder visitor = filter != null ? new FilteringDependencyVisitor((DependencyVisitor)builder, filter) : builder;
        visitor = new TreeDependencyVisitor((DependencyVisitor)visitor);
        result.getRoot().accept((DependencyVisitor)visitor);
        List<ArtifactRequest> requests = builder.getRequests();
        try {
            results = this.artifactResolver.resolveArtifacts(session, requests);
        }
        catch (ArtifactResolutionException e) {
            are = e;
            results = e.getResults();
        }
        result.setArtifactResults(results);
        this.updateNodesWithResolvedArtifacts(results);
        if (dce != null) {
            throw new DependencyResolutionException(result, (Throwable)dce);
        }
        if (are != null) {
            throw new DependencyResolutionException(result, (Throwable)are);
        }
        return result;
    }

    private void updateNodesWithResolvedArtifacts(List<ArtifactResult> results) {
        for (ArtifactResult result : results) {
            Artifact artifact = result.getArtifact();
            if (artifact == null) continue;
            result.getRequest().getDependencyNode().setArtifact(artifact);
        }
    }

    public InstallResult install(RepositorySystemSession session, InstallRequest request) throws InstallationException {
        this.validateSession(session);
        return this.installer.install(session, request);
    }

    public DeployResult deploy(RepositorySystemSession session, DeployRequest request) throws DeploymentException {
        this.validateSession(session);
        return this.deployer.deploy(session, request);
    }

    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository localRepository) {
        try {
            return this.localRepositoryProvider.newLocalRepositoryManager(session, localRepository);
        }
        catch (NoLocalRepositoryManagerException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public SyncContext newSyncContext(RepositorySystemSession session, boolean shared) {
        this.validateSession(session);
        return this.syncContextFactory.newInstance(session, shared);
    }

    public List<RemoteRepository> newResolutionRepositories(RepositorySystemSession session, List<RemoteRepository> repositories) {
        this.validateSession(session);
        repositories = this.remoteRepositoryManager.aggregateRepositories(session, new ArrayList<RemoteRepository>(), repositories, true);
        return repositories;
    }

    public RemoteRepository newDeploymentRepository(RepositorySystemSession session, RemoteRepository repository) {
        this.validateSession(session);
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository);
        Authentication auth = session.getAuthenticationSelector().getAuthentication(repository);
        builder.setAuthentication(auth);
        Proxy proxy = session.getProxySelector().getProxy(repository);
        builder.setProxy(proxy);
        return builder.build();
    }

    private void validateSession(RepositorySystemSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Invalid repository system session: the session may not be null.");
        }
        if (session.getLocalRepositoryManager() == null) {
            this.invalidSession("LocalRepositoryManager");
        }
        if (session.getSystemProperties() == null) {
            this.invalidSession("SystemProperties");
        }
        if (session.getUserProperties() == null) {
            this.invalidSession("UserProperties");
        }
        if (session.getConfigProperties() == null) {
            this.invalidSession("ConfigProperties");
        }
        if (session.getMirrorSelector() == null) {
            this.invalidSession("MirrorSelector");
        }
        if (session.getProxySelector() == null) {
            this.invalidSession("ProxySelector");
        }
        if (session.getAuthenticationSelector() == null) {
            this.invalidSession("AuthenticationSelector");
        }
        if (session.getArtifactTypeRegistry() == null) {
            this.invalidSession("ArtifactTypeRegistry");
        }
        if (session.getData() == null) {
            this.invalidSession("Data");
        }
    }

    private void invalidSession(String name) {
        throw new IllegalArgumentException("Invalid repository system session: " + name + " is not set.");
    }
}

