# is-number [![NPM version](https://badge.fury.io/js/is-number.svg)](http://badge.fury.io/js/is-number)


> Is the value a number? Has extensive tests.

## Install
#### Install with [npm](npmjs.org):

```bash
npm i is-number --save-dev
```

## Run tests

```bash
npm test
```

## Usage

```js
var isNumber = require('is-number');
```


### true

```js
isNumber(5e3);

isNumber(0xff);

isNumber(-1.1);
isNumber(0);
isNumber(1);
isNumber(1.1);
isNumber(10);
isNumber(10.10);
isNumber(100);

isNumber('-1.1');
isNumber('0');
isNumber('012');
isNumber('0xff');
isNumber('1');
isNumber('1.1');
isNumber('10');
isNumber('10.10');
isNumber('100');
isNumber('5e3');

isNumber(parseInt('012'));
isNumber(parseFloat('012'));

isNumber(Infinity);
isNumber('Infinity');
```

If you want `Infinity` to be `false`, just do:

```js
var isNumber = require('is-number');

function isNum(val) {
  return isNumber(val) && isFinite(val);
}
```

### false

```js
isNumber('3abc');
isNumber('abc');
isNumber('abc3');
isNumber('null');
isNumber('undefined');
isNumber([1, 2, 3]);
isNumber(function () {});
isNumber(new Buffer('abc'));
isNumber(null);
isNumber(undefined);
isNumber({abc: 'abc'});
isNumber({});
isNumber([]);
```

## Notes

Instead of using `isFinite()`, you can also achieve similar results by using something like `((+n+1) / (+n+1) === 1))`, but this alone allows values like `null` to pass as numbers (in JavaScript, the leading `+` coerces the value to a number, [see this gist](https://gist.github.com/jonschlinkert/e30c70c713da325d0e81) for some oddities).


## Author

**Jon Schlinkert**
 
+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

## License
Copyright (c) 2014 Jon Schlinkert, contributors.  
Released under the MIT license

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on September 21, 2014._