"""Locale information.
Holds a map from ISO 3166-1 country code (e.g. GB) to a dict.
Each dict maps from an ISO 639-1 language code (e.g. ja) to the country's name in that language.

Generated from java.util.Locale, generation info:
  java.version=1.6.0_65
  java.vendor=Apple Inc.
  os.name=Mac OS X
  os.arch=x86_64
  os.version=10.10.5

Auto-generated file, do not edit by hand.
"""
from ..util import u
LOCALE_DATA = {
  'AD': {'aa':'Andorra','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03bd\u03b4\u03cc\u03c1\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Andorre','fy':'*aa','ga':u('And\u00f3ra'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Andora','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30f3\u30c9\u30e9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc548\ub3c4\ub77c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*id','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0410\u043d\u0434\u043e\u0440\u0440\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0410\u043d\u0434\u043e\u0440\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e31\u0e19\u0e14\u0e2d\u0e23\u0e4c\u0e23\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5b89\u9053\u5c14'),'zu':'*aa',},
  'AE': {'aa':'United Arab Emirates','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0627\u0644\u0625\u0645\u0627\u0631\u0627\u062a'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Uni\u00f3 dels Emirats \u00c0rabs'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Vereinigte Arabische Emirate','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0397\u03bd\u03c9\u03bc\u03ad\u03bd\u03b1 \u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03ac \u0395\u03bc\u03b9\u03c1\u03ac\u03c4\u03b1'),'en':'*aa','eo':'*aa','es':u('Emiratos \u00c1rabes Unidos'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Emirats Arabes Unis','fy':'*aa','ga':u('Aontas na n\u00c9im\u00edr\u00edochta\u00ed Arabacha'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Uni Emirat Arab','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Emirati Arabi Uniti','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30e9\u30d6\u9996\u9577\u56fd\u9023\u90a6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc544\ub78d\uc5d0\ubbf8\ub9ac\ud2b8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Emiriah Arab Bersatu','mt':u('Emirati G\u0127arab Maqg\u0127uda'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Zjednoczone Emiraty Arabskie','ps':'*aa','pt':u('Emirados \u00c1rabes Unidos'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041e\u0431\u044a\u0435\u0434\u0438\u043d\u0435\u043d\u043d\u044b\u0435 \u0410\u0440\u0430\u0431\u0441\u043a\u0438\u0435 \u042d\u043c\u0438\u0440\u0430\u0442\u044b'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0423\u0458\u0435\u0434\u0438\u045a\u0435\u043d\u0438 \u0410\u0440\u0430\u043f\u0441\u043a\u0438 \u0415\u043c\u0438\u0440\u0430\u0442\u0438'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('F\u00f6renade Arabemiraten'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e40\u0e2d\u0e21\u0e34\u0e40\u0e23\u0e15\u0e2a\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('C\u00e1c Ti\u1ec3u V\u01b0\u01a1ng qu\u1ed1c A-r\u1eadp Th\u1ed1ng nh\u1ea5t'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u963f\u62c9\u4f2f\u8054\u5408\u914b\u957f\u56fd'),'zu':'*aa',},
  'AF': {'aa':'Afghanistan','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Afganistan','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03c6\u03b3\u03b1\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd'),'en':'*aa','eo':'*aa','es':u('Afganist\u00e1n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Afganast\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30d5\u30ac\u30cb\u30b9\u30bf\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc544\ud504\uac00\ub2c8\uc2a4\ud0c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*ca','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*ca','ps':'*aa','pt':u('Afeganist\u00e3o'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0410\u0444\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0410\u0432\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e31\u0e1f\u0e01\u0e32\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u00c1p-ga-ni-xtan'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u963f\u5bcc\u6c57'),'zu':'*aa',},
  'AG': {'aa':'Antigua and Barbuda','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Antigua und Barbuda','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03bd\u03c4\u03af\u03b3\u03ba\u03bf\u03c5\u03b1 \u03ba\u03b1\u03b9 \u039c\u03c0\u03b1\u03c1\u03bc\u03c0\u03bf\u03cd\u03bd\u03c4\u03b1'),'en':'*aa','eo':'*aa','es':'Antigua y Barbuda','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Antigua et Barbuda','fy':'*aa','ga':'Antigua agus Barbuda','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Antigua dan Barbuda','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Antigua e Barbuda','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30f3\u30c1\u30b0\u30a2\u30d0\u30fc\u30d6\u30fc\u30c0'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc564\ud2f0\uac00 \ubc14\ubd80\ub2e4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Ant\u00edgua e Barbuda'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'Antigua och Barbuda','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('An-ti-gu-a v\u00e0 Ba-bu-\u0111a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe'),'zu':'*aa',},
  'AI': {'aa':'Anguilla','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03bd\u03b3\u03ba\u03bf\u03c5\u03af\u03bb\u03b1'),'en':'*aa','eo':'*aa','es':'Anguila','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30f3\u30ae\u30e9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc548\uae38\ub77c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Angwilla','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0410\u043d\u0433\u0443\u0438\u043b\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e31\u0e19\u0e01\u0e34\u0e25\u0e48\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5b89\u572d\u62c9'),'zu':'*aa',},
  'AL': {'aa':'Albania','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Alb\u00e0nia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Albanien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03bb\u03b2\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Albanie','fy':'*aa','ga':u('An Alb\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30eb\u30d0\u30cb\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc54c\ubc14\ub2c8\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Albanija','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Alb\u00e2nia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0410\u043b\u0431\u0430\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Shqip\u00ebria'),'sr':u('\u0410\u043b\u0431\u0430\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e41\u0e2d\u0e25\u0e40\u0e1a\u0e40\u0e19\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'An-ba-ni','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u963f\u5c14\u5df4\u5c3c\u4e9a'),'zu':'*aa',},
  'AM': {'aa':'Armenia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Arm\u00e8nia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Armenien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03c1\u03bc\u03b5\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Arm\u00e9nie'),'fy':'*aa','ga':u('An Airm\u00e9in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30eb\u30e1\u30cb\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc544\ub974\uba54\ub2c8\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Armenja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Arm\u00eania'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0410\u0440\u043c\u0435\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0410\u0440\u043c\u0435\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e32\u0e23\u0e4c\u0e21\u0e35\u0e40\u0e19\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u00c1c-m\u00ea-ni-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e9a\u7f8e\u5c3c\u4e9a'),'zu':'*aa',},
  'AN': {'aa':'Netherlands Antilles','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Antilles Holandeses','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('Niederl\u00e4ndische Antillen'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039f\u03bb\u03bb\u03b1\u03bd\u03b4\u03b9\u03ba\u03ad\u03c2 \u0391\u03bd\u03c4\u03af\u03bb\u03bb\u03b5\u03c2'),'en':'*aa','eo':'*aa','es':'Antillas Holandesas','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Antilles N\u00e9erlandaises'),'fy':'*aa','ga':u('Antill\u00ed na h\u00cdsilt\u00edre'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Antilles Belanda','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Antille Olandesi','iu':'*aa','iw':'*aa','ja':u('\u30aa\u30e9\u30f3\u30c0\u9818\u30a2\u30f3\u30c6\u30a3\u30eb\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub124\ub35c\ub780\ub4dc\ub839 \uc548\ud2f8\ub808\uc2a4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Antilles Olandi\u017ci'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Antyle Holenderskie','ps':'*aa','pt':'Antilhas Holandesas','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0435 \u0410\u043d\u0442\u0438\u043b\u044c\u0441\u043a\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0425\u043e\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u0410\u043d\u0442\u0438\u043b\u0438'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Nederl\u00e4ndska Antillerna '),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e19\u0e40\u0e18\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c\u0e41\u0e2d\u0e19\u0e17\u0e34\u0e25\u0e25\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8377\u5c5e\u5b89\u7684\u5217\u65af\u7fa4\u5c9b'),'zu':'*aa',},
  'AO': {'aa':'Angola','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03bd\u03b3\u03ba\u03cc\u03bb\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Ang\u00f3la'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30f3\u30b4\u30e9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc559\uace8\ub77c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0410\u043d\u0433\u043e\u043b\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e31\u0e19\u0e42\u0e01\u0e25\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u0102ng-g\u00f4-la'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5b89\u54e5\u62c9'),'zu':'*aa',},
  'AQ': {'aa':'Antarctica','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Antarktis','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03bd\u03c4\u03b1\u03c1\u03ba\u03c4\u03b9\u03ba\u03ae'),'en':'*aa','eo':'*aa','es':u('Ant\u00e1rtida'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Antarctique','fy':'*aa','ga':'An Antartaice','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Antarktika','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Antartide','iu':'*aa','iw':'*aa','ja':u('\u5357\u6975'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub0a8\uadf9'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Antartika','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5357\u6781\u6d32'),'zu':'*aa',},
  'AR': {'aa':'Argentina','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Argentinien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Argentine','fy':'*aa','ga':u('An Airgint\u00edn'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30eb\u30bc\u30f3\u30c1\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc544\ub974\ud5e8\ud2f0\ub098'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Ar\u0121entina'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Argentyna','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e48\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u00c1c-hen-ti-na'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u963f\u6839\u5ef7'),'zu':'*aa',},
  'AS': {'aa':'American Samoa','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Amerikanisch-Samoa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03b1\u03bd\u03b9\u03ba\u03ae \u03a3\u03b1\u03bc\u03cc\u03b1'),'en':'*aa','eo':'*aa','es':'Samoa Americana','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Samoa am\u00e9ricaines'),'fy':'*aa','ga':u('Sam\u00f3 Meirice\u00e1nach'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Samoa Amerika','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Samoa americane','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30e1\u30ea\u30ab\u30f3\u30b5\u30e2\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubbf8\uad6d\ub839 \uc0ac\ubaa8\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Samoa Amerikana','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'Amerikanska Samoa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e1c\u8428\u6469\u4e9a'),'zu':'*aa',},
  'AT': {'aa':'Austria','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('\u00c2ustria'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('\u00d6sterreich'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03c5\u03c3\u03c4\u03c1\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Autriche','fy':'*aa','ga':'An Ostair','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30aa\u30fc\u30b9\u30c8\u30ea\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc624\uc2a4\ud2b8\ub9ac\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Awstrija','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('\u00c1ustria'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0410\u0432\u0441\u0442\u0440\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0410\u0443\u0441\u0442\u0440\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('\u00d6sterrike'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u00c1o'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5965\u5730\u5229'),'zu':'*aa',},
  'AU': {'aa':'Australia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Austr\u00e0lia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Australien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Australie','fy':'*aa','ga':u('An Astr\u00e1il'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30aa\u30fc\u30b9\u30c8\u30e9\u30ea\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Awstralja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Austr\u00e1lia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u00dac'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6fb3\u5927\u5229\u4e9a'),'zu':'*aa',},
  'AW': {'aa':'Aruba','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03c1\u03bf\u03cd\u03bc\u03c0\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30eb\u30d0\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc544\ub8e8\ubc14'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0410\u0440\u0443\u0431\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e32\u0e23\u0e39\u0e1a\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u963f\u9c81\u5df4'),'zu':'*aa',},
  'AX': {'aa':u('\u00c5land Islands'),'ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Aaland-Inseln','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 Aland'),'en':'*aa','eo':'*aa','es':'Islas Aland','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00celes \u00c5land'),'fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Isole Aland','iu':'*aa','iw':'*aa','ja':u('\u30aa\u30fc\u30e9\u30f3\u30c9\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc62c\ub780\ub4dc \uc81c\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0410\u043b\u0430\u043d\u0434\u0441\u043a\u0430 \u043e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('\u00c5land'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5965\u5170\u7fa4\u5c9b'),'zu':'*aa',},
  'AZ': {'aa':'Azerbaijan','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Azerbaidjan','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Aserbaidschan','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03b6\u03b5\u03c1\u03bc\u03c0\u03b1\u03ca\u03c4\u03b6\u03ac\u03bd'),'en':'*aa','eo':'*aa','es':u('Azerbaiy\u00e1n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Azerba\u00efdjan'),'fy':'*aa','ga':u('An Asarbaise\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Azerbaigian','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30bc\u30eb\u30d0\u30a4\u30b8\u30e3\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc544\uc81c\ub974\ubc14\uc774\uc794'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('A\u017cerbaj\u0121an'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Azerbejd\u017can'),'ps':'*aa','pt':u('Azerbaij\u00e3o'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0410\u0437\u0435\u0440\u0431\u0435\u0458\u045f\u0430\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Azerbadjan','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e32\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e44\u0e1a\u0e08\u0e31\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ai-d\u00e9c-bai-gian'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u963f\u585e\u62dc\u7586'),'zu':'*aa',},
  'BA': {'aa':'Bosnia and Herzegovina','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('B\u00f2snia i Hercegovina'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Bosnien und Herzegowina','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0392\u03bf\u03c3\u03bd\u03af\u03b1 - \u0395\u03c1\u03b6\u03b5\u03b3\u03bf\u03b2\u03af\u03bd\u03b7'),'en':'*aa','eo':'*aa','es':'Bosnia y Hercegovina','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Bosnie-Herz\u00e9govine'),'fy':'*aa','ga':u('An Bhoisnia-Heirseagaiv\u00e9in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Bosnia dan Herzegovina','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Bosnia-Erzegovina','iu':'*aa','iw':'*aa','ja':u('\u30dc\u30b9\u30cb\u30a2\u30fb\u30d8\u30eb\u30c4\u30a7\u30b4\u30d3\u30ca'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubcf4\uc2a4\ub2c8\uc544 \ud5e4\ub974\uccb4\uace0\ube44\ub098'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':u('Bo\u017cnija \u0126er\u017cegovina'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Bo\u015bnia i Hercegowina'),'ps':'*aa','pt':u('B\u00f3snia-Herzeg\u00f3vina'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u043e\u0441\u043d\u0438\u044f \u0438 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u043e\u0441\u043d\u0430 \u0438 \u0425\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Bosnien och Herzegovina','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1a\u0e2d\u0e2a\u0e40\u0e19\u0e35\u0e22 \u0e41\u0e25\u0e30 \u0e40\u0e2e\u0e34\u0e23\u0e4c\u0e0b\u0e42\u0e01\u0e27\u0e34\u0e40\u0e19\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('B\u00f4-xni-a H\u00e9c-x\u00ea-g\u00f4-vi-na'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6ce2\u65af\u5c3c\u4e9a\u548c\u9ed1\u5c71\u5171\u548c\u56fd'),'zu':'*aa',},
  'BB': {'aa':'Barbados','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03c0\u03b1\u03c1\u03bc\u03c0\u03ac\u03bd\u03c4\u03bf\u03c2'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Barbade','fy':'*aa','ga':u('Barbad\u00f3s'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d0\u30eb\u30d0\u30c9\u30b9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubc14\ubca0\uc774\ub3c4\uc2a4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1a\u0e32\u0e23\u0e4c\u0e1a\u0e32\u0e14\u0e2d\u0e2a'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('B\u00e1c-ba-\u0111\u1ed1t'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5df4\u5df4\u591a\u65af'),'zu':'*aa',},
  'BD': {'aa':'Bangladesh','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Bangla Desh','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Bangladesch','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03c0\u03b1\u03bd\u03b3\u03ba\u03bb\u03b1\u03bd\u03c4\u03ad\u03c2'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Bhanglaid\u00e9is'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d0\u30f3\u30b0\u30e9\u30c7\u30b7\u30e5'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubc29\uae00\ub77c\ub370\uc2dc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Bangladexx','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Bangladesz','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1a\u0e31\u0e07\u0e04\u0e25\u0e32\u0e40\u0e17\u0e28'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('B\u0103ng-la-\u0111\u00e9t'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5b5f\u52a0\u62c9'),'zu':'*aa',},
  'BE': {'aa':'Belgium','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('B\u00e8lgica'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Belgien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0392\u03ad\u03bb\u03b3\u03b9\u03bf'),'en':'*aa','eo':'*aa','es':u('B\u00e9lgica'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Belgia','fj':'*aa','fo':'*aa','fr':'Belgique','fy':'*aa','ga':'An Bheilg','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*fi','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*fi','io':'*aa','is':'*aa','it':'Belgio','iu':'*aa','iw':'*aa','ja':u('\u30d9\u30eb\u30ae\u30fc'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubca8\uae30\uc5d0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Bel\u0121ju'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':u('Belgi\u00eb'),'nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*fi','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u0435\u043b\u044c\u0433\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u0435\u043b\u0433\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e1a\u0e25\u0e40\u0e22\u0e35\u0e48\u0e22\u0e21'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('B\u1ec9'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6bd4\u5229\u65f6'),'zu':'*aa',},
  'BF': {'aa':'Burkina Faso','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03c0\u03bf\u03c5\u03c1\u03ba\u03af\u03bd\u03b1 \u03a6\u03ac\u03c3\u03bf'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Buirc\u00edne Fas\u00f3'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d6\u30eb\u30ad\u30ca\u30d5\u30a1\u30bd'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubd80\ub974\ud0a4\ub098\ud30c\uc18c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Burquina Faso','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u0443\u0440\u043a\u0438\u043d\u0430-\u0424\u0430\u0441\u043e'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u0443\u0440\u043a\u0438\u043d\u0430 \u0424\u0430\u0441\u043e'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e1a\u0e2d\u0e23\u0e4c\u0e01\u0e34\u0e19\u0e32\u0e1f\u0e32\u0e42\u0e0b'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Bu\u1ed1c-ki-na Pha-x\u00f4'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5e03\u57fa\u7eb3\u6cd5\u7d22'),'zu':'*aa',},
  'BG': {'aa':'Bulgaria','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':u('\u0411\u044a\u043b\u0433\u0430\u0440\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Bulg\u00e0ria'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Bulgarien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0392\u03bf\u03c5\u03bb\u03b3\u03b1\u03c1\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Bulgarie','fy':'*aa','ga':u('An Bhulg\u00e1ir'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d6\u30eb\u30ac\u30ea\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubd88\uac00\ub9ac\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Bulgarija','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Bu\u0142garia'),'ps':'*aa','pt':u('Bulg\u00e1ria'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u0443\u0433\u0430\u0440\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1a\u0e31\u0e25\u0e41\u0e01\u0e40\u0e23\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Bun-ga-ri','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4fdd\u52a0\u5229\u4e9a'),'zu':'*aa',},
  'BH': {'aa':'Bahrain','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0627\u0644\u0628\u062d\u0631\u064a\u0646'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03c0\u03b1\u03c7\u03c1\u03ad\u03b9\u03bd'),'en':'*aa','eo':'*aa','es':u('Bahr\u00e1in'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Bahre\u00efn'),'fy':'*aa','ga':u('Bair\u00e9in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d0\u30fc\u30ec\u30fc\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubc14\ub808\uc778'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Ba\u0127rajn'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Bahrajn','ps':'*aa','pt':'Bareine','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u0430\u0445\u0440\u0435\u0439\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u0430\u0445\u0440\u0435\u0438\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1a\u0e32\u0e2b\u0e4c\u0e40\u0e23\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Ba-ren','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5df4\u6797'),'zu':'*aa',},
  'BI': {'aa':'Burundi','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03c0\u03bf\u03c5\u03c1\u03bf\u03cd\u03bd\u03c4\u03b9'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Bhur\u00fain'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d6\u30eb\u30f3\u30b8'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubd80\ub8ec\ub514'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u0443\u0440\u0443\u043d\u0434\u0438'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1a\u0e39\u0e23\u0e31\u0e19\u0e14\u0e34'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Bu-run-\u0111i'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5e03\u9686\u8fea'),'zu':'*aa',},
  'BJ': {'aa':'Benin','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03c0\u03ad\u03bd\u03b9\u03bd'),'en':'*aa','eo':'*aa','es':u('Ben\u00edn'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'Beinin','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d9\u30cb\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubca0\ub139'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u0435\u043d\u0438\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e1a\u0e19\u0e34\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('B\u00ea-nanh'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8d1d\u5b81'),'zu':'*aa',},
  'BL': {'aa':u('Saint Barth\u00e9lemy'),'ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':'*aa','en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':'*aa','ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':'*aa','kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':'*aa','zu':'*aa',},
  'BM': {'aa':'Bermuda','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Bermudes','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0392\u03b5\u03c1\u03bc\u03bf\u03cd\u03b4\u03b5\u03c2'),'en':'*aa','eo':'*aa','es':'Bermudas','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*ca','fy':'*aa','ga':u('Beirmi\u00fada'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d0\u30fc\u30df\u30e5\u30fc\u30c0\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubc84\ubba4\ub2e4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Bermudy','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u043a\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u0435\u0440\u043c\u0443\u0434\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e1a\u0e2d\u0e23\u0e4c\u0e21\u0e34\u0e27\u0e14\u0e49\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u767e\u6155\u5927'),'zu':'*aa',},
  'BN': {'aa':'Brunei','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03c0\u03c1\u03bf\u03c5\u03bd\u03ad\u03b9 \u039d\u03c4\u03b1\u03c1\u03bf\u03c5\u03c3\u03b1\u03bb\u03ac\u03bc'),'en':'*aa','eo':'*aa','es':u('Brun\u00e9i'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Br\u00fain\u00e9'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d6\u30eb\u30cd\u30a4'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ube0c\ub8e8\ub098\uc774'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Brunej','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u0440\u0443\u043d\u0435\u0439'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u0440\u0443\u043d\u0435\u0458'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1a\u0e23\u0e39\u0e44\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Bru-n\u00e2y'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6587\u83b1'),'zu':'*aa',},
  'BO': {'aa':'Bolivia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Bol\u00edvia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Bolivien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0392\u03bf\u03bb\u03b9\u03b2\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Bolivie','fy':'*aa','ga':'An Bholaiv','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30dc\u30ea\u30d3\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubcfc\ub9ac\ube44\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Bolivja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Boliwia','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u043e\u043b\u0438\u0432\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u043e\u043b\u0438\u0432\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e1a\u0e25\u0e34\u0e40\u0e27\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('B\u00f4-li-vi-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u73bb\u5229\u7ef4\u4e9a'),'zu':'*aa',},
  'BQ': {'aa':'Bonaire, Sint Eustatius and Saba','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':'*aa','en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':'*aa','ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':'*aa','kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':'*aa','zu':'*aa',},
  'BR': {'aa':'Brazil','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Brasil','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Brasilien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0392\u03c1\u03b1\u03b6\u03b9\u03bb\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*ca','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Brasilia','fj':'*aa','fo':'*aa','fr':u('Br\u00e9sil'),'fy':'*aa','ga':u('An Bhrasa\u00edl'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Brasile','iu':'*aa','iw':'*aa','ja':u('\u30d6\u30e9\u30b8\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ube0c\ub77c\uc9c8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Bra\u017cil'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Brazylia','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u0440\u0430\u0455\u0438\u043b'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Bra-xin','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5df4\u897f'),'zu':'*aa',},
  'BS': {'aa':'Bahamas','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Bahames','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03c0\u03b1\u03c7\u03ac\u03bc\u03b5\u03c2'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Na Bah\u00e1ma\u00ed'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d0\u30cf\u30de'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubc14\ud558\ub9c8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Ba\u0127amas'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Bahamy','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u0430\u0433\u0430\u043c\u0441\u043a\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u0430\u0445\u0430\u043c\u0438'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1a\u0e32\u0e2e\u0e32\u0e21\u0e32\u0e2a'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Ba-ha-ma','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5df4\u54c8\u9a6c'),'zu':'*aa',},
  'BT': {'aa':'Bhutan','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03c0\u03bf\u03c5\u03c4\u03ac\u03bd'),'en':'*aa','eo':'*aa','es':u('But\u00e1n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Bhoutan','fy':'*aa','ga':u('An Bh\u00fat\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d6\u30fc\u30bf\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubd80\ud0c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Butan','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('But\u00e3o'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u0443\u0442\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e20\u0e39\u0e10\u0e32\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e0d\u4e39'),'zu':'*aa',},
  'BV': {'aa':'Bouvet Island','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Bouvet-Insel','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03c2 \u039c\u03c0\u03bf\u03c5\u03b2\u03ad'),'en':'*aa','eo':'*aa','es':'Isla Bouvet','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00cele Bouvet'),'fy':'*aa','ga':u('Oile\u00e1in Bouvet'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kepulauan Bouvet','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Isola di Bouvet','iu':'*aa','iw':'*aa','ja':u('\u30d6\u30fc\u30d9\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubd80\ubca0\uc774 \uc12c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Ilha Bouvet','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u0443\u0432\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Bouvet\u00f6n'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5e03\u97e6\u5c9b'),'zu':'*aa',},
  'BW': {'aa':'Botswana','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Botsuana','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03c0\u03bf\u03c4\u03c3\u03bf\u03c5\u03ac\u03bd\u03b1'),'en':'*aa','eo':'*aa','es':'*de','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Bhotsu\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30dc\u30c4\u30ef\u30ca'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubcf4\uce20\uc640\ub098'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*de','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u043e\u0446\u0432\u0430\u043d\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1a\u0e2d\u0e15\u0e2a\u0e27\u0e32\u0e19\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('B\u1ed1t-xoa-na'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u535a\u8328\u74e6\u7eb3'),'zu':'*aa',},
  'BY': {'aa':'Belarus','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c'),'bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Bielor\u00fassia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039b\u03b5\u03c5\u03ba\u03bf\u03c1\u03c9\u03c3\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Bielorrusia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Bi\u00e9lo-Russie'),'fy':'*aa','ga':u('An Bhealar\u00fais'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Belarusia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Bielorussia','iu':'*aa','iw':'*aa','ja':u('\u30d9\u30e9\u30eb\u30fc\u30b7'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubca8\ub77c\ub8e8\uc2a4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Bjelorussja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Bia\u0142oru\u015b'),'ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Vitryssland','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e1a\u0e25\u0e25\u0e32\u0e23\u0e31\u0e2a'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('B\u00ea-la-r\u00fat'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u767d\u4fc4\u7f57\u65af'),'zu':'*aa',},
  'BZ': {'aa':'Belize','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03c0\u03b5\u03bb\u03af\u03b6'),'en':'*aa','eo':'*aa','es':'Belice','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('B\u00e9lize'),'fy':'*aa','ga':u('An Bheil\u00eds'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d9\u30ea\u30fc\u30ba'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubca8\ub9ac\uc988'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Beli\u017ce'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u0435\u043b\u0438\u0437'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u0435\u043b\u0438\u0441\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e1a\u0e25\u0e34\u0e0b'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('B\u00ea-li-x\u00ea'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4f2f\u91cc\u5179'),'zu':'*aa',},
  'CA': {'aa':'Canada','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Canad\u00e0'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Kanada','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03b1\u03bd\u03b1\u03b4\u03ac\u03c2'),'en':'*aa','eo':'*aa','es':u('Canad\u00e1'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*de','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'Ceanada','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*de','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*de','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ab\u30ca\u30c0'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uce90\ub098\ub2e4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*de','mt':'*de','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*de','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u0430\u043d\u0430\u0434\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e41\u0e04\u0e19\u0e32\u0e14\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ca-na-\u0111a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u52a0\u62ff\u5927'),'zu':'*aa',},
  'CC': {'aa':'Cocos Islands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Kokos-Inseln','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u039a\u03cc\u03ba\u03bf\u03c2 (\u039a\u03ae\u03bb\u03b9\u03bd\u03b3\u03ba)'),'en':'*aa','eo':'*aa','es':'Islas Cocos','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00celes Cocos'),'fy':'*aa','ga':u('Oile\u00e1in Cocos (Keeling)'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kepulauan Cocos','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Isole Cocos','iu':'*aa','iw':'*aa','ja':u('\u30b3\u30b3\u30b9\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ucf54\ucf54\uc2a4 \uad70\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Cocos (Keeling) Islands','mt':'*ms','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Ilhas Cocos (Keeling)','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041a\u043e\u043a\u043e\u0441\u043e\u0432\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Cocos\u00f6arna'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u79d1\u5e93\u65af\u7fa4\u5c9b'),'zu':'*aa',},
  'CD': {'aa':'The Democratic Republic Of Congo','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Demokratische Republik Kongo','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03bf\u03bd\u03b3\u03ba\u03cc, \u039b\u03b1\u03ca\u03ba\u03ae \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1 \u03c4\u03bf\u03c5'),'en':'*aa','eo':'*aa','es':u('Rep\u00fablica Democr\u00e1tica del Congo'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('R\u00e9publique d\u00e9mocratique du Congo'),'fy':'*aa','ga':u('Poblacht Dhaonlathach an Chong\u00f3'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Republik Demokratik Kongo','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Repubblica democratica del Congo','iu':'*aa','iw':'*aa','ja':u('\u30b3\u30f3\u30b4\u6c11\u4e3b\u5171\u548c\u56fd'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ucf69\uace0 \ubbfc\uc8fc \uacf5\ud654\uad6d'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Democratic Republic of the Congo','mt':'*ms','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Congo, Rep\u00fablica Democr\u00e1tica do'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0414\u0435\u043c\u043e\u043a\u0440\u0430\u0442\u0441\u043a\u0430 \u0440\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u043e\u043d\u0433\u043e'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Demokratiska republiken Kongo','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u521a\u679c\u6c11\u4e3b\u5171\u548c\u56fd'),'zu':'*aa',},
  'CF': {'aa':'Central African Republic','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Rep\u00fablica Centrafricana'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Zentralafrikanische Republik','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03b5\u03bd\u03c4\u03c1\u03bf\u03b1\u03c6\u03c1\u03b9\u03ba\u03b1\u03bd\u03b9\u03ba\u03ae \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1'),'en':'*aa','eo':'*aa','es':u('Rep\u00fablica Centroafricana'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('R\u00e9publique Centre-Africaine'),'fy':'*aa','ga':u('Poblacht na hAfraice L\u00e1ir'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Republik Afrika Tengah','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Repubblica Centrafricana','iu':'*aa','iw':'*aa','ja':u('\u4e2d\u592e\u30a2\u30d5\u30ea\u30ab\u5171\u548c\u56fd'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc911\uc559 \uc544\ud504\ub9ac\uce74'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':u('Repubblika Afrikana \u010aentrali'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Republika \u015arodkowoafryka\u0144ska'),'ps':'*aa','pt':u('Rep\u00fablica Centro-Africana'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0410\u0444\u0440\u0438\u0447\u043a\u0430 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Centralafrikanska republiken','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e01\u0e25\u0e32\u0e07'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('C\u1ed9ng h\u00f2a Trung Phi'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e2d\u975e\u5171\u548c\u56fd'),'zu':'*aa',},
  'CG': {'aa':'Congo','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Kongo','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03bf\u03bd\u03b3\u03ba\u03cc'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Cong\u00f3'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*de','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*de','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b3\u30f3\u30b4'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ucf69\uace0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*de','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*de','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u043e\u043d\u0433\u043e'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e04\u0e2d\u0e07\u0e42\u0e01'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('C\u00f4ng-g\u00f4'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u521a\u679c'),'zu':'*aa',},
  'CH': {'aa':'Switzerland','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Schweiz','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0395\u03bb\u03b2\u03b5\u03c4\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Suiza','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Sveitsi','fj':'*aa','fo':'*aa','fr':'Suisse','fy':'*aa','ga':u('An Eilv\u00e9is'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Swiss','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Svizzera','iu':'*aa','iw':'*aa','ja':u('\u30b9\u30a4\u30b9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc2a4\uc704\uc2a4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*it','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Szwajcaria','ps':'*aa','pt':u('Su\u00ed\u00e7a'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0428\u0432\u0430\u0458\u0446\u0430\u0440\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2a\u0e27\u0e34\u0e2a\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Th\u1ee5y S\u0129'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u745e\u58eb'),'zu':'*aa',},
  'CI': {'aa':u('C\u00f4te d\'Ivoire'),'ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Costa d\'Ivori','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('Elfenbeink\u00fcste'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03ba\u03c4\u03ae \u0395\u03bb\u03b5\u03c6\u03b1\u03bd\u03c4\u03cc\u03b4\u03bf\u03bd\u03c4\u03bf\u03c2'),'en':'*aa','eo':'*aa','es':'Costa de Marfil','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An C\u00f3sta Eabhair'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Pantai Gading','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Costa d\'Avorio','iu':'*aa','iw':'*aa','ja':u('\u30b3\u30fc\u30c8\u30b8\u30dc\u30a2\u30fc\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ucf54\ud2b8\ub514\ubd80\uc640\ub974'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':u('Kosta ta\u2019 l-Avorju'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Wybrze\u017ce Ko\u015bci S\u0142oniowej'),'ps':'*aa','pt':'Costa do Marfim','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u043e\u0442-\u0434\'\u0418\u0432\u0443\u0430\u0440'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041e\u0431\u0430\u043b\u0430 \u0421\u043b\u043e\u043d\u043e\u0432\u0430\u0447\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Elfenbenskusten','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1d\u0e31\u0e48\u0e07\u0e17\u0e30\u0e40\u0e25\u0e44\u0e2d\u0e27\u0e2d\u0e23\u0e34'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('B\u1edd Bi\u1ec3n Ng\u00e0'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8c61\u7259\u6d77\u5cb8'),'zu':'*aa',},
  'CK': {'aa':'Cook Islands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Cook-Inseln','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u039a\u03bf\u03c5\u03ba'),'en':'*aa','eo':'*aa','es':'Islas Cook','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00celes Cook'),'fy':'*aa','ga':u('Oile\u00e1in Cook'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kepulauan Cook','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Isole Cook','iu':'*aa','iw':'*aa','ja':u('\u30af\u30c3\u30af\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ucfe1 \uc81c\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Ilhas Cook','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':u('Cook\u00f6arna'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5e93\u514b\u7fa4\u5c9b'),'zu':'*aa',},
  'CL': {'aa':'Chile','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Xile','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a7\u03b9\u03bb\u03ae'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Chili','fy':'*aa','ga':'An tSile','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*fr','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*fr','io':'*aa','is':'*aa','it':'Cile','iu':'*aa','iw':'*aa','ja':u('\u30c1\u30ea'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uce60\ub808'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*it','mt':u('\u010aili'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0427\u0438\u043b\u0438'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0427\u0438\u043b\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e0a\u0e34\u0e25\u0e35'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Chi-l\u00ea'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u667a\u5229'),'zu':'*aa',},
  'CM': {'aa':'Cameroon','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Camerun','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Kamerun','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03b1\u03bc\u03b5\u03c1\u03bf\u03cd\u03bd'),'en':'*aa','eo':'*aa','es':u('Camer\u00fan'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Cameroun','fy':'*aa','ga':u('Camar\u00fan'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*de','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*de','io':'*aa','is':'*aa','it':'*ca','iu':'*aa','iw':'*aa','ja':u('\u30ab\u30e1\u30eb\u30fc\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uce74\uba54\ub8ec'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*de','mt':'*de','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*de','ps':'*aa','pt':u('Rep\u00fablica dos Camar\u00f5es'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u0430\u043c\u0435\u0440\u0443\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e04\u0e32\u0e40\u0e21\u0e23\u0e39\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ca-m\u01a1-run'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5580\u9ea6\u9686'),'zu':'*aa',},
  'CN': {'aa':'China','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Xina','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03af\u03bd\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Kiina','fj':'*aa','fo':'*aa','fr':'Chine','fy':'*aa','ga':u('An tS\u00edn'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Cina','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*id','iu':'*aa','iw':'*aa','ja':u('\u4e2d\u83ef\u4eba\u6c11\u5171\u548c\u56fd'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc911\uad6d'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':u('\u010aina'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Chiny','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u0438\u0442\u0430\u0439'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041a\u0438\u043d\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Kina','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e08\u0e35\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Trung Qu\u1ed1c'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e2d\u56fd'),'zu':'*aa',},
  'CO': {'aa':'Colombia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Col\u00f2mbia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Kolumbien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03bf\u03bb\u03bf\u03bc\u03b2\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Colombie','fy':'*aa','ga':u('An Chol\u00f3im'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kolombia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b3\u30ed\u30f3\u30d3\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ucf5c\ub86c\ube44\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Kolumbja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Kolumbia','ps':'*aa','pt':u('Col\u00f4mbia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e04\u0e25\u0e31\u0e21\u0e40\u0e1a\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('C\u00f4-l\u00f4m-bi-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u54e5\u4f26\u6bd4\u4e9a'),'zu':'*aa',},
  'CR': {'aa':'Costa Rica','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03cc\u03c3\u03c4\u03b1 \u03a1\u03af\u03ba\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('C\u00f3sta R\u00edce'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kosta Rika','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b3\u30b9\u30bf\u30ea\u30ab'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ucf54\uc2a4\ud0c0\ub9ac\uce74'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':'*id','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Kostaryka','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041a\u043e\u0441\u0442\u0430\u0440\u0438\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e04\u0e2d\u0e2a\u0e15\u0e32\u0e23\u0e34\u0e01\u0e49\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('C\u1ed1t-xta Ri-ca'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u54e5\u65af\u8fbe\u9ece\u52a0'),'zu':'*aa',},
  'CS': {'aa':'Serbia and Montenegro','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Serbien und Montenegro','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03b5\u03c1\u03b2\u03af\u03b1 \u03ba\u03b1\u03b9 \u039c\u03b1\u03c5\u03c1\u03bf\u03b2\u03bf\u03cd\u03bd\u03b9\u03bf'),'en':'*aa','eo':'*aa','es':'Serbia y Montenegro','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Serbie et Mont\u00e9n\u00e9gro'),'fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Serbia e Montenegro','iu':'*aa','iw':'*aa','ja':u('\u30bb\u30eb\u30d3\u30a2\u30fb\u30e2\u30f3\u30c6\u30cd\u30b0\u30ed'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc138\ub974\ube44\uc544 \ubaac\ud14c\ub124\uadf8\ub85c(\uc720\uace0\uc2ac\ub77c\ube44\uc544)'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Serbja u Montenegro','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('S\u00e9rvia e Montenegro'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0440\u0431\u0438\u0458\u0430 \u0438 \u0426\u0440\u043d\u0430 \u0413\u043e\u0440\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Serbien och Montenegro','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u585e\u5c14\u7ef4\u4e9a\u53ca\u9ed1\u5c71'),'zu':'*aa',},
  'CU': {'aa':'Cuba','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Kuba','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03bf\u03cd\u03b2\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('C\u00faba'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*de','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*de','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ad\u30e5\u30fc\u30d0'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ucfe0\ubc14'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*de','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*de','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u0443\u0431\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e04\u0e34\u0e27\u0e1a\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Cu Ba','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u53e4\u5df4'),'zu':'*aa',},
  'CV': {'aa':'Cape Verde','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Cap Verd','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Kap Verde','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u03a0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c5 \u0391\u03ba\u03c1\u03c9\u03c4\u03b7\u03c1\u03af\u03bf\u03c5'),'en':'*aa','eo':'*aa','es':'Cabo Verde','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Cap Vert','fy':'*aa','ga':'Rinn Verde','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Tanjung Verde','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Capo Verde','iu':'*aa','iw':'*aa','ja':u('\u30ab\u30fc\u30dc\u30d9\u30eb\u30c7'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uae4c\ubf40\ubca0\ub974\ub370'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Kape Verde','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Republika Zielonego Przyl\u0105dka'),'ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0417\u0435\u043b\u0435\u043d\u044b\u0439 \u041c\u044b\u0441'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041a\u0430\u043f\u0435 \u0412\u0435\u0440\u0434\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e04\u0e1e\u0e40\u0e27\u0e2d\u0e23\u0e4c\u0e14'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('C\u00e1p-ve'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4f5b\u5f97\u89d2'),'zu':'*aa',},
  'CW': {'aa':u('Cura\u00e7ao'),'ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':'*aa','en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':'*aa','ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':'*aa','kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':'*aa','zu':'*aa',},
  'CX': {'aa':'Christmas Island','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Weihnachtsinsel','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03c2 \u03a7\u03c1\u03b9\u03c3\u03c4\u03bf\u03c5\u03b3\u03ad\u03bd\u03bd\u03c9\u03bd'),'en':'*aa','eo':'*aa','es':'Isla Christmas','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00cele Christmas'),'fy':'*aa','ga':u('Oile\u00e1n na Nollag'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Pulau Christmas','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Isola di Natale','iu':'*aa','iw':'*aa','ja':u('\u30af\u30ea\u30b9\u30de\u30b9\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud06c\ub9ac\uc2a4\ub9c8\uc2a4 \uc12c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Ilhas Natal','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u043e\u0436\u0438\u045b\u043d\u043e \u041e\u0441\u0442\u0440\u0432\u043e'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Jul\u00f6n'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5723\u8bde\u5c9b'),'zu':'*aa',},
  'CY': {'aa':'Cyprus','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Xipre','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Zypern','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03cd\u03c0\u03c1\u03bf\u03c2'),'en':'*aa','eo':'*aa','es':'Chipre','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Chypre','fy':'*aa','ga':'An Chipir','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Siprus','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Cipro','iu':'*aa','iw':'*aa','ja':u('\u30ad\u30d7\u30ed\u30b9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc0ac\uc774\ud504\ub7ec\uc2a4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Kibris','mt':u('\u010aipru'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Cypr','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u0438\u043f\u0440'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041a\u0438\u043f\u0430\u0440'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Cypern','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e44\u0e0b\u0e1b\u0e23\u0e31\u0e2a'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('S\u00edp'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u585e\u6d66\u8def\u65af'),'zu':'*aa',},
  'CZ': {'aa':'Czech Republic','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Rep\u00fablica Txeca'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':u('\u010cesk\u00e1 republika'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Tschechische Republik','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03c3\u03b5\u03c7\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Chequia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Tsekin tasavalta','fj':'*aa','fo':'*aa','fr':u('R\u00e9publique Tch\u00e8que'),'fy':'*aa','ga':'Poblacht na Seice','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Republik Ceko','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Repubblica Ceca','iu':'*aa','iw':'*aa','ja':u('\u30c1\u30a7\u30b3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uccb4\ucf54'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Republik Czech','mt':u('Repubblika \u010aeka'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Republika Czeska','ps':'*aa','pt':u('Rep\u00fablica Tcheca'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0427\u0435\u0445\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0427\u0435\u0448\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Tjeckiska republiken','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e40\u0e0a\u0e47\u0e04'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('C\u1ed9ng h\u00f2a S\u00e9c'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6377\u514b\u5171\u548c\u56fd'),'zu':'*aa',},
  'DE': {'aa':'Germany','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Alemanya','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Deutschland','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Alemania','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Saksa','fj':'*aa','fo':'*aa','fr':'Allemagne','fy':'*aa','ga':u('An Ghearm\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Jerman','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Germania','iu':'*aa','iw':'*aa','ja':u('\u30c9\u30a4\u30c4'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub3c5\uc77c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':u('\u0120ermanja'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Niemcy','ps':'*aa','pt':'Alemanha','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041d\u0435\u043c\u0430\u0447\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Tyskland','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e19\u0e35'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u0110\u1ee9c'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5fb7\u56fd'),'zu':'*aa',},
  'DJ': {'aa':'Djibouti','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Dschibuti','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03b6\u03b9\u03bc\u03c0\u03bf\u03c5\u03c4\u03af'),'en':'*aa','eo':'*aa','es':'Yibuti','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Jibouti','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Gibuti','iu':'*aa','iw':'*aa','ja':u('\u30b8\u30d6\u30c1'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc9c0\ubd80\ud2f0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':u('\u0120ibuti'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('D\u017cibuti'),'ps':'*aa','pt':'Djibuti','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0414\u0436\u0438\u0431\u0443\u0442\u0438'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u040f\u0438\u0431\u0443\u0442\u0438'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e14\u0e34\u0e42\u0e1a\u0e15\u0e34'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Gi-bu-ti','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5409\u5e03\u63d0'),'zu':'*aa',},
  'DK': {'aa':'Denmark','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Dinamarca','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'Danmark','de':u('D\u00e4nemark'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0394\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*ca','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Tanska','fj':'*aa','fo':'*aa','fr':'Danemark','fy':'*aa','ga':'An Danmhairg','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Danimarca','iu':'*aa','iw':'*aa','ja':u('\u30c7\u30f3\u30de\u30fc\u30af'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub374\ub9c8\ud06c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Danimarka','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Dania','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0414\u0430\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0414\u0430\u043d\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e14\u0e19\u0e21\u0e32\u0e23\u0e4c\u0e01'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u0110an M\u1ea1ch'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e39\u9ea6'),'zu':'*aa',},
  'DM': {'aa':'Dominica','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03c4\u03bf\u03bc\u03af\u03bd\u03b9\u03ba\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Dominique','fy':'*aa','ga':'Doiminice','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Dominika','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30c9\u30df\u30cb\u30ab\u56fd'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub3c4\ubbf8\ub2c8\uce74'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*id','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*id','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e14\u0e21\u0e34\u0e19\u0e34\u0e01\u0e49\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u591a\u7c73\u5c3c\u52a0\u8054\u90a6'),'zu':'*aa',},
  'DO': {'aa':'Dominican Republic','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Rep\u00fablica Dominicana'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Dominikanische Republik','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0394\u03bf\u03bc\u03b9\u03bd\u03b9\u03ba\u03b1\u03bd\u03ae \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*ca','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('R\u00e9publique Dominicaine'),'fy':'*aa','ga':'An Phoblacht Dhoiminiceach','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Republik Dominika','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Repubblica Dominicana','iu':'*aa','iw':'*aa','ja':u('\u30c9\u30df\u30cb\u30ab\u5171\u548c\u56fd'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub3c4\ubbf8\ub2c8\uce74 \uacf5\ud654\uad6d'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Republik Dominican','mt':'Republikka Domenikana','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Republika Dominikany','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Dominikanska republiken','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e42\u0e14\u0e21\u0e34\u0e19\u0e34\u0e01\u0e31\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u591a\u7c73\u5c3c\u52a0\u5171\u548c\u56fd'),'zu':'*aa',},
  'DZ': {'aa':'Algeria','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0627\u0644\u062c\u0632\u0627\u0626\u0631'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Alg\u00e8ria'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Algerien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03bb\u03b3\u03b5\u03c1\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Argelia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Alg\u00e9rie'),'fy':'*aa','ga':u('An Ailg\u00e9ir'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30eb\u30b8\u30a7\u30ea\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc54c\uc81c\ub9ac'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Aljazair','mt':u('Al\u0121erija'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Arg\u00e9lia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0410\u043b\u0436\u0438\u0440'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'Algeriet','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e41\u0e2d\u0e25\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('An-gi\u00ea-ri'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u963f\u5c14\u53ca\u5229\u4e9a'),'zu':'*aa',},
  'EC': {'aa':'Ecuador','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Equador','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0399\u03c3\u03b7\u03bc\u03b5\u03c1\u03b9\u03bd\u03cc\u03c2'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Equateur','fy':'*aa','ga':u('Eacuad\u00f3r'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Ekuador','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a8\u30af\u30a2\u30c9\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc5d0\ucfe0\uc544\ub3c4\ub974'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Ekwador','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*mt','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u042d\u043a\u0432\u0430\u0434\u043e\u0440'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0415\u043a\u0432\u0430\u0434\u043e\u0440'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e2d\u0e01\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u00ca-cu-a-\u0111o'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5384\u74dc\u591a\u5c14'),'zu':'*aa',},
  'EE': {'aa':'Estonia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Est\u00f2nia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Estland','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0395\u03c3\u03b8\u03bf\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'Eesti','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Estonie','fy':'*aa','ga':u('An East\u00f3in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a8\u30b9\u30c8\u30cb\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc5d0\uc2a4\ud1a0\ub2c8\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Estonja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Est\u00f4nia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u042d\u0441\u0442\u043e\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0415\u0441\u0442\u043e\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e2d\u0e2a\u0e42\u0e15\u0e40\u0e19\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('E-xt\u00f4-ni-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7231\u6c99\u5c3c\u4e9a'),'zu':'*aa',},
  'EG': {'aa':'Egypt','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0645\u0635\u0631'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Egipte','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('\u00c4gypten'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03af\u03b3\u03c5\u03c0\u03c4\u03bf\u03c2'),'en':'*aa','eo':'*aa','es':'Egipto','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Egypte','fy':'*aa','ga':u('An \u00c9igipt'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Mesir','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Egitto','iu':'*aa','iw':'*aa','ja':u('\u30a8\u30b8\u30d7\u30c8'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc774\uc9d1\ud2b8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':u('E\u0121ittu'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Egipt','ps':'*aa','pt':'Egito','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0415\u0433\u0438\u043f\u0442'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0415\u0433\u0438\u043f\u0430\u0442'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Egypten','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ai C\u1eadp'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u57c3\u53ca'),'zu':'*aa',},
  'EH': {'aa':'Western Sahara','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('S\u00e0hara Occidental'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Westsahara','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0394\u03c5\u03c4\u03b9\u03ba\u03ae \u03a3\u03b1\u03c7\u03ac\u03c1\u03b1'),'en':'*aa','eo':'*aa','es':'Sahara Occidental','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*es','fy':'*aa','ga':u('An Sah\u00e1ra Thiar'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Sahara Barat','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Sahara Occidentale','iu':'*aa','iw':'*aa','ja':u('\u897f\u30b5\u30cf\u30e9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc11c\uc0ac\ud558\ub77c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':'Sahara tal-Punent','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Sahara Zachodnia','ps':'*aa','pt':'Saara Ocidental','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0417\u0430\u043f\u0430\u0434\u043d\u0430\u044f \u0421\u0430\u0445\u0430\u0440\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0421\u0430\u0445\u0430\u0440\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('V\u00e4stra Sahara'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e0b\u0e32\u0e2e\u0e32\u0e23\u0e48\u0e32\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('T\u00e2y Sahara'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u897f\u6492\u54c8\u62c9'),'zu':'*aa',},
  'ER': {'aa':'Eritrea','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0395\u03c1\u03c5\u03b8\u03c1\u03b1\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Erythr\u00e9e'),'fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a8\u30ea\u30c8\u30ea\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc5d0\ub9ac\ud2b8\ub9ac\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Eritreja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Erytrea','ps':'*aa','pt':u('Eritr\u00e9ia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u042d\u0440\u0438\u0442\u0440\u0435\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0415\u0440\u0438\u0442\u0440\u0435\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e34\u0e23\u0e34\u0e17\u0e23\u0e35'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u00ca-ri-t\u01a1-r\u00ea-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5384\u91cc\u7279\u5c3c\u4e9a'),'zu':'*aa',},
  'ES': {'aa':'Spain','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Espanya','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Spanien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0399\u03c3\u03c0\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':u('Espa\u00f1a'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Espanja','fj':'*aa','fo':'*aa','fr':'Espagne','fy':'*aa','ga':u('An Sp\u00e1inn'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Spanyol','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Spagna','iu':'*aa','iw':'*aa','ja':u('\u30b9\u30da\u30a4\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc2a4\ud398\uc778'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Sepanyol','mt':'Spanja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Hiszpania','ps':'*aa','pt':'Espanha','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0418\u0441\u043f\u0430\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0428\u043f\u0430\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2a\u0e40\u0e1b\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('T\u00e2y Ban Nha'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u897f\u73ed\u7259'),'zu':'*aa',},
  'ET': {'aa':'Ethiopia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Eti\u00f2pia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('\u00c4thiopien'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03b9\u03b8\u03b9\u03bf\u03c0\u03af\u03b1'),'en':'*aa','eo':'*aa','es':u('Etiop\u00eda'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Ethiopie','fy':'*aa','ga':u('An Aet\u00f3ip'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Etiopia','iu':'*aa','iw':'*aa','ja':u('\u30a8\u30c1\u30aa\u30d4\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc774\ub514\uc624\ud53c\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Etijopja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*it','ps':'*aa','pt':u('Eti\u00f3pia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u042d\u0444\u0438\u043e\u043f\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0415\u0442\u0438\u043e\u043f\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Etiopien','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e40\u0e1b\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u00ca-ti-\u00f4-pi-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u57c3\u585e\u4fc4\u6bd4\u4e9a'),'zu':'*aa',},
  'FI': {'aa':'Finland','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Finl\u00e0ndia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Finnland','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a6\u03b9\u03bd\u03bb\u03b1\u03bd\u03b4\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Finlandia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Suomi','fj':'*aa','fo':'*aa','fr':'Finlande','fy':'*aa','ga':'An Fhionlainn','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*es','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*es','io':'*aa','is':'*aa','it':'*es','iu':'*aa','iw':'*aa','ja':u('\u30d5\u30a3\u30f3\u30e9\u30f3\u30c9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud540\ub780\ub4dc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Finlandja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*es','ps':'*aa','pt':u('Finl\u00e2ndia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0424\u0438\u043d\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1f\u0e34\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ph\u1ea7n Lan'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u82ac\u5170'),'zu':'*aa',},
  'FJ': {'aa':'Fiji','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Fidschi','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a6\u03af\u03c4\u03b6\u03b9'),'en':'*aa','eo':'*aa','es':'Fiyi','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Fidji','fy':'*aa','ga':u('Fids\u00ed'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Figi','iu':'*aa','iw':'*aa','ja':u('\u30d5\u30a3\u30b8\u30fc'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud53c\uc9c0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Fi\u0121i'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Fid\u017ci'),'ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0424\u0438\u0434\u0436\u0438'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0424\u0438\u045f\u0438'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1f\u0e34\u0e08\u0e34'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Phi-gi','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6590\u6d4e'),'zu':'*aa',},
  'FK': {'aa':'Falkland Islands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Falkland-Inseln','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u03a6\u03ce\u03ba\u03bb\u03b1\u03bd\u03c4'),'en':'*aa','eo':'*aa','es':'Islas Malvinas','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00celes Malouines'),'fy':'*aa','ga':u('Oile\u00e1in Fh\u00e1clainne'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kepulauan Falkland','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Isole Falkland','iu':'*aa','iw':'*aa','ja':u('\u30d5\u30a9\u30fc\u30af\u30e9\u30f3\u30c9\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud3ec\ud074\ub79c\ub4dc \uc81c\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Ilhas Malvinas','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0424\u043e\u043b\u043a\u043b\u0430\u043d\u0434\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Falklands\u00f6arna'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5bcc\u514b\u5170\u7fa4\u5c9b'),'zu':'*aa',},
  'FM': {'aa':'Micronesia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Micron\u00e8sia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Mikronesien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03b9\u03ba\u03c1\u03bf\u03bd\u03b7\u03c3\u03af\u03b1, \u039f\u03bc\u03cc\u03c3\u03c0\u03bf\u03bd\u03b4\u03b5\u03c2 \u03a0\u03bf\u03bb\u03b9\u03c4\u03b5\u03af\u03b5\u03c2 \u03c4\u03b7\u03c2'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Micron\u00e9sie'),'fy':'*aa','ga':u('An Mhicrin\u00e9is'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Mikronesia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30df\u30af\u30ed\u30cd\u30b7\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub9c8\uc774\ud06c\ub85c\ub124\uc2dc\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Mikronesja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Mikronezja','ps':'*aa','pt':u('Micron\u00e9sia, Estados Federados da'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e44\u0e21\u0e42\u0e04\u0e23\u0e19\u0e34\u0e40\u0e0b\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Mi-cr\u00f4-n\u00ea-xi-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a'),'zu':'*aa',},
  'FO': {'aa':'Faroe Islands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('F\u00e4r\u00f6er-Inseln'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u03a6\u03b5\u03c1\u03cc\u03b5\u03c2'),'en':'*aa','eo':'*aa','es':'Islas Feroe','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00celes F\u00e9ro\u00e9'),'fy':'*aa','ga':u('Oile\u00e1in Fhar\u00f3'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kepulauan Faroe','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':u('Isole F\u00e6roer'),'iu':'*aa','iw':'*aa','ja':u('\u30d5\u30a7\u30ed\u30fc\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud398\ub85c \uc81c\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('G\u017cejjer Faroe'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Ilhas Faroe','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0424\u0430\u0440\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('F\u00e4r\u00f6arna'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6cd5\u7f57\u7fa4\u5c9b'),'zu':'*aa',},
  'FR': {'aa':'France','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Fran\u00e7a'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Frankreich','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03b1\u03bb\u03bb\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Francia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Ranska','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'An Fhrainc','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Perancis','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*es','iu':'*aa','iw':'*aa','ja':u('\u30d5\u30e9\u30f3\u30b9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud504\ub791\uc2a4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':'Franza','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Francja','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0424\u0440\u0430\u043d\u0446\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Frankrike','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ph\u00e1p'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6cd5\u56fd'),'zu':'*aa',},
  'GA': {'aa':'Gabon','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Gabun','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03ba\u03b1\u03bc\u03c0\u03cc\u03bd'),'en':'*aa','eo':'*aa','es':u('Gab\u00f3n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Ghab\u00fain'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ac\u30dc\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uac00\ubd09'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Gab\u00e3o'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0413\u0430\u0431\u043e\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e01\u0e32\u0e1a\u0e2d\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ga-b\u00f4ng'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u52a0\u84ec'),'zu':'*aa',},
  'GB': {'aa':'United Kingdom','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Regne Unit','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('Vereinigtes K\u00f6nigreich'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0397\u03bd\u03c9\u03bc\u03ad\u03bd\u03bf \u0392\u03b1\u03c3\u03af\u03bb\u03b5\u03b9\u03bf'),'en':'*aa','eo':'*aa','es':'Reino Unido','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Iso-Britannia','fj':'*aa','fo':'*aa','fr':'Royaume-Uni','fy':'*aa','ga':u('An R\u00edocht Aontaithe'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Inggris Raya','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Regno Unito','iu':'*aa','iw':'*aa','ja':u('\u30a4\u30ae\u30ea\u30b9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc601\uad6d'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Ingilterra','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Wielka Brytania','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u043d\u043e\u0435 \u041a\u043e\u0440\u043e\u043b\u0435\u0432\u0441\u0442\u0432\u043e'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0412\u0435\u043b\u0438\u043a\u0430 \u0411\u0440\u0438\u0442\u0430\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Storbritannien','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2a\u0e2b\u0e23\u0e32\u0e0a\u0e2d\u0e32\u0e13\u0e32\u0e08\u0e31\u0e01\u0e23'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('V\u01b0\u01a1ng qu\u1ed1c Anh'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u82f1\u56fd'),'zu':'*aa',},
  'GD': {'aa':'Grenada','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03c1\u03b5\u03bd\u03ac\u03b4\u03b1'),'en':'*aa','eo':'*aa','es':'Granada','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Grenade','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b0\u30ec\u30ca\u30c0'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uadf8\ub808\ub098\ub2e4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0413\u0440\u0435\u043d\u0430\u0434\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Gr\u00ea-na-\u0111a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u683c\u6797\u7eb3\u8fbe'),'zu':'*aa',},
  'GE': {'aa':'Georgia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Ge\u00f2rgia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Georgien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03b5\u03c9\u03c1\u03b3\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('G\u00e9orgie'),'fy':'*aa','ga':'An tSeoirsia','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b0\u30eb\u30b8\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uadf8\ub8e8\uc9c0\uc57c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('\u0120or\u0121ja'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Gruzja','ps':'*aa','pt':u('Ge\u00f3rgia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0413\u0440\u0443\u0437\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0413\u0440\u0443\u0437\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Gru-di-a','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u683c\u9c81\u5409\u4e9a'),'zu':'*aa',},
  'GF': {'aa':'French Guiana','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Guaiana Francesa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('Franz\u00f6sisch-Guayana'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ae \u0393\u03bf\u03c5\u03b9\u03ac\u03bd\u03b1'),'en':'*aa','eo':'*aa','es':'Guayana Francesa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Guyane fran\u00e7aise'),'fy':'*aa','ga':u('An Ghu\u00e1in Fhrancach'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Guyana Perancis','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Guayana Francese','iu':'*aa','iw':'*aa','ja':u('\u4ecf\u9818\u30ae\u30a2\u30ca'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud504\ub791\uc2a4\ub839 \uae30\uc544\ub098'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Gujana Fran\u010bi\u017ca'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Gujana Francuska','ps':'*aa','pt':'Guiana Francesa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u0413\u0432\u0438\u043d\u0435\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430 \u0413\u0432\u0430\u0458\u0430\u043d\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Franska Guyana','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e1f\u0e23\u0e47\u0e19\u0e0a\u0e01\u0e34\u0e27\u0e19\u0e48\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6cd5\u5c5e\u572d\u4e9a\u90a3'),'zu':'*aa',},
  'GG': {'aa':'Guernsey','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':'*aa','en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':'*aa','ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':'*aa','kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':'*aa','zu':'*aa',},
  'GH': {'aa':'Ghana','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03ba\u03ac\u03bd\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('G\u00e1na'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ac\u30fc\u30ca'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uac00\ub098'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Gana','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*mt','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0413\u0430\u043d\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e01\u0e32\u0e19\u0e48\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Gha-na','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u52a0\u7eb3'),'zu':'*aa',},
  'GI': {'aa':'Gibraltar','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03b9\u03b2\u03c1\u03b1\u03bb\u03c4\u03ac\u03c1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Giobr\u00e1ltar'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Gibilterra','iu':'*aa','iw':'*aa','ja':u('\u30b8\u30d6\u30e9\u30eb\u30bf\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc9c0\ube0c\ub864\ud130'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u76f4\u5e03\u7f57\u9640'),'zu':'*aa',},
  'GL': {'aa':'Greenland','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('Gr\u00f6nland'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03c1\u03bf\u03b9\u03bb\u03b1\u03bd\u03b4\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Groenlandia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Groenland','fy':'*aa','ga':'An Ghraonlainn','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*es','iu':'*aa','iw':'*aa','ja':u('\u30b0\u30ea\u30fc\u30f3\u30e9\u30f3\u30c9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uadf8\ub9b0\ub79c\ub4dc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Grinlandja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Gro\u00eanlandia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u683c\u9675\u5170'),'zu':'*aa',},
  'GM': {'aa':'Gambia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('G\u00e0mbia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03ba\u03ac\u03bc\u03c0\u03b9\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Gambie','fy':'*aa','ga':'An Ghaimbia','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ac\u30f3\u30d3\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uac10\ube44\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Gambja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('G\u00e2mbia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0413\u0430\u043c\u0431\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0413\u0430\u043c\u0431\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e41\u0e01\u0e21\u0e40\u0e1a\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('G\u0103m-bi-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5188\u6bd4\u4e9a'),'zu':'*aa',},
  'GN': {'aa':'Guinea','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Guin\u00e9e'),'fy':'*aa','ga':'An Ghuine','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ae\u30cb\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uae30\ub2c8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Gineja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Gwinea','ps':'*aa','pt':u('Guin\u00e9'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0413\u0432\u0438\u043d\u0435\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0413\u0432\u0438\u043d\u0435\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e01\u0e34\u0e27\u0e19\u0e35'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ghi-n\u00ea'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u51e0\u5185\u4e9a'),'zu':'*aa',},
  'GP': {'aa':'Guadeloupe','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03bf\u03c5\u03b1\u03b4\u03b5\u03bb\u03bf\u03cd\u03c0\u03b7'),'en':'*aa','eo':'*aa','es':'Guadalupe','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Guadal\u00faip'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Guadalupa','iu':'*aa','iw':'*aa','ja':u('\u30b0\u30a2\u30c9\u30eb\u30fc\u30d7'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uacfc\ub2ec\ub85c\ud504'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Gwadelupe','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Gwadelupa','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e01\u0e31\u0e27\u0e40\u0e14\u0e2d\u0e25\u0e39\u0e1b'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u74dc\u5fb7\u7f57\u666e\u5c9b'),'zu':'*aa',},
  'GQ': {'aa':'Equatorial Guinea','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Guinea Equatorial','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('\u00c4quatorial-Guinea'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0399\u03c3\u03b7\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1'),'en':'*aa','eo':'*aa','es':'Guinea Ecuatorial','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Guin\u00e9e Equatoriale'),'fy':'*aa','ga':u('An Ghuine Mhe\u00e1nchriosach'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Guinea Khatulistiwa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Guinea Equatoriale','iu':'*aa','iw':'*aa','ja':u('\u8d64\u9053\u30ae\u30cb\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc801\ub3c4 \uae30\ub2c8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Ginea Ekwatorjali','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Gwinea R\u00f3wnikowa'),'ps':'*aa','pt':u('Guin\u00e9 Equatorial'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b\u044c\u043d\u0430\u044f \u0413\u0432\u0438\u043d\u0435\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0415\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0458\u0430\u043b\u043d\u0430 \u0413\u0432\u0438\u043d\u0435\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Ekvatorialguinea','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e2d\u0e04\u0e27\u0e32\u0e42\u0e17\u0e40\u0e23\u0e35\u0e22\u0e25\u0e01\u0e34\u0e19\u0e35'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ghi-n\u00ea X\u00edch-\u0111\u1ea1o'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8d64\u9053\u51e0\u5185\u4e9a'),'zu':'*aa',},
  'GR': {'aa':'Greece','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Gr\u00e8cia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Griechenland','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0395\u03bb\u03bb\u03ac\u03b4\u03b1'),'en':'*aa','eo':'*aa','es':'Grecia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Kreikka','fj':'*aa','fo':'*aa','fr':u('Gr\u00e8ce'),'fy':'*aa','ga':u('An Ghr\u00e9ig'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Yunani','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*es','iu':'*aa','iw':'*aa','ja':u('\u30ae\u30ea\u30b7\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uadf8\ub9ac\uc2a4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':u('Gre\u010bja'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Grecja','ps':'*aa','pt':u('Gr\u00e9cia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0413\u0440\u0435\u0446\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0413\u0440\u0447\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Grekland','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e01\u0e23\u0e35\u0e0b'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Hy L\u1ea1p'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5e0c\u814a'),'zu':'*aa',},
  'GS': {'aa':'South Georgia And The South Sandwich Islands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('S\u00fcd-Georgia und die s\u00fcdlichen Sandwich-Inseln'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03cc\u03c4\u03b9\u03b1 \u0393\u03b5\u03c9\u03c1\u03b3\u03af\u03b1 \u03ba\u03b1\u03b9 \u039d\u03ae\u03c3\u03bf\u03b9 \u039d\u03cc\u03c4\u03b9\u03b5\u03c2 \u03a3\u03ac\u03bd\u03c4\u03bf\u03c5\u03b9\u03c4\u03c2'),'en':'*aa','eo':'*aa','es':'Islas Georgia del Sur y Sandwich del Sur','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('G\u00e9orgie du Sud et \u00eeles Sandwich du Sud'),'fy':'*aa','ga':u('An tSeoirsia Theas agus Oile\u00e1in Sandwich Theas'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Georgia Selatan dan Kepulauan Sandwich Selatan','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Georgia del sud e isole Sandwich meridionali','iu':'*aa','iw':'*aa','ja':u('\u30b5\u30a6\u30b9\u30b8\u30e7\u30fc\u30b8\u30a2\u5cf6\u30fb\u30b5\u30a6\u30b9\u30b5\u30f3\u30c9\u30a6\u30a3\u30c3\u30c1\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc0ac\uc6b0\uc2a4 \uc870\uc9c0\uc544 \ubc0f \uc0ac\uc6b0\uc2a4 \uc0cc\ub4dc\uc704\uce58 \uc81c\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'South Georgia and the South Sandwich Islands','mt':'*ms','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Ge\u00f3rgia do Sul e Ilhas Sandwich do Sul'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0408\u0443\u0436\u043d\u0430 \u040f\u043e\u0440\u045f\u0438\u0458\u0430 \u0438 \u0408\u0443\u0436\u043d\u0430 \u0421\u0435\u043d\u0434\u0432\u0438\u0447 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Sydgeorgien och Sydsandwich\u00f6arna'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5357\u4e54\u6cbb\u4e9a\u5c9b\u548c\u5357\u6851\u5fb7\u97e6\u5947\u5c9b'),'zu':'*aa',},
  'GT': {'aa':'Guatemala','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03bf\u03c5\u03b1\u03c4\u03b5\u03bc\u03ac\u03bb\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'Guatamala','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b0\u30a2\u30c6\u30de\u30e9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uacfc\ud14c\ub9d0\ub77c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Gwatemala','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*mt','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e01\u0e31\u0e27\u0e40\u0e15\u0e21\u0e32\u0e25\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Goa-t\u00ea-ma-la'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5371\u5730\u9a6c\u62c9'),'zu':'*aa',},
  'GU': {'aa':'Guam','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03ba\u03bf\u03c5\u03ac\u03bc'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b0\u30a2\u30e0'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uad0c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Gwam','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0413\u0443\u0430\u043c'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5173\u5c9b'),'zu':'*aa',},
  'GW': {'aa':'Guinea-Bissau','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Guinea Bissau','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1-\u039c\u03c0\u03b9\u03c3\u03ac\u03bf\u03c5'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Guin\u00e9e-Bissau'),'fy':'*aa','ga':'An Ghuine-Bhissau','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*ca','iu':'*aa','iw':'*aa','ja':u('\u30ae\u30cb\u30a2\u30d3\u30b5\u30a6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uae30\ub124\ube44\uc3d8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*ca','mt':'Ginea-Bissaw','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Gwinea Bissau','ps':'*aa','pt':u('Guin\u00e9 Bissau'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0413\u0432\u0438\u043d\u0435\u044f-\u0411\u0438\u0441\u0430\u0443'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0413\u0432\u0438\u043d\u0435\u0458\u0430-\u0411\u0438\u0441\u0430\u043e'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e01\u0e34\u0e27\u0e19\u0e35-\u0e1a\u0e34\u0e2a\u0e42\u0e0b'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ghi-n\u00ea B\u00edt-xao'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u51e0\u5185\u4e9a\u6bd4\u7ecd\u5171\u548c\u56fd'),'zu':'*aa',},
  'GY': {'aa':'Guyana','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03bf\u03c5\u03b9\u03ac\u03bd\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Ghu\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ac\u30a4\u30a2\u30ca'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uac00\uc774\uc544\ub098'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Gujana','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*mt','ps':'*aa','pt':'Guiana','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0413\u0430\u0439\u0430\u043d\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0413\u0432\u0430\u0458\u0430\u043d\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e01\u0e39\u0e22\u0e32\u0e19\u0e48\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Guy-a-na','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u572d\u4e9a\u90a3'),'zu':'*aa',},
  'HK': {'aa':'Hong Kong','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Hongkong','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a7\u03bf\u03bd\u03b3\u03ba \u039a\u03bf\u03bd\u03b3\u03ba, \u0395\u03b9\u03b4\u03b9\u03ba\u03ae \u0394\u03b9\u03bf\u03b9\u03ba\u03b7\u03c4\u03b9\u03ba\u03ae \u03a0\u03b5\u03c1\u03b9\u03c6\u03ad\u03c1\u03b5\u03b9\u03b1 \u03c4\u03b7\u03c2 \u039a\u03af\u03bd\u03b1\u03c2'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Hong-Kong','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Hong Kong S.A.R., Cina','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u9999\u6e2f'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud64d\ucf69'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Hong Kong S.A.R., China','mt':u('\u0126ong Kong S.A.R., \u010aina'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Hong Kong, Regi\u00e3o Admin. Especial da China'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0413\u043e\u043d\u043a\u043e\u043d\u0433'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0425\u043e\u043d\u0433 \u041a\u043e\u043d\u0433 (\u0421. \u0410. \u0420. \u041a\u0438\u043d\u0430)'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2e\u0e48\u0e2d\u0e07\u0e01\u0e07'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':'*ja','zu':'*aa',},
  'HM': {'aa':'Heard Island And McDonald Islands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Heard- und McDonald-Inseln','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u03a7\u03b5\u03c1\u03bd\u03c4 \u03ba\u03b1\u03b9 \u039c\u03b1\u03ba\u03bd\u03c4\u03cc\u03bd\u03b1\u03bb\u03bd\u03c4'),'en':'*aa','eo':'*aa','es':'Islas Heard y McDonald','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00cele Heard et \u00eeles McDonald'),'fy':'*aa','ga':u('Oile\u00e1n Heard agus Oile\u00e1in McDonald'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Pulau Heard dan Kepulauan McDonald','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Isole Heard e McDonald','iu':'*aa','iw':'*aa','ja':u('\u30cf\u30fc\u30c9\u30fb\u30de\u30af\u30c9\u30ca\u30eb\u30c9\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud5c8\ub4dc \uc12c \ubc0f \ub9e5\ub3c4\ub110\ub4dc \uc81c\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Heard Island and McDonald Islands','mt':'*ms','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Ilha Heard e Ilhas McDonald','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0425\u0435\u0440\u0434 \u0438 \u041c\u0435\u043a\u0434\u043e\u043d\u0430\u043b\u0434 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Heard\u00f6ch McDonald\u00f6arna'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8d6b\u5fb7\u548c\u9ea6\u514b\u5510\u7eb3\u7fa4\u5c9b'),'zu':'*aa',},
  'HN': {'aa':'Honduras','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Hondures','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039f\u03bd\u03b4\u03bf\u03cd\u03c1\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Hond\u00faras'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30db\u30f3\u30b8\u30e5\u30e9\u30b9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc628\ub450\ub77c\uc2a4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('\u0126onduras'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0425\u043e\u043d\u0434\u0443\u0440\u0430\u0441'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2e\u0e2d\u0e19\u0e14\u0e39\u0e23\u0e31\u0e2a'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('H\u00f4n-\u0111u-r\u00e1t'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6d2a\u90fd\u62c9\u65af'),'zu':'*aa',},
  'HR': {'aa':'Croatia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Cro\u00e0cia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Kroatien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03c1\u03bf\u03b1\u03c4\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Croacia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Croatie','fy':'*aa','ga':u('An Chr\u00f3it'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'Hrvatska','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kroasia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Croazia','iu':'*aa','iw':'*aa','ja':u('\u30af\u30ed\u30a2\u30c1\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud06c\ub85c\uc544\ud2f0\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Kroazja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Chorwacja','ps':'*aa','pt':u('Cro\u00e1cia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0425\u043e\u0440\u0432\u0430\u0442\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0425\u0440\u0432\u0430\u0442\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e04\u0e23\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Cr\u00f4-a-ti-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u514b\u7f57\u5730\u4e9a'),'zu':'*aa',},
  'HT': {'aa':'Haiti','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Hait\u00ed'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03ca\u03c4\u03ae'),'en':'*aa','eo':'*aa','es':'*ca','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Ha\u00efti'),'fy':'*aa','ga':u('H\u00e1it\u00ed'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30cf\u30a4\u30c1'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud558\uc774\ud2f0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('\u0126aiti'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0413\u0430\u0438\u0442\u0438'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0425\u0430\u0438\u0442\u0438'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e44\u0e2e\u0e15\u0e35'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Ha-i-ti','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6d77\u5730'),'zu':'*aa',},
  'HU': {'aa':'Hungary','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Hongria','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Ungarn','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039f\u03c5\u03b3\u03b3\u03b1\u03c1\u03af\u03b1'),'en':'*aa','eo':'*aa','es':u('Hungr\u00eda'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Hongrie','fy':'*aa','ga':u('An Ung\u00e1ir'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':u('Magyarorsz\u00e1g'),'hy':'*aa','hz':'*aa','ia':'*aa','id':'Hungaria','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Ungheria','iu':'*aa','iw':'*aa','ja':u('\u30cf\u30f3\u30ac\u30ea\u30fc'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud5dd\uac00\ub9ac'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Hungari','mt':'Ungerija','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('W\u0119gry'),'ps':'*aa','pt':'Hungria','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0412\u0435\u043d\u0433\u0440\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0430\u0452\u0430\u0440\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Ungern','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2e\u0e31\u0e07\u0e01\u0e32\u0e23\u0e35'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Hung-ga-ri','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5308\u7259\u5229'),'zu':'*aa',},
  'ID': {'aa':'Indonesia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Indon\u00e8sia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Indonesien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Indon\u00e9sie'),'fy':'*aa','ga':u('An Indin\u00e9is'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a4\u30f3\u30c9\u30cd\u30b7\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc778\ub3c4\ub124\uc2dc\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Indone\u017cja'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Indonezja','ps':'*aa','pt':u('Indon\u00e9sia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e34\u0e19\u0e42\u0e14\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Nam D\u01b0\u01a1ng'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5370\u5ea6\u5c3c\u897f\u4e9a'),'zu':'*aa',},
  'IE': {'aa':'Ireland','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Irlanda','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Irland','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0399\u03c1\u03bb\u03b1\u03bd\u03b4\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*ca','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Irlanti','fj':'*aa','fo':'*aa','fr':'Irlande','fy':'*aa','ga':u('\u00c9ire'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Irlandia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*ca','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30a4\u30eb\u30e9\u30f3\u30c9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc544\uc77c\ub79c\ub4dc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*ca','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*id','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0418\u0440\u043b\u0430\u043d\u0434\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0418\u0440\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e44\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Ai-len','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7231\u5c14\u5170'),'zu':'*aa',},
  'IL': {'aa':'Israel','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0399\u03c3\u03c1\u03b1\u03ae\u03bb'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Isra\u00ebl'),'fy':'*aa','ga':'Iosrael','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':u('\u05d9\u05e9\u05e8\u05d0\u05dc'),'hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Israele','iu':'*aa','iw':'*he','ja':u('\u30a4\u30b9\u30e9\u30a8\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc774\uc2a4\ub77c\uc5d8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('I\u017crael'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Izrael','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0418\u0437\u0440\u0430\u0438\u043b\u044c'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0418\u0437\u0440\u0430\u0435\u043b'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e34\u0e2a\u0e23\u0e32\u0e40\u0e2d\u0e25'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'I-xra-en','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4ee5\u8272\u5217'),'zu':'*aa',},
  'IM': {'aa':'Isle Of Man','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':'*aa','en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':'*aa','ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':'*aa','kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':'*aa','zu':'*aa',},
  'IN': {'aa':'India','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('\u00cdndia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Indien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0399\u03bd\u03b4\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Inde','fy':'*aa','ga':'An India','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':u('\u092d\u093e\u0930\u0924'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a4\u30f3\u30c9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc778\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Hindia','mt':'Indja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Indie','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0418\u043d\u0434\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0418\u043d\u0434\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e34\u0e19\u0e40\u0e14\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u1ea4n \u0110\u1ed9'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5370\u5ea6'),'zu':'*aa',},
  'IO': {'aa':'British Indian Ocean Territory','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Britische Territorien im Indischen Ozean','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0392\u03c1\u03b5\u03c4\u03b1\u03bd\u03b9\u03ba\u03ac \u0388\u03b4\u03ac\u03c6\u03b7 \u0399\u03bd\u03b4\u03b9\u03ba\u03bf\u03cd \u03a9\u03ba\u03b5\u03b1\u03bd\u03bf\u03cd'),'en':'*aa','eo':'*aa','es':u('Territorio Brit\u00e1nico del Oc\u00e9ano \u00cdndico'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Territoires britanniques de l\'Oc\u00e9an Indien'),'fy':'*aa','ga':u('Cr\u00edocha Briotanacha an Aig\u00e9in Indiagh'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Territorio britannico dell\'Oceano Indiano','iu':'*aa','iw':'*aa','ja':u('\u82f1\u9818\u30a4\u30f3\u30c9\u6d0b\u5730\u57df'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc601\uc778\ub3c4 \uc81c\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Territ\u00f3rio Brit\u00e2nico do Oceano \u00cdndico'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'Brittiska territoriet i Indiska Oceanen','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u82f1\u5c5e\u5370\u5ea6\u6d0b\u9886\u5730'),'zu':'*aa',},
  'IQ': {'aa':'Iraq','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0627\u0644\u0639\u0631\u0627\u0642'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Irak','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0399\u03c1\u03ac\u03ba'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*de','fy':'*aa','ga':u('An Iar\u00e1ic'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a4\u30e9\u30af'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc774\ub77c\ud06c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*de','ps':'*aa','pt':'Iraque','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0418\u0440\u0430\u043a'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e34\u0e23\u0e31\u0e01'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('I-r\u1eafc'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4f0a\u62c9\u514b'),'zu':'*aa',},
  'IR': {'aa':'Iran','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0399\u03c1\u03ac\u03bd, \u0399\u03c3\u03bb\u03b1\u03bc\u03b9\u03ba\u03ae \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1 \u03c4\u03bf\u03c5'),'en':'*aa','eo':'*aa','es':u('Ir\u00e1n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Iar\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a4\u30e9\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc774\ub780'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Ir\u00e3'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0418\u0440\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e34\u0e2b\u0e23\u0e48\u0e32\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'I-ran','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4f0a\u6717'),'zu':'*aa',},
  'IS': {'aa':'Iceland','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Isl\u00e0ndia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Island','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0399\u03c3\u03bb\u03b1\u03bd\u03b4\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Islandia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Islande','fy':'*aa','ga':u('An \u00cdoslainn'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*es','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*es','io':'*aa','is':u('\u00cdsland'),'it':'Islanda','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30a4\u30b9\u30e9\u30f3\u30c9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc544\uc774\uc2ac\ub780\ub4dc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*it','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*es','ps':'*aa','pt':u('Isl\u00e2ndia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0418\u0441\u043b\u0430\u043d\u0434\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0418\u0441\u043b\u0430\u043d\u0434'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e44\u0e2d\u0e0b\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ai-x\u01a1-len'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u51b0\u5c9b'),'zu':'*aa',},
  'IT': {'aa':'Italy','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('It\u00e0lia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Italien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0399\u03c4\u03b1\u03bb\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Italia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*es','fj':'*aa','fo':'*aa','fr':'Italie','fy':'*aa','ga':u('An Iod\u00e1il'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Itali','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*es','iu':'*aa','iw':'*aa','ja':u('\u30a4\u30bf\u30ea\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc774\ud0c8\ub9ac\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':'Italja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('W\u0142ochy'),'ps':'*aa','pt':u('It\u00e1lia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0418\u0442\u0430\u043b\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0418\u0442\u0430\u043b\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e34\u0e15\u0e32\u0e25\u0e35'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u00dd'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u610f\u5927\u5229'),'zu':'*aa',},
  'JE': {'aa':'Jersey','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':'*aa','en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':'*aa','ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':'*aa','kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':'*aa','zu':'*aa',},
  'JM': {'aa':'Jamaica','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Jamaika','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03b6\u03b1\u03bc\u03ac\u03b9\u03ba\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Jama\u00efque'),'fy':'*aa','ga':u('Iam\u00e1ice'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*de','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*de','io':'*aa','is':'*aa','it':'Giamaica','iu':'*aa','iw':'*aa','ja':u('\u30b8\u30e3\u30de\u30a4\u30ab'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc790\uba54\uc774\uce74'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*de','mt':u('\u0120amajka'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Jamajka','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u042f\u043c\u0430\u0439\u043a\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0408\u0430\u043c\u0430\u0458\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e08\u0e32\u0e44\u0e21\u0e01\u0e49\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Ha-mai-ca','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7259\u4e70\u52a0'),'zu':'*aa',},
  'JO': {'aa':'Jordan','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0627\u0644\u0623\u0631\u062f\u0646'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Jord\u00e0nia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Jordanien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0399\u03bf\u03c1\u03b4\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Jordania','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Jordanie','fy':'*aa','ga':u('An Iord\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Yordania','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Giordania','iu':'*aa','iw':'*aa','ja':u('\u30e8\u30eb\u30c0\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc694\ub974\ub2e8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('\u0120ordan'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Jord\u00e2nia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0418\u043e\u0440\u0434\u0430\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0408\u043e\u0440\u0434\u0430\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e08\u0e2d\u0e23\u0e4c\u0e41\u0e14\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Gi\u00f3c-\u0111a-ni'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7ea6\u65e6'),'zu':'*aa',},
  'JP': {'aa':'Japan','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Jap\u00f3'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0399\u03b1\u03c0\u03c9\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':u('Jap\u00f3n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Japani','fj':'*aa','fo':'*aa','fr':'Japon','fy':'*aa','ga':u('An tSeap\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Jepang','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Giappone','iu':'*aa','iw':'*aa','ja':u('\u65e5\u672c'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc77c\ubcf8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Jepun','mt':u('\u0120appun'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Japonia','ps':'*aa','pt':u('Jap\u00e3o'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u042f\u043f\u043e\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0408\u0430\u043f\u0430\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e0d\u0e35\u0e48\u0e1b\u0e38\u0e48\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Nh\u1eadt B\u1ea3n'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':'*ja','zu':'*aa',},
  'KE': {'aa':'Kenya','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Kenia','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03ad\u03bd\u03c5\u03b1'),'en':'*aa','eo':'*aa','es':'*de','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Ch\u00e9inia'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b1\u30cb\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ucf00\ub0d0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Kenja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*de','ps':'*aa','pt':u('Qu\u00eania'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u0435\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041a\u0435\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e04\u0e19\u0e22\u0e48\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('K\u00ea-ni-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u80af\u5c3c\u4e9a'),'zu':'*aa',},
  'KG': {'aa':'Kyrgyzstan','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Kirgizistan','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Kirgistan','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03b9\u03c1\u03b3\u03b9\u03b6\u03af\u03b1'),'en':'*aa','eo':'*aa','es':u('Kirguizist\u00e1n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Chirgeast\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Kirghizistan','iu':'*aa','iw':'*aa','ja':u('\u30ad\u30eb\u30ae\u30b9\u30bf\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud0a4\ub974\uae30\uc2a4\uc2a4\ud0c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*de','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*de','ps':'*aa','pt':u('Quirguist\u00e3o'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u0438\u0440\u0433\u0438\u0437\u0441\u0442\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'Kirgisistan','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e04\u0e2d\u0e23\u0e4c\u0e01\u0e34\u0e2a\u0e16\u0e32\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('C\u01b0-r\u01a1-g\u01b0-xtan'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5409\u5c14\u5409\u514b\u65af\u5766'),'zu':'*aa',},
  'KH': {'aa':'Cambodia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Cambodja','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Kambodscha','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03b1\u03bc\u03c0\u03cc\u03c4\u03b6\u03b7'),'en':'*aa','eo':'*aa','es':'Camboya','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Cambodge','fy':'*aa','ga':u('An Chamb\u00f3id'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kamboja','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Cambogia','iu':'*aa','iw':'*aa','ja':u('\u30ab\u30f3\u30dc\u30b8\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uce84\ubcf4\ub514\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Kemboja','mt':'Kambodja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Kambod\u017ca'),'ps':'*aa','pt':'Camboja','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041a\u0430\u043c\u0431\u043e\u045f\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*mt','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e01\u0e31\u0e21\u0e1e\u0e39\u0e0a\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Campuchia','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u67ec\u57d4\u5be8'),'zu':'*aa',},
  'KI': {'aa':'Kiribati','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03b9\u03c1\u03b9\u03bc\u03c0\u03ac\u03c4\u03b9'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Cireabait\u00ed'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ad\u30ea\u30d0\u30b9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud0a4\ub9ac\ubc14\uc2dc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Quiribati','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e04\u0e34\u0e23\u0e35\u0e1a\u0e32\u0e15\u0e34'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Ki-ri-ba-ti','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u57fa\u91cc\u5df4\u65af'),'zu':'*aa',},
  'KM': {'aa':'Comoros','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Comores','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Komoren','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03bf\u03bc\u03cc\u03c1\u03b5\u03c2'),'en':'*aa','eo':'*aa','es':'*ca','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*ca','fy':'*aa','ga':u('Oile\u00e1in Chom\u00f3ra'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Komoros','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Comore','iu':'*aa','iw':'*aa','ja':u('\u30b3\u30e2\u30ed'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ucf54\ubaa8\ub974'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*id','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Komory','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u043e\u043c\u043e\u0440\u043e\u0441'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041a\u043e\u043c\u043e\u0440\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Komorerna','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e04\u0e42\u0e21\u0e23\u0e2d\u0e2a'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('C\u00f4-m\u00f4'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u79d1\u6469\u7f57'),'zu':'*aa',},
  'KN': {'aa':'Saint Kitts And Nevis','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Saint Kitts und Nevis','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03b1\u03b9\u03bd\u03c4 \u039a\u03b9\u03c4\u03c2 \u03ba\u03b1\u03b9 \u039d\u03ad\u03b2\u03b9\u03c2'),'en':'*aa','eo':'*aa','es':u('San Crist\u00f3bal y Nieves'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Saint-Christophe-et-Ni\u00e9v\u00e8s'),'fy':'*aa','ga':'Saint Kitts agus Nevis','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Saint Kitts dan Nevis','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Saint Kitts e Nevis','iu':'*aa','iw':'*aa','ja':u('\u30bb\u30f3\u30c8\u30af\u30ea\u30b9\u30c8\u30d5\u30a1\u30fc\u30fb\u30cd\u30a4\u30d3\u30b9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc138\uc778\ud2b8 \ud06c\ub9ac\uc2a4\ud1a0\ud37c \ub2c8\ube44\uc2a4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':'Saint Kitts and Nevis','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('S\u00e3o Cristov\u00e3o e Nevis'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0435\u043d\u0442 \u041a\u0438\u0442\u0441 \u0438 \u041d\u0435\u0432\u0438\u0441'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Saint Kitts och Nevis','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Xan-k\u00edt v\u00e0 N\u00ea-vi'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af'),'zu':'*aa',},
  'KP': {'aa':'North Korea','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Corea del Nord','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Nordkorea','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03bf\u03c1\u03ad\u03b1, \u0392\u03cc\u03c1\u03b5\u03b9\u03b1'),'en':'*aa','eo':'*aa','es':'Corea del Norte','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Cor\u00e9e du Nord'),'fy':'*aa','ga':u('An Ch\u00f3ir\u00e9 Thuaidh'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Korea Utara','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*ca','iu':'*aa','iw':'*aa','ja':u('\u671d\u9bae\u6c11\u4e3b\u4e3b\u7fa9\u4eba\u6c11\u5171\u548c\u56fd'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubd81\ud55c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Utara Korea','mt':u('Koreja ta\u2019 Fuq'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Korea P\u00f3\u0142nocna'),'ps':'*aa','pt':u('Cor\u00e9ia, Norte'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u041a\u043e\u0440\u0435\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u041a\u043e\u0440\u0435\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e40\u0e2b\u0e19\u0e37\u0e2d'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('B\u1eafc Tri\u1ec1u Ti\u00ean'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u671d\u9c9c'),'zu':'*aa',},
  'KR': {'aa':'South Korea','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Corea del Sud','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('S\u00fcdkorea'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03bf\u03c1\u03ad\u03b1, \u039d\u03cc\u03c4\u03b9\u03b1'),'en':'*aa','eo':'*aa','es':'Corea del Sur','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Korea','fj':'*aa','fo':'*aa','fr':u('Cor\u00e9e du Sud'),'fy':'*aa','ga':u('An Ch\u00f3ir\u00e9 Theas'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Korea Selatan','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*ca','iu':'*aa','iw':'*aa','ja':u('\u5927\u97d3\u6c11\u56fd'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub300\ud55c\ubbfc\uad6d'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Selatan Korea','mt':u('Koreja t\u2019Isfel'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Korea Po\u0142udniowa'),'ps':'*aa','pt':u('Cor\u00e9ia, Sul'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u042e\u0436\u043d\u0430\u044f \u041a\u043e\u0440\u0435\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0408\u0443\u0436\u043d\u0430 \u041a\u043e\u0440\u0435\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Sydkorea','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e43\u0e15\u0e49'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('H\u00e0n Qu\u1ed1c'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u97e9\u56fd'),'zu':'*aa',},
  'KW': {'aa':'Kuwait','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0627\u0644\u0643\u0648\u064a\u062a'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03bf\u03c5\u03b2\u03ad\u03b9\u03c4'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Koweit','fy':'*aa','ga':u('Cu\u00e1it'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30af\u30a6\u30a7\u30fc\u30c8'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ucfe0\uc6e8\uc774\ud2b8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Kuwajt','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Kuwejt','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u0443\u0432\u0435\u0439\u0442'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041a\u0443\u0432\u0430\u0458\u0442'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e04\u0e39\u0e40\u0e27\u0e15'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('C\u00f4-o\u00e9t'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u79d1\u5a01\u7279'),'zu':'*aa',},
  'KY': {'aa':'Cayman Islands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Kaiman-Inseln','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u039a\u03ad\u03b9\u03bc\u03b1\u03bd'),'en':'*aa','eo':'*aa','es':u('Islas Caim\u00e1n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00celes Ca\u00efmans'),'fy':'*aa','ga':u('Oile\u00e1in Cayman'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kepulauan Kayman','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Isole Cayman','iu':'*aa','iw':'*aa','ja':u('\u30b1\u30a4\u30de\u30f3\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ucf00\uc774\ub9e8 \uc81c\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Ilhas Caiman','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041a\u0430\u0458\u043c\u0430\u043d\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Cayman\u00f6arna'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5f00\u66fc\u7fa4\u5c9b'),'zu':'*aa',},
  'KZ': {'aa':'Kazakhstan','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Kasachstan','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03b1\u03b6\u03b1\u03ba\u03c3\u03c4\u03ac\u03bd'),'en':'*aa','eo':'*aa','es':u('Kazajst\u00e1n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Chasacst\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ab\u30b6\u30d5\u30b9\u30bf\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uce74\uc790\ud750\uc2a4\ud0c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Ka\u017cakstan'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Kazachstan','ps':'*aa','pt':u('Casaquist\u00e3o'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'Kazakstan','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e04\u0e32\u0e0b\u0e31\u0e04\u0e2a\u0e16\u0e32\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ka-d\u1eafc-xtan'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u54c8\u8428\u514b\u65af\u5766'),'zu':'*aa',},
  'LA': {'aa':'Laos','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039b\u03b1\u03c4\u03b9\u03bd\u03b9\u03ba\u03ae \u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03ae'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30e9\u30aa\u30b9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub77c\uc624\uc2a4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Rep\u00fablica Democr\u00e1tica Popular de Lao'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041b\u0430\u043e\u0441'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e25\u0e32\u0e27'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('L\u00e0o'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8001\u631d'),'zu':'*aa',},
  'LB': {'aa':'Lebanon','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0644\u0628\u0646\u0627\u0646'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('L\u00edban'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Libanon','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039b\u03af\u03b2\u03b1\u03bd\u03bf\u03c2'),'en':'*aa','eo':'*aa','es':u('L\u00edbano'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Liban','fy':'*aa','ga':u('An Liob\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Libano','iu':'*aa','iw':'*aa','ja':u('\u30ec\u30d0\u30ce\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub808\ubc14\ub17c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Lubnan','mt':'Libanu','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*fr','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041b\u0438\u0432\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041b\u0438\u0431\u0430\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e25\u0e1a\u0e32\u0e19\u0e2d\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Li-b\u0103ng'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u9ece\u5df4\u5ae9'),'zu':'*aa',},
  'LC': {'aa':'Saint Lucia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'St. Lucia','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03b3\u03af\u03b1 \u039b\u03bf\u03c5\u03ba\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Santa Lucia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Sainte-Lucie','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Santa Lusia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Sainte Lucia','iu':'*aa','iw':'*aa','ja':u('\u30bb\u30f3\u30c8\u30eb\u30b7\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc138\uc778\ud2b8 \ub8e8\uc2dc\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Santa Lu\u010bija'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Santa L\u00facia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0435\u043d\u0442 \u041b\u0443\u0446\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Xan Lu-xi','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5723\u5362\u897f\u4e9a'),'zu':'*aa',},
  'LI': {'aa':'Liechtenstein','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039b\u03b9\u03c7\u03c4\u03b5\u03bd\u03c3\u03c4\u03ac\u03b9\u03bd'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Lichtinst\u00e9in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ea\u30d2\u30c6\u30f3\u30b7\u30e5\u30bf\u30a4\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub9ac\ud788\ud150\uc288\ud0c0\uc778'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0430\u0458\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e44\u0e25\u0e40\u0e17\u0e19\u0e2a\u0e44\u0e15\u0e19\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Lich-ten-xt\u00ean'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5217\u652f\u6566\u58eb\u767b'),'zu':'*aa',},
  'LK': {'aa':'Sri Lanka','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03c1\u03b9 \u039b\u03ac\u03bd\u03ba\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Sr\u00ed Lanca'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b9\u30ea\u30e9\u30f3\u30ab'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc2a4\ub9ac\ub791\uce74'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0428\u0440\u0438 \u041b\u0430\u043d\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e28\u0e23\u0e35\u0e25\u0e31\u0e07\u0e01\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Xri Lan-ca','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u65af\u91cc\u5170\u5361'),'zu':'*aa',},
  'LR': {'aa':'Liberia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Lib\u00e8ria'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039b\u03b9\u03b2\u03b5\u03c1\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Lib\u00e9ir'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ea\u30d9\u30ea\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub77c\uc774\ubca0\ub9ac\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Liberja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Lib\u00e9ria'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041b\u0438\u0431\u0435\u0440\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041b\u0438\u0431\u0435\u0440\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e25\u0e34\u0e40\u0e1a\u0e2d\u0e23\u0e4c\u0e40\u0e25\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Li-b\u00ea-ri-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5229\u6bd4\u91cc\u4e9a'),'zu':'*aa',},
  'LS': {'aa':'Lesotho','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039b\u03b5\u03c3\u03cc\u03c4\u03bf'),'en':'*aa','eo':'*aa','es':'Lesoto','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Leos\u00f3ta'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ec\u30bd\u30c8'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub808\uc18c\ud1a0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*es','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*es','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041b\u0435\u0441\u043e\u0442\u043e'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e25\u0e42\u0e0b\u0e42\u0e17'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('L\u00ea-x\u00f4-th\u00f4'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u83b1\u7d22\u6258'),'zu':'*aa',},
  'LT': {'aa':'Lithuania','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Litu\u00e0nia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Litauen','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039b\u03b9\u03b8\u03bf\u03c5\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Lituania','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Lithuanie','fy':'*aa','ga':u('An Liotu\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*es','iu':'*aa','iw':'*aa','ja':u('\u30ea\u30c8\u30a2\u30cb\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub9ac\ud22c\uc544\ub2c8\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'Lietuva','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Litwanja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Litwa','ps':'*aa','pt':u('Litu\u00e2nia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041b\u0438\u0442\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041b\u0438\u0442\u0432\u0430\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e25\u0e34\u0e40\u0e17\u0e2d\u0e23\u0e4c\u0e40\u0e19\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Li-tu-a-ni-a','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7acb\u9676\u5b9b'),'zu':'*aa',},
  'LU': {'aa':'Luxembourg','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Luxemburg','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*ca','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039b\u03bf\u03c5\u03be\u03b5\u03bc\u03b2\u03bf\u03cd\u03c1\u03b3\u03bf'),'en':'*aa','eo':'*aa','es':'Luxemburgo','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'Lucsamburg','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Lussemburgo','iu':'*aa','iw':'*aa','ja':u('\u30eb\u30af\u30bb\u30f3\u30d6\u30eb\u30af'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub8e9\uc148\ubd80\ub974\ud06c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Luksembourg','mt':'Lussemburgu','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Luksemburg','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041b\u0443\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*ca','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e25\u0e31\u0e01\u0e0b\u0e4c\u0e40\u0e0b\u0e21\u0e40\u0e1a\u0e2d\u0e23\u0e4c\u0e01'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('L\u00fac-x\u0103m-bua'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5362\u68ee\u5821'),'zu':'*aa',},
  'LV': {'aa':'Latvia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Let\u00f2nia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Lettland','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039b\u03b5\u03c4\u03bf\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Letonia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Lettonie','fy':'*aa','ga':'An Laitvia','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Lettonia','iu':'*aa','iw':'*aa','ja':u('\u30e9\u30c8\u30d3\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub77c\ud2b8\ube44\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'Latvija','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Latvja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('\u0141otwa'),'ps':'*aa','pt':u('Let\u00f4nia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041b\u0430\u0442\u0432\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041b\u0435\u0442\u043e\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e25\u0e32\u0e15\u0e40\u0e27\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('L\u00e1t-vi-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u62c9\u8131\u7ef4\u4e9a'),'zu':'*aa',},
  'LY': {'aa':'Libya','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0644\u064a\u0628\u064a\u0627'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('L\u00edbia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Libyen','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039b\u03b9\u03b2\u03cd\u03b7'),'en':'*aa','eo':'*aa','es':'Libia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Libye','fy':'*aa','ga':'An Libia','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*es','iu':'*aa','iw':'*aa','ja':u('\u30ea\u30d3\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub9ac\ube44\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Libja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*es','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041b\u0438\u0432\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041b\u0438\u0431\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e25\u0e34\u0e40\u0e1a\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Li-bi','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5229\u6bd4\u4e9a'),'zu':'*aa',},
  'MA': {'aa':'Morocco','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0627\u0644\u0645\u063a\u0631\u0628'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Marroc','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Marokko','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03b1\u03c1\u03cc\u03ba\u03bf'),'en':'*aa','eo':'*aa','es':'Marruecos','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Maroc','fy':'*aa','ga':u('Marac\u00f3'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Maroko','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Marocco','iu':'*aa','iw':'*aa','ja':u('\u30e2\u30ed\u30c3\u30b3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubaa8\ub85c\ucf54'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Maghribi','mt':'Marokk','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*id','ps':'*aa','pt':'Marrocos','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u0430\u0440\u043e\u043a\u043a\u043e'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0430\u0440\u043e\u043a\u043e'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Marocko','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e21\u0e23\u0e2d\u0e04\u0e42\u0e04'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ma-r\u1ed1c'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6469\u6d1b\u54e5'),'zu':'*aa',},
  'MC': {'aa':'Monaco','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('M\u00f2naco'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03bf\u03bd\u03b1\u03ba\u03cc'),'en':'*aa','eo':'*aa','es':u('M\u00f3naco'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Monac\u00f3'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30e2\u30ca\u30b3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubaa8\ub098\ucf54'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Monako','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*mt','ps':'*aa','pt':u('M\u00f4naco'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u043e\u043d\u0430\u043a\u043e'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e21\u0e19\u0e32\u0e42\u0e04'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('M\u00f4-na-c\u00f4'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6469\u7eb3\u54e5'),'zu':'*aa',},
  'MD': {'aa':'Moldova','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Mold\u00e0via'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Moldau','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03bf\u03bb\u03b4\u03b1\u03b2\u03af\u03b1, \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1 \u03c4\u03b7\u03c2'),'en':'*aa','eo':'*aa','es':'Moldavia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Moldavie','fy':'*aa','ga':u('An Mhold\u00f3iv'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*es','iu':'*aa','iw':'*aa','ja':u('\u30e2\u30eb\u30c9\u30d0'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubab0\ub3c4\ubc14'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Maldova','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Mo\u0142dawia'),'ps':'*aa','pt':u('Moldova, Rep\u00fablica de'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u043e\u043b\u0434\u043e\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u043e\u043b\u0434\u0430\u0432\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Moldavien','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e21\u0e25\u0e42\u0e14\u0e27\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('M\u00f4n-\u0111\u00f4-va'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6469\u5c14\u591a\u74e6'),'zu':'*aa',},
  'ME': {'aa':'Montenegro','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':'*aa','en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Mont\u00e9n\u00e9gro'),'fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30e2\u30f3\u30c6\u30cd\u30b0\u30ed'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubaac\ud14c\ub124\uadf8\ub85c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u9ed1\u5c71'),'zu':'*aa',},
  'MF': {'aa':'Saint Martin','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':'*aa','en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':'*aa','ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':'*aa','kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':'*aa','zu':'*aa',},
  'MG': {'aa':'Madagascar','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Madagaskar','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03b1\u03b4\u03b1\u03b3\u03b1\u03c3\u03ba\u03ac\u03c1\u03b7'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*de','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*de','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30de\u30c0\u30ac\u30b9\u30ab\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub9c8\ub2e4\uac00\uc2a4\uce74\ub974'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*de','mt':'*de','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*de','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e21\u0e32\u0e14\u0e32\u0e01\u0e32\u0e2a\u0e01\u0e49\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ma-\u0111a-g\u00e1t-xca'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u9a6c\u8fbe\u52a0\u65af\u52a0'),'zu':'*aa',},
  'MH': {'aa':'Marshall Islands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Marshall-Inseln','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u039c\u03ac\u03c1\u03c3\u03b1\u03bb'),'en':'*aa','eo':'*aa','es':'Islas Marshall','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00celes Marshall'),'fy':'*aa','ga':u('Oile\u00e1in Marshall'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kepulauan Marshall','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Isole Marshall','iu':'*aa','iw':'*aa','ja':u('\u30de\u30fc\u30b7\u30e3\u30eb\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub9c8\uc15c \uc81c\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':u('G\u017cejjer ta\u2019 Marshall'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Ilhas Marshall','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0430\u0440\u0448\u0430\u043b\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Marshall\u00f6arna'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Qu\u1ea7n \u0111\u1ea3o M\u00e1c-san'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u9a6c\u7ecd\u5c14\u7fa4\u5c9b'),'zu':'*aa',},
  'MK': {'aa':'Macedonia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Maced\u00f2nia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Mazedonien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a0\u0393\u0394 \u039c\u03b1\u03ba\u03b5\u03b4\u03bf\u03bd\u03af\u03b1\u03c2'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Mac\u00e9doine'),'fy':'*aa','ga':u('An Mhacad\u00f3in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30de\u30b1\u30c9\u30cb\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub9c8\ucf00\ub3c4\ub2c8\uc544\uc5b4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u0458\u0430'),'ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Ma\u010bedonja'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Maced\u00f4nia, Rep\u00fablica da'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'Makedonien','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e41\u0e21\u0e0b\u0e35\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ma-x\u00ea-\u0111\u00f4-ni-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u9a6c\u5176\u987f\u738b\u56fd'),'zu':'*aa',},
  'ML': {'aa':'Mali','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03ac\u03bb\u03b9'),'en':'*aa','eo':'*aa','es':u('Mal\u00ed'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Mail\u00ed'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30de\u30ea'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub9d0\ub9ac'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u0430\u043b\u0438'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e21\u0e32\u0e25\u0e35'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Ma-li','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u9a6c\u91cc'),'zu':'*aa',},
  'MM': {'aa':'Myanmar','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03b9\u03b1\u03bd\u03bc\u03ac\u03c1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'Maenmar','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30df\u30e3\u30f3\u30de\u30fc'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubbf8\uc580\ub9c8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Mjanmar','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Mianm\u00e1'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u044c\u044f\u043d\u043c\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0438\u0458\u0430\u043d\u043c\u0430\u0440'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2a\u0e2b\u0e20\u0e32\u0e1e\u0e1e\u0e21\u0e48\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Mi-an-ma','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7f05\u7538'),'zu':'*aa',},
  'MN': {'aa':'Mongolia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Mong\u00f2lia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Mongolei','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03bf\u03b3\u03b3\u03bf\u03bb\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Mongolie','fy':'*aa','ga':u('An Mhong\u00f3il'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30e2\u30f3\u30b4\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubabd\uace8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Mongolja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Mong\u00f3lia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Mongoliet','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e21\u0e2d\u0e07\u0e42\u0e01\u0e40\u0e25\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('M\u00f4ng C\u1ed5'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8499\u53e4'),'zu':'*aa',},
  'MO': {'aa':'Macao','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03b1\u03ba\u03ac\u03bf, \u0395\u03b9\u03b4\u03b9\u03ba\u03ae \u0394\u03b9\u03bf\u03b9\u03ba\u03b7\u03c4\u03b9\u03ba\u03ae \u03a0\u03b5\u03c1\u03b9\u03c6\u03ad\u03c1\u03b5\u03b9\u03b1 \u03c4\u03b7\u03c2 \u039a\u03af\u03bd\u03b1\u03c2'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Makao S.A.R. Cina','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30de\u30ab\u30aa'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub9c8\uce74\uc624'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Macao S.A.R., China','mt':'*ms','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Macau, Regi\u00e3o Admin. Especial da China'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0430\u043a\u0430\u043e (\u0421. \u0410. \u0420. \u041a\u0438\u043d\u0430)'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6fb3\u95e8\u7279\u533a'),'zu':'*aa',},
  'MP': {'aa':'Northern Mariana Islands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('N\u00f6rdliche Mariannen-Inseln'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u0392\u03cc\u03c1\u03b5\u03b9\u03b5\u03c2 \u039c\u03b1\u03c1\u03b9\u03ac\u03bd\u03b5\u03c2'),'en':'*aa','eo':'*aa','es':'Islas Marianas del Norte','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00celes Mariannes du Nord'),'fy':'*aa','ga':u('Oile\u00e1in Mariana Thuaidh'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kepualuan Mariana Utara','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Isole Marianne settentrionali','iu':'*aa','iw':'*aa','ja':u('\u5317\u30de\u30ea\u30a2\u30ca\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubd81\ub9c8\ub9ac\uc544\ub098 \uc81c\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('G\u017cejjer Marjana ta\u2019 Fuq'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Ilhas Marianas do Norte','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u041c\u0430\u0440\u0438\u0458\u0430\u043d\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Nordmarianerna','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7f8e\u5c5e\u5317\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b'),'zu':'*aa',},
  'MQ': {'aa':'Martinique','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Martinica','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03b1\u03c1\u03c4\u03b9\u03bd\u03af\u03ba\u03b1'),'en':'*aa','eo':'*aa','es':'*ca','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*ca','iu':'*aa','iw':'*aa','ja':u('\u30de\u30eb\u30c6\u30a3\u30cb\u30fc\u30af\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub9d0\ud2f0\ub2c8\ud06c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Martinik','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Martynika','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e21\u0e32\u0e23\u0e4c\u0e15\u0e34\u0e19\u0e34\u0e01'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u9a6c\u63d0\u5c3c\u514b\u5c9b'),'zu':'*aa',},
  'MR': {'aa':'Mauritania','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Maurit\u00e0nia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Mauretanien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03b1\u03c5\u03c1\u03b9\u03c4\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Mauritanie','fy':'*aa','ga':u('An Mharat\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30e2\u30fc\u30ea\u30bf\u30cb\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubaa8\ub9ac\ud0c0\ub2c8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Mawritanja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Mauretania','ps':'*aa','pt':u('Maurit\u00e2nia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0430\u0443\u0440\u0438\u0442\u0430\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e21\u0e2d\u0e23\u0e34\u0e17\u0e32\u0e40\u0e19\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('M\u00f4-ri-ta-ni'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6bdb\u91cc\u5854\u5c3c\u4e9a'),'zu':'*aa',},
  'MS': {'aa':'Montserrat','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03bf\u03bd\u03c3\u03b5\u03c1\u03ac\u03c4'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'Montsarat','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30e2\u30f3\u30c8\u30bb\u30e9\u30c8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubaac\ud2b8\uc138\ub77c\ud2b8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0430\u0442'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u043e\u043d\u0441\u0435\u0440\u0430\u0442'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e21\u0e2d\u0e19\u0e15\u0e4c\u0e40\u0e0b\u0e2d\u0e23\u0e32\u0e15'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8499\u7279\u585e\u62c9\u7fa4\u5c9b'),'zu':'*aa',},
  'MT': {'aa':'Malta','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03ac\u03bb\u03c4\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Malte','fy':'*aa','ga':u('M\u00e1lta'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30de\u30eb\u30bf'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubab0\ud0c0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u0430\u043b\u044c\u0442\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0430\u043b\u0442\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e21\u0e31\u0e25\u0e15\u0e49\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Man-ta','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u9a6c\u8033\u4ed6'),'zu':'*aa',},
  'MU': {'aa':'Mauritius','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Maurici','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03b1\u03c5\u03c1\u03af\u03ba\u03b9\u03bf\u03c2'),'en':'*aa','eo':'*aa','es':'Mauricio','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Maurice','fy':'*aa','ga':u('Oile\u00e1n Mhuir\u00eds'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Maurizio','iu':'*aa','iw':'*aa','ja':u('\u30e2\u30fc\u30ea\u30b7\u30e3\u30b9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubaa8\ub9ac\uc154\uc2a4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Mawrizju','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Maur\u00edcio'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0430\u0443\u0440\u0438\u0446\u0438\u0458\u0443\u0441'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e21\u0e2d\u0e23\u0e34\u0e40\u0e15\u0e35\u0e22\u0e2a'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('M\u00f4-ri-x\u01a1'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6bdb\u91cc\u6c42\u65af'),'zu':'*aa',},
  'MV': {'aa':'Maldives','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Maldiven','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03b1\u03bb\u03b4\u03af\u03b2\u03b5\u03c2'),'en':'*aa','eo':'*aa','es':'Maldivas','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Mhaildiv\u00ed'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Maldive','iu':'*aa','iw':'*aa','ja':u('\u30e2\u30eb\u30c7\u30a3\u30d6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubab0\ub514\ube0c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Maldiv','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0430\u043b\u0434\u0438\u0432\u0438'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Maldiverna','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Man-\u0111i-v\u01a1'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u9a6c\u5c14\u4ee3\u592b'),'zu':'*aa',},
  'MW': {'aa':'Malawi','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03b1\u03bb\u03ac\u03bf\u03c5\u03b9'),'en':'*aa','eo':'*aa','es':'Malaui','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Mhal\u00e1iv'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30de\u30e9\u30a6\u30a4'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub9d0\ub77c\uc704'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0430\u043b\u0430\u0432\u0438'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Ma-la-uy','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u9a6c\u62c9\u7ef4'),'zu':'*aa',},
  'MX': {'aa':'Mexico','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('M\u00e8xic'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Mexiko','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03b5\u03be\u03b9\u03ba\u03cc'),'en':'*aa','eo':'*aa','es':u('M\u00e9xico'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Mexique','fy':'*aa','ga':'Meicsiceo','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Messico','iu':'*aa','iw':'*aa','ja':u('\u30e1\u30ad\u30b7\u30b3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uba55\uc2dc\ucf54'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Meksiko','mt':'Messiku','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Meksyk','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u0435\u043a\u0441\u0438\u043a\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0435\u043a\u0441\u0438\u043a\u043e'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e41\u0e21\u0e47\u0e01\u0e0b\u0e34\u0e42\u0e01'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('M\u00ea-hi-c\u00f4'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u58a8\u897f\u54e5'),'zu':'*aa',},
  'MY': {'aa':'Malaysia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Mal\u00e0isia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03b1\u03bb\u03b1\u03b9\u03c3\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Malasia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Malaisie','fy':'*aa','ga':'An Mhalaeisia','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30de\u30ec\u30fc\u30b7\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub9d0\ub808\uc774\uc9c0\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Malasja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Malezja','ps':'*aa','pt':u('Mal\u00e1sia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u0430\u043b\u0430\u0439\u0437\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0430\u043b\u0435\u0437\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e21\u0e32\u0e40\u0e25\u0e40\u0e0b\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Ma-lay-xi-a','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u9a6c\u6765\u897f\u4e9a'),'zu':'*aa',},
  'MZ': {'aa':'Mozambique','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Mo\u00e7ambic'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Mosambik','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03bf\u03b6\u03b1\u03bc\u03b2\u03af\u03ba\u03b7'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('M\u00f3saimb\u00edc'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Mozambico','iu':'*aa','iw':'*aa','ja':u('\u30e2\u30b6\u30f3\u30d3\u30fc\u30af'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubaa8\uc7a0\ube44\ud06c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Mozambik','mt':u('Mo\u017cambik'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*ms','ps':'*aa','pt':u('Mo\u00e7ambique'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*pt','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e21\u0e41\u0e0b\u0e21\u0e1a\u0e34\u0e04'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('M\u00f4-d\u0103m-b\u00edch'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u83ab\u6851\u6bd4\u514b'),'zu':'*aa',},
  'NA': {'aa':'Namibia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Nam\u00edbia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03b1\u03bc\u03af\u03bc\u03c0\u03b9\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Namibie','fy':'*aa','ga':'An Namaib','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ca\u30df\u30d3\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub098\ubbf8\ube44\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Namibja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041d\u0430\u043c\u0438\u0431\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041d\u0430\u043c\u0438\u0431\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e19\u0e32\u0e21\u0e34\u0e40\u0e1a\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Nam-mi-bi-a','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7eb3\u7c73\u6bd4\u4e9a'),'zu':'*aa',},
  'NC': {'aa':'New Caledonia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Nova Caled\u00f2nia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Neukaledonien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ad\u03b1 \u039a\u03b1\u03bb\u03b7\u03b4\u03bf\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Nueva Caledonia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Nouvelle-Cal\u00e9donie'),'fy':'*aa','ga':u('An Nua-Chalad\u00f3in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kaledonia Baru','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Nuova Caledonia','iu':'*aa','iw':'*aa','ja':u('\u30cb\u30e5\u30fc\u30ab\u30ec\u30c9\u30cb\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub274 \uce7c\ub808\ub3c4\ub2c8\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Nowa Kaledonia','ps':'*aa','pt':u('Nova Caled\u00f4nia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041d\u043e\u0432\u0430\u044f \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041d\u043e\u0432\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Nya Kaledonien','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e19\u0e34\u0e27\u0e04\u0e32\u0e25\u0e34\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u65b0\u514b\u91cc\u591a\u5c3c\u4e9a\u7fa4\u5c9b'),'zu':'*aa',},
  'NE': {'aa':'Niger','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('N\u00edger'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03af\u03b3\u03b7\u03c1'),'en':'*aa','eo':'*aa','es':'*ca','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An N\u00edgir'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30cb\u30b8\u30a7\u30fc\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub2c8\uc81c\ub974'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Ni\u0121er'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041d\u0438\u0433\u0435\u0440'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e44\u0e19\u0e40\u0e08\u0e2d\u0e23\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ni-gi\u00ea'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5c3c\u65e5\u5c14'),'zu':'*aa',},
  'NF': {'aa':'Norfolk Island','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Norfolk-Insel','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03c2 \u039d\u03cc\u03c1\u03c6\u03bf\u03bb\u03ba'),'en':'*aa','eo':'*aa','es':'Isla Norfolk','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00cele Norfolk'),'fy':'*aa','ga':u('Oile\u00e1n Norfolk'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kepulauan Norfolk','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Isola Norfolk','iu':'*aa','iw':'*aa','ja':u('\u30ce\u30fc\u30d5\u30a9\u30fc\u30af\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub178\ud37d \uc12c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Ilha Norfolk','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u041e\u0441\u0442\u0440\u0432\u043e'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Norfolk\u00f6n'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8bfa\u798f\u514b\u5c9b'),'zu':'*aa',},
  'NG': {'aa':'Nigeria','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Nig\u00e8ria'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03b9\u03b3\u03b7\u03c1\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Nig\u00e9ria'),'fy':'*aa','ga':u('An Nig\u00e9ir'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ca\u30a4\u30b8\u30a7\u30ea\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub098\uc774\uc9c0\ub9ac\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Ni\u0121erja'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*fr','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041d\u0438\u0433\u0435\u0440\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041d\u0438\u0433\u0435\u0440\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e44\u0e19\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ni-gi\u00ea-ri-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5c3c\u65e5\u5229\u4e9a'),'zu':'*aa',},
  'NI': {'aa':'Nicaragua','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03b9\u03ba\u03b1\u03c1\u03ac\u03b3\u03bf\u03c5\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'Nicearagua','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30cb\u30ab\u30e9\u30b0\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub2c8\uce74\ub77c\uacfc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Nikaragwa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Nikaragua','ps':'*aa','pt':u('Nicar\u00e1gua'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e19\u0e34\u0e04\u0e32\u0e23\u0e32\u0e01\u0e31\u0e27'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Ni-ca-ra-goa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5c3c\u52a0\u62c9\u74dc'),'zu':'*aa',},
  'NL': {'aa':'Netherlands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Pa\u00efsos Baixos'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Niederlande','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039f\u03bb\u03bb\u03b1\u03bd\u03b4\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Holanda','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Alankomaat','fj':'*aa','fo':'*aa','fr':'Pays-Bas','fy':'*aa','ga':u('An \u00cdsilt\u00edr'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Paesi Bassi','iu':'*aa','iw':'*aa','ja':u('\u30aa\u30e9\u30f3\u30c0'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub124\ub35c\ub780\ub4dc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Belanda','mt':'Olanda','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'Nederland','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Holandia','ps':'*aa','pt':u('Pa\u00edses Baixos'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u044b'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0425\u043e\u043b\u0430\u043d\u0434\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Nederl\u00e4nderna'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e19\u0e40\u0e18\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('H\u00e0 Lan'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8377\u5170'),'zu':'*aa',},
  'NO': {'aa':'Norway','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Noruega','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Norwegen','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03bf\u03c1\u03b2\u03b7\u03b3\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*ca','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Norja','fj':'*aa','fo':'*aa','fr':u('Norv\u00e8ge'),'fy':'*aa','ga':'An Iorua','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Norwegia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Norvegia','iu':'*aa','iw':'*aa','ja':u('\u30ce\u30eb\u30a6\u30a7\u30fc'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub178\ub974\uc6e8\uc774'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Norve\u0121ja'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'Norge','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*id','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041d\u043e\u0440\u0432\u0435\u0433\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041d\u043e\u0440\u0432\u0435\u0448\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*no','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e27\u0e22\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Na Uy','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u632a\u5a01'),'zu':'*aa',},
  'NP': {'aa':'Nepal','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03b5\u03c0\u03ac\u03bb'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('N\u00e9pal'),'fy':'*aa','ga':'Neipeal','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30cd\u30d1\u30fc\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub124\ud314'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041d\u0435\u043f\u0430\u043b'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e19\u0e1b\u0e32\u0e25'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('N\u00ea-pan'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5c3c\u6cca\u5c14'),'zu':'*aa',},
  'NR': {'aa':'Nauru','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03b1\u03bf\u03cd\u03c1\u03bf\u03c5'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('N\u00e1r\u00fa'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ca\u30a6\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub098\uc6b0\ub8e8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041d\u0430\u0443\u0440\u0443'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7459\u9c81'),'zu':'*aa',},
  'NU': {'aa':'Niue','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03b9\u03bf\u03cd\u03b5'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30cb\u30a6\u30a8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub2c8\uc6b0\uc5d0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041d\u0438\u044e'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041d\u0438\u0443\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e19\u0e35\u0e22\u0e39'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7ebd\u57c3\u5c9b'),'zu':'*aa',},
  'NZ': {'aa':'New Zealand','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Nova Zelanda','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Neuseeland','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ad\u03b1 \u0396\u03b7\u03bb\u03b1\u03bd\u03b4\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Nueva Zelanda','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Nouvelle-Z\u00e9lande'),'fy':'*aa','ga':u('An Nua-Sh\u00e9alainn'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Selandia Baru','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Nuova Zelanda','iu':'*aa','iw':'*aa','ja':u('\u30cb\u30e5\u30fc\u30b8\u30fc\u30e9\u30f3\u30c9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub274\uc9c8\ub79c\ub4dc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Nowa Zelandia','ps':'*aa','pt':u('Nova Zel\u00e2ndia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041d\u043e\u0432\u0430\u044f \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041d\u043e\u0432\u0438 \u0417\u0435\u043b\u0430\u043d\u0434'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Nya Zeeland','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e19\u0e34\u0e27\u0e0b\u0e35\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Niu Di-l\u00e2n'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u65b0\u897f\u5170'),'zu':'*aa',},
  'OM': {'aa':'Oman','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0633\u0644\u0637\u0646\u0629 \u0639\u0645\u0627\u0646'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039f\u03bc\u03ac\u03bd'),'en':'*aa','eo':'*aa','es':u('Om\u00e1n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30aa\u30de\u30fc\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc624\ub9cc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Om\u00e3'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041e\u043c\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e2d\u0e21\u0e32\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u00d4-man'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u963f\u66fc'),'zu':'*aa',},
  'PA': {'aa':'Panama','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Panam\u00e0'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a0\u03b1\u03bd\u03b1\u03bc\u03ac\u03c2'),'en':'*aa','eo':'*aa','es':u('Panam\u00e1'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d1\u30ca\u30de'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud30c\ub098\ub9c8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041f\u0430\u043d\u0430\u043c\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1b\u0e32\u0e19\u0e32\u0e21\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Pa-na-ma','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5df4\u62ff\u9a6c'),'zu':'*aa',},
  'PE': {'aa':'Peru','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Per\u00fa'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a0\u03b5\u03c1\u03bf\u03cd'),'en':'*aa','eo':'*aa','es':'*ca','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('P\u00e9rou'),'fy':'*aa','ga':u('Peiri\u00fa'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':u('Per\u00f9'),'iu':'*aa','iw':'*aa','ja':u('\u30da\u30eb\u30fc'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud398\ub8e8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041f\u0435\u0440\u0443'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e1b\u0e23\u0e39'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('P\u00ea-ru'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u79d8\u9c81'),'zu':'*aa',},
  'PF': {'aa':'French Polynesia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Polin\u00e8sia Francesa'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('Franz\u00f6sisch-Polynesien'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ae \u03a0\u03bf\u03bb\u03c5\u03bd\u03b7\u03c3\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Polinesia Francesa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Polyn\u00e9sie Fran\u00e7aise'),'fy':'*aa','ga':u('An Pholain\u00e9is Fhrancach'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Polynesia Perancis','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Polinesia Francese','iu':'*aa','iw':'*aa','ja':u('\u4ecf\u9818\u30dd\u30ea\u30cd\u30b7\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud504\ub791\uc2a4\ub839 \ud3f4\ub9ac\ub124\uc2dc\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Polinesja Fran\u010bi\u017ca'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Polinezja Francuska','ps':'*aa','pt':u('Polin\u00e9sia Francesa'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430 \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Franska Polynesien','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e1f\u0e23\u0e47\u0e19\u0e0a\u0e42\u0e1e\u0e25\u0e34\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6cd5\u5c5e\u73bb\u5229\u5c3c\u897f\u4e9a'),'zu':'*aa',},
  'PG': {'aa':'Papua New Guinea','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Papua Nova Guinea','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Papua-Neuguinea','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a0\u03b1\u03c0\u03bf\u03cd\u03b1 - \u039d\u03ad\u03b1 \u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1'),'en':'*aa','eo':'*aa','es':u('Pap\u00faa New Guinea'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Papouasie-Nouvelle-Guin\u00e9e'),'fy':'*aa','ga':'Nua-Ghuine Phapua','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Papua Nugini','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Papua Nuova Guinea','iu':'*aa','iw':'*aa','ja':u('\u30d1\u30d7\u30a2\u30cb\u30e5\u30fc\u30ae\u30cb\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud30c\ud478\uc544\ub274\uae30\ub2c8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Papwa-Ginea \u0120dida'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Papua Nowa Gwinea','ps':'*aa','pt':u('Papua-Nova Guin\u00e9'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041f\u0430\u043f\u0443\u0430 - \u041d\u043e\u0432\u0430\u044f \u0413\u0432\u0438\u043d\u0435\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041f\u0430\u043f\u0443\u0430 \u041d\u043e\u0432\u0430 \u0413\u0432\u0438\u043d\u0435\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Papua Nya Guinea','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1b\u0e32\u0e1b\u0e31\u0e27\u0e19\u0e34\u0e27\u0e01\u0e35\u0e19\u0e35'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Pa-pu-a Niu Ghi-n\u00ea'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a'),'zu':'*aa',},
  'PH': {'aa':'Philippines','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Filipines','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Philippinen','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a6\u03b9\u03bb\u03b9\u03c0\u03c0\u03af\u03bd\u03b5\u03c2'),'en':'*aa','eo':'*aa','es':'Filipinas','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Na hOile\u00e1in Fhilip\u00edneacha'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Filipina','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Filippine','iu':'*aa','iw':'*aa','ja':u('\u30d5\u30a3\u30ea\u30d4\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud544\ub9ac\ud540'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':'Filippini','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Filipiny','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u044b'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0424\u0438\u043b\u0438\u043f\u0438\u043d\u0438'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Filippinerna','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1f\u0e34\u0e25\u0e34\u0e1b\u0e1b\u0e34\u0e19\u0e2a\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Phi-lip-pin','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u83f2\u5f8b\u5bbe'),'zu':'*aa',},
  'PK': {'aa':'Pakistan','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a0\u03b1\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd'),'en':'*aa','eo':'*aa','es':u('Paquist\u00e1n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Phacast\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d1\u30ad\u30b9\u30bf\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud30c\ud0a4\uc2a4\ud0c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Paquist\u00e3o'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1b\u0e32\u0e01\u0e35\u0e2a\u0e16\u0e32\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Pa-ki-xtan','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5df4\u57fa\u65af\u5766'),'zu':'*aa',},
  'PL': {'aa':'Poland','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Pol\u00f2nia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Polen','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a0\u03bf\u03bb\u03c9\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Polonia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Puola','fj':'*aa','fo':'*aa','fr':'Pologne','fy':'*aa','ga':'An Pholainn','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Polandia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*es','iu':'*aa','iw':'*aa','ja':u('\u30dd\u30fc\u30e9\u30f3\u30c9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud3f4\ub780\ub4dc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Polonja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Polska','ps':'*aa','pt':u('Pol\u00f4nia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041f\u043e\u043b\u044c\u0448\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041f\u043e\u0459\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e1b\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Ba Lan','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6ce2\u5170'),'zu':'*aa',},
  'PM': {'aa':'Saint Pierre And Miquelon','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'St. Pierre und Miquelon','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03b1\u03b9\u03bd\u03c4 \u03a0\u03b9\u03ad\u03c1 \u03ba\u03b1\u03b9 \u039c\u03b9\u03ba\u03b5\u03bb\u03cc\u03bd'),'en':'*aa','eo':'*aa','es':u('San Pedro y Miquel\u00f3n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Saint-Pierre-et-Miquelon','fy':'*aa','ga':'Saint Pierre agus Miquelon','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Saint Pierre dan Miquelon','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Saint Pierre e Miquelon','iu':'*aa','iw':'*aa','ja':u('\u30b5\u30f3\u30d4\u30a8\u30fc\u30eb\u5cf6\u30fb\u30df\u30af\u30ed\u30f3\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc138\uc778\ud2b8 \ud53c\uc5d0\ub974 \ubbf8\ucf08\ub860'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Saint Pierre and Miquelon','mt':'*ms','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*it','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0435\u043d \u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Saint Pierre och Miquelon','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686\u7fa4\u5c9b'),'zu':'*aa',},
  'PN': {'aa':'Pitcairn','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a0\u03af\u03c4\u03ba\u03b5\u03c1\u03bd'),'en':'*aa','eo':'*aa','es':'Islas Pitcairn','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d4\u30c8\u30b1\u30a2\u30f3\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud54f\ucf00\uc5b8 \uc81c\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041f\u0438\u0442\u043a\u0435\u0440\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u76ae\u7279\u514b\u6069\u5c9b'),'zu':'*aa',},
  'PR': {'aa':'Puerto Rico','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a0\u03bf\u03c5\u03ad\u03c1\u03c4\u03bf \u03a1\u03af\u03ba\u03bf'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Porto Rico','fy':'*aa','ga':u('Port\u00f3 R\u00edce'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Puerto Riko','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d7\u30a8\u30eb\u30c8\u30ea\u30b3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud478\uc5d0\ub974\ud1a0\ub9ac\ucf54'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Portoryko','ps':'*aa','pt':'*fr','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041f\u0443\u044d\u0440\u0442\u043e-\u0420\u0438\u043a\u043e'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041f\u043e\u0440\u0442\u043e \u0420\u0438\u043a\u043e'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e42\u0e15\u0e23\u0e34\u0e42\u0e01'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6ce2\u591a\u9ece\u54e5'),'zu':'*aa',},
  'PS': {'aa':'Palestine','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('Pal\u00e4stina'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a0\u03b1\u03bb\u03b1\u03b9\u03c3\u03c4\u03b9\u03bd\u03b9\u03b1\u03ba\u03ac \u0395\u03b4\u03ac\u03c6\u03b7'),'en':'*aa','eo':'*aa','es':'Palestina','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Na Cr\u00edocha Pailist\u00edneacha'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Otoritas Palestina','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*es','iu':'*aa','iw':'*aa','ja':u('\u30d1\u30ec\u30b9\u30c1\u30ca'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud314\ub808\uc2a4\ud0c0\uc778'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Palestinian Territory','mt':'*ms','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Territ\u00f3rio da Palestina'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u0441\u043a\u0430 \u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*es','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5df4\u52d2\u65af\u5766'),'zu':'*aa',},
  'PT': {'aa':'Portugal','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a0\u03bf\u03c1\u03c4\u03bf\u03b3\u03b1\u03bb\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Portugali','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Phortaing\u00e9il'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Portugis','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Portogallo','iu':'*aa','iw':'*aa','ja':u('\u30dd\u30eb\u30c8\u30ac\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud3ec\ub974\ud2b8\uce7c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Feringgi','mt':'Portugall','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Portugalia','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e1b\u0e15\u0e38\u0e01\u0e31\u0e25'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('B\u1ed3 \u0110\u00e0o Nha'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8461\u8404\u7259'),'zu':'*aa',},
  'PW': {'aa':'Palau','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a0\u03b1\u03bb\u03ac\u03bf\u03c5'),'en':'*aa','eo':'*aa','es':'Palaos','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Belau','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d1\u30e9\u30aa'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud314\ub77c\uc6b0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041f\u0430\u043b\u0430\u0443'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5e15\u52b3'),'zu':'*aa',},
  'PY': {'aa':'Paraguay','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Paraguai','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a0\u03b1\u03c1\u03b1\u03b3\u03bf\u03c5\u03ac\u03b7'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'Paragua','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d1\u30e9\u30b0\u30a2\u30a4'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud30c\ub77c\uacfc\uc774'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Paragwaj','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*mt','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1b\u0e32\u0e23\u0e32\u0e01\u0e27\u0e31\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Pa-ra-goay','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5df4\u62c9\u572d'),'zu':'*aa',},
  'QA': {'aa':'Qatar','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0642\u0637\u0631'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Katar','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039a\u03b1\u03c4\u03ac\u03c1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'Catar','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ab\u30bf\u30fc\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uce74\ud0c0\ub974'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*de','ps':'*aa','pt':'*ga','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041a\u0430\u0442\u0430\u0440'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e01\u0e32\u0e15\u0e32\u0e23\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Ca-ta','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5361\u5854\u5c14'),'zu':'*aa',},
  'RE': {'aa':'Reunion','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a1\u03b5\u03cb\u03bd\u03b9\u03cc\u03bd'),'en':'*aa','eo':'*aa','es':u('Reuni\u00f3n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('La R\u00e9union'),'fy':'*aa','ga':u('R\u00e9union'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*ga','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*ga','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ec\u30e6\u30cb\u30aa\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub9ac\uc720\ub2c8\uc5b8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*ga','mt':'*ga','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Reuni\u00e3o'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0420\u0435\u0438\u043d\u0438\u043e\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*ga','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7559\u5c3c\u6c6a\u5c9b'),'zu':'*aa',},
  'RO': {'aa':'Romania','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('Rum\u00e4nien'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a1\u03bf\u03c5\u03bc\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Rumania','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Roumanie','fy':'*aa','ga':u('An R\u00f3m\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30eb\u30fc\u30de\u30cb\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub8e8\ub9c8\ub2c8\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Rumanija','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Rumunia','ps':'*aa','pt':u('Rom\u00eania'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':u('Rom\u00e2nia'),'ru':u('\u0420\u0443\u043c\u044b\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0420\u0443\u043c\u0443\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e23\u0e39\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Ru-ma-ni','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7f57\u9a6c\u5c3c\u4e9a'),'zu':'*aa',},
  'RS': {'aa':'Serbia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Serbien','dv':'*aa','dz':'*aa','ee':'*aa','el':'*aa','en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Serbie','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30bb\u30eb\u30d3\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc138\ub974\ube44\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u585e\u5c14\u7ef4\u4e9a'),'zu':'*aa',},
  'RU': {'aa':'Russia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('R\u00fassia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Russland','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a1\u03c9\u03c3\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Rusia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':u('Ven\u00e4j\u00e4'),'fj':'*aa','fo':'*aa','fr':'Russie','fy':'*aa','ga':u('C\u00f3naidhm na R\u00faise'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*es','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*es','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30ed\u30b7\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub7ec\uc2dc\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Russja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Rosja','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0420\u043e\u0441\u0441\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0420\u0443\u0441\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Ryssland','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e23\u0e31\u0e2a\u0e40\u0e0b\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Nga','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4fc4\u7f57\u65af'),'zu':'*aa',},
  'RW': {'aa':'Rwanda','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Ruanda','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a1\u03bf\u03c5\u03ac\u03bd\u03c4\u03b1'),'en':'*aa','eo':'*aa','es':'*de','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*de','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*de','iu':'*aa','iw':'*aa','ja':u('\u30eb\u30ef\u30f3\u30c0'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub974\uc644\ub2e4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*de','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0420\u0443\u0430\u043d\u0434\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e23\u0e32\u0e27\u0e31\u0e25\u0e14\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Ru-an-\u0111a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5362\u65fa\u8fbe'),'zu':'*aa',},
  'SA': {'aa':'Saudi Arabia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Ar\u00e0bia Saud\u00ed'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Saudi-Arabien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03b1\u03bf\u03c5\u03b4\u03b9\u03ba\u03ae \u0391\u03c1\u03b1\u03b2\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Arabia Saudita','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Arabie Saoudite','fy':'*aa','ga':u('An Araib Sh\u00e1dach'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Arab Saudi','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*es','iu':'*aa','iw':'*aa','ja':u('\u30b5\u30a6\u30b8\u30a2\u30e9\u30d3\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc0ac\uc6b0\ub514\uc544\ub77c\ube44\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':u('G\u0127arabja Sawdita'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Arabia Saudyjska','ps':'*aa','pt':u('Ar\u00e1bia Saudita'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u0430\u0443\u0434\u043e\u0432\u0441\u043a\u0430\u044f \u0410\u0440\u0430\u0432\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0430\u0443\u0434\u0438\u0458\u0441\u043a\u0430 \u0410\u0440\u0430\u0431\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Saudiarabien','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e0b\u0e32\u0e2d\u0e38\u0e14\u0e34\u0e2d\u0e32\u0e23\u0e30\u0e40\u0e1a\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('A-r\u1eadp X\u00ea-\u00fat'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6c99\u7279\u963f\u62c9\u4f2f'),'zu':'*aa',},
  'SB': {'aa':'Solomon Islands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Solomon-Inseln','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u03a3\u03bf\u03bb\u03bf\u03bc\u03ce\u03bd\u03c4\u03bf\u03c2'),'en':'*aa','eo':'*aa','es':u('Islas Salom\u00f3n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00celes Salomon'),'fy':'*aa','ga':u('Oile\u00e1in Solomon'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kepulauan Solomon','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Isole Solomon','iu':'*aa','iw':'*aa','ja':u('\u30bd\u30ed\u30e2\u30f3\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc194\ub85c\ubaac \uc81c\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Ilhas Salom\u00e3o'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Salomon\u00f6arna'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Qu\u1ea7n \u0111\u1ea3o X\u00f4-l\u00f4-m\u00f4ng'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6240\u7f57\u95e8\u7fa4\u5c9b'),'zu':'*aa',},
  'SC': {'aa':'Seychelles','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Seychellen','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03b5\u03cb\u03c7\u03ad\u03bb\u03bb\u03b5\u03c2'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Na S\u00e9is\u00e9il'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30bb\u30a4\u30b7\u30a7\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc250\uc774\uc258'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Seszele','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u0435\u0439\u0448\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u041e\u0441\u0442\u0440\u043e\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0435\u0458\u0448\u0435\u043b\u0438'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Seychellerna','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e0b\u0e22\u0e4c\u0e41\u0e0a\u0e25\u0e25\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('X\u00e2y-sen'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u585e\u820c\u5c14\u7fa4\u5c9b'),'zu':'*aa',},
  'SD': {'aa':'Sudan','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0627\u0644\u0633\u0648\u062f\u0627\u0646'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03bf\u03c5\u03b4\u03ac\u03bd'),'en':'*aa','eo':'*aa','es':u('Sud\u00e1n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Soudan','fy':'*aa','ga':u('An tS\u00fad\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b9\u30fc\u30c0\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc218\ub2e8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Sud\u00e3o'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u0443\u0434\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e0b\u0e39\u0e14\u0e32\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Xu-\u0111\u0103ng'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u82cf\u4e39'),'zu':'*aa',},
  'SE': {'aa':'Sweden','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Su\u00e8cia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Schweden','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03bf\u03c5\u03b7\u03b4\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Suecia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Ruotsi','fj':'*aa','fo':'*aa','fr':u('Su\u00e8de'),'fy':'*aa','ga':'An tSualainn','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Svezia','iu':'*aa','iw':'*aa','ja':u('\u30b9\u30a6\u30a7\u30fc\u30c7\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc2a4\uc6e8\ub374'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('\u017bvezja'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Szwecja','ps':'*aa','pt':u('Su\u00e9cia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0428\u0432\u0435\u0446\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0428\u0432\u0435\u0434\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Sverige','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2a\u0e27\u0e35\u0e40\u0e14\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Th\u1ee5y \u0110i\u1ec3n'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u745e\u5178'),'zu':'*aa',},
  'SG': {'aa':'Singapore','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Singapur','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*ca','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03b9\u03b3\u03ba\u03b1\u03c0\u03bf\u03cd\u03c1\u03b7'),'en':'*aa','eo':'*aa','es':'*ca','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Singapour','fy':'*aa','ga':u('Singeap\u00f3r'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Singapura','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b7\u30f3\u30ac\u30dd\u30fc\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc2f1\uac00\ud3ec\ub974'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':'Singapor','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*ca','ps':'*aa','pt':'Cingapura','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2a\u0e34\u0e07\u0e04\u0e42\u0e1b\u0e23\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Xin-ga-po','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u65b0\u52a0\u5761'),'zu':'*aa',},
  'SH': {'aa':'Saint Helena','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'St. Helena','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03b3\u03af\u03b1 \u0395\u03bb\u03ad\u03bd\u03b7'),'en':'*aa','eo':'*aa','es':'Santa Helena','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Sainte-H\u00e9l\u00e8ne'),'fy':'*aa','ga':u('San H\u00e9ilin'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Sant\'Elena','iu':'*aa','iw':'*aa','ja':u('\u30bb\u30f3\u30c8\u30d8\u30ec\u30ca\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc138\uc778\ud2b8 \ud5ec\ub808\ub098'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0432\u0435\u0442\u0430 \u0408\u0435\u043b\u0435\u043d\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5723\u8d6b\u52d2\u62ff\u5c9b'),'zu':'*aa',},
  'SI': {'aa':'Slovenia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Eslov\u00e8nia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Slowenien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03bb\u03bf\u03b2\u03b5\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Eslovenia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Slov\u00e9nie'),'fy':'*aa','ga':u('An tSl\u00f3v\u00e9in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b9\u30ed\u30d9\u30cb\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc2ac\ub85c\ubca0\ub2c8\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Slovenja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('S\u0142owenia'),'ps':'*aa','pt':u('Eslov\u00eania'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'Slovenija','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Slovenien','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2a\u0e42\u0e25\u0e27\u0e34\u0e40\u0e19\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Xl\u00f4-ven-ni-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u65af\u6d1b\u6587\u5c3c\u4e9a'),'zu':'*aa',},
  'SJ': {'aa':'Svalbard And Jan Mayen','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Svalbard und Jan Mayen','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u03a3\u03b2\u03ac\u03bb\u03bc\u03c0\u03b1\u03c1 \u03ba\u03b1\u03b9 \u0393\u03b9\u03b1\u03bd \u039c\u03b1\u03b3\u03b9\u03ad\u03bd'),'en':'*aa','eo':'*aa','es':'Svalbard y Jan Mayen','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Svalbard et Jan Mayen','fy':'*aa','ga':'Svalbard agus Jan Mayen','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Svalbard dan Jan Mayen','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Svalbard e Jan Mayen','iu':'*aa','iw':'*aa','ja':u('\u30b9\u30d0\u30fc\u30eb\u30d0\u30eb\u8af8\u5cf6\u30fb\u30e4\u30f3\u30de\u30a4\u30a8\u30f3\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc2a4\ubc1c\ubc14\ub974 \ubc0f \uc580\ub9c8\uc6ec'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Svalbard and Jan Mayen','mt':'*ms','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*it','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0432\u0430\u043b\u0431\u0430\u0440\u0434 \u0438 \u0408\u0430\u043d\u043c\u0430\u0458\u0435\u043d \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Svalbard och Jan Mayen','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u65af\u74e6\u5c14\u5df4\u7279\u548c\u626c\u9a6c\u5ef6\u5c9b'),'zu':'*aa',},
  'SK': {'aa':'Slovakia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Eslov\u00e0quia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Slowakei','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03bb\u03bf\u03b2\u03b1\u03ba\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Eslovaquia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Slovaquie','fy':'*aa','ga':u('An tSl\u00f3vaic'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Slovacchia','iu':'*aa','iw':'*aa','ja':u('\u30b9\u30ed\u30d0\u30ad\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc2ac\ub85c\ubc14\ud0a4\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Slovakkja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('S\u0142owacja'),'ps':'*aa','pt':u('Eslov\u00e1quia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u043b\u043e\u0432\u0430\u043a\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':u('Slovensk\u00e1 republika'),'sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u043b\u043e\u0432\u0430\u0447\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Slovakien','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2a\u0e42\u0e25\u0e27\u0e32\u0e40\u0e01\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Xl\u00f4-va-ki-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u65af\u6d1b\u4f10\u514b'),'zu':'*aa',},
  'SL': {'aa':'Sierra Leone','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03b9\u03ad\u03c1\u03b1 \u039b\u03b5\u03cc\u03bd\u03b5'),'en':'*aa','eo':'*aa','es':'Sierra Leona','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'Siarra Leon','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b7\u30a8\u30e9\u30ec\u30aa\u30cd'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc2dc\uc5d0\ub77c\ub9ac\uc628'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Siera Leon','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Serra Leoa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u044c\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0438\u0458\u0435\u0440\u0430 \u041b\u0435\u043e\u043d\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e0b\u0e35\u0e22\u0e23\u0e4c\u0e23\u0e48\u0e32\u0e25\u0e35\u0e2d\u0e2d\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Xi-\u00ea-ra L\u00ea-\u00f4n'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u585e\u62c9\u91cc\u6602'),'zu':'*aa',},
  'SM': {'aa':'San Marino','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0386\u03b3\u03b9\u03bf\u03c2 \u039c\u03b1\u03c1\u03af\u03bd\u03bf\u03c2'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Saint-Marin','fy':'*aa','ga':u('San Mair\u00edne'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b5\u30f3\u30de\u30ea\u30ce'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc0b0\ub9c8\ub9ac\ub178'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0430\u043d \u041c\u0430\u0440\u0438\u043d\u043e'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Xan Ma-ri-n\u00f4'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5723\u9a6c\u529b\u8bfa'),'zu':'*aa',},
  'SN': {'aa':'Senegal','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03b5\u03bd\u03b5\u03b3\u03ac\u03bb\u03b7'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('S\u00e9n\u00e9gal'),'fy':'*aa','ga':u('An tSeineag\u00e1il'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30bb\u30cd\u30ac\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc138\ub124\uac08'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u0435\u043d\u0435\u0433\u0430\u043b'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e0b\u0e34\u0e19\u0e35\u0e01\u0e31\u0e25'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('X\u00ea-n\u00ea-gan'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u585e\u5185\u52a0\u5c14'),'zu':'*aa',},
  'SO': {'aa':'Somalia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Som\u00e0lia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03bf\u03bc\u03b1\u03bb\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Somalie','fy':'*aa','ga':u('An tSom\u00e1il'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30bd\u30de\u30ea\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc18c\ub9d0\ub9ac\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Somalja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Som\u00e1lia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u043e\u043c\u0430\u043b\u0438'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u043e\u043c\u0430\u043b\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e0b\u0e21\u0e32\u0e40\u0e25\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('X\u00f4-ma-li'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7d22\u9a6c\u91cc'),'zu':'*aa',},
  'SR': {'aa':'Suriname','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Surinam','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03bf\u03c5\u03c1\u03b9\u03bd\u03ac\u03bc'),'en':'*aa','eo':'*aa','es':'*ca','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'Suranam','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b9\u30ea\u30ca\u30e0'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc218\ub9ac\ub0a8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*ca','mt':'*ca','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*ca','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u0443\u0440\u0438\u043d\u0430\u043c'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*ca','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e0b\u0e39\u0e23\u0e34\u0e19\u0e32\u0e21\u0e34'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Xu-ri-nam','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u82cf\u91cc\u5357'),'zu':'*aa',},
  'ST': {'aa':'Sao Tome And Principe','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Sao Tome und Principe','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03ac\u03bf \u03a4\u03bf\u03bc\u03ad \u03ba\u03b1\u03b9 \u03a0\u03c1\u03af\u03bd\u03c3\u03b9\u03c0\u03b5'),'en':'*aa','eo':'*aa','es':u('Santo Tom\u00e9 y Pr\u00edncipe'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Sao Tom\u00e9 et Principe'),'fy':'*aa','ga':'Sao Tome agus Principe','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Sao Tome dan Principe','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':u('S\u00e3o Tom\u00e9 e Principe'),'iu':'*aa','iw':'*aa','ja':u('\u30b5\u30f3\u30c8\u30e1\u30fb\u30d7\u30ea\u30f3\u30b7\u30da'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc0c1\ud22c\uba54 \ud504\ub9b0\uc2dc\ud398'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':'Sao Tome and Principe','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('S\u00e3o Tom\u00e9 e Pr\u00edncipe'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0430\u043e \u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0446\u0438\u043f\u0438'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('S\u00e3o Tom\u00e9 och Pr\u00edncipe'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Xao T\u00f4-m\u00ea v\u00e0 Prin-xi-p\u00ea'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4'),'zu':'*aa',},
  'SV': {'aa':'El Salvador','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0395\u03bb \u03a3\u03b1\u03bb\u03b2\u03b1\u03b4\u03cc\u03c1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An tSalvad\u00f3ir'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a8\u30eb\u30b5\u30eb\u30d0\u30c9\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc5d8\uc0b4\ubc14\ub3c4\ub974'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Salwador','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0430\u043b\u0432\u0430\u0434\u043e\u0440'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e2d\u0e25\u0e0b\u0e32\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('En-san-va-\u0111o'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8428\u5c14\u74e6\u591a'),'zu':'*aa',},
  'SX': {'aa':'Sint Maarten (Dutch part)','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':'*aa','en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':'*aa','ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':'*aa','kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*aa','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':'*aa','zu':'*aa',},
  'SY': {'aa':'Syria','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0633\u0648\u0631\u064a\u0627'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('S\u00edria'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Syrien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03c5\u03c1\u03af\u03b1, \u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03ae \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1 \u03c4\u03b7\u03c2'),'en':'*aa','eo':'*aa','es':'Siria','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Syrie','fy':'*aa','ga':'An tSiria','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*es','iu':'*aa','iw':'*aa','ja':u('\u30b7\u30ea\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc2dc\ub9ac\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Sirja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u0438\u0440\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0438\u0440\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e0b\u0e35\u0e40\u0e23\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Xi-ri','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u53d9\u5229\u4e9a'),'zu':'*aa',},
  'SZ': {'aa':'Swaziland','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Swazil\u00e0ndia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Swasiland','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03bf\u03c5\u03b1\u03b6\u03b9\u03bb\u03ac\u03bd\u03b4\u03b7'),'en':'*aa','eo':'*aa','es':'Suazilandia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'An tSuasalainn','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b9\u30ef\u30b8\u30e9\u30f3\u30c9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc2a4\uc640\uc9c8\ub79c\ub4dc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Swa\u017ciland'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Suazi','ps':'*aa','pt':u('Suazil\u00e2ndia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2a\u0e27\u0e32\u0e0b\u0e34\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Xoa-di-len','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u65af\u5a01\u58eb\u5170'),'zu':'*aa',},
  'TC': {'aa':'Turks And Caicos Islands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Turks- und Caicos-Inseln','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u03a4\u03b5\u03c1\u03ba\u03c2 \u03ba\u03b1\u03b9 \u039a\u03ac\u03b9\u03ba\u03bf\u03c2'),'en':'*aa','eo':'*aa','es':'Islas Turcas y Caicos','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00celes Turks et Caicos'),'fy':'*aa','ga':u('Oile\u00e1in Turks agus Caicos'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Isole Turks e Caicos','iu':'*aa','iw':'*aa','ja':u('\u30bf\u30fc\u30af\u30b9\u8af8\u5cf6\u30fb\u30ab\u30a4\u30b3\u30b9\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud130\ud06c\uc2a4 \ucf00\uc774\ucee4\uc2a4 \uc81c\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Turks and Caicos Islands','mt':'*ms','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Ilhas Turks e Caicos','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0422\u0443\u0440\u043a\u0441 \u0438 \u041a\u0430\u0458\u043a\u043e\u0441 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Turks- och Caicos\u00f6arna'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7279\u514b\u65af\u7fa4\u5c9b\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b'),'zu':'*aa',},
  'TD': {'aa':'Chad','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Txad','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Tschad','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03c3\u03b1\u03bd\u03c4'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Tchad','fy':'*aa','ga':'Sead','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Ciad','iu':'*aa','iw':'*aa','ja':u('\u30c1\u30e3\u30c9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ucc28\ub4dc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Cad','mt':u('\u010aad'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Czad','ps':'*aa','pt':'Chade','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0427\u0430\u0434'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*fr','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e0a\u0e32\u0e14'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('S\u00e1t'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e4d\u5f97'),'zu':'*aa',},
  'TF': {'aa':'French Southern Territories','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Territoris Meridionals Francesos ??','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('Franz\u00f6sische S\u00fcdgebiete'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ac \u039d\u03cc\u03c4\u03b9\u03b1 \u0395\u03b4\u03ac\u03c6\u03b7'),'en':'*aa','eo':'*aa','es':'Territorios Franceses del Sur','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Territoires Fran\u00e7ais du Sud'),'fy':'*aa','ga':u('Cr\u00edocha Francacha Theas'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Territori Francesi d\'Oltremare','iu':'*aa','iw':'*aa','ja':u('\u30d5\u30e9\u30f3\u30b9\u9818\u6975\u5357\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud504\ub791\uc2a4 \ub0a8\ubd80 \uc9c0\ubc29'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Territorji Fran\u010bi\u017ci ta\u2019 Nofsinhar'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Francuskie Terytoria Zamorskie','ps':'*aa','pt':u('Territ\u00f3rios Franceses do Sul'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0435 \u044e\u0436\u043d\u044b\u0435 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0435 \u0408\u0443\u0436\u043d\u0435 \u0422\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0458\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Franska s\u00f6dra territorierna'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e32\u0e13\u0e32\u0e40\u0e02\u0e15\u0e17\u0e32\u0e07\u0e43\u0e15\u0e49\u0e02\u0e2d\u0e07\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6cd5\u5c5e\u5357\u7279\u7acb\u5c3c\u8fbe'),'zu':'*aa',},
  'TG': {'aa':'Togo','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03cc\u03b3\u03ba\u03bf'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('T\u00f3ga'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30c8\u30fc\u30b4'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud1a0\uace0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0422\u043e\u0433\u043e'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e15\u0e42\u0e01'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('T\u00f4-g\u00f4'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u591a\u54e5'),'zu':'*aa',},
  'TH': {'aa':'Thailand','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Tail\u00e0ndia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03b1\u03ca\u03bb\u03ac\u03bd\u03b4\u03b7'),'en':'*aa','eo':'*aa','es':'Tailandia','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Tha\u00eflande'),'fy':'*aa','ga':u('An T\u00e9alainn'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Thailandia','iu':'*aa','iw':'*aa','ja':u('\u30bf\u30a4'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud0dc\uad6d'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Tajlandja','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Tajlandia','ps':'*aa','pt':u('Tail\u00e2ndia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0422\u0430\u0438\u043b\u0430\u043d\u0434'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0422\u0430\u0458\u043b\u0430\u043d\u0434'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1b\u0e23\u0e30\u0e40\u0e17\u0e28\u0e44\u0e17\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Th\u00e1i Lan'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6cf0\u56fd'),'zu':'*aa',},
  'TJ': {'aa':'Tajikistan','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Tadjikistan','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Tadschikistan','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03b1\u03c4\u03b6\u03b9\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd'),'en':'*aa','eo':'*aa','es':u('Tayikist\u00e1n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*ca','fy':'*aa','ga':u('An T\u00e1ids\u00edceast\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Tagikistan','iu':'*aa','iw':'*aa','ja':u('\u30bf\u30b8\u30ad\u30b9\u30bf\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*ca','mt':u('Ta\u0121ikistan'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Tad\u017cykistan'),'ps':'*aa','pt':u('Tadjiquist\u00e3o'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0422\u0430\u0434\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0422\u0430\u045f\u0438\u043a\u0438\u0441\u0442\u0430\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Tadzjikistan','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e17\u0e32\u0e08\u0e34\u0e01\u0e34\u0e2a\u0e16\u0e32\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('T\u00e1t-gi-ki-xtan'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5854\u5409\u514b\u65af\u5766'),'zu':'*aa',},
  'TK': {'aa':'Tokelau','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03bf\u03ba\u03b5\u03bb\u03ac\u03bf\u03c5'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('T\u00f3cal\u00e1'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30c8\u30b1\u30e9\u30a6\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud1a0\ucf08\ub77c\uc6b0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Tokelaw','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0422\u043e\u043a\u0435\u043b\u0430\u0443'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e42\u0e17\u0e01\u0e34\u0e42\u0e25'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8054\u5408\u7fa4\u5c9b'),'zu':'*aa',},
  'TL': {'aa':'Timor-Leste','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03cc \u03a4\u03b9\u03bc\u03cc\u03c1'),'en':'*aa','eo':'*aa','es':'Timor Oriental','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('T\u00edom\u00f3r-Leste'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Timor Leste','iu':'*aa','iw':'*aa','ja':u('\u6771\u30c6\u30a3\u30e2\u30fc\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub3d9\ud2f0\ubaa8\ub974'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Timor tal-Lvant','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*it','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0422\u0438\u043c\u043e\u0440-\u041b\u0435\u0441\u0442\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e1c\u5e1d\u6c76'),'zu':'*aa',},
  'TM': {'aa':'Turkmenistan','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03bf\u03c5\u03c1\u03ba\u03bc\u03b5\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd'),'en':'*aa','eo':'*aa','es':u('Turkmenist\u00e1n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Turkm\u00e9nistan'),'fy':'*aa','ga':u('An Tuircm\u00e9anast\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30c8\u30eb\u30af\u30e1\u30cb\u30b9\u30bf\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Turcomenist\u00e3o'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e15\u0e34\u0e23\u0e4c\u0e01\u0e40\u0e21\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Tu\u1ed1c-m\u00ea-ni-xtan'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u571f\u5e93\u66fc\u65af\u5766'),'zu':'*aa',},
  'TN': {'aa':'Tunisia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u062a\u0648\u0646\u0633'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Tun\u00edsia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Tunesien','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03c5\u03bd\u03b7\u03c3\u03af\u03b1'),'en':'*aa','eo':'*aa','es':u('T\u00fanez'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Tunisie','fy':'*aa','ga':u('An T\u00fain\u00e9is'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30c1\u30e5\u30cb\u30b8\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud280\ub2c8\uc9c0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Tune\u017c'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Tunezja','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0422\u0443\u043d\u0438\u0441'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'Tunisien','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e15\u0e39\u0e19\u0e34\u0e40\u0e0b\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Tuy-ni-di','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7a81\u5c3c\u65af'),'zu':'*aa',},
  'TO': {'aa':'Tonga','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03cc\u03bd\u03b3\u03ba\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30c8\u30f3\u30ac'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud1b5\uac00'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0422\u043e\u043d\u0433\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e17\u0e2d\u0e07\u0e01\u0e49\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('T\u00f4ng-ga'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6c64\u52a0'),'zu':'*aa',},
  'TR': {'aa':'Turkey','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Turquia','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('T\u00fcrkei'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03bf\u03c5\u03c1\u03ba\u03af\u03b1'),'en':'*aa','eo':'*aa','es':u('Turqu\u00eda'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Turkki','fj':'*aa','fo':'*aa','fr':'Turquie','fy':'*aa','ga':'An Tuirc','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Turchia','iu':'*aa','iw':'*aa','ja':u('\u30c8\u30eb\u30b3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud130\ud0a4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Turki','mt':'Turkija','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Turcja','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0422\u0443\u0440\u0446\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0422\u0443\u0440\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Turkiet','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e15\u0e38\u0e23\u0e01\u0e35'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':u('T\u00fcrkiye'),'ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Th\u1ed5 Nh\u0129 K\u1ef3'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u571f\u8033\u5176'),'zu':'*aa',},
  'TT': {'aa':'Trinidad and Tobago','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Trinitat i Tobago','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Trinidad und Tobago','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03c1\u03b9\u03bd\u03b9\u03b4\u03ac\u03b4 \u03ba\u03b1\u03b9 \u03a4\u03bf\u03bc\u03c0\u03ac\u03b3\u03ba\u03bf'),'en':'*aa','eo':'*aa','es':'Trinidad y Tobago','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Trinit\u00e9-et-Tobago'),'fy':'*aa','ga':u('Oile\u00e1in na Tr\u00edon\u00f3ide agus Tob\u00e1ga'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Trinidad dan Tobago','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Trinidad e Tobago','iu':'*aa','iw':'*aa','ja':u('\u30c8\u30ea\u30cb\u30c0\u30fc\u30c9\u30fb\u30c8\u30d0\u30b4'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud2b8\ub9ac\ub2c8\ub2e4\ub4dc \ud1a0\ubc14\uace0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':'Trinidad u Tobago','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Trynidad i Tobago','ps':'*aa','pt':'*it','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0438 \u0422\u043e\u0431\u0430\u0433\u043e'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'Trinidad och Tobago','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e17\u0e23\u0e34\u0e19\u0e34\u0e41\u0e14\u0e14 \u0e41\u0e25\u0e30\u0e42\u0e17\u0e1a\u0e32\u0e42\u0e01'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Tri-ni-\u0111\u00e1t v\u00e0 T\u00f4-ba-g\u00f4'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5'),'zu':'*aa',},
  'TV': {'aa':'Tuvalu','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03bf\u03c5\u03b2\u03b1\u03bb\u03bf\u03cd'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Tuval\u00fa'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30c4\u30d0\u30eb'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud22c\ubc1c\ub8e8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0422\u0443\u0432\u0430\u043b\u0443'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Tu-va-lu','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u56fe\u74e6\u5362'),'zu':'*aa',},
  'TW': {'aa':'Taiwan','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03b1\u03ca\u03b2\u03ac\u03bd'),'en':'*aa','eo':'*aa','es':u('Taiw\u00e1n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An T\u00e9av\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u53f0\u6e7e'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub300\ub9cc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Tajwan','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*mt','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0422\u0430\u0439\u0432\u0430\u043d\u044c'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0422\u0430\u0458\u0432\u0430\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e44\u0e15\u0e49\u0e2b\u0e27\u0e31\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('\u0110\u00e0i Loan'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u53f0\u6e7e\u5730\u533a'),'zu':'*aa',},
  'TZ': {'aa':'Tanzania','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Tanz\u00e0nia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Tansania','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a4\u03b1\u03bd\u03b6\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Tanzanie','fy':'*aa','ga':u('An Tans\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30bf\u30f3\u30b6\u30cb\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ud0c4\uc790\ub2c8\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('Tan\u017canija'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Tanz\u00e2nia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e17\u0e32\u0e19\u0e0b\u0e32\u0e40\u0e19\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Tan-da-ni-a','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5766\u6851\u5c3c\u4e9a'),'zu':'*aa',},
  'UA': {'aa':'Ukraine','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Ucra\u00efna'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039f\u03c5\u03ba\u03c1\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'Ucrania','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An \u00dacr\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Ukraina','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Ucraina','iu':'*aa','iw':'*aa','ja':u('\u30a6\u30af\u30e9\u30a4\u30ca'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc6b0\ud06c\ub77c\uc774\ub098'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*id','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*id','ps':'*aa','pt':u('Ucr\u00e2nia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0423\u043a\u0440\u0430\u0438\u043d\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0423\u043a\u0440\u0430\u0458\u0438\u043d\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*id','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e22\u0e39\u0e40\u0e04\u0e23\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':u('\u0423\u043a\u0440\u0430\u0457\u043d\u0430'),'ur':'*aa','uz':'*aa','ve':'*aa','vi':'U-crai-na','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e4c\u514b\u5170'),'zu':'*aa',},
  'UG': {'aa':'Uganda','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039f\u03c5\u03b3\u03ba\u03ac\u03bd\u03c4\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Ouganda','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a6\u30ac\u30f3\u30c0'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc6b0\uac04\ub2e4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0423\u0433\u0430\u043d\u0434\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e39\u0e01\u0e32\u0e19\u0e14\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('U-gan-\u0111a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e4c\u5e72\u8fbe'),'zu':'*aa',},
  'UM': {'aa':'United States Minor Outlying Islands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('\u00dcbrige Inseln im Pazifik der USA'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03c0\u03bf\u03bc\u03b1\u03ba\u03c1\u03c5\u03c3\u03bc\u03ad\u03bd\u03b5\u03c2 \u039d\u03b7\u03c3\u03af\u03b4\u03b5\u03c2 \u03c4\u03c9\u03bd \u0397\u03bd\u03c9\u03bc\u03ad\u03bd\u03c9\u03bd \u03a0\u03bf\u03bb\u03b9\u03c4\u03b5\u03b9\u03ce\u03bd'),'en':'*aa','eo':'*aa','es':'Islas menores alejadas de los Estados Unidos','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('D\u00e9pendances am\u00e9ricaines du Pacifique'),'fy':'*aa','ga':u('Mion-Oile\u00e1in Imeallacha S.A.M.'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Isole minori lontane degli Stati Uniti','iu':'*aa','iw':'*aa','ja':u('\u7c73\u9818\u592a\u5e73\u6d0b\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubbf8\uad6d\ub839 \uad70\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'Ilhas Menores Distantes dos Estados Unidos','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0430\u045a\u0430 \u0443\u0434\u0430\u0459\u0435\u043d\u0430 \u043e\u0441\u0442\u0440\u0432\u0430 \u0421\u0410\u0414'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('F\u00f6renta staternas mindre \u00f6ar i Oceanien och V\u00e4stindien'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7f8e\u5c5e\u5c0f\u5965\u7279\u5170\u7fa4\u5c9b'),'zu':'*aa',},
  'US': {'aa':'United States','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Estats Units','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Vereinigte Staaten von Amerika','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0397\u03bd\u03c9\u03bc\u03ad\u03bd\u03b5\u03c2 \u03a0\u03bf\u03bb\u03b9\u03c4\u03b5\u03af\u03b5\u03c2'),'en':'*aa','eo':'*aa','es':'Estados Unidos','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'Yhdysvallat','fj':'*aa','fo':'*aa','fr':'Etats-Unis','fy':'*aa','ga':u('St\u00e1it Aontaithe Mheirice\u00e1'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':u('\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u091c\u094d\u092f \u0905\u092e\u0947\u0930\u093f\u0915\u093e'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Amerika Serikat','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Stati Uniti','iu':'*aa','iw':'*aa','ja':u('\u30a2\u30e1\u30ea\u30ab\u5408\u8846\u56fd'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubbf8\uad6d'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Amerika Syarikat','mt':'*it','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Stany Zjednoczone Ameryki','ps':'*aa','pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u043d\u044b\u0435 \u0428\u0442\u0430\u0442\u044b'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0458\u0435\u0434\u0438\u045a\u0435\u043d\u0435 \u0410\u043c\u0435\u0440\u0438\u0447\u043a\u0435 \u0414\u0440\u0436\u0430\u0432\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Amerikas F\u00f6renta Stater'),'sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Hoa K\u1ef3'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7f8e\u56fd'),'zu':'*aa',},
  'UY': {'aa':'Uruguay','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Uruguai','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039f\u03c5\u03c1\u03bf\u03c5\u03b3\u03bf\u03c5\u03ac\u03b7'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'Urugua','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a6\u30eb\u30b0\u30a2\u30a4'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc6b0\ub8e8\uacfc\uc774'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Urugwaj','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*mt','ps':'*aa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0423\u0440\u0443\u0433\u0432\u0430\u0439'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0423\u0440\u0443\u0433\u0432\u0430\u0458'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e38\u0e23\u0e39\u0e01\u0e27\u0e31\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'U-ru-goay','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e4c\u62c9\u572d'),'zu':'*aa',},
  'UZ': {'aa':'Uzbekistan','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Usbekistan','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039f\u03c5\u03b6\u03bc\u03c0\u03b5\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd'),'en':'*aa','eo':'*aa','es':u('Uzbekist\u00e1n'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Ouzb\u00e9kistan'),'fy':'*aa','ga':u('\u00daisb\u00e9iceast\u00e1in'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a6\u30ba\u30d9\u30ad\u30b9\u30bf\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('U\u017cbekistan'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Uzbequist\u00e3o'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e2d\u0e38\u0e0b\u0e40\u0e1a\u0e01\u0e34\u0e2a\u0e16\u0e32\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('U-d\u01a1-b\u00ea-ki-xtan'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e4c\u5179\u522b\u514b\u65af\u5766'),'zu':'*aa',},
  'VA': {'aa':'Vatican','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Vatic\u00e0'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Vatikanstadt','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03b3\u03af\u03b1 \u0388\u03b4\u03c1\u03b1 (\u0392\u03b1\u03c4\u03b9\u03ba\u03b1\u03bd\u03cc)'),'en':'*aa','eo':'*aa','es':'Ciudad del Vaticano','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An Chathaoir Naofa (St\u00e1t Chathair na Vatac\u00e1ine)'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Vatikan','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':u('Citt\u00e0 del Vaticano'),'iu':'*aa','iw':'*aa','ja':u('\u30d0\u30c1\u30ab\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubc14\ud2f0\uce78'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*id','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Watykan','ps':'*aa','pt':'Vaticano','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0412\u0430\u0442\u0438\u043a\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'Vatikanen','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e27\u0e32\u0e15\u0e34\u0e01\u0e31\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Va-ti-c\u0103ng'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u68b5\u8482\u5188'),'zu':'*aa',},
  'VC': {'aa':'Saint Vincent And The Grenadines','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'St. Vincent und die Grenadinen','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0386\u03b3\u03b9\u03bf\u03c2 \u0392\u03b9\u03ba\u03ad\u03bd\u03c4\u03b9\u03bf\u03c2 \u03ba\u03b1\u03b9 \u0393\u03c1\u03b5\u03bd\u03b1\u03b4\u03af\u03bd\u03b5\u03c2'),'en':'*aa','eo':'*aa','es':'San Vicente y las Granadinas','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Saint-Vincent-et-les Grenadines','fy':'*aa','ga':'Saint Vincent agus na Grenadines','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Saint Vincent dan Grenadines','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Saint Vincent e Grenadine','iu':'*aa','iw':'*aa','ja':u('\u30bb\u30f3\u30c8\u30d3\u30f3\u30bb\u30f3\u30c8\u304a\u3088\u3073\u30b0\u30ec\u30ca\u30c7\u30a3\u30fc\u30f3\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc138\uc778\ud2b8 \ube48\uc13c\ud2b8 \uadf8\ub808\ub098\ub518\uc2a4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':'Saint Vincent and the Grenadines','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('S\u00e3o Vicente e Granadinas'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0435\u043d\u0442 \u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0438 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d\u0438'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Saint Vincent och Grenadinerna','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Xan Vin-xen v\u00e0 Gr\u00ea-na-din'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af'),'zu':'*aa',},
  'VE': {'aa':'Venezuela','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Vene\u00e7uela'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0392\u03b5\u03bd\u03b5\u03b6\u03bf\u03c5\u03ad\u03bb\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('V\u00e9n\u00e9zuela'),'fy':'*aa','ga':u('Veinis\u00e9ala'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d9\u30cd\u30ba\u30a8\u30e9'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubca0\ub124\uc218\uc5d8\ub77c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Venezwela','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Wenezuela','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0412\u0435\u043d\u0435\u0446\u0443\u0435\u043b\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e27\u0e40\u0e19\u0e0b\u0e39\u0e40\u0e2d\u0e25\u0e48\u0e32'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('V\u00ea-n\u00ea-zu-\u00ea-la'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u59d4\u5185\u745e\u62c9'),'zu':'*aa',},
  'VG': {'aa':'British Virgin Islands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Illes Verges Brit\u00e0niques'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Britische Jungferninseln','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0392\u03c1\u03b5\u03c4\u03b1\u03bd\u03b9\u03ba\u03ad\u03c2 \u03a0\u03b1\u03c1\u03b8\u03ad\u03bd\u03bf\u03b9 \u039d\u03ae\u03c3\u03bf\u03b9'),'en':'*aa','eo':'*aa','es':u('Islas V\u00edrgenes Brit\u00e1nicas'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Iles Vierges Britanniques','fy':'*aa','ga':u('Oile\u00e1in Bhriotanacha na Maighdean'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kepulauan British Virgin','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Isole Vergini (GB)','iu':'*aa','iw':'*aa','ja':u('\u82f1\u9818\u30d0\u30fc\u30b8\u30f3\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc601\uad6d\ub839 \ubc84\uc9c4 \uc544\uc77c\ub79c\ub4dc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Dziewicze Wyspy Brytyjskie','ps':'*aa','pt':u('Ilhas Virgens Brit\u00e2nicas'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0438\u0435 \u0412\u0438\u0440\u0433\u0438\u043d\u0441\u043a\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0430 \u0414\u0435\u0432\u0438\u0447\u0430\u043d\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Brittiska Virgin Islands','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e1a\u0e23\u0e34\u0e17\u0e34\u0e0a\u0e40\u0e27\u0e2d\u0e23\u0e4c\u0e08\u0e34\u0e19\u0e44\u0e2d\u0e2a\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u82f1\u5c5e\u7ef4\u4eac\u7fa4\u5c9b'),'zu':'*aa',},
  'VI': {'aa':'U.S. Virgin Islands','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Illes Verges dels USA','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Amerikanische Jungferninseln','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03b1\u03bd\u03b9\u03ba\u03ad\u03c2 \u03a0\u03b1\u03c1\u03b8\u03ad\u03bd\u03bf\u03b9 \u039d\u03ae\u03c3\u03bf\u03b9'),'en':'*aa','eo':'*aa','es':u('Islas V\u00edrgenes Americanas'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Iles Vierges Am\u00e9ricaines'),'fy':'*aa','ga':u('Oile\u00e1in na Maighdean S.A.M.'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Kepulauan U.S. Virgin','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Isole Vergini (USA)','iu':'*aa','iw':'*aa','ja':u('\u7c73\u9818\u30d0\u30fc\u30b8\u30f3\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubbf8\uad6d\ub839 \ubc84\uc9c4 \uc544\uc77c\ub79c\ub4dc'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Dziewicze Wyspy Stan\u00f3w Zjednoczonych'),'ps':'*aa','pt':'Ilhas Virgens dos EUA','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0412\u0438\u0440\u0433\u0438\u043d\u0441\u043a\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430 \u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u043d\u044b\u0445 \u0428\u0442\u0430\u0442\u043e\u0432'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421.\u0410.\u0414. \u0414\u0435\u0432\u0438\u0447\u0430\u043d\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Amerikanska Virgin Islands','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e22\u0e39\u0e40\u0e2d\u0e2a\u0e40\u0e27\u0e2d\u0e23\u0e4c\u0e08\u0e34\u0e19\u0e44\u0e2d\u0e2a\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u7f8e\u5c5e\u7ef4\u4eac\u7fa4\u5c9b'),'zu':'*aa',},
  'VN': {'aa':'Vietnam','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0392\u03b9\u03b5\u03c4\u03bd\u03ac\u03bc'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('V\u00edtneam'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d9\u30c8\u30ca\u30e0'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubca0\ud2b8\ub0a8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Vjetnam','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'Wietnam','ps':'*aa','pt':u('Vietn\u00e3'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0412\u044c\u0435\u0442\u043d\u0430\u043c'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0412\u0438\u0458\u0435\u0442\u043d\u0430\u043c'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e27\u0e35\u0e22\u0e14\u0e19\u0e32\u0e21'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Vi\u1ec7t Nam'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8d8a\u5357'),'zu':'*aa',},
  'VU': {'aa':'Vanuatu','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0392\u03b1\u03bd\u03bf\u03c5\u03ac\u03c4\u03bf\u03c5'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Vanuat\u00fa'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30d0\u30cc\u30a2\u30c4'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ubc14\ub204\uc544\ud22c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Vanwatu','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0412\u0430\u043d\u0443\u0430\u0442\u0443'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e27\u0e32\u0e19\u0e31\u0e27\u0e15\u0e39'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Va-nu-a-tu','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u74e6\u52aa\u963f\u56fe'),'zu':'*aa',},
  'WF': {'aa':'Wallis And Futuna','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Wallis und Futuna','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u039f\u03c5\u03b1\u03bb\u03bb\u03af\u03c2 \u03ba\u03b1\u03b9 \u03a6\u03bf\u03c5\u03c4\u03bf\u03c5\u03bd\u03ac'),'en':'*aa','eo':'*aa','es':'Wallis y Futuna','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Wallis-et-Futuna','fy':'*aa','ga':u('Oile\u00e1in Vail\u00eds agus Fut\u00fana'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Wallis dan Futuna','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Wallis e Futuna','iu':'*aa','iw':'*aa','ja':u('\u30ef\u30ea\u30b9\u30fb\u30d5\u30c6\u30e5\u30ca\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc70c\ub9ac\uc2a4 \ud478\ud22c\ub098'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'Wallis and Futuna','mt':'*ms','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*it','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0412\u0430\u043b\u0438\u0441 \u0438 \u0424\u0443\u0442\u0443\u043d\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Wallis och Futuna','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u74e6\u5229\u65af\u7fa4\u5c9b\u548c\u5bcc\u56fe\u7eb3\u7fa4\u5c9b'),'zu':'*aa',},
  'WS': {'aa':'Samoa','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a3\u03b1\u03bc\u03cc\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Sam\u00f3'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u897f\u30b5\u30e2\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc0ac\ubaa8\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'*aa','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*aa','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0421\u0430\u043c\u043e\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':'*aa','ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Xa-moa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':'*zh','zu':'*aa',},
  'YE': {'aa':'Yemen','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':u('\u0627\u0644\u064a\u0645\u0646'),'as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'Iemen','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Jemen','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u03a5\u03b5\u03bc\u03ad\u03bd\u03b7'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Y\u00e9men'),'fy':'*aa','ga':u('\u00c9imin'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Yaman','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30a4\u30a8\u30e1\u30f3'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc608\uba58'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':'*de','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*de','ps':'*aa','pt':u('I\u00eamen'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0419\u0435\u043c\u0435\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0408\u0435\u043c\u0435\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e40\u0e22\u0e40\u0e21\u0e19'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Y-\u00ea-men'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e5f\u95e8'),'zu':'*aa',},
  'YT': {'aa':'Mayotte','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039c\u03b1\u03b3\u03b9\u03cc\u03c4'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'Mayotta','iu':'*aa','iw':'*aa','ja':u('\u30de\u30e8\u30c3\u30c8\u5cf6'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub9c8\uc694\ud2f0'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':'Majotte','my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u041c\u0430\u0439\u043e\u0442\u0442\u0435'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u041c\u0430\u0458\u043e\u0442\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e21\u0e32\u0e22\u0e2d\u0e15'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u9a6c\u7ea6\u7279\u5c9b'),'zu':'*aa',},
  'ZA': {'aa':'South Africa','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Sud-\u00e0frica'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('S\u00fcdafrika'),'dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u039d\u03cc\u03c4\u03b9\u03b1 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae'),'en':'*aa','eo':'*aa','es':u('Sud\u00e1frica'),'et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Afrique du Sud','fy':'*aa','ga':'An Afraic Theas','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'Afrika Selatan','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Sudafrica','iu':'*aa','iw':'*aa','ja':u('\u5357\u30a2\u30d5\u30ea\u30ab'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\ub0a8\uc544\ud504\ub9ac\uce74'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*id','mt':u('Afrika t\u2019Isfel'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':u('Republika Po\u0142udniowej Afryki'),'ps':'*aa','pt':u('\u00c1frica do Sul'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u042e\u0436\u043d\u0430\u044f \u0410\u0444\u0440\u0438\u043a\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0408\u0443\u0436\u043d\u043e\u0430\u0444\u0440\u0438\u0447\u043a\u0430 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Sydafrika ','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e43\u0e15\u0e49'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':'Nam Phi','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5357\u975e'),'zu':'*aa',},
  'ZM': {'aa':'Zambia','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Z\u00e0mbia'),'ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Sambia','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0396\u03ac\u03bc\u03c0\u03b9\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Zambie','fy':'*aa','ga':'An tSaimbia','gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b6\u30f3\u30d3\u30a2'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc7a0\ube44\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('\u017bambja'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Z\u00e2mbia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0417\u0430\u043c\u0431\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':u('\u0417\u0430\u043c\u0431\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e41\u0e0b\u0e21\u0e40\u0e1a\u0e35\u0e22'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('D\u0103m-bi-a'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8d5e\u6bd4\u4e9a'),'zu':'*aa',},
  'ZW': {'aa':'Zimbabwe','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':'*aa','an':'*aa','ar':'*aa','as':'*aa','av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':'*aa','bg':'*aa','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*aa','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*aa','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Simbabwe','dv':'*aa','dz':'*aa','ee':'*aa','el':u('\u0396\u03b9\u03bc\u03c0\u03ac\u03bc\u03c0\u03bf\u03c5\u03b5'),'en':'*aa','eo':'*aa','es':'Zimbabue','et':'*aa','eu':'*aa','fa':'*aa','ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('An tSiomb\u00e1ib'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':'*aa','gv':'*aa','ha':'*aa','he':'*aa','hi':'*aa','ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':'*aa','hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*aa','ja':u('\u30b8\u30f3\u30d0\u30d6\u30a8'),'ji':'*aa','jv':'*aa','ka':'*aa','kg':'*aa','ki':'*aa','kj':'*aa','kk':'*aa','kl':'*aa','km':'*aa','kn':'*aa','ko':u('\uc9d0\ubc14\ube0c\uc6e8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*aa','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':'*aa','lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*aa','ml':'*aa','mn':'*aa','mo':'*aa','mr':'*aa','ms':'*aa','mt':u('\u017bimbabwe'),'my':'*aa','na':'*aa','nb':'*aa','nd':'*aa','ne':'*aa','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':'*aa','os':'*aa','pa':'*aa','pi':'*aa','pl':'*aa','ps':'*aa','pt':u('Zimb\u00e1bwe'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':u('\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*aa','se':'*aa','sg':'*aa','si':'*aa','sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*ru','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':'*aa','te':'*aa','tg':'*aa','th':u('\u0e0b\u0e34\u0e21\u0e1a\u0e32\u0e1a\u0e40\u0e27'),'ti':'*aa','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':'*aa','uk':'*aa','ur':'*aa','uz':'*aa','ve':'*aa','vi':u('Dim-ba-bu-\u00ea'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6d25\u5df4\u5e03\u97e6'),'zu':'*aa',},
}
