/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.PaletteListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;

public abstract class PaletteButton
extends JButton
implements MouseListener,
MouseMotionListener {
    static final int NORMAL = 1;
    static final int PRESSED = 2;
    static final int SELECTED = 3;
    private PaletteListener fListener;
    private int fState;
    private int fOldState;

    public PaletteButton(PaletteListener listener) {
        this.fListener = listener;
        this.fOldState = 1;
        this.fState = 1;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public Object value() {
        return null;
    }

    public String name() {
        return "";
    }

    public void reset() {
        if (this.isEnabled()) {
            this.fState = 1;
            this.setSelected(false);
            this.repaint();
        }
    }

    public void select() {
        if (this.isEnabled()) {
            this.fState = 3;
            this.setSelected(true);
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.isEnabled()) {
            this.fOldState = this.fState;
            this.fState = 2;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isEnabled()) {
            this.fState = this.contains(e.getX(), e.getY()) ? 2 : this.fOldState;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.isEnabled()) {
            this.fState = this.fOldState;
            this.repaint();
            if (this.contains(e.getX(), e.getY())) {
                this.fListener.paletteUserSelected(this);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.fListener.paletteUserOver(this, true);
    }

    public void mouseExited(MouseEvent e) {
        if (this.fState == 2) {
            this.mouseDragged(e);
        }
        this.fListener.paletteUserOver(this, false);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }
}

