/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Stack;
import org.freehep.graphics2d.TagHandler;
import org.freehep.graphics2d.TagString;

public class GenericTagHandler
extends TagHandler {
    private static final float scriptShiftRatio = 0.5f;
    private static final float scriptSizeFactor = 0.6666667f;
    private static final String mM = "mM";
    private Graphics2D graphics;
    private boolean vertical;
    private float buffered;
    private float overlineStart;
    private float overlineEnd;
    private float x;
    private float y;
    private float miny;
    private float maxy;
    private boolean print = false;
    private Stack fontStack;

    public GenericTagHandler(Graphics2D graphics) {
        this.graphics = graphics;
    }

    public void print(TagString s, double x, double y) {
        this.x = (float)x;
        this.miny = this.y = (float)y;
        this.maxy = this.y;
        this.fontStack = new Stack();
        this.print = true;
        this.vertical = false;
        this.buffered = 0.0f;
        this.parse(s);
    }

    private float stringWidth(TagString s) {
        this.x = 0.0f;
        this.miny = this.y = 0.0f;
        this.maxy = this.y;
        this.fontStack = new Stack();
        this.print = false;
        this.vertical = false;
        this.buffered = 0.0f;
        this.parse(s);
        return this.x;
    }

    public Rectangle2D stringSize(TagString s) {
        this.x = 0.0f;
        this.miny = this.y = 0.0f;
        this.maxy = this.y;
        this.fontStack = new Stack();
        this.print = false;
        this.vertical = false;
        this.buffered = 0.0f;
        this.parse(s);
        return new Rectangle2D.Float(0.0f, this.miny, this.x, this.maxy - this.miny);
    }

    protected String openTag(String tag) {
        Font font = this.graphics.getFont();
        FontRenderContext fontContext = this.graphics.getFontRenderContext();
        if (tag.equalsIgnoreCase("b")) {
            if (!font.isBold()) {
                this.graphics.setFont(font.deriveFont(1));
            }
        } else if (tag.equalsIgnoreCase("i")) {
            if (!font.isItalic()) {
                this.graphics.setFont(font.deriveFont(2));
            }
        } else if (tag.equalsIgnoreCase("tt")) {
            this.fontStack.push(font);
            this.graphics.setFont(new Font("Courier", 0, font.getSize()));
        } else if (tag.equalsIgnoreCase("v")) {
            this.vertical = true;
        } else if (tag.equalsIgnoreCase("over")) {
            this.overlineStart = this.x;
        } else if (tag.equalsIgnoreCase("sup")) {
            this.y -= font.getLineMetrics(mM, fontContext).getAscent() * 0.5f;
            this.fontStack.push(font);
            this.graphics.setFont(font.deriveFont(font.getSize2D() * 0.6666667f));
        } else if (tag.equalsIgnoreCase("sub")) {
            this.y += font.getLineMetrics(mM, fontContext).getAscent() * 0.5f;
            this.fontStack.push(font);
            this.graphics.setFont(font.deriveFont(font.getSize2D() * 0.6666667f));
        } else {
            return super.openTag(tag);
        }
        return "";
    }

    protected String closeTag(String tag) {
        if (tag.equalsIgnoreCase("b")) {
            Font font = this.graphics.getFont();
            if (font.isBold()) {
                this.graphics.setFont(font.deriveFont(font.getStyle() - 1));
            }
        } else if (tag.equalsIgnoreCase("i")) {
            Font font = this.graphics.getFont();
            if (font.isItalic()) {
                this.graphics.setFont(font.deriveFont(font.getStyle() - 2));
            }
        } else if (tag.equalsIgnoreCase("tt")) {
            this.graphics.setFont((Font)this.fontStack.pop());
        } else if (tag.equalsIgnoreCase("v")) {
            this.vertical = false;
        } else if (tag.equalsIgnoreCase("over")) {
            if (this.print) {
                LineMetrics metrics = this.graphics.getFont().getLineMetrics(mM, this.graphics.getFontRenderContext());
                float ascent = metrics.getAscent();
                GeneralPath path = new GeneralPath();
                path.moveTo(this.overlineStart, this.y - ascent);
                path.lineTo(this.overlineEnd, this.y - ascent);
                this.graphics.draw(path);
            }
        } else if (tag.equalsIgnoreCase("sup")) {
            this.graphics.setFont((Font)this.fontStack.pop());
            this.y += this.graphics.getFont().getLineMetrics(mM, this.graphics.getFontRenderContext()).getAscent() * 0.5f;
        } else if (tag.equalsIgnoreCase("sub")) {
            this.graphics.setFont((Font)this.fontStack.pop());
            this.y -= this.graphics.getFont().getLineMetrics(mM, this.graphics.getFontRenderContext()).getAscent() * 0.5f;
        } else {
            return super.closeTag(tag);
        }
        return "";
    }

    protected String text(String text) {
        Font font = this.graphics.getFont();
        FontRenderContext fontContext = this.graphics.getFontRenderContext();
        LineMetrics metrics = this.graphics.getFont().getLineMetrics(text, fontContext);
        float width = (float)font.getStringBounds(text, fontContext).getWidth();
        float descent = metrics.getDescent();
        float ascent = metrics.getAscent();
        if (!this.vertical && this.buffered > 0.0f) {
            this.x += this.buffered;
            this.buffered = 0.0f;
        }
        if (this.print) {
            this.graphics.drawString(text, this.x, this.y);
        }
        if (this.vertical) {
            this.buffered = Math.max(this.buffered, width);
            this.overlineEnd = this.x + width;
        } else {
            this.x += width;
            this.overlineEnd = this.x;
        }
        this.miny = Math.min(this.miny, this.y - ascent);
        this.maxy = Math.max(this.maxy, this.y + descent);
        return text;
    }
}

