/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.encode;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.owasp.jbrofuzz.encode.EncoderHashFrame;
import org.owasp.jbrofuzz.ui.menu.AboutBox;
import org.owasp.jbrofuzz.version.ImageCreator;

public class EncoderHashMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 4335762453196377717L;
    private final JMenu file = new JMenu("File");
    private final JMenu help = new JMenu("Help");
    private final JMenuItem exit = new JMenuItem("Exit", ImageCreator.IMG_EXIT);
    private final JMenuItem disclaimer;
    private final JMenuItem about;

    public EncoderHashMenuBar(final EncoderHashFrame mEncoderHashFrame) {
        this.exit.setAccelerator(KeyStroke.getKeyStroke(49, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.disclaimer = new JMenuItem("Disclaimer", ImageCreator.IMG_DISCLAIMER);
        this.about = new JMenuItem("About", ImageCreator.IMG_ABOUT);
        this.about.setAccelerator(KeyStroke.getKeyStroke(48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        mEncoderHashFrame.closeFrame();
                    }
                });
            }
        });
        this.disclaimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new AboutBox(mEncoderHashFrame, AboutBox.Tab.DISCLAIMER);
                    }
                });
            }
        });
        this.about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new AboutBox(mEncoderHashFrame, AboutBox.Tab.ABOUT);
                    }
                });
            }
        });
        this.file.add(this.exit);
        this.help.add(this.disclaimer);
        this.help.add(this.about);
        this.add(this.file);
        this.add(this.help);
    }
}

