/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk.impl.http;

import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.brk.impl.http.HttpBreakpointMessage;
import org.zaproxy.zap.extension.brk.impl.http.HttpBreakpointsUiManagerInterface;
import org.zaproxy.zap.view.StandardFieldsDialog;

public class BreakAddEditDialog
extends StandardFieldsDialog {
    private static final String FIELD_LOCATION = "brk.brkpoint.location.label";
    private static final String FIELD_MATCH = "brk.brkpoint.match.label";
    private static final String FIELD_STRING = "brk.brkpoint.string.label";
    private static final String FIELD_INVERSE = "brk.brkpoint.inverse.label";
    private static final String FIELD_IGNORECASE = "brk.brkpoint.ignorecase.label";
    private static final long serialVersionUID = 1L;
    private HttpBreakpointsUiManagerInterface breakPointsManager;
    private boolean add = false;
    private HttpBreakpointMessage breakpoint;

    public BreakAddEditDialog(HttpBreakpointsUiManagerInterface httpBreakpointsUiManagerInterface, Frame frame, Dimension dimension) {
        super(frame, "brk.brkpoint.add.title", dimension);
        this.breakPointsManager = httpBreakpointsUiManagerInterface;
    }

    public void init(HttpBreakpointMessage httpBreakpointMessage, boolean bl) {
        this.add = bl;
        this.breakpoint = httpBreakpointMessage;
        this.removeAllFields();
        if (bl) {
            this.setTitle(Constant.messages.getString("brk.brkpoint.add.title"));
        } else {
            this.setTitle(Constant.messages.getString("brk.brkpoint.edit.title"));
        }
        this.addComboField(FIELD_LOCATION, this.getLocations(), this.locToStr(httpBreakpointMessage.getLocation()));
        this.addComboField(FIELD_MATCH, this.getMatches(), this.matchToStr(httpBreakpointMessage.getMatch()));
        this.addTextField(FIELD_STRING, httpBreakpointMessage.getString());
        this.addCheckBoxField(FIELD_INVERSE, httpBreakpointMessage.isInverse());
        this.addCheckBoxField(FIELD_IGNORECASE, httpBreakpointMessage.isIgnoreCase());
        this.addPadding();
    }

    private List<String> getLocations() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HttpBreakpointMessage.Location location : HttpBreakpointMessage.Location.values()) {
            arrayList.add(this.locToStr(location));
        }
        return arrayList;
    }

    private String locToStr(HttpBreakpointMessage.Location location) {
        return Constant.messages.getString("brk.brkpoint.location." + location.name());
    }

    private HttpBreakpointMessage.Location strToLoc(String string) {
        for (HttpBreakpointMessage.Location location : HttpBreakpointMessage.Location.values()) {
            if (!this.locToStr(location).equals(string)) continue;
            return location;
        }
        return null;
    }

    private List<String> getMatches() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HttpBreakpointMessage.Match match : HttpBreakpointMessage.Match.values()) {
            arrayList.add(this.matchToStr(match));
        }
        return arrayList;
    }

    private String matchToStr(HttpBreakpointMessage.Match match) {
        return Constant.messages.getString("brk.brkpoint.match." + match.name());
    }

    private HttpBreakpointMessage.Match strToMatch(String string) {
        for (HttpBreakpointMessage.Match match : HttpBreakpointMessage.Match.values()) {
            if (!this.matchToStr(match).equals(string)) continue;
            return match;
        }
        return null;
    }

    @Override
    public void save() {
        HttpBreakpointMessage httpBreakpointMessage = new HttpBreakpointMessage(this.getStringValue(FIELD_STRING), this.strToLoc(this.getStringValue(FIELD_LOCATION)), this.strToMatch(this.getStringValue(FIELD_MATCH)), this.getBoolValue(FIELD_INVERSE), this.getBoolValue(FIELD_IGNORECASE));
        if (this.add) {
            this.breakPointsManager.addBreakpoint(httpBreakpointMessage);
            this.breakPointsManager.hideAddDialog();
        } else {
            this.breakPointsManager.editBreakpoint(this.breakpoint, httpBreakpointMessage);
            this.breakpoint = null;
            this.breakPointsManager.hideEditDialog();
        }
    }

    @Override
    public String validateFields() {
        if (this.isEmptyField(FIELD_STRING)) {
            return Constant.messages.getString("brk.brkpoint.error.nostr");
        }
        if (HttpBreakpointMessage.Match.regex.equals((Object)this.strToMatch(this.getStringValue(FIELD_MATCH)))) {
            try {
                Pattern.compile(this.getStringValue(FIELD_STRING));
            }
            catch (Exception exception) {
                return Constant.messages.getString("brk.brkpoint.error.regex");
            }
        }
        return null;
    }

    @Override
    public void cancelPressed() {
        if (this.add) {
            this.breakPointsManager.hideAddDialog();
        } else {
            this.breakPointsManager.hideEditDialog();
        }
    }
}

