/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import org.parosproxy.paros.Constant;

public class Tech
implements Comparable<Tech> {
    public static final Tech Db = new Tech("Db", "technologies.db");
    public static final Tech MySQL = new Tech(Db, "MySQL");
    public static final Tech PostgreSQL = new Tech(Db, "PostgreSQL");
    public static final Tech MsSQL = new Tech(Db, "Microsoft SQL Server");
    public static final Tech Oracle = new Tech(Db, "Oracle");
    public static final Tech SQLite = new Tech(Db, "SQLite");
    public static final Tech Access = new Tech(Db, "Microsoft Access");
    public static final Tech Firebird = new Tech(Db, "Firebird");
    public static final Tech MaxDB = new Tech(Db, "SAP MaxDB");
    public static final Tech Sybase = new Tech(Db, "Sybase");
    public static final Tech Db2 = new Tech(Db, "IBM DB2");
    public static final Tech HypersonicSQL = new Tech(Db, "HypersonicSQL");
    public static final Tech Lang = new Tech("Language", "technologies.lang");
    public static final Tech ASP = new Tech(Lang, "ASP");
    public static final Tech C = new Tech(Lang, "C");
    public static final Tech PHP = new Tech(Lang, "PHP");
    public static final Tech XML = new Tech(Lang, "XML");
    public static final Tech OS = new Tech("OS", "technologies.os");
    public static final Tech Linux = new Tech(OS, "Linux");
    public static final Tech MacOS = new Tech(OS, "MacOS");
    public static final Tech Windows = new Tech(OS, "Windows");
    public static final Tech SCM = new Tech("SCM", "technologies.scm");
    public static final Tech Git = new Tech(SCM, "Git");
    public static final Tech SVN = new Tech(SCM, "SVN");
    public static final Tech WS = new Tech("WS", "technologies.ws");
    public static final Tech Apache = new Tech(WS, "Apache");
    public static final Tech IIS = new Tech(WS, "IIS");
    public static final Tech Tomcat = new Tech(WS, "Tomcat");
    public static final Tech[] builtInTech = new Tech[]{Db, MySQL, PostgreSQL, MsSQL, Oracle, SQLite, Access, Firebird, MaxDB, Sybase, Db2, HypersonicSQL, Lang, ASP, C, PHP, XML, OS, Linux, MacOS, Windows, SCM, Git, SVN, WS, Apache, IIS, Tomcat};
    public static final Tech[] builtInTopLevelTech = new Tech[]{Db, Lang, OS, SCM, WS};
    private Tech parent = null;
    private String name = null;
    private String keyUiName;

    public Tech(String string) {
        this(string, null);
    }

    public Tech(String string, String string2) {
        if (string.indexOf(".") > 0) {
            this.name = string.substring(string.lastIndexOf(".") + 1);
            this.parent = new Tech(string.substring(0, string.lastIndexOf(".")));
        } else {
            this.name = string;
        }
        this.keyUiName = string2;
    }

    public Tech(Tech tech, String string) {
        this(tech, string, null);
    }

    public Tech(Tech tech, String string, String string2) {
        this.parent = tech;
        this.name = string;
        this.keyUiName = string2;
    }

    public String toString() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.toString() + "." + this.name;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean is(Tech tech) {
        if (tech == null) {
            return false;
        }
        Tech tech2 = this;
        while (tech2 != null) {
            if (tech == tech2) {
                return true;
            }
            tech2 = tech2.parent;
        }
        return false;
    }

    public Tech getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getUiName() {
        if (this.keyUiName == null) {
            return this.getName();
        }
        return Constant.messages.getString(this.keyUiName);
    }

    @Override
    public int compareTo(Tech tech) {
        if (tech == null) {
            return -1;
        }
        return this.toString().compareTo(tech.toString());
    }
}

