/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.ContextsTreeCellRenderer;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.SiteMapListener;
import org.zaproxy.zap.view.SiteMapTreeCellRenderer;

public class NodeSelectDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private JTree treeContext = null;
    private JTree treeSite = null;
    private JButton selectButton = null;
    private JButton cancelButton = null;
    private DefaultTreeModel contextTree = null;
    private DefaultTreeModel siteTree = null;
    private JScrollPane jScrollPane = null;
    private SiteNode selectedSiteNode = null;
    private Target selectedTarget = null;
    private boolean allowRoot = false;

    public NodeSelectDialog(Window window) throws HeadlessException {
        super(window, true);
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Constant.messages.getString("siteselect.dialog.title"));
        this.setContentPane(this.getJPanel());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NodeSelectDialog.this.cancelButton.doClick();
            }
        });
        this.pack();
    }

    public SiteNode showDialog(URI uRI) {
        return this.showDialog(Model.getSingleton().getSession().getSiteTree().findNode(uRI));
    }

    public SiteNode showDialog(SiteNode siteNode) {
        this.getTreeContext().setVisible(false);
        SiteNode siteNode2 = (SiteNode)Model.getSingleton().getSession().getSiteTree().getRoot();
        this.populateNode(siteNode2, (SiteNode)this.siteTree.getRoot(), siteNode);
        if (this.selectedSiteNode != null) {
            TreePath treePath = new TreePath(this.siteTree.getPathToRoot(this.selectedSiteNode));
            this.getTreeSite().setExpandsSelectedPaths(true);
            this.getTreeSite().setSelectionPath(treePath);
            this.getTreeSite().scrollPathToVisible(treePath);
            this.getTreeSite().expandPath(treePath);
        } else {
            TreePath treePath = new TreePath(this.siteTree.getPathToRoot((TreeNode)this.siteTree.getRoot()));
            this.getTreeSite().expandPath(treePath);
        }
        this.setVisible(true);
        return this.selectedSiteNode;
    }

    public Target showDialog(Target target) {
        this.getTreeContext().setVisible(true);
        SiteNode siteNode = (SiteNode)Model.getSingleton().getSession().getSiteTree().getRoot();
        this.populateContexts((SiteNode)this.contextTree.getRoot());
        if (target != null) {
            this.populateNode(siteNode, (SiteNode)this.siteTree.getRoot(), target.getStartNode());
        } else {
            this.populateNode(siteNode, (SiteNode)this.siteTree.getRoot(), null);
        }
        if (this.selectedSiteNode != null) {
            TreePath treePath = new TreePath(this.siteTree.getPathToRoot(this.selectedSiteNode));
            this.getTreeSite().setExpandsSelectedPaths(true);
            this.getTreeSite().setSelectionPath(treePath);
            this.getTreeSite().scrollPathToVisible(treePath);
            this.getTreeSite().expandPath(treePath);
        } else {
            TreePath treePath = new TreePath(this.siteTree.getPathToRoot((TreeNode)this.siteTree.getRoot()));
            this.getTreeSite().expandPath(treePath);
        }
        this.setVisible(true);
        if (this.selectedSiteNode != null) {
            return new Target(this.selectedSiteNode);
        }
        return this.selectedTarget;
    }

    private void populateContexts(SiteNode siteNode) {
        int n = 0;
        for (Context context : Model.getSingleton().getSession().getContexts()) {
            if (context.getIncludeInContextRegexs().size() <= 0) continue;
            SiteNode siteNode2 = new SiteNode(null, 1, context.getName());
            siteNode2.setUserObject(new Target(context));
            siteNode.add(siteNode2);
            if (!context.isInScope()) continue;
            ++n;
        }
        if (n > 1) {
            SiteNode siteNode3 = new SiteNode(null, 1, Constant.messages.getString("context.allInScope"));
            siteNode3.setUserObject(new Target(null, null, true, true));
            siteNode.add(siteNode3);
        }
        this.getTreeContext().expandRow(0);
    }

    private void populateNode(SiteNode siteNode, SiteNode siteNode2, SiteNode siteNode3) {
        if (siteNode.equals(siteNode3)) {
            this.selectedSiteNode = siteNode2;
        }
        for (int i = 0; i < siteNode.getChildCount(); ++i) {
            SiteNode siteNode4 = (SiteNode)siteNode.getChildAt(i);
            SiteNode siteNode5 = new SiteNode(null, 1, siteNode4.getNodeName());
            siteNode5.setUserObject(siteNode4);
            siteNode2.add(siteNode5);
            this.populateNode(siteNode4, siteNode5, siteNode3);
        }
    }

    private DefaultTreeModel emptyContextTree() {
        return new DefaultTreeModel(new SiteNode(null, -1, Constant.messages.getString("context.list")));
    }

    private DefaultTreeModel emptySiteTree() {
        SiteNode siteNode = (SiteNode)Model.getSingleton().getSession().getSiteTree().getRoot();
        SiteNode siteNode2 = new SiteNode(null, -1, Constant.messages.getString("tab.sites"));
        siteNode2.setUserObject(siteNode);
        return new DefaultTreeModel(siteNode2);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setPreferredSize(DisplayUtils.getScaledDimension(400, 400));
            this.jPanel.setMinimumSize(DisplayUtils.getScaledDimension(400, 400));
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 5;
            gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints4.anchor = 13;
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridy = 5;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 10);
            gridBagConstraints3.anchor = 13;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 5;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(2, 10, 2, 5);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 10;
            this.jPanel.add((Component)this.getJScrollPane(), gridBagConstraints);
            this.jPanel.add((Component)jLabel, gridBagConstraints2);
            this.jPanel.add((Component)this.getCancelButton(), gridBagConstraints4);
            this.jPanel.add((Component)this.getSelectButton(), gridBagConstraints3);
        }
        return this.jPanel;
    }

    private JTree getTreeSite() {
        if (this.treeSite == null) {
            this.siteTree = this.emptySiteTree();
            this.treeSite = new JTree(this.siteTree);
            this.treeSite.setShowsRootHandles(true);
            this.treeSite.setName("nodeSelectTree");
            this.treeSite.setToggleClickCount(1);
            this.treeSite.getSelectionModel().setSelectionMode(1);
            this.treeSite.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    SiteNode siteNode = (SiteNode)NodeSelectDialog.this.treeSite.getLastSelectedPathComponent();
                    NodeSelectDialog.this.getSelectButton().setEnabled(siteNode != null && (siteNode.getParent() != null || NodeSelectDialog.this.allowRoot));
                }
            });
            this.treeSite.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.mouseClicked(mouseEvent);
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (NodeSelectDialog.this.treeSite.getLastSelectedPathComponent() != null) {
                        NodeSelectDialog.this.getTreeContext().clearSelection();
                    }
                    if (mouseEvent.getClickCount() > 1) {
                        NodeSelectDialog.this.nodeSelected();
                    }
                }
            });
            this.treeSite.setCellRenderer(new SiteMapTreeCellRenderer(new ArrayList<SiteMapListener>()));
        }
        return this.treeSite;
    }

    private void nodeSelected() {
        SiteNode siteNode = (SiteNode)this.treeSite.getLastSelectedPathComponent();
        if (siteNode != null && (siteNode.getParent() != null || this.allowRoot)) {
            this.selectedSiteNode = (SiteNode)siteNode.getUserObject();
            this.selectedTarget = null;
            this.setVisible(false);
        }
    }

    private void contextSelected() {
        SiteNode siteNode = (SiteNode)this.treeContext.getLastSelectedPathComponent();
        if (siteNode != null && (siteNode.getParent() != null || this.allowRoot)) {
            this.selectedTarget = (Target)siteNode.getUserObject();
            this.selectedSiteNode = null;
            this.setVisible(false);
        }
    }

    private JTree getTreeContext() {
        if (this.treeContext == null) {
            this.contextTree = this.emptyContextTree();
            this.treeContext = new JTree(this.contextTree);
            this.treeContext.setShowsRootHandles(true);
            this.treeContext.setName("nodeContextTree");
            this.treeContext.setToggleClickCount(1);
            this.treeContext.getSelectionModel().setSelectionMode(1);
            this.treeContext.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    SiteNode siteNode = (SiteNode)NodeSelectDialog.this.treeContext.getLastSelectedPathComponent();
                    NodeSelectDialog.this.getSelectButton().setEnabled(siteNode != null && (siteNode.getParent() != null || NodeSelectDialog.this.allowRoot));
                }
            });
            this.treeContext.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.mouseClicked(mouseEvent);
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (NodeSelectDialog.this.treeContext.getLastSelectedPathComponent() != null) {
                        NodeSelectDialog.this.getTreeSite().clearSelection();
                    }
                    if (mouseEvent.getClickCount() > 1) {
                        NodeSelectDialog.this.contextSelected();
                    }
                }
            });
            this.treeContext.setCellRenderer(new ContextsTreeCellRenderer());
        }
        return this.treeContext;
    }

    private JButton getSelectButton() {
        if (this.selectButton == null) {
            this.selectButton = new JButton();
            this.selectButton.setText(Constant.messages.getString("siteselect.button.select"));
            this.selectButton.setEnabled(false);
            this.selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (NodeSelectDialog.this.treeSite.getLastSelectedPathComponent() != null) {
                        NodeSelectDialog.this.nodeSelected();
                    } else if (NodeSelectDialog.this.treeContext.getLastSelectedPathComponent() != null) {
                        NodeSelectDialog.this.contextSelected();
                    }
                }
            });
        }
        return this.selectButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(Constant.messages.getString("all.button.cancel"));
            this.cancelButton.setEnabled(true);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NodeSelectDialog.this.selectedSiteNode = null;
                    NodeSelectDialog.this.selectedTarget = null;
                    NodeSelectDialog.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(30);
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)this.getTreeContext(), LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0));
            jPanel.add((Component)this.getTreeSite(), LayoutHelper.getGBC(0, 1, 1, 1.0, 1.0));
            this.jScrollPane.setViewportView(jPanel);
        }
        return this.jScrollPane;
    }

    public boolean isAllowRoot() {
        return this.allowRoot;
    }

    public void setAllowRoot(boolean bl) {
        this.allowRoot = bl;
    }
}

