/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.c.PAL;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.shape.AtomShape;
import org.jmol.shapespecial.Ellipsoid;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Tensor;

public class Ellipsoids
extends AtomShape {
    private static final String PROPERTY_MODES = "ax ce co de eq mo on op sc tr";
    public Map<String, Ellipsoid> simpleEllipsoids = new Hashtable<String, Ellipsoid>();
    public Map<Tensor, Ellipsoid> atomEllipsoids = new Hashtable<Tensor, Ellipsoid>();
    private String typeSelected = "1";
    private BS selectedAtoms;
    private Lst<Ellipsoid> ellipsoidSet;

    public boolean isActive() {
        return !this.atomEllipsoids.isEmpty() || !this.simpleEllipsoids.isEmpty();
    }

    @Override
    public int getIndexFromName(String thisID) {
        return this.checkID(thisID) ? 1 : -1;
    }

    @Override
    protected void setSize(int size, BS bsSelected) {
        Lst<Object> tensors;
        boolean isAll;
        if (this.atoms == null || size == 0 && this.ms.atomTensors == null) {
            return;
        }
        boolean bl = isAll = bsSelected == null;
        if (!isAll && this.selectedAtoms != null) {
            bsSelected = this.selectedAtoms;
        }
        if ((tensors = this.vwr.ms.getAllAtomTensors(this.typeSelected)) == null) {
            return;
        }
        int i = tensors.size();
        while (--i >= 0) {
            boolean isNew;
            Tensor t = (Tensor)tensors.get(i);
            if (!isAll && !t.isSelected(bsSelected, -1)) continue;
            Ellipsoid e = this.atomEllipsoids.get(t);
            boolean bl2 = isNew = size != 0 && e == null;
            if (isNew) {
                e = Ellipsoid.getEllipsoidForAtomTensor(t, this.atoms[t.atomIndex1]);
                this.atomEllipsoids.put(t, e);
            }
            if (e == null || !isNew && size == Integer.MAX_VALUE) continue;
            e.setScale(size, true);
        }
    }

    @Override
    public boolean getPropertyData(String property, Object[] data) {
        if (property == "checkID") {
            return this.checkID((String)data[0]);
        }
        return this.getPropShape(property, data);
    }

    private boolean checkID(String thisID) {
        Ellipsoid e;
        this.ellipsoidSet = new Lst();
        if (thisID == null) {
            return false;
        }
        if (PT.isWild(thisID = thisID.toLowerCase())) {
            for (Map.Entry<String, Ellipsoid> e2 : this.simpleEllipsoids.entrySet()) {
                String key = e2.getKey().toLowerCase();
                if (!PT.isMatch(key, thisID, true, true)) continue;
                this.ellipsoidSet.addLast(e2.getValue());
            }
        }
        if ((e = this.simpleEllipsoids.get(thisID)) != null) {
            this.ellipsoidSet.addLast(e);
        }
        return this.ellipsoidSet.size() > 0;
    }

    private boolean initEllipsoids(Object value) {
        boolean haveID = value != null;
        this.checkID((String)value);
        if (haveID) {
            this.typeSelected = null;
        }
        this.selectedAtoms = null;
        return haveID;
    }

    @Override
    public void initShape() {
        this.setProperty("thisID", null, null);
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        if (propertyName == "thisID") {
            if (this.initEllipsoids(value) && this.ellipsoidSet.size() == 0) {
                String id = (String)value;
                Ellipsoid e = Ellipsoid.getEmptyEllipsoid(id, this.vwr.am.cmi);
                this.ellipsoidSet.addLast(e);
                this.simpleEllipsoids.put(id, e);
            }
            return;
        }
        if ("atoms" == propertyName) {
            this.selectedAtoms = (BS)value;
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int modelIndex = ((int[])((Object[])value)[2])[0];
            Iterator<Ellipsoid> e = this.simpleEllipsoids.values().iterator();
            while (e.hasNext()) {
                if (e.next().tensor.modelIndex != modelIndex) continue;
                e.remove();
            }
            e = this.atomEllipsoids.values().iterator();
            while (e.hasNext()) {
                if (e.next().modelIndex != modelIndex) continue;
                e.remove();
            }
            this.ellipsoidSet.clear();
            return;
        }
        int mode = PROPERTY_MODES.indexOf((propertyName + "  ").substring(0, 2));
        if (this.ellipsoidSet.size() > 0) {
            if ("translucentLevel" == propertyName) {
                this.setPropS(propertyName, value, bs);
                return;
            }
            if (mode >= 0) {
                int i = this.ellipsoidSet.size();
                while (--i >= 0) {
                    this.setProp((Ellipsoid)this.ellipsoidSet.get(i), mode / 3, value);
                }
            }
            return;
        }
        if ("color" == propertyName) {
            short colix = C.getColixO(value);
            byte pid = PAL.pidOf(value);
            if (this.selectedAtoms != null) {
                bs = this.selectedAtoms;
            }
            for (Ellipsoid e : this.atomEllipsoids.values()) {
                if (!e.tensor.type.equals(this.typeSelected) || !e.tensor.isSelected(bs, -1)) continue;
                e.colix = this.getColixI(colix, pid, e.tensor.atomIndex1);
                e.pid = pid;
            }
            return;
        }
        if ("on" == propertyName) {
            boolean isOn = (Boolean)value;
            if (this.selectedAtoms != null) {
                bs = this.selectedAtoms;
            }
            if (isOn) {
                this.setSize(Integer.MAX_VALUE, bs);
            }
            for (Ellipsoid e : this.atomEllipsoids.values()) {
                Tensor t = e.tensor;
                if ((t.type.equals(this.typeSelected) || this.typeSelected.equals(t.altType)) && t.isSelected(bs, -1)) {
                    e.isOn = isOn;
                }
                ((Atom)e.center).setShapeVisibility(this.vf, isOn);
            }
            return;
        }
        if ("options" == propertyName) {
            String options = ((String)value).toLowerCase().trim();
            if (options.length() == 0) {
                options = null;
            }
            if (this.selectedAtoms != null) {
                bs = this.selectedAtoms;
            }
            if (options != null) {
                this.setSize(Integer.MAX_VALUE, bs);
            }
            for (Ellipsoid e : this.atomEllipsoids.values()) {
                if (!e.tensor.type.equals(this.typeSelected) || !e.tensor.isSelected(bs, -1)) continue;
                e.options = options;
            }
            return;
        }
        if ("params" == propertyName) {
            Object[] data = (Object[])value;
            data[2] = null;
            this.typeSelected = "0";
            this.setSize(50, bs);
        }
        if ("points" == propertyName) {
            return;
        }
        if ("scale" == propertyName) {
            this.setSize((int)(((Float)value).floatValue() * 100.0f), bs);
            return;
        }
        if ("select" == propertyName) {
            this.typeSelected = ((String)value).toLowerCase();
            return;
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent = value.equals("translucent");
            for (Ellipsoid e : this.atomEllipsoids.values()) {
                if (!e.tensor.type.equals(this.typeSelected) || !e.tensor.isSelected(bs, -1)) continue;
                e.colix = C.getColixTranslucent3(e.colix, isTranslucent, this.translucentLevel);
            }
            return;
        }
        this.setPropS(propertyName, value, bs);
    }

    private void setProp(Ellipsoid e, int mode, Object value) {
        switch (mode) {
            case 0: {
                e.setTensor(((Tensor)Interface.getUtil("Tensor", this.vwr, "script")).setFromAxes((V3[])value));
                return;
            }
            case 1: {
                e.setCenter((P3)value);
                return;
            }
            case 2: {
                e.colix = C.getColixO(value);
                return;
            }
            case 3: {
                this.simpleEllipsoids.remove(e.id);
                return;
            }
            case 4: {
                e.setTensor(((Tensor)Interface.getUtil("Tensor", this.vwr, "script")).setFromThermalEquation((double[])value, null));
                return;
            }
            case 5: {
                e.tensor.modelIndex = (Integer)value;
                return;
            }
            case 6: {
                e.isOn = (Boolean)value;
                return;
            }
            case 7: {
                e.options = ((String)value).toLowerCase();
                return;
            }
            case 8: {
                e.setScale(((Float)value).floatValue(), false);
                return;
            }
            case 9: {
                e.colix = C.getColixTranslucent3(e.colix, value.equals("translucent"), this.translucentLevel);
                return;
            }
        }
    }

    @Override
    public String getShapeState() {
        if (!this.isActive()) {
            return "";
        }
        SB sb = new SB();
        sb.append("\n");
        if (!this.simpleEllipsoids.isEmpty()) {
            this.getStateID(sb);
        }
        if (!this.atomEllipsoids.isEmpty()) {
            this.getStateAtoms(sb);
        }
        return sb.toString();
    }

    private void getStateID(SB sb) {
        V3 v1 = new V3();
        for (Ellipsoid ellipsoid : this.simpleEllipsoids.values()) {
            Tensor t = ellipsoid.tensor;
            if (!ellipsoid.isValid || t == null) continue;
            sb.append("  Ellipsoid ID ").append(ellipsoid.id).append(" modelIndex ").appendI(t.modelIndex).append(" center ").append(Escape.eP(ellipsoid.center)).append(" axes");
            for (int i = 0; i < 3; ++i) {
                v1.setT(t.eigenVectors[i]);
                v1.scale(ellipsoid.lengths[i]);
                sb.append(" ").append(Escape.eP(v1));
            }
            sb.append(" " + Ellipsoids.getColorCommandUnk("", ellipsoid.colix, this.translucentAllowed));
            if (ellipsoid.options != null) {
                sb.append(" options ").append(PT.esc(ellipsoid.options));
            }
            if (!ellipsoid.isOn) {
                sb.append(" off");
            }
            sb.append(";\n");
        }
    }

    private void getStateAtoms(SB sb) {
        BS bsDone = new BS();
        Hashtable<String, BS> temp = new Hashtable<String, BS>();
        Hashtable<String, BS> temp2 = new Hashtable<String, BS>();
        for (Ellipsoid e : this.atomEllipsoids.values()) {
            int iType = e.tensor.iType;
            if (bsDone.get(iType + 1)) continue;
            bsDone.set(iType + 1);
            boolean isADP = e.tensor.iType == 1;
            String cmd = isADP ? null : "Ellipsoids set " + PT.esc(e.tensor.type);
            for (Ellipsoid e2 : this.atomEllipsoids.values()) {
                if (e2.tensor.iType != iType || isADP && !e2.isOn) continue;
                int i = e2.tensor.atomIndex1;
                BSUtil.setMapBitSet(temp, i, i, isADP ? "Ellipsoids " + e2.percent : cmd + " scale " + e2.scale + (e2.options == null ? "" : " options " + PT.esc(e2.options)) + (e2.isOn ? " ON" : " OFF"));
                if (e2.colix == 0) continue;
                BSUtil.setMapBitSet(temp2, i, i, Ellipsoids.getColorCommand(cmd, e2.pid, e2.colix, this.translucentAllowed));
            }
        }
        sb.append(this.vwr.getCommands(temp, temp2, "select"));
    }

    @Override
    public void setModelVisibilityFlags(BS bsModels) {
        if (!this.isActive()) {
            return;
        }
        this.setVis(this.simpleEllipsoids, bsModels, this.atoms);
        this.setVis(this.atomEllipsoids, bsModels, this.atoms);
    }

    private void setVis(Map<?, Ellipsoid> ellipsoids, BS bs, Atom[] atoms) {
        for (Ellipsoid e : ellipsoids.values()) {
            boolean isOK;
            Tensor t = e.tensor;
            boolean bl = isOK = t != null && e.isValid && e.isOn;
            if (isOK && t.atomIndex1 >= 0) {
                if (t.iType == 1) {
                    boolean isModTensor = t.isModulated;
                    boolean isUnmodTensor = t.isUnmodulated;
                    boolean isModAtom = this.ms.isModulated(t.atomIndex1);
                    isOK = !isModTensor && !isUnmodTensor || isModTensor == isModAtom;
                }
                atoms[t.atomIndex1].setShapeVisibility(this.vf, true);
            }
            e.visible = isOK && (e.modelIndex < 0 || bs.get(e.modelIndex));
        }
    }

    @Override
    public void setAtomClickability() {
        if (this.atomEllipsoids.isEmpty()) {
            return;
        }
        for (Ellipsoid e : this.atomEllipsoids.values()) {
            int i = e.tensor.atomIndex1;
            Atom atom = this.atoms[i];
            if ((atom.shapeVisibilityFlags & this.vf) == 0 || this.ms.isAtomHidden(i)) continue;
            atom.setClickable(this.vf);
        }
    }
}

