/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class AwarenessAllocationDecider
extends AllocationDecider {
    public static final String NAME = "awareness";
    public static final String CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTES = "cluster.routing.allocation.awareness.attributes";
    public static final String CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP = "cluster.routing.allocation.awareness.force.";
    private String[] awarenessAttributes;
    private Map<String, String[]> forcedAwarenessAttributes;

    public AwarenessAllocationDecider() {
        this(Settings.Builder.EMPTY_SETTINGS);
    }

    public AwarenessAllocationDecider(Settings settings) {
        this(settings, new NodeSettingsService(settings));
    }

    @Inject
    public AwarenessAllocationDecider(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.awarenessAttributes = settings.getAsArray(CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTES);
        this.forcedAwarenessAttributes = Maps.newHashMap();
        Map<String, Settings> forceGroups = settings.getGroups(CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP);
        for (Map.Entry<String, Settings> entry : forceGroups.entrySet()) {
            String[] aValues = entry.getValue().getAsArray("values");
            if (aValues.length <= 0) continue;
            this.forcedAwarenessAttributes.put(entry.getKey(), aValues);
        }
        nodeSettingsService.addListener(new ApplySettings());
    }

    public String[] awarenessAttributes() {
        return this.awarenessAttributes;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.underCapacity(shardRouting, node, allocation, true);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.underCapacity(shardRouting, node, allocation, false);
    }

    private Decision underCapacity(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, boolean moveToNode) {
        if (this.awarenessAttributes.length == 0) {
            return allocation.decision(Decision.YES, NAME, "no allocation awareness enabled", new Object[0]);
        }
        IndexMetaData indexMetaData = allocation.metaData().index(shardRouting.index());
        int shardCount = indexMetaData.getNumberOfReplicas() + 1;
        for (String awarenessAttribute : this.awarenessAttributes) {
            int requiredCountPerAttribute;
            if (!node.node().attributes().containsKey((Object)awarenessAttribute)) {
                return allocation.decision(Decision.NO, NAME, "node does not contain awareness attribute: [%s]", awarenessAttribute);
            }
            ObjectIntHashMap<String> nodesPerAttribute = allocation.routingNodes().nodesPerAttributesCounts(awarenessAttribute);
            ObjectIntHashMap shardPerAttribute = new ObjectIntHashMap();
            for (ShardRouting assignedShard : allocation.routingNodes().assignedShards(shardRouting)) {
                if (!assignedShard.started() && !assignedShard.initializing()) continue;
                RoutingNode routingNode = allocation.routingNodes().node(assignedShard.currentNodeId());
                shardPerAttribute.addTo(routingNode.node().attributes().get((Object)awarenessAttribute), 1);
            }
            if (moveToNode) {
                if (shardRouting.assignedToNode()) {
                    String nodeId;
                    String string = nodeId = shardRouting.relocating() ? shardRouting.relocatingNodeId() : shardRouting.currentNodeId();
                    if (!node.nodeId().equals(nodeId)) {
                        shardPerAttribute.putOrAdd(allocation.routingNodes().node(nodeId).node().attributes().get((Object)awarenessAttribute), 0, -1);
                        shardPerAttribute.addTo(node.node().attributes().get((Object)awarenessAttribute), 1);
                    }
                } else {
                    shardPerAttribute.addTo(node.node().attributes().get((Object)awarenessAttribute), 1);
                }
            }
            int numberOfAttributes = nodesPerAttribute.size();
            String[] fullValues = this.forcedAwarenessAttributes.get(awarenessAttribute);
            if (fullValues != null) {
                for (String fullValue : fullValues) {
                    if (shardPerAttribute.containsKey((Object)fullValue)) continue;
                    ++numberOfAttributes;
                }
            }
            int averagePerAttribute = shardCount / numberOfAttributes;
            int totalLeftover = shardCount % numberOfAttributes;
            if (averagePerAttribute == 0) {
                totalLeftover = 0;
                requiredCountPerAttribute = 1;
            } else {
                requiredCountPerAttribute = averagePerAttribute;
            }
            int leftoverPerAttribute = totalLeftover == 0 ? 0 : 1;
            int currentNodeCount = shardPerAttribute.get(node.node().attributes().get((Object)awarenessAttribute));
            if (currentNodeCount > requiredCountPerAttribute + leftoverPerAttribute) {
                return allocation.decision(Decision.NO, NAME, "too many shards on node for attribute: [%s], required per attribute: [%d], node count: [%d], leftover: [%d]", awarenessAttribute, requiredCountPerAttribute, currentNodeCount, leftoverPerAttribute);
            }
            if (currentNodeCount > requiredCountPerAttribute) continue;
        }
        return allocation.decision(Decision.YES, NAME, "node meets awareness requirements", new Object[0]);
    }

    static /* synthetic */ String[] access$002(AwarenessAllocationDecider x0, String[] x1) {
        x0.awarenessAttributes = x1;
        return x1;
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            String[] awarenessAttributes = settings.getAsArray(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTES, null);
            if (awarenessAttributes == null && "".equals(settings.get(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTES, null))) {
                awarenessAttributes = Strings.EMPTY_ARRAY;
            }
            if (awarenessAttributes != null) {
                AwarenessAllocationDecider.this.logger.info("updating [cluster.routing.allocation.awareness.attributes] from [{}] to [{}]", AwarenessAllocationDecider.this.awarenessAttributes, awarenessAttributes);
                AwarenessAllocationDecider.access$002(AwarenessAllocationDecider.this, awarenessAttributes);
            }
            HashMap<String, String[]> forcedAwarenessAttributes = new HashMap<String, String[]>(AwarenessAllocationDecider.this.forcedAwarenessAttributes);
            Map<String, Settings> forceGroups = settings.getGroups(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP);
            if (!forceGroups.isEmpty()) {
                for (Map.Entry<String, Settings> entry : forceGroups.entrySet()) {
                    String[] aValues = entry.getValue().getAsArray("values");
                    if (aValues.length <= 0) continue;
                    forcedAwarenessAttributes.put(entry.getKey(), aValues);
                }
            }
            AwarenessAllocationDecider.this.forcedAwarenessAttributes = forcedAwarenessAttributes;
        }
    }
}

