# For iTerm2 version 2.x

(Originally posted by @gleachkr)

To open fzf from MacVim in a new iTerm2 window, it should work to make the following script executable somewhere in your Vim's PATH (with the title, for example, "In_a_new_term_function") and to let g:fzf_launcher = "In_a_new_term_function %s"

```bash
#!/bin/bash

osascript -e \
'on run argv
    tell application "System Events"
        set old_frontmost to item 1 of (get name of processes whose frontmost is true)
    end tell
    tell application "iTerm"
        activate
        set myterm to (make new terminal)
        tell myterm
            set mysession to (make new session at the end of sessions)
            tell mysession
                exec command "bash"
                write text "cd " & quoted form of (item 2 of argv)
                write text (item 1 of argv) & " && exit"
            end tell
            repeat while (exists myterm)
                delay 0.1
            end repeat
        end tell
    end tell
    tell application old_frontmost
        activate
    end tell
end run' "$1" "$PWD"
```

to control the size of the generated iTerm window you just need to insert the lines

```applescript
      set number of columns of myterm to C
      set number of rows of myterm to R
```
for some numbers C,R after `set myterm to (make new terminal)`

**And for zsh**:

```sh
#!/usr/local/bin/zsh

osascript -e \
'on run argv
    tell application "System Events"
        set old_frontmost to item 1 of (get name of processes whose frontmost is true)
    end tell
    tell application "iTerm"
        activate
        set myterm to (make new terminal)
        # set number of columns of myterm to 250
        # set number of rows of myterm to 30
        tell myterm
            set mysession to (make new session at the end of sessions)
            tell mysession
                exec command "env PATH=/usr/local/bin/:$PATH /usr/local/bin/zsh -f"
                write text "cd " & quoted form of (item 2 of argv)
                write text (item 1 of argv) & " && exit"
            end tell
            repeat while (exists myterm)
                delay 0.1
            end repeat
        end tell
    end tell
    tell application old_frontmost
        activate
    end tell
end run' $1 $PWD
```

And put it in PATH (I've put it in `/usr/local/bin`)

Note: it doesn't work very well if you've got an instance of iTerm2 running in full screen

# For iTerm2 version 3.0 and higher

(Added by @amacdougall)

The Applescript API for iTerm2 has changed with version 3.0. This updated script works for me:

```bash
# update for iterm2 3.0+
osascript -e \
'on run argv
    tell application "System Events"
        set old_frontmost to item 1 of (get name of processes whose frontmost is true)
    end tell
    tell application "iTerm2"
        set myterm to (create window with default profile)
        tell current session of first window
            write text "cd " & quoted form of (item 2 of argv)
            write text (item 1 of argv) & " && exit"
        end tell
        repeat while (exists myterm)
            delay 0.1
        end repeat
    end tell
    tell application old_frontmost
        activate
    end tell
end run' "$1" "$PWD"
```