/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.response;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.client.MockClientHttpResponse;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.util.Assert;

public class DefaultResponseCreator
implements ResponseCreator {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private byte[] content;
    private Resource contentResource;
    private final HttpHeaders headers = new HttpHeaders();
    private HttpStatus statusCode;

    protected DefaultResponseCreator(HttpStatus statusCode) {
        Assert.notNull((Object)statusCode);
        this.statusCode = statusCode;
    }

    @Override
    public ClientHttpResponse createResponse(ClientHttpRequest request) throws IOException {
        MockClientHttpResponse response;
        if (this.contentResource != null) {
            InputStream stream = this.contentResource.getInputStream();
            response = new MockClientHttpResponse(stream, this.statusCode);
        } else {
            response = new MockClientHttpResponse(this.content, this.statusCode);
        }
        response.getHeaders().putAll((Map)this.headers);
        return response;
    }

    public DefaultResponseCreator body(String content) {
        this.content = content.getBytes(UTF8_CHARSET);
        return this;
    }

    public DefaultResponseCreator body(byte[] content) {
        this.content = content;
        return this;
    }

    public DefaultResponseCreator body(Resource resource) {
        this.contentResource = resource;
        return this;
    }

    public DefaultResponseCreator contentType(MediaType mediaType) {
        if (mediaType != null) {
            this.headers.setContentType(mediaType);
        }
        return this;
    }

    public DefaultResponseCreator location(URI location) {
        this.headers.setLocation(location);
        return this;
    }

    public DefaultResponseCreator headers(HttpHeaders headers) {
        for (String headerName : headers.keySet()) {
            for (String headerValue : headers.get((Object)headerName)) {
                this.headers.add(headerName, headerValue);
            }
        }
        return this;
    }
}

