/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import javajs.util.AU;

class JpegObj {
    String comment;
    int imageHeight;
    int imageWidth;
    int[] blockWidth;
    int[] blockHeight;
    int precision = 8;
    int numberOfComponents = 3;
    float[][][] components;
    int[] compID = new int[]{1, 2, 3};
    int[] hsampFactor = new int[]{1, 1, 1};
    int[] vsampFactor = new int[]{1, 1, 1};
    int[] qtableNumber = new int[]{0, 1, 1};
    int[] dctableNumber = new int[]{0, 1, 1};
    int[] actableNumber = new int[]{0, 1, 1};
    private boolean[] lastColumnIsDummy = new boolean[]{false, false, false};
    private boolean[] lastRowIsDummy = new boolean[]{false, false, false};
    int ss = 0;
    int se = 63;
    int ah = 0;
    int al = 0;
    private int[] compWidth;
    private int[] compHeight;
    private int maxHsampFactor;
    private int maxVsampFactor;

    public JpegObj() {
        this.components = AU.newFloat3(this.numberOfComponents, -1);
        this.compWidth = new int[this.numberOfComponents];
        this.compHeight = new int[this.numberOfComponents];
        this.blockWidth = new int[this.numberOfComponents];
        this.blockHeight = new int[this.numberOfComponents];
    }

    void getYCCArray(int[] pixels) {
        int y;
        this.maxHsampFactor = 1;
        this.maxVsampFactor = 1;
        for (y = 0; y < this.numberOfComponents; ++y) {
            this.maxHsampFactor = Math.max(this.maxHsampFactor, this.hsampFactor[y]);
            this.maxVsampFactor = Math.max(this.maxVsampFactor, this.vsampFactor[y]);
        }
        for (y = 0; y < this.numberOfComponents; ++y) {
            this.compWidth[y] = (this.imageWidth % 8 != 0 ? (int)Math.ceil((double)this.imageWidth / 8.0) * 8 : this.imageWidth) / this.maxHsampFactor * this.hsampFactor[y];
            if (this.compWidth[y] != this.imageWidth / this.maxHsampFactor * this.hsampFactor[y]) {
                this.lastColumnIsDummy[y] = true;
            }
            this.blockWidth[y] = (int)Math.ceil((double)this.compWidth[y] / 8.0);
            this.compHeight[y] = (this.imageHeight % 8 != 0 ? (int)Math.ceil((double)this.imageHeight / 8.0) * 8 : this.imageHeight) / this.maxVsampFactor * this.vsampFactor[y];
            if (this.compHeight[y] != this.imageHeight / this.maxVsampFactor * this.vsampFactor[y]) {
                this.lastRowIsDummy[y] = true;
            }
            this.blockHeight[y] = (int)Math.ceil((double)this.compHeight[y] / 8.0);
        }
        float[][] Y = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] Cr1 = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] Cb1 = new float[this.compHeight[0]][this.compWidth[0]];
        int pt = 0;
        for (int y2 = 0; y2 < this.imageHeight; ++y2) {
            int x = 0;
            while (x < this.imageWidth) {
                int p = pixels[pt];
                int r = p >> 16 & 0xFF;
                int g = p >> 8 & 0xFF;
                int b = p & 0xFF;
                Y[y2][x] = (float)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                Cb1[y2][x] = 128.0f + (float)(-0.16874 * (double)r - 0.33126 * (double)g + 0.5 * (double)b);
                Cr1[y2][x] = 128.0f + (float)(0.5 * (double)r - 0.41869 * (double)g - 0.08131 * (double)b);
                ++x;
                ++pt;
            }
        }
        this.components[0] = Y;
        this.components[1] = Cb1;
        this.components[2] = Cr1;
    }
}

