/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import java.util.Map;
import javajs.util.AU;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.c.PAL;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.shape.AtomShape;
import org.jmol.shape.Mesh;
import org.jmol.shapebio.BioShapeCollection;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Logger;

public class BioShape
extends AtomShape {
    public int modelIndex;
    public int modelVisibilityFlags = 0;
    BioShapeCollection shape;
    public BioPolymer bioPolymer;
    public Mesh[] meshes;
    public boolean[] meshReady;
    public short[] colixesBack;
    public Monomer[] monomers;
    public V3[] wingVectors;
    int[] leadAtomIndices;
    boolean hasBfactorRange = false;
    int bfactorMin;
    int bfactorMax;
    int range;
    float floatRange;
    private static final double eightPiSquared100 = 7895.6835208714865;

    @Override
    public void setProperty(String propertyName, Object value, BS bsSelected) {
        this.setPropAS(propertyName, value, bsSelected);
    }

    BioShape(BioShapeCollection shape, int modelIndex, BioPolymer bioPolymer) {
        this.shape = shape;
        this.modelIndex = modelIndex;
        this.bioPolymer = bioPolymer;
        this.isActive = shape.isActive;
        this.bsSizeDefault = new BS();
        this.monomerCount = bioPolymer.monomerCount;
        if (this.monomerCount > 0) {
            this.colixes = new short[this.monomerCount];
            this.paletteIDs = new byte[this.monomerCount];
            this.mads = new short[this.monomerCount + 1];
            this.monomers = bioPolymer.monomers;
            this.meshReady = new boolean[this.monomerCount];
            this.meshes = new Mesh[this.monomerCount];
            this.wingVectors = bioPolymer.getWingVectors();
            this.leadAtomIndices = bioPolymer.getLeadAtomIndices();
        }
    }

    void calcBfactorRange() {
        this.bfactorMin = this.bfactorMax = this.monomers[0].getLeadAtom().getBfactor100();
        int i = this.monomerCount;
        while (--i > 0) {
            int bfactor = this.monomers[i].getLeadAtom().getBfactor100();
            if (bfactor < this.bfactorMin) {
                this.bfactorMin = bfactor;
                continue;
            }
            if (bfactor <= this.bfactorMax) continue;
            this.bfactorMax = bfactor;
        }
        this.range = this.bfactorMax - this.bfactorMin;
        this.floatRange = this.range;
        this.hasBfactorRange = true;
    }

    short calcMeanPositionalDisplacement(int bFactor100) {
        return (short)(Math.sqrt((double)bFactor100 / 7895.6835208714865) * 1000.0);
    }

    @Override
    public void findNearestAtomIndex(int xMouse, int yMouse, Atom[] closest, BS bsNot) {
        this.bioPolymer.findNearestAtomIndex(xMouse, yMouse, closest, this.mads, this.shape.vf, bsNot);
    }

    void setMad(short mad, BS bsSelected, float[] values) {
        int flag;
        if (this.monomerCount < 2) {
            return;
        }
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BS();
        }
        boolean setRingVis = (flag = this.shape.vf) == 32768 && this.bioPolymer instanceof NucleicPolymer;
        int i = this.monomerCount;
        while (--i >= 0) {
            int leadAtomIndex = this.leadAtomIndices[i];
            if (!bsSelected.get(leadAtomIndex)) continue;
            if (values != null && leadAtomIndex < values.length) {
                if (Float.isNaN(values[leadAtomIndex])) continue;
                mad = (short)(values[leadAtomIndex] * 2000.0f);
            }
            boolean isVisible = (this.mads[i] = this.getMad(i, mad)) > 0;
            this.bsSizeSet.setBitTo(i, isVisible);
            this.monomers[i].setShapeVisibility(flag, isVisible);
            this.shape.atoms[leadAtomIndex].setShapeVisibility(flag, isVisible);
            if (setRingVis) {
                ((NucleicMonomer)this.monomers[i]).setRingsVisible(isVisible);
            }
            this.falsifyNearbyMesh(i);
        }
        if (this.monomerCount > 1) {
            this.mads[this.monomerCount] = this.mads[this.monomerCount - 1];
        }
    }

    private short getMad(int groupIndex, short mad) {
        this.bsSizeDefault.setBitTo(groupIndex, mad == -1 || mad == -2);
        if (mad >= 0) {
            return mad;
        }
        switch (mad) {
            case -2: 
            case -1: {
                if (mad == -1 && this.shape.madOn >= 0) {
                    return this.shape.madOn;
                }
                switch (this.monomers[groupIndex].getProteinStructureType()) {
                    case SHEET: 
                    case HELIX: {
                        return this.shape.madHelixSheet;
                    }
                    case DNA: 
                    case RNA: {
                        return this.shape.madDnaRna;
                    }
                }
                return this.shape.madTurnRandom;
            }
            case -3: {
                if (!this.hasBfactorRange) {
                    this.calcBfactorRange();
                }
                Atom atom = this.monomers[groupIndex].getLeadAtom();
                int bfactor100 = atom.getBfactor100();
                int scaled = bfactor100 - this.bfactorMin;
                if (this.range == 0) {
                    return 0;
                }
                float percentile = (float)scaled / this.floatRange;
                if (percentile < 0.0f || percentile > 1.0f) {
                    Logger.error("Que ha ocurrido? " + percentile);
                }
                return (short)(1750.0f * percentile + 250.0f);
            }
            case -4: {
                Atom atom = this.monomers[groupIndex].getLeadAtom();
                return (short)(2 * this.calcMeanPositionalDisplacement(atom.getBfactor100()));
            }
        }
        Logger.error("unrecognized setMad(" + mad + ")");
        return 0;
    }

    public void falsifyMesh() {
        if (this.meshReady == null) {
            return;
        }
        for (int i = 0; i < this.monomerCount; ++i) {
            this.meshReady[i] = false;
        }
    }

    private void falsifyNearbyMesh(int index) {
        if (this.meshReady == null) {
            return;
        }
        this.meshReady[index] = false;
        if (index > 0) {
            this.meshReady[index - 1] = false;
        }
        if (index < this.monomerCount - 1) {
            this.meshReady[index + 1] = false;
        }
    }

    void setColixBS(short colix, byte pid, BS bsSelected) {
        this.isActive = true;
        if (this.bsColixSet == null) {
            this.bsColixSet = BS.newN(this.monomerCount);
        }
        int i = this.monomerCount;
        while (--i >= 0) {
            int atomIndex = this.leadAtomIndices[i];
            if (!bsSelected.get(atomIndex)) continue;
            this.colixes[i] = this.shape.getColixI(colix, pid, atomIndex);
            if (this.colixesBack != null && this.colixesBack.length > i) {
                this.colixesBack[i] = 0;
            }
            this.paletteIDs[i] = pid;
            this.bsColixSet.setBitTo(i, this.colixes[i] != 0);
        }
    }

    void setColixBack(short colix, BS bsSelected) {
        if (this.colixesBack == null) {
            this.colixesBack = new short[this.colixes.length];
        }
        if (this.colixesBack.length < this.colixes.length) {
            this.colixesBack = AU.ensureLengthShort(this.colixesBack, this.colixes.length);
        }
        int i = this.monomerCount;
        while (--i >= 0) {
            if (!bsSelected.get(this.leadAtomIndices[i])) continue;
            this.colixesBack[i] = colix;
        }
    }

    void setColixes(short[] atomColixes, BS bsSelected) {
        this.isActive = true;
        if (this.bsColixSet == null) {
            this.bsColixSet = BS.newN(this.monomerCount);
        }
        int i = this.monomerCount;
        while (--i >= 0) {
            int atomIndex = this.leadAtomIndices[i];
            if (!bsSelected.get(atomIndex) || i >= this.colixes.length || atomIndex >= atomColixes.length) continue;
            this.colixes[i] = this.shape.getColixI(atomColixes[atomIndex], PAL.UNKNOWN.id, atomIndex);
            if (this.colixesBack != null && i < this.colixesBack.length) {
                this.colixesBack[i] = 0;
            }
            this.paletteIDs[i] = PAL.UNKNOWN.id;
            this.bsColixSet.set(i);
        }
    }

    public void setParams(Object[] data, int[] atomMap, BS bsSelected) {
        if (this.monomerCount == 0) {
            return;
        }
        short[] c = (short[])data[0];
        float[] atrans = (float[])data[1];
        this.isActive = true;
        if (this.bsColixSet == null) {
            this.bsColixSet = BS.newN(this.monomerCount);
        }
        int n = atomMap.length;
        int i = this.monomerCount;
        while (--i >= 0) {
            float f;
            int atomIndex = this.leadAtomIndices[i];
            if (!bsSelected.get(atomIndex) || i >= this.colixes.length || atomIndex >= n) continue;
            int pt = atomMap[atomIndex];
            short colix = c == null ? (short)0 : c[pt];
            float f2 = f = atrans == null ? 0.0f : atrans[pt];
            if (f > 0.01f) {
                colix = C.getColixTranslucent3(colix, true, f);
            }
            this.colixes[i] = this.shape.getColixI(colix, PAL.UNKNOWN.id, atomIndex);
            if (this.colixesBack != null && i < this.colixesBack.length) {
                this.colixesBack[i] = 0;
            }
            this.paletteIDs[i] = PAL.UNKNOWN.id;
            this.bsColixSet.set(i);
        }
    }

    void setTranslucent(boolean isTranslucent, BS bsSelected, float translucentLevel) {
        this.isActive = true;
        if (this.bsColixSet == null) {
            this.bsColixSet = BS.newN(this.monomerCount);
        }
        int i = this.monomerCount;
        while (--i >= 0) {
            if (!bsSelected.get(this.leadAtomIndices[i])) continue;
            this.colixes[i] = C.getColixTranslucent3(this.colixes[i], isTranslucent, translucentLevel);
            if (this.colixesBack != null && this.colixesBack.length > i) {
                this.colixesBack[i] = C.getColixTranslucent3(this.colixesBack[i], isTranslucent, translucentLevel);
            }
            this.bsColixSet.setBitTo(i, this.colixes[i] != 0);
        }
    }

    @Override
    public void setAtomClickability() {
        if (!this.isActive || this.wingVectors == null || this.monomerCount == 0) {
            return;
        }
        boolean setRingsClickable = this.bioPolymer instanceof NucleicPolymer && this.shape.shapeID == 11;
        boolean setAlphaClickable = this.bioPolymer instanceof AlphaPolymer || this.shape.shapeID != 15;
        ModelSet ms = this.monomers[0].chain.model.ms;
        int i = this.monomerCount;
        while (--i >= 0) {
            int iAtom;
            if (this.mads[i] <= 0 || ms.isAtomHidden(iAtom = this.leadAtomIndices[i])) continue;
            if (setAlphaClickable) {
                ms.at[iAtom].setClickable(1040384);
            }
            if (!setRingsClickable) continue;
            ((NucleicMonomer)this.monomers[i]).setRingsClickable();
        }
    }

    void getBioShapeState(String type, boolean translucentAllowed, Map<String, BS> temp, Map<String, BS> temp2) {
        if (this.monomerCount > 0) {
            if (!this.isActive || this.bsSizeSet == null && this.bsColixSet == null) {
                return;
            }
            for (int i = 0; i < this.monomerCount; ++i) {
                int atomIndex1 = this.monomers[i].firstAtomIndex;
                int atomIndex2 = this.monomers[i].lastAtomIndex;
                if (this.bsSizeSet != null && (this.bsSizeSet.get(i) || this.bsColixSet != null && this.bsColixSet.get(i))) {
                    if (this.bsSizeDefault.get(i)) {
                        BSUtil.setMapBitSet(temp, atomIndex1, atomIndex2, type + (this.bsSizeSet.get(i) ? " on" : " off"));
                    } else {
                        BSUtil.setMapBitSet(temp, atomIndex1, atomIndex2, type + " " + PT.escF((float)this.mads[i] / 2000.0f));
                    }
                }
                if (this.bsColixSet == null || !this.bsColixSet.get(i)) continue;
                String s = BioShape.getColorCommand(type, this.paletteIDs[i], this.colixes[i], translucentAllowed);
                if (this.colixesBack != null && this.colixesBack.length > i && this.colixesBack[i] != 0) {
                    s = s + " " + C.getHexCode(this.colixesBack[i]);
                }
                BSUtil.setMapBitSet(temp2, atomIndex1, atomIndex2, s);
            }
        }
    }

    @Override
    public String getShapeState() {
        return null;
    }
}

