/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.render.ShapeRenderer;
import org.jmol.shapespecial.Dipole;
import org.jmol.shapespecial.Dipoles;
import org.jmol.util.C;

public class DipolesRenderer
extends ShapeRenderer {
    private float dipoleVectorScale;
    private final V3 offset = new V3();
    private final P3[] screens3f = new P3[6];
    private final P3[] points = new P3[6];
    private P3 cross0;
    private P3 cross1;
    private static final int cylinderBase = 0;
    private static final int cross = 1;
    private static final int crossEnd = 2;
    private static final int center = 3;
    private static final int arrowHeadBase = 4;
    private static final int arrowHeadTip = 5;
    private int diameter;
    private int headWidthPixels;
    private int crossWidthPixels;
    private float offsetSide;
    private short colixA;
    private short colixB;
    private boolean noCross;
    private static final float arrowHeadOffset = 0.9f;
    private static final float arrowHeadWidthFactor = 2.0f;
    private static final float crossOffset = 0.1f;
    private static final float crossWidth = 0.04f;

    public DipolesRenderer() {
        for (int i = 0; i < 6; ++i) {
            this.screens3f[i] = new P3();
            this.points[i] = new P3();
        }
        this.cross0 = new P3();
        this.cross1 = new P3();
    }

    protected boolean render() {
        Dipoles dipoles = (Dipoles)this.shape;
        this.dipoleVectorScale = this.vwr.getFloat(0x2200000B);
        boolean needTranslucent = false;
        BS vis = this.vwr.ms.getVisibleSet(false);
        int i = dipoles.dipoleCount;
        while (--i >= 0) {
            Dipole dipole = dipoles.dipoles[i];
            if (dipole.visibilityFlags == 0 || dipole.atoms[0] != null && this.ms.isAtomHidden(dipole.atoms[0].i) || dipole.bsMolecule != null && !dipole.bsMolecule.intersects(vis) || !this.renderDipoleVector(dipole, vis)) continue;
            needTranslucent = true;
        }
        return needTranslucent;
    }

    private boolean renderDipoleVector(Dipole dipole, BS vis) {
        this.mad = dipole.mad;
        this.offsetSide = dipole.offsetSide;
        this.noCross = dipole.noCross;
        this.colixB = this.colixA = dipole.bond == null ? dipole.colix : C.getColixInherited((short)dipole.colix, (short)dipole.bond.colix);
        if (dipole.atoms[0] != null) {
            this.colixA = C.getColixInherited((short)this.colixA, (short)dipole.atoms[0].colixAtom);
            this.colixB = C.getColixInherited((short)this.colixB, (short)dipole.atoms[1].colixAtom);
        }
        if (this.colixA == 0) {
            this.colixA = (short)5;
        }
        if (this.colixB == 0) {
            this.colixB = (short)5;
        }
        if (this.dipoleVectorScale < 0.0f) {
            short c = this.colixA;
            this.colixA = this.colixB;
            this.colixB = c;
        }
        float factor = dipole.offsetAngstroms / dipole.dipoleValue;
        if (dipole.lstDipoles == null) {
            return this.renderVector(dipole.vector, dipole.origin, dipole.center, factor, false);
        }
        boolean needTranslucent = false;
        int i = dipole.lstDipoles.size();
        while (--i >= 0) {
            Object[] o = (Object[])dipole.lstDipoles.get(i);
            V3 v = (V3)o[0];
            P3 origin = (P3)o[1];
            BS bsAtoms = (BS)o[2];
            if (!bsAtoms.intersects(vis)) continue;
            needTranslucent = this.renderVector(v, origin, null, dipole.offsetAngstroms, true);
        }
        return needTranslucent;
    }

    private boolean renderVector(V3 vector, P3 origin, P3 dcenter, float factor, boolean isGroup) {
        int i;
        this.offset.setT((T3)vector);
        if (dcenter == null) {
            if (isGroup) {
                this.offset.normalize();
                this.offset.scale(factor);
            } else {
                this.offset.scale(factor);
                if (this.dipoleVectorScale < 0.0f) {
                    this.offset.add((T3)vector);
                }
            }
            this.points[0].add2((T3)origin, (T3)this.offset);
        } else {
            this.offset.scale(-0.5f * this.dipoleVectorScale);
            this.points[0].add2((T3)dcenter, (T3)this.offset);
            if (factor != 0.0f) {
                this.offset.setT((T3)vector);
                this.offset.scale(factor);
                this.points[0].add((T3)this.offset);
            }
        }
        this.points[1].scaleAdd2(this.dipoleVectorScale * 0.1f, (T3)vector, (T3)this.points[0]);
        this.points[2].scaleAdd2(this.dipoleVectorScale * 0.14f, (T3)vector, (T3)this.points[0]);
        this.points[3].scaleAdd2(this.dipoleVectorScale / 2.0f, (T3)vector, (T3)this.points[0]);
        this.points[4].scaleAdd2(this.dipoleVectorScale * 0.9f, (T3)vector, (T3)this.points[0]);
        this.points[5].scaleAdd2(this.dipoleVectorScale, (T3)vector, (T3)this.points[0]);
        this.offset.setT((T3)this.points[3]);
        this.offset.cross((T3)this.offset, (T3)vector);
        if (this.offset.length() == 0.0f) {
            this.offset.set(this.points[3].x + 0.2345f, this.points[3].y + 0.1234f, this.points[3].z + 0.4321f);
            this.offset.cross((T3)this.offset, (T3)vector);
        }
        this.offset.scale(this.offsetSide / this.offset.length());
        for (i = 0; i < 6; ++i) {
            this.points[i].add((T3)this.offset);
        }
        for (i = 0; i < 6; ++i) {
            this.tm.transformPtScrT3((T3)this.points[i], (T3)this.screens3f[i]);
        }
        this.tm.transformPt3f((T3)this.points[1], this.cross0);
        this.tm.transformPt3f((T3)this.points[2], this.cross1);
        float d = this.vwr.tm.scaleToScreen((int)this.screens3f[3].z, (int)this.mad);
        this.diameter = (int)d;
        this.headWidthPixels = (int)Math.floor(d * 2.0f);
        if (this.headWidthPixels < this.diameter + 5) {
            this.headWidthPixels = this.diameter + 5;
        }
        this.crossWidthPixels = this.headWidthPixels;
        this.colix = this.colixA;
        if (this.colix == this.colixB) {
            if (!this.g3d.setC(this.colix)) {
                return true;
            }
            this.g3d.fillCylinderBits((byte)1, this.diameter, this.screens3f[0], this.screens3f[4]);
            if (!this.noCross) {
                this.g3d.fillCylinderBits((byte)2, this.crossWidthPixels, this.cross0, this.cross1);
            }
            this.g3d.fillConeScreen3f((byte)2, this.headWidthPixels, this.screens3f[4], this.screens3f[5], false);
            return false;
        }
        boolean needTranslucent = false;
        if (this.g3d.setC(this.colix)) {
            this.g3d.fillCylinderBits((byte)1, this.diameter, this.screens3f[0], this.screens3f[3]);
            if (!this.noCross) {
                this.g3d.fillCylinderBits((byte)2, this.crossWidthPixels, this.cross0, this.cross1);
            }
        } else {
            needTranslucent = true;
        }
        this.colix = this.colixB;
        if (this.g3d.setC(this.colix)) {
            this.g3d.fillCylinderBits((byte)4, this.diameter, this.screens3f[3], this.screens3f[4]);
            this.g3d.fillConeScreen3f((byte)2, this.headWidthPixels, this.screens3f[4], this.screens3f[5], false);
        } else {
            needTranslucent = true;
        }
        return needTranslucent;
    }
}

