/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv.normalize;

import java.io.File;
import org.encog.EncogError;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.csv.TimeSeriesUtil;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.csv.normalize.AnalystNormalizeCSV;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.analyst.util.CSVHeaders;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.buffer.BufferedMLDataSet;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.util.logging.EncogLogging;

public class AnalystNormalizeToEGB
extends BasicFile {
    private EncogAnalyst analyst;
    private TimeSeriesUtil series;
    private CSVHeaders analystHeaders;

    public void analyze(File inputFilename, boolean expectInputHeaders, CSVFormat inputFormat, EncogAnalyst theAnalyst) {
        this.setInputFilename(inputFilename);
        this.setInputFormat(inputFormat);
        this.setExpectInputHeaders(expectInputHeaders);
        this.analyst = theAnalyst;
        this.setAnalyzed(true);
        this.analystHeaders = new CSVHeaders(inputFilename, expectInputHeaders, inputFormat);
        for (AnalystField field : this.analyst.getScript().getNormalize().getNormalizedFields()) {
            field.init();
        }
        this.series = new TimeSeriesUtil(this.analyst, true, this.analystHeaders.getHeaders());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normalize(File file) {
        if (this.analyst == null) {
            throw new EncogError("Can't normalize yet, file has not been analyzed.");
        }
        int inputCount = this.analyst.getScript().getNormalize().calculateInputColumns();
        int idealCount = this.analyst.getScript().getNormalize().calculateOutputColumns();
        BasicMLData inputData = new BasicMLData(inputCount);
        BasicMLData idealData = new BasicMLData(idealCount);
        ReadCSV csv = null;
        BufferedMLDataSet buffer = new BufferedMLDataSet(file);
        buffer.beginLoad(inputCount, idealCount);
        try {
            csv = new ReadCSV(this.getInputFilename().toString(), this.isExpectInputHeaders(), this.getFormat());
            this.resetStatus();
            int outputLength = this.analyst.determineTotalColumns();
            while (csv.next() && !this.shouldStop()) {
                int i;
                this.updateStatus(false);
                double[] output = AnalystNormalizeCSV.extractFields(this.analyst, this.analystHeaders, csv, outputLength, false);
                if (this.series.getTotalDepth() > 1) {
                    output = this.series.process(output);
                }
                int idx = 0;
                for (i = 0; i < inputData.size(); ++i) {
                    inputData.setData(i, output[idx++]);
                }
                for (i = 0; i < idealData.size(); ++i) {
                    idealData.setData(i, output[idx++]);
                }
                if (output == null) continue;
                buffer.add(inputData, idealData);
            }
        }
        finally {
            this.reportDone(false);
            if (csv != null) {
                try {
                    csv.close();
                }
                catch (Exception ex) {
                    EncogLogging.log(ex);
                }
            }
            if (buffer != null) {
                try {
                    buffer.endLoad();
                }
                catch (Exception ex) {
                    EncogLogging.log(ex);
                }
            }
        }
    }

    public void setSourceFile(File file, boolean headers, CSVFormat format) {
        this.setInputFilename(file);
        this.setExpectInputHeaders(headers);
        this.setInputFormat(format);
    }
}

