/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.BoundMath;
import org.encog.util.obj.ActivationUtil;

public class ActivationSigmoid
implements ActivationFunction {
    private static final long serialVersionUID = 5622349801036468572L;
    private final double[] params = new double[0];

    @Override
    public final void activationFunction(double[] x, int start, int size) {
        for (int i = start; i < start + size; ++i) {
            x[i] = 1.0 / (1.0 + BoundMath.exp(-1.0 * x[i]));
        }
    }

    @Override
    public final ActivationFunction clone() {
        return new ActivationSigmoid();
    }

    @Override
    public final double derivativeFunction(double b, double a) {
        return a * (1.0 - a);
    }

    @Override
    public final String[] getParamNames() {
        String[] results = new String[]{};
        return results;
    }

    @Override
    public final double[] getParams() {
        return this.params;
    }

    @Override
    public final boolean hasDerivative() {
        return true;
    }

    @Override
    public final void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getFactoryCode() {
        return ActivationUtil.generateActivationFactory("sigmoid", this);
    }
}

