/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.ea.opp;

import java.util.Random;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.opp.EvolutionaryOperator;
import org.encog.ml.ea.opp.OperationList;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.util.obj.ObjectHolder;

public class CompoundOperator
implements EvolutionaryOperator {
    private EvolutionaryAlgorithm owner;
    private final OperationList components = new OperationList();

    public OperationList getComponents() {
        return this.components;
    }

    public EvolutionaryAlgorithm getOwner() {
        return this.owner;
    }

    @Override
    public void init(EvolutionaryAlgorithm theOwner) {
        this.owner = theOwner;
        for (ObjectHolder obj : this.components.getList()) {
            ((EvolutionaryOperator)obj.getObj()).init(theOwner);
        }
    }

    @Override
    public int offspringProduced() {
        return this.components.maxOffspring();
    }

    @Override
    public int parentsNeeded() {
        return this.components.maxOffspring();
    }

    @Override
    public void performOperation(Random rnd, Genome[] parents, int parentIndex, Genome[] offspring, int offspringIndex) {
        EvolutionaryOperator opp = (EvolutionaryOperator)this.components.pick(rnd);
        opp.performOperation(rnd, parents, parentIndex, offspring, offspringIndex);
    }
}

