/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.ea.species;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.population.Population;
import org.encog.ml.ea.species.Species;
import org.encog.util.Format;

public class BasicSpecies
implements Serializable,
Species {
    private static final long serialVersionUID = 1L;
    private int age;
    private double bestScore;
    private int gensNoImprovement;
    private Genome leader;
    private final List<Genome> members = new ArrayList<Genome>();
    private Population population;
    private transient int offspringCount;
    private transient double offspringShare;

    public BasicSpecies() {
    }

    public BasicSpecies(Population thePopulation, Genome theFirst) {
        this.population = thePopulation;
        this.bestScore = theFirst.getScore();
        this.gensNoImprovement = 0;
        this.age = 0;
        this.leader = theFirst;
        this.members.add(theFirst);
    }

    @Override
    public void add(Genome genome) {
        genome.setPopulation(this.population);
        this.members.add(genome);
    }

    @Override
    public double calculateShare(boolean shouldMinimize, double maxScore) {
        double total = 0.0;
        int count = 0;
        for (Genome genome : this.members) {
            if (Double.isNaN(genome.getAdjustedScore()) || Double.isInfinite(genome.getAdjustedScore())) continue;
            double s = shouldMinimize ? maxScore - genome.getAdjustedScore() : genome.getAdjustedScore();
            total += s;
            ++count;
        }
        this.offspringShare = count == 0 ? 0.0 : total / (double)count;
        return this.offspringShare;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public double getBestScore() {
        return this.bestScore;
    }

    @Override
    public int getGensNoImprovement() {
        return this.gensNoImprovement;
    }

    @Override
    public Genome getLeader() {
        return this.leader;
    }

    @Override
    public List<Genome> getMembers() {
        return this.members;
    }

    @Override
    public int getOffspringCount() {
        return this.offspringCount;
    }

    @Override
    public double getOffspringShare() {
        return this.offspringShare;
    }

    @Override
    public Population getPopulation() {
        return this.population;
    }

    public void purge() {
        this.members.clear();
        if (this.leader != null) {
            this.members.add(this.leader);
        }
        ++this.age;
        ++this.gensNoImprovement;
        this.offspringCount = 0;
        this.offspringShare = 0.0;
    }

    @Override
    public void setAge(int theAge) {
        this.age = theAge;
    }

    @Override
    public void setBestScore(double theBestScore) {
        this.bestScore = theBestScore;
    }

    @Override
    public void setGensNoImprovement(int theGensNoImprovement) {
        this.gensNoImprovement = theGensNoImprovement;
    }

    @Override
    public void setLeader(Genome theLeader) {
        this.leader = theLeader;
    }

    @Override
    public void setOffspringCount(int offspringCount) {
        this.offspringCount = offspringCount;
    }

    @Override
    public void setPopulation(Population thePopulation) {
        this.population = thePopulation;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[BasicSpecies: score=");
        result.append(Format.formatDouble(this.getBestScore(), 2));
        result.append(", members=");
        result.append(this.members.size());
        result.append(", age=");
        result.append(this.age);
        result.append(", no_improv=");
        result.append(this.gensNoImprovement);
        result.append(", share=");
        result.append(this.offspringShare);
        result.append(", offspring count=");
        result.append(this.offspringShare);
        result.append("]");
        return result.toString();
    }
}

