/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.train;

import java.util.Map;
import org.encog.ml.MLEncodable;
import org.encog.ml.MLMethod;
import org.encog.ml.MLResettable;
import org.encog.ml.MethodFactory;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.factory.parse.ArchitectureParse;
import org.encog.ml.genetic.MLMethodGeneticAlgorithm;
import org.encog.ml.train.MLTrain;
import org.encog.neural.networks.training.TrainingError;
import org.encog.neural.networks.training.TrainingSetScore;
import org.encog.util.ParamsHolder;
import org.encog.util.obj.ObjectCloner;

public class GeneticFactory {
    public MLTrain create(final MLMethod method, MLDataSet training, String argsStr) {
        if (!(method instanceof MLEncodable)) {
            throw new TrainingError("Invalid method type, requires an encodable MLMethod");
        }
        TrainingSetScore score = new TrainingSetScore(training);
        Map<String, String> args = ArchitectureParse.parseParams(argsStr);
        ParamsHolder holder = new ParamsHolder(args);
        int populationSize = holder.getInt("population", false, 5000);
        MLMethodGeneticAlgorithm train = new MLMethodGeneticAlgorithm(new MethodFactory(){

            @Override
            public MLMethod factor() {
                MLMethod result = (MLMethod)ObjectCloner.deepCopy(method);
                ((MLResettable)result).reset();
                return result;
            }
        }, score, populationSize);
        return train;
    }
}

