/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.hyperneat.substrate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.neural.hyperneat.substrate.SubstrateLink;
import org.encog.neural.hyperneat.substrate.SubstrateNode;

public class Substrate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int dimensions;
    private final List<SubstrateNode> inputNodes = new ArrayList<SubstrateNode>();
    private final List<SubstrateNode> outputNodes = new ArrayList<SubstrateNode>();
    private final List<SubstrateNode> hiddenNodes = new ArrayList<SubstrateNode>();
    private final List<SubstrateLink> links = new ArrayList<SubstrateLink>();
    private int currentNeuronNumber;
    private int activationCycles = 1;

    public Substrate(int theDimensions) {
        this.dimensions = theDimensions;
        this.currentNeuronNumber = 1;
    }

    public List<SubstrateNode> getHiddenNodes() {
        return this.hiddenNodes;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public List<SubstrateNode> getInputNodes() {
        return this.inputNodes;
    }

    public List<SubstrateNode> getOutputNodes() {
        return this.outputNodes;
    }

    public int getInputCount() {
        return this.inputNodes.size();
    }

    public int getOutputCount() {
        return this.outputNodes.size();
    }

    public SubstrateNode createNode() {
        SubstrateNode result = new SubstrateNode(this.currentNeuronNumber++, this.dimensions);
        return result;
    }

    public SubstrateNode createInputNode() {
        SubstrateNode result = this.createNode();
        this.inputNodes.add(result);
        return result;
    }

    public SubstrateNode createOutputNode() {
        SubstrateNode result = this.createNode();
        this.outputNodes.add(result);
        return result;
    }

    public SubstrateNode createHiddenNode() {
        SubstrateNode result = this.createNode();
        this.hiddenNodes.add(result);
        return result;
    }

    public void createLink(SubstrateNode inputNode, SubstrateNode outputNode) {
        SubstrateLink link = new SubstrateLink(inputNode, outputNode);
        this.links.add(link);
    }

    public List<SubstrateLink> getLinks() {
        return this.links;
    }

    public int getLinkCount() {
        return this.links.size();
    }

    public int getNodeCount() {
        return 1 + this.inputNodes.size() + this.outputNodes.size() + this.hiddenNodes.size();
    }

    public int getActivationCycles() {
        return this.activationCycles;
    }

    public void setActivationCycles(int activationCycles) {
        this.activationCycles = activationCycles;
    }

    public List<SubstrateNode> getBiasedNodes() {
        ArrayList<SubstrateNode> result = new ArrayList<SubstrateNode>();
        result.addAll(this.hiddenNodes);
        result.addAll(this.outputNodes);
        return result;
    }
}

