/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training.species;

import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.species.ThresholdSpeciation;
import org.encog.neural.neat.training.NEATGenome;

public class OriginalNEATSpeciation
extends ThresholdSpeciation {
    private static final long serialVersionUID = 1L;
    private double constDisjoint = 1.0;
    private double constExcess = 1.0;
    private double constMatched = 0.4;

    @Override
    public double getCompatibilityScore(Genome gen1, Genome gen2) {
        double numDisjoint = 0.0;
        double numExcess = 0.0;
        double numMatched = 0.0;
        double weightDifference = 0.0;
        NEATGenome genome1 = (NEATGenome)gen1;
        NEATGenome genome2 = (NEATGenome)gen2;
        int genome1Size = genome1.getLinksChromosome().size();
        int genome2Size = genome2.getLinksChromosome().size();
        boolean n = true;
        int g1 = 0;
        int g2 = 0;
        while (g1 < genome1Size || g2 < genome2Size) {
            long id2;
            if (g1 == genome1Size) {
                ++g2;
                numExcess += 1.0;
                continue;
            }
            if (g2 == genome2Size) {
                ++g1;
                numExcess += 1.0;
                continue;
            }
            long id1 = genome1.getLinksChromosome().get(g1).getInnovationId();
            if (id1 == (id2 = genome2.getLinksChromosome().get(g2).getInnovationId())) {
                weightDifference += Math.abs(genome1.getLinksChromosome().get(g1).getWeight() - genome2.getLinksChromosome().get(g2).getWeight());
                ++g1;
                ++g2;
                numMatched += 1.0;
            }
            if (id1 < id2) {
                numDisjoint += 1.0;
                ++g1;
            }
            if (id1 <= id2) continue;
            numDisjoint += 1.0;
            ++g2;
        }
        double score = this.constExcess * numExcess / 1.0 + this.constDisjoint * numDisjoint / 1.0 + this.constMatched * (weightDifference / numMatched);
        return score;
    }

    public double getConstDisjoint() {
        return this.constDisjoint;
    }

    public double getConstExcess() {
        return this.constExcess;
    }

    public double getConstMatched() {
        return this.constMatched;
    }

    public void setConstDisjoint(double constDisjoint) {
        this.constDisjoint = constDisjoint;
    }

    public void setConstExcess(double constExcess) {
        this.constExcess = constExcess;
    }

    public void setConstMatched(double constMatched) {
        this.constMatched = constMatched;
    }
}

