/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.anneal;

import org.encog.ml.CalculateScore;
import org.encog.ml.MLEncodable;
import org.encog.ml.MLRegression;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.train.BasicTraining;
import org.encog.neural.networks.structure.NetworkCODEC;
import org.encog.neural.networks.training.TrainingError;
import org.encog.neural.networks.training.anneal.NeuralSimulatedAnnealingHelper;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.util.logging.EncogLogging;

public class NeuralSimulatedAnnealing
extends BasicTraining {
    public static final double CUT = 0.5;
    private final MLEncodable network;
    private final NeuralSimulatedAnnealingHelper anneal;
    private final CalculateScore calculateScore;

    public NeuralSimulatedAnnealing(MLEncodable network, CalculateScore calculateScore, double startTemp, double stopTemp, int cycles) {
        super(TrainingImplementationType.Iterative);
        if (!(network instanceof MLRegression)) {
            throw new TrainingError("Simulated annealing requires the MLMethod to support MLRegression.");
        }
        this.network = network;
        this.calculateScore = calculateScore;
        this.anneal = new NeuralSimulatedAnnealingHelper(this);
        this.anneal.setTemperature(startTemp);
        this.anneal.setStartTemperature(startTemp);
        this.anneal.setStopTemperature(stopTemp);
        this.anneal.setCycles(cycles);
    }

    @Override
    public boolean canContinue() {
        return false;
    }

    public double[] getArray() {
        return NetworkCODEC.networkToArray(this.network);
    }

    public double[] getArrayCopy() {
        return this.getArray();
    }

    public CalculateScore getCalculateScore() {
        return this.calculateScore;
    }

    @Override
    public MLEncodable getMethod() {
        return this.network;
    }

    @Override
    public void iteration() {
        EncogLogging.log(1, "Performing Simulated Annealing iteration.");
        this.preIteration();
        this.anneal.iteration();
        this.setError(this.anneal.calculateScore());
        this.postIteration();
    }

    @Override
    public TrainingContinuation pause() {
        return null;
    }

    public void putArray(double[] array) {
        NetworkCODEC.arrayToNetwork(array, this.network);
    }

    public void randomize() {
        double[] array = NetworkCODEC.networkToArray(this.network);
        for (int i = 0; i < array.length; ++i) {
            double add = 0.5 - Math.random();
            add /= this.anneal.getStartTemperature();
            array[i] = array[i] + (add *= this.anneal.getTemperature());
        }
        NetworkCODEC.arrayToNetwork(array, this.network);
    }

    @Override
    public void resume(TrainingContinuation state) {
    }
}

