/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.simple;

import org.encog.mathutil.error.ErrorCalculation;
import org.encog.ml.MLMethod;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.BasicTraining;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.LearningRate;
import org.encog.neural.networks.training.propagation.TrainingContinuation;

public class TrainAdaline
extends BasicTraining
implements LearningRate {
    private final BasicNetwork network;
    private final MLDataSet training;
    private double learningRate;

    public TrainAdaline(BasicNetwork network, MLDataSet training, double learningRate) {
        super(TrainingImplementationType.Iterative);
        if (network.getLayerCount() > 2) {
            throw new NeuralNetworkError("An ADALINE network only has two layers.");
        }
        this.network = network;
        this.training = training;
        this.learningRate = learningRate;
    }

    @Override
    public boolean canContinue() {
        return false;
    }

    @Override
    public double getLearningRate() {
        return this.learningRate;
    }

    @Override
    public MLMethod getMethod() {
        return this.network;
    }

    @Override
    public void iteration() {
        ErrorCalculation errorCalculation = new ErrorCalculation();
        for (MLDataPair pair : this.training) {
            MLData output = this.network.compute(pair.getInput());
            for (int currentAdaline = 0; currentAdaline < output.size(); ++currentAdaline) {
                double diff = pair.getIdeal().getData(currentAdaline) - output.getData(currentAdaline);
                for (int i = 0; i <= this.network.getInputCount(); ++i) {
                    double input = i == this.network.getInputCount() ? 1.0 : pair.getInput().getData(i);
                    this.network.addWeight(0, i, currentAdaline, this.learningRate * diff * input);
                }
            }
            errorCalculation.updateError(output.getData(), pair.getIdeal().getData(), pair.getSignificance());
        }
        this.setError(errorCalculation.calculate());
    }

    @Override
    public TrainingContinuation pause() {
        return null;
    }

    @Override
    public void resume(TrainingContinuation state) {
    }

    @Override
    public void setLearningRate(double rate) {
        this.learningRate = rate;
    }
}

