/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.policytool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Permission;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.PolicyParser;
import sun.security.tools.policytool.PolicyEntry;
import sun.security.tools.policytool.ToolWindow;
import sun.security.util.PolicyUtil;
import sun.security.util.PropertyExpander;

public class PolicyTool {
    static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.util.Resources");
    static final Collator collator = Collator.getInstance();
    Vector<String> warnings;
    boolean newWarning = false;
    boolean modified = false;
    private static final boolean testing = false;
    private static final Class[] TWOPARAMS;
    private static final Class[] ONEPARAMS;
    private static final Class[] NOPARAMS;
    private static String policyFileName;
    private Vector<PolicyEntry> policyEntries = new Vector();
    private PolicyParser parser = new PolicyParser();
    private KeyStore keyStore = null;
    private String keyStoreName = " ";
    private String keyStoreType = " ";
    private String keyStoreProvider = " ";
    private String keyStorePwdURL = " ";
    private static final String P11KEYSTORE = "PKCS11";
    private static final String NONE = "NONE";

    private PolicyTool() {
        this.warnings = new Vector();
    }

    String getPolicyFileName() {
        return policyFileName;
    }

    void setPolicyFileName(String policyFileName) {
        PolicyTool.policyFileName = policyFileName;
    }

    void clearKeyStoreInfo() {
        this.keyStoreName = null;
        this.keyStoreType = null;
        this.keyStoreProvider = null;
        this.keyStorePwdURL = null;
        this.keyStore = null;
    }

    String getKeyStoreName() {
        return this.keyStoreName;
    }

    String getKeyStoreType() {
        return this.keyStoreType;
    }

    String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    String getKeyStorePwdURL() {
        return this.keyStorePwdURL;
    }

    void openPolicy(String filename) throws FileNotFoundException, PolicyParser.ParsingException, KeyStoreException, CertificateException, InstantiationException, MalformedURLException, IOException, NoSuchAlgorithmException, IllegalAccessException, NoSuchMethodException, UnrecoverableKeyException, NoSuchProviderException, ClassNotFoundException, PropertyExpander.ExpandException, InvocationTargetException {
        this.newWarning = false;
        this.policyEntries = new Vector();
        this.parser = new PolicyParser();
        this.warnings = new Vector();
        this.setPolicyFileName(null);
        this.clearKeyStoreInfo();
        if (filename == null) {
            this.modified = false;
            return;
        }
        this.setPolicyFileName(filename);
        this.parser.read(new FileReader(filename));
        this.openKeyStore(this.parser.getKeyStoreUrl(), this.parser.getKeyStoreType(), this.parser.getKeyStoreProvider(), this.parser.getStorePassURL());
        Enumeration<PolicyParser.GrantEntry> enum_ = this.parser.grantElements();
        while (enum_.hasMoreElements()) {
            Object[] source;
            MessageFormat form;
            PolicyParser.GrantEntry ge = enum_.nextElement();
            if (ge.signedBy != null) {
                String[] signers = this.parseSigners(ge.signedBy);
                for (int i = 0; i < signers.length; ++i) {
                    PublicKey pubKey = this.getPublicKeyAlias(signers[i]);
                    if (pubKey != null) continue;
                    this.newWarning = true;
                    form = new MessageFormat(rb.getString("Warning.A.public.key.for.alias.signers.i.does.not.exist.Make.sure.a.KeyStore.is.properly.configured."));
                    source = new Object[]{signers[i]};
                    this.warnings.addElement(form.format(source));
                }
            }
            ListIterator<PolicyParser.PrincipalEntry> prinList = ge.principals.listIterator(0);
            while (prinList.hasNext()) {
                PolicyParser.PrincipalEntry pe = prinList.next();
                try {
                    this.verifyPrincipal(pe.getPrincipalClass(), pe.getPrincipalName());
                }
                catch (ClassNotFoundException fnfe) {
                    this.newWarning = true;
                    form = new MessageFormat(rb.getString("Warning.Class.not.found.class"));
                    source = new Object[]{pe.getPrincipalClass()};
                    this.warnings.addElement(form.format(source));
                }
            }
            Enumeration<PolicyParser.PermissionEntry> perms = ge.permissionElements();
            while (perms.hasMoreElements()) {
                Object[] source2;
                PolicyParser.PermissionEntry pe = perms.nextElement();
                try {
                    this.verifyPermission(pe.permission, pe.name, pe.action);
                }
                catch (ClassNotFoundException fnfe) {
                    this.newWarning = true;
                    MessageFormat form2 = new MessageFormat(rb.getString("Warning.Class.not.found.class"));
                    source2 = new Object[]{pe.permission};
                    this.warnings.addElement(form2.format(source2));
                }
                catch (InvocationTargetException ite) {
                    this.newWarning = true;
                    MessageFormat form3 = new MessageFormat(rb.getString("Warning.Invalid.argument.s.for.constructor.arg"));
                    source2 = new Object[]{pe.permission};
                    this.warnings.addElement(form3.format(source2));
                }
                if (pe.signedBy == null) continue;
                String[] signers = this.parseSigners(pe.signedBy);
                for (int i = 0; i < signers.length; ++i) {
                    PublicKey pubKey = this.getPublicKeyAlias(signers[i]);
                    if (pubKey != null) continue;
                    this.newWarning = true;
                    MessageFormat form4 = new MessageFormat(rb.getString("Warning.A.public.key.for.alias.signers.i.does.not.exist.Make.sure.a.KeyStore.is.properly.configured."));
                    Object[] source3 = new Object[]{signers[i]};
                    this.warnings.addElement(form4.format(source3));
                }
            }
            PolicyEntry pEntry = new PolicyEntry(this, ge);
            this.policyEntries.addElement(pEntry);
        }
        this.modified = false;
    }

    void savePolicy(String filename) throws FileNotFoundException, IOException {
        this.parser.setKeyStoreUrl(this.keyStoreName);
        this.parser.setKeyStoreType(this.keyStoreType);
        this.parser.setKeyStoreProvider(this.keyStoreProvider);
        this.parser.setStorePassURL(this.keyStorePwdURL);
        this.parser.write(new FileWriter(filename));
        this.modified = false;
    }

    void openKeyStore(String name, String type, String provider, String pwdURL) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException, NoSuchProviderException, PropertyExpander.ExpandException {
        if (name == null && type == null && provider == null && pwdURL == null) {
            this.keyStoreName = null;
            this.keyStoreType = null;
            this.keyStoreProvider = null;
            this.keyStorePwdURL = null;
            return;
        }
        URL policyURL = null;
        if (policyFileName != null) {
            File pfile = new File(policyFileName);
            policyURL = new URL("file:" + pfile.getCanonicalPath());
        }
        if (name != null && name.length() > 0) {
            name = PropertyExpander.expand(name).replace(File.separatorChar, '/');
        }
        if (type == null || type.length() == 0) {
            type = KeyStore.getDefaultType();
        }
        if (pwdURL != null && pwdURL.length() > 0) {
            pwdURL = PropertyExpander.expand(pwdURL).replace(File.separatorChar, '/');
        }
        try {
            this.keyStore = PolicyUtil.getKeyStore(policyURL, name, type, provider, pwdURL, null);
        }
        catch (IOException ioe) {
            String MSG = "no password provided, and no callback handler available for retrieving password";
            Throwable cause = ioe.getCause();
            if (cause != null && cause instanceof LoginException && MSG.equals(cause.getMessage())) {
                throw new IOException(MSG);
            }
            throw ioe;
        }
        this.keyStoreName = name;
        this.keyStoreType = type;
        this.keyStoreProvider = provider;
        this.keyStorePwdURL = pwdURL;
    }

    boolean addEntry(PolicyEntry pe, int index) {
        if (index < 0) {
            this.policyEntries.addElement(pe);
            this.parser.add(pe.getGrantEntry());
        } else {
            PolicyEntry origPe = this.policyEntries.elementAt(index);
            this.parser.replace(origPe.getGrantEntry(), pe.getGrantEntry());
            this.policyEntries.setElementAt(pe, index);
        }
        return true;
    }

    boolean addPrinEntry(PolicyEntry pe, PolicyParser.PrincipalEntry newPrin, int index) {
        PolicyParser.GrantEntry grantEntry = pe.getGrantEntry();
        if (grantEntry.contains(newPrin)) {
            return false;
        }
        LinkedList<PolicyParser.PrincipalEntry> prinList = grantEntry.principals;
        if (index != -1) {
            prinList.set(index, newPrin);
        } else {
            prinList.add(newPrin);
        }
        this.modified = true;
        return true;
    }

    boolean addPermEntry(PolicyEntry pe, PolicyParser.PermissionEntry newPerm, int index) {
        PolicyParser.GrantEntry grantEntry = pe.getGrantEntry();
        if (grantEntry.contains(newPerm)) {
            return false;
        }
        Vector<PolicyParser.PermissionEntry> permList = grantEntry.permissionEntries;
        if (index != -1) {
            permList.setElementAt(newPerm, index);
        } else {
            permList.addElement(newPerm);
        }
        this.modified = true;
        return true;
    }

    boolean removePermEntry(PolicyEntry pe, PolicyParser.PermissionEntry perm) {
        PolicyParser.GrantEntry ppge = pe.getGrantEntry();
        this.modified = ppge.remove(perm);
        return this.modified;
    }

    boolean removeEntry(PolicyEntry pe) {
        this.parser.remove(pe.getGrantEntry());
        this.modified = true;
        return this.policyEntries.removeElement(pe);
    }

    PolicyEntry[] getEntry() {
        if (this.policyEntries.size() > 0) {
            PolicyEntry[] entries = new PolicyEntry[this.policyEntries.size()];
            for (int i = 0; i < this.policyEntries.size(); ++i) {
                entries[i] = this.policyEntries.elementAt(i);
            }
            return entries;
        }
        return null;
    }

    PublicKey getPublicKeyAlias(String name) throws KeyStoreException {
        if (this.keyStore == null) {
            return null;
        }
        Certificate cert = this.keyStore.getCertificate(name);
        if (cert == null) {
            return null;
        }
        PublicKey pubKey = cert.getPublicKey();
        return pubKey;
    }

    String[] getPublicKeyAlias() throws KeyStoreException {
        int numAliases = 0;
        String[] aliases = null;
        if (this.keyStore == null) {
            return null;
        }
        Enumeration<String> enum_ = this.keyStore.aliases();
        while (enum_.hasMoreElements()) {
            enum_.nextElement();
            ++numAliases;
        }
        if (numAliases > 0) {
            aliases = new String[numAliases];
            numAliases = 0;
            enum_ = this.keyStore.aliases();
            while (enum_.hasMoreElements()) {
                aliases[numAliases] = new String(enum_.nextElement());
                ++numAliases;
            }
        }
        return aliases;
    }

    String[] parseSigners(String signedBy) {
        String[] signers = null;
        int numSigners = 1;
        int signedByIndex = 0;
        int commaIndex = 0;
        int signerNum = 0;
        while (commaIndex >= 0) {
            commaIndex = signedBy.indexOf(44, signedByIndex);
            if (commaIndex < 0) continue;
            ++numSigners;
            signedByIndex = commaIndex + 1;
        }
        signers = new String[numSigners];
        commaIndex = 0;
        signedByIndex = 0;
        while (commaIndex >= 0) {
            commaIndex = signedBy.indexOf(44, signedByIndex);
            if (commaIndex >= 0) {
                signers[signerNum] = signedBy.substring(signedByIndex, commaIndex).trim();
                ++signerNum;
                signedByIndex = commaIndex + 1;
                continue;
            }
            signers[signerNum] = signedBy.substring(signedByIndex).trim();
        }
        return signers;
    }

    void verifyPrincipal(String type, String name) throws ClassNotFoundException, InstantiationException {
        Class<?> pc;
        if (type.equals("WILDCARD_PRINCIPAL_CLASS") || type.equals("PolicyParser.REPLACE_NAME")) {
            return;
        }
        Class<?> PRIN = Class.forName("java.security.Principal");
        if (!PRIN.isAssignableFrom(pc = Class.forName(type, true, Thread.currentThread().getContextClassLoader()))) {
            MessageFormat form = new MessageFormat(rb.getString("Illegal.Principal.Type.type"));
            Object[] source = new Object[]{type};
            throw new InstantiationException(form.format(source));
        }
        if ("javax.security.auth.x500.X500Principal".equals(pc.getName())) {
            X500Principal x500Principal = new X500Principal(name);
        }
    }

    void verifyPermission(String type, String name, String actions2) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> pc = Class.forName(type, true, Thread.currentThread().getContextClassLoader());
        Constructor<?> c = null;
        Vector<String> objects = new Vector<String>(2);
        if (name != null) {
            objects.add(name);
        }
        if (actions2 != null) {
            objects.add(actions2);
        }
        switch (objects.size()) {
            case 0: {
                try {
                    c = pc.getConstructor(NOPARAMS);
                    break;
                }
                catch (NoSuchMethodException ex) {
                    objects.add(null);
                }
            }
            case 1: {
                try {
                    c = pc.getConstructor(ONEPARAMS);
                    break;
                }
                catch (NoSuchMethodException ex) {
                    objects.add(null);
                }
            }
            case 2: {
                c = pc.getConstructor(TWOPARAMS);
            }
        }
        Object[] parameters = objects.toArray();
        Permission p = (Permission)c.newInstance(parameters);
    }

    static void parseArgs(String[] args) {
        int n = 0;
        for (n = 0; n < args.length && args[n].startsWith("-"); ++n) {
            String flags = args[n];
            if (collator.compare(flags, "-file") == 0) {
                if (++n == args.length) {
                    PolicyTool.usage();
                }
                policyFileName = args[n];
                continue;
            }
            MessageFormat form = new MessageFormat(rb.getString("Illegal.option.option"));
            Object[] source = new Object[]{flags};
            System.err.println(form.format(source));
            PolicyTool.usage();
        }
    }

    static void usage() {
        System.out.println(rb.getString("Usage.policytool.options."));
        System.out.println();
        System.out.println(rb.getString(".file.file.policy.file.location"));
        System.out.println();
        System.exit(1);
    }

    public static void main(String[] args) {
        PolicyTool.parseArgs(args);
        ToolWindow tw = new ToolWindow(new PolicyTool());
        tw.displayToolWindow(args);
    }

    static String splitToWords(String instr) {
        return instr.replaceAll("([A-Z])", " $1");
    }

    static {
        collator.setStrength(0);
        TWOPARAMS = new Class[]{String.class, String.class};
        ONEPARAMS = new Class[]{String.class};
        NOPARAMS = new Class[0];
        policyFileName = null;
    }
}

