/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import dguitar.codecs.guitarPro.GPColor;
import dguitar.codecs.guitarPro.GPMeasureTrackPair;
import dguitar.codecs.guitarPro.GPTrack;
import dguitar.gui.Bar;
import dguitar.gui.BarMTP;
import dguitar.gui.BarPanel;
import dguitar.gui.BarTablature;
import dguitar.gui.DGuitar;
import dguitar.gui.DisplayOptions;
import dguitar.gui.MusicCursor;
import dguitar.gui.MusicCursorPosition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;

public class TrackPanel
extends JLayeredPane
implements MouseListener {
    private int leftMargin = 0;
    private int rightMargin = 15;
    private JLabel TrebleLabel = null;
    private boolean changed = false;
    private BarPanel TablaturePanel;
    private int numBars;
    private Dimension clefSize;
    private int spaceBCBP = 5;
    protected DisplayOptions displayOptions;
    private MusicCursor tablatureMusicCursor;
    private static Integer CURSOR_LAYER = new Integer(99);
    private GPTrack gpTrack;
    private boolean musicCursorsProcesingEvents;

    public TrackPanel() {
        this.displayOptions = new DisplayOptions();
        this.gpTrack = null;
        this.musicCursorsProcesingEvents = true;
        this.initComponents();
    }

    public TrackPanel(DisplayOptions currentDisplayOptions, MusicCursorPosition aMusicCursorPosition) {
        if (currentDisplayOptions == null) {
            throw new NullPointerException("display options passed are null");
        }
        this.displayOptions = currentDisplayOptions;
        this.gpTrack = null;
        this.musicCursorsProcesingEvents = true;
        this.initComponents();
        this.tablatureMusicCursor = new MusicCursor(this.TablaturePanel);
        this.tablatureMusicCursor.setVisible(this.displayOptions.displayMusicCursor);
        this.add((Component)this.tablatureMusicCursor, CURSOR_LAYER);
        this.addMouseListener(this);
    }

    private void arrange() {
        Dimension dim = this.TablaturePanel.getMinimumSize();
        if (this.clefSize == null) {
            this.clefSize = this.TrebleLabel.getPreferredSize();
        }
        int y = (dim.height - this.clefSize.height) / 2;
        this.TrebleLabel.setBounds(this.leftMargin, y, this.clefSize.width, this.clefSize.height);
        int x = this.leftMargin + this.TrebleLabel.getWidth() + this.spaceBCBP;
        this.TablaturePanel.setBounds(x, 1, dim.width, dim.height);
    }

    private void initComponents() {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.TrebleLabel = new JLabel(DGuitar.Clefs[0]);
        this.TablaturePanel = new BarPanel(this.displayOptions);
        this.numBars = 0;
        this.clefSize = null;
        this.arrange();
        this.TablaturePanel.setExtendTop(false);
        this.TablaturePanel.setExtendBottom(false);
        this.TablaturePanel.setBackground(Color.WHITE);
        this.TablaturePanel.setForeground(Color.BLACK);
        this.add(this.TablaturePanel);
    }

    public void setMeasures(List Measures) {
        this.TablaturePanel.setMeasures(Measures);
    }

    public void setMeasureTrackPair(int measure, GPMeasureTrackPair mtp) {
        this.TablaturePanel.setMeasureTrackPair(measure, mtp);
    }

    public void setMusicCursor(int measure, int measurePrev, boolean scroll) {
        MusicCursorPosition MCP = this.TablaturePanel.getMusicCursorPosition(measure, this.tablatureMusicCursor);
        Point p = MCP.getPoint();
        p.x = p.x + this.leftMargin + this.TrebleLabel.getWidth() + this.spaceBCBP;
        MCP.setPoint(p);
        boolean wasVisible = this.tablatureMusicCursor.isVisible();
        if (wasVisible) {
            this.tablatureMusicCursor.setVisible(false);
        }
        Rectangle rect = this.tablatureMusicCursor.getBounds();
        if (scroll) {
            if (measure > measurePrev) {
                rect.x += rect.width + 250;
            } else {
                rect.width = 1;
            }
            this.scrollRectToVisible(rect);
        }
        this.tablatureMusicCursor.setMusicCursorPosition(MCP);
        if (wasVisible) {
            this.tablatureMusicCursor.setVisible(true);
        }
    }

    public BarMTP getTablatureBar(int measure) {
        BarMTP barMTP = null;
        Bar bar = this.TablaturePanel.getBar(measure);
        try {
            barMTP = (BarMTP)bar;
        }
        catch (ClassCastException CCE) {
            System.err.println("TrackPanel.getTablatureBar returned != BarMTP");
        }
        return barMTP;
    }

    public void addTablatureBar(int n) {
        if (n >= 1) {
            BarTablature bar = new BarTablature(this.displayOptions, this.TablaturePanel);
            bar.isFirst = true;
            bar.isLast = n == 1;
            this.TablaturePanel.addBar(bar);
            if (n >= 2) {
                int i = 1;
                while (i < n - 1) {
                    bar = new BarTablature(this.displayOptions, this.TablaturePanel);
                    this.TablaturePanel.addBar(bar);
                    ++i;
                }
                bar = new BarTablature(this.displayOptions, this.TablaturePanel);
                bar.isLast = true;
                this.TablaturePanel.addBar(bar);
            }
        }
    }

    public void addBar(int n) {
        this.addTablatureBar(n);
        this.numBars += n;
    }

    public int getNumBars() {
        return this.numBars;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public Dimension getMinimumSize() {
        Dimension aux = this.TablaturePanel.getMinimumSize();
        int w = this.leftMargin + this.clefSize.width + this.spaceBCBP + aux.width + this.rightMargin;
        int h = aux.height;
        Dimension dim = new Dimension(w, h);
        return dim;
    }

    public Dimension getPreferredSize() {
        Dimension d = this.getMinimumSize();
        return d;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int newx) {
        this.leftMargin = newx;
        this.arrange();
    }

    public void validate() {
        this.arrange();
        super.validate();
    }

    public void setNoteSpacing(int ns) {
        this.TablaturePanel.setNoteSpacing(ns);
    }

    public int getNoteSpacing() {
        return this.TablaturePanel.getNoteSpacing();
    }

    public void setTrack(GPTrack t) {
        this.gpTrack = t;
        this.setMusicCursorSingleColor(this.displayOptions.singleMusicCursorColor);
        this.TablaturePanel.setTrack(t);
    }

    public void setMusicCursorSingleColor(boolean singleColor) {
        Color color = this.displayOptions.musicCursorColor;
        if (!singleColor) {
            GPColor gpColor = this.gpTrack.getColor();
            try {
                color = new Color(gpColor.red, gpColor.green, gpColor.blue);
            }
            catch (IllegalArgumentException IAE) {
                System.err.println("Color of the Guitar Pro file is invalid, using default color");
            }
            if (color.equals(Color.WHITE)) {
                color = this.displayOptions.musicCursorColor;
            }
        }
        this.tablatureMusicCursor.setColorBorder(color);
    }

    public void updateMusicCursor(MouseEvent e) {
        Point p = e.getPoint();
        Component comp = this.getComponentAt(p);
        Class<?> c = comp.getClass();
        if (c.isInstance(new BarPanel())) {
            BarPanel barPanel = (BarPanel)comp;
            int barPanelX = barPanel.getX();
            Point p2 = new Point(p.x - barPanelX, p.y);
            MusicCursorPosition MCP = barPanel.snap(p2, this.tablatureMusicCursor);
            Point aux = MCP.getPoint();
            Point newP = new Point(barPanelX + aux.x, aux.y);
            MCP.setPoint(newP);
            this.tablatureMusicCursor.setMusicCursorPosition(MCP);
        }
    }

    public void setMusicCursorsProcesingEvents(boolean musicCursorsProcesingEvents) {
        this.musicCursorsProcesingEvents = musicCursorsProcesingEvents;
    }

    public void setMusicCursorsVisible(boolean value) {
        this.tablatureMusicCursor.setVisible(value);
    }

    public boolean isMusicCursorsProcesingEvents() {
        return this.musicCursorsProcesingEvents;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int btn = e.getButton();
        if (btn == 1 && this.musicCursorsProcesingEvents) {
            this.updateMusicCursor(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public String toString() {
        String resp = this.getClass().getName();
        if (this.gpTrack != null) {
            resp = String.valueOf(resp) + " " + this.gpTrack.toString();
        }
        return resp;
    }
}

